"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumns = getColumns;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _description_cell = require("./description_cell");
var _detector_cell = require("./detector_cell");
var _entity_cell = require("../entity_cell");
var _influencers_cell = require("./influencers_cell");
var _links_menu = require("./links_menu");
var _check_capabilities = require("../../capabilities/check_capabilities");
var _anomalies_table_constants = require("./anomalies_table_constants");
var _severity_cell = require("./severity_cell");
var _anomaly_value_display = require("./anomaly_value_display");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/anomalies_table/anomalies_table_columns.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function renderTime(date, aggregationInterval) {
  if (aggregationInterval === 'hour') {
    return (0, _mlDateUtils.formatHumanReadableDateTime)(date);
  } else if (aggregationInterval === 'second') {
    return (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(date);
  } else {
    return (0, _mlDateUtils.formatHumanReadableDate)(date);
  }
}
function showLinksMenuForItem(item, showViewSeriesLink, sourceIndicesWithGeoFields) {
  const canConfigureRules = (0, _mlAnomalyUtils.isRuleSupported)(item.source) && (0, _check_capabilities.checkPermission)('canUpdateJob');
  return canConfigureRules || showViewSeriesLink && item.isTimeSeriesViewRecord || item.entityName === 'mlcategory' || item.customUrls !== undefined || item.detector.includes(_mlAnomalyUtils.ML_JOB_AGGREGATION.LAT_LONG) || item.sourceIndices && item.sourceIndices(sourceIndex => sourceIndicesWithGeoFields[item.jobId][sourceIndex] !== undefined);
}
function getColumns(mlFieldFormatService, items, jobIds, examplesByJobId, isAggregatedData, interval, bounds, showViewSeriesLink, showRuleEditorFlyout, itemIdToExpandedRowMap, toggleRow, filter, influencerFilter, sourceIndicesWithGeoFields) {
  const columns = [{
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomaliesTable.showDetailsColumn.screenReaderDescription",
      defaultMessage: "This column contains clickable controls for showing more details on each anomaly",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 13
      }
    }))),
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: () => toggleRow(item),
      iconType: itemIdToExpandedRowMap[item.rowId] ? 'arrowDown' : 'arrowRight',
      "aria-label": itemIdToExpandedRowMap[item.rowId] ? _i18n.i18n.translate('xpack.ml.anomaliesTable.hideDetailsAriaLabel', {
        defaultMessage: 'Hide details'
      }) : _i18n.i18n.translate('xpack.ml.anomaliesTable.showDetailsAriaLabel', {
        defaultMessage: 'Show details'
      }),
      "data-row-id": item.rowId,
      "data-test-subj": "mlAnomaliesListRowDetailsToggle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 9
      }
    })
  }, {
    field: 'time',
    'data-test-subj': 'mlAnomaliesListColumnTime',
    name: _i18n.i18n.translate('xpack.ml.anomaliesTable.timeColumnName', {
      defaultMessage: 'Time'
    }),
    dataType: 'date',
    scope: 'row',
    render: date => renderTime(date, interval),
    textOnly: true,
    sortable: true
  }, {
    field: 'severity',
    'data-test-subj': 'mlAnomaliesListColumnSeverity',
    name: /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.ml.anomaliesTable.severityColumnName', {
      defaultMessage: 'Score'
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignTop",
      content: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.tableSeverityTooltip', {
        defaultMessage: 'A normalized score between 0-100, which indicates the relative significance of the anomaly record results.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 11
      }
    })),
    render: (score, item) => /*#__PURE__*/_react.default.createElement(_severity_cell.SeverityCell, {
      score: score,
      isMultiBucketAnomaly: (0, _mlAnomalyUtils.isMultiBucketAnomaly)(item.source),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 9
      }
    }),
    sortable: true
  }, {
    field: 'detector',
    'data-test-subj': 'mlAnomaliesListColumnDetector',
    name: _i18n.i18n.translate('xpack.ml.anomaliesTable.detectorColumnName', {
      defaultMessage: 'Detector'
    }),
    render: (detectorDescription, item) => /*#__PURE__*/_react.default.createElement(_detector_cell.DetectorCell, {
      detectorDescription: detectorDescription,
      numberOfRules: item.rulesLength,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 9
      }
    }),
    textOnly: true,
    sortable: true
  }];
  if (items.some(item => item.entityValue !== undefined)) {
    columns.push({
      field: 'entityValue',
      'data-test-subj': 'mlAnomaliesListColumnFoundFor',
      name: _i18n.i18n.translate('xpack.ml.anomaliesTable.entityValueColumnName', {
        defaultMessage: 'Found for'
      }),
      render: (entityValue, item) => /*#__PURE__*/_react.default.createElement(_entity_cell.EntityCell, {
        entityName: item.entityName,
        entityValue: entityValue,
        filter: filter,
        wrapText: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 9
        }
      }),
      textOnly: true,
      sortable: true
    });
  }
  if (items.some(item => item.influencers !== undefined)) {
    columns.push({
      field: 'influencers',
      'data-test-subj': 'mlAnomaliesListColumnInfluencers',
      name: _i18n.i18n.translate('xpack.ml.anomaliesTable.influencersColumnName', {
        defaultMessage: 'Influenced by'
      }),
      render: influencers => /*#__PURE__*/_react.default.createElement(_influencers_cell.InfluencersCell, {
        limit: _anomalies_table_constants.INFLUENCERS_LIMIT,
        influencers: influencers,
        influencerFilter: influencerFilter,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 183,
          columnNumber: 9
        }
      }),
      textOnly: true,
      sortable: true
    });
  }

  // Map the additional 'sort' fields to the actual, typical and description
  // fields to ensure sorting is done correctly on the underlying metric value
  // and not on e.g. the actual values array as a String.
  if (items.some(item => item.actual !== undefined)) {
    columns.push({
      field: 'actualSort',
      'data-test-subj': 'mlAnomaliesListColumnActual',
      name: /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 202,
          columnNumber: 9
        }
      }, _i18n.i18n.translate('xpack.ml.anomaliesTable.actualSortColumnName', {
        defaultMessage: 'Actual'
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "question",
        className: "eui-alignTop",
        content: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.tableActualTooltip', {
          defaultMessage: 'The actual values in the anomaly record results.'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 207,
          columnNumber: 11
        }
      })),
      render: (actual, item) => {
        const fieldFormat = mlFieldFormatService.getFieldFormat(item.jobId, item.source.detector_index);
        return /*#__PURE__*/_react.default.createElement(_anomaly_value_display.AnomalyValueDisplay, {
          value: item.actual,
          function: item.source.function,
          fieldFormat: fieldFormat,
          record: item.source,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 224,
            columnNumber: 11
          }
        });
      },
      sortable: true,
      className: 'eui-textBreakNormal'
    });
  }
  if (items.some(item => item.typical !== undefined)) {
    columns.push({
      field: 'typicalSort',
      'data-test-subj': 'mlAnomaliesListColumnTypical',
      name: /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 242,
          columnNumber: 9
        }
      }, _i18n.i18n.translate('xpack.ml.anomaliesTable.typicalSortColumnName', {
        defaultMessage: 'Typical'
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "question",
        className: "eui-alignTop",
        content: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.tableTypicalTooltip', {
          defaultMessage: 'The typical values in the anomaly record results.'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 247,
          columnNumber: 11
        }
      })),
      render: (typical, item) => {
        const fieldFormat = mlFieldFormatService.getFieldFormat(item.jobId, item.source.detector_index);
        return /*#__PURE__*/_react.default.createElement(_anomaly_value_display.AnomalyValueDisplay, {
          value: item.typical,
          function: item.source.function,
          fieldFormat: fieldFormat,
          record: item.source,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 264,
            columnNumber: 11
          }
        });
      },
      sortable: true,
      className: 'eui-textBreakNormal'
    });

    // Assume that if we are showing typical, there will be an actual too,
    // so we can add a column to describe how actual compares to typical.
    const nonTimeOfDayOrWeek = items.some(item => {
      const summaryRecFunc = item.source.function;
      return summaryRecFunc !== 'time_of_day' && summaryRecFunc !== 'time_of_week';
    });
    if (nonTimeOfDayOrWeek === true) {
      columns.push({
        field: 'metricDescriptionSort',
        'data-test-subj': 'mlAnomaliesListColumnDescription',
        name: _i18n.i18n.translate('xpack.ml.anomaliesTable.metricDescriptionSortColumnName', {
          defaultMessage: 'Description'
        }),
        render: (metricDescriptionSort, item) => /*#__PURE__*/_react.default.createElement(_description_cell.DescriptionCell, {
          actual: item.actual,
          typical: item.typical,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 290,
            columnNumber: 11
          }
        }),
        textOnly: true,
        sortable: true
      });
    }
  }
  if (jobIds && jobIds.length > 1) {
    columns.push({
      field: 'jobId',
      'data-test-subj': 'mlAnomaliesListColumnJobID',
      name: _i18n.i18n.translate('xpack.ml.anomaliesTable.jobIdColumnName', {
        defaultMessage: 'Job ID'
      }),
      sortable: true
    });
  }
  const showExamples = items.some(item => item.entityName === 'mlcategory');
  if (showExamples === true) {
    columns.push({
      'data-test-subj': 'mlAnomaliesListColumnCategoryExamples',
      name: _i18n.i18n.translate('xpack.ml.anomaliesTable.categoryExamplesColumnName', {
        defaultMessage: 'Category examples'
      }),
      truncateText: true,
      render: item => {
        const examples = (0, _lodash.get)(examplesByJobId, [item.jobId, item.entityValue], []);
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          css: {
            width: '100%'
          },
          onClick: () => toggleRow(item, _anomalies_table_constants.ANOMALIES_TABLE_TABS.CATEGORY_EXAMPLES),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 320,
            columnNumber: 11
          }
        }, examples.map((example, i) => {
          return /*#__PURE__*/_react.default.createElement("span", {
            key: `example${i}`,
            css: {
              display: 'block',
              whiteSpace: 'nowrap',
              overflow: 'hidden',
              textOverflow: 'ellipsis'
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 328,
              columnNumber: 17
            }
          }, example);
        }));
      },
      width: '13%'
    });
  }
  const showLinks = items.some(item => showLinksMenuForItem(item, showViewSeriesLink, sourceIndicesWithGeoFields));
  if (showLinks === true) {
    columns.push({
      'data-test-subj': 'mlAnomaliesListColumnAction',
      name: _i18n.i18n.translate('xpack.ml.anomaliesTable.actionsColumnName', {
        defaultMessage: 'Actions'
      }),
      render: item => {
        if (showLinksMenuForItem(item, showViewSeriesLink, sourceIndicesWithGeoFields) === true) {
          return /*#__PURE__*/_react.default.createElement(_links_menu.LinksMenu, {
            anomaly: item,
            bounds: bounds,
            showViewSeriesLink: showViewSeriesLink,
            isAggregatedData: isAggregatedData,
            interval: interval,
            showRuleEditorFlyout: showRuleEditorFlyout,
            sourceIndicesWithGeoFields: sourceIndicesWithGeoFields,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 361,
              columnNumber: 13
            }
          });
        } else {
          return null;
        }
      }
    });
  }
  return columns;
}