"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedSettings = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _react = _interopRequireWildcard(require("react"));
var _validators = require("../validators");
var _alerts = require("../../../common/constants/alerts");
var _time_interval_control = require("../time_interval_control");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/alerting/anomaly_detection_rule/advanced_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AdvancedSettings = exports.AdvancedSettings = /*#__PURE__*/_react.default.memo(({
  value,
  onChange
}) => {
  var _value$topNBuckets;
  const topNBucketsValidationErrors = (0, _react.useMemo)(() => {
    if (!(0, _mlIsDefined.isDefined)(value.topNBuckets)) {
      return null;
    }
    return (0, _validators.validateTopNBucket)(value.topNBuckets);
  }, [value.topNBuckets]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "mlAnomalyAlertAdvancedSettings",
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetectionAlert.advancedSettingsLabel",
      defaultMessage: "Advanced settings",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 9
      }
    }),
    "data-test-subj": 'mlAnomalyAlertAdvancedSettingsTrigger',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    gutterSize: 's',
    titleSize: 'xxs',
    title: /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetectionAlert.lookbackIntervalLabel",
      defaultMessage: "Lookback interval",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 'xs',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetectionAlert.lookbackIntervalDescription",
      defaultMessage: "Time interval to query the anomalies data during each rule condition check. By default, is derived from the bucket span of the job and the query delay of the datafeed.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_time_interval_control.TimeIntervalControl, {
    value: value.lookbackInterval,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetectionAlert.lookbackIntervalLabel",
      defaultMessage: "Lookback interval",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 13
      }
    }),
    onChange: update => {
      onChange({
        lookbackInterval: update
      });
    },
    "data-test-subj": 'mlAnomalyAlertLookbackInterval',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    gutterSize: 's',
    titleSize: 'xxs',
    title: /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetectionAlert.topNBucketsLabel",
      defaultMessage: "Number of latest buckets",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 'xs',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetectionAlert.topNBucketsDescription",
      defaultMessage: "The number of latest buckets to check to obtain the highest anomaly.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetectionAlert.topNBucketsLabel",
      defaultMessage: "Number of latest buckets",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 13
      }
    }),
    isInvalid: topNBucketsValidationErrors !== null,
    "data-test-subj": 'mlAnomalyAlertTopNBucketsFormRow',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: (_value$topNBuckets = value.topNBuckets) !== null && _value$topNBuckets !== void 0 ? _value$topNBuckets : _alerts.TOP_N_BUCKETS_COUNT,
    min: 1,
    onChange: e => {
      onChange({
        topNBuckets: Number(e.target.value)
      });
    },
    "data-test-subj": 'mlAnomalyAlertTopNBuckets',
    isInvalid: topNBucketsValidationErrors !== null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }));
});