"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteDataViewFn = void 0;
var _data_view_handler = require("./data_view_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDataViewId(dataViewsService, patternName) {
  const iph = new _data_view_handler.DataViewHandler(dataViewsService);
  return await iph.getDataViewId(patternName);
}
async function deleteDestDataViewById(dataViewsService, dataViewId) {
  const iph = new _data_view_handler.DataViewHandler(dataViewsService);
  return await iph.deleteDataViewById(dataViewId);
}
const deleteDataViewFn = async ({
  dataViewsService,
  dataViewName
}) => {
  const response = {
    success: false
  };
  try {
    const dataViewId = await getDataViewId(dataViewsService, dataViewName);
    if (dataViewId) {
      await deleteDestDataViewById(dataViewsService, dataViewId);
    }
    response.success = true;
  } catch (deleteDestDataViewError) {
    response.error = deleteDestDataViewError;
  }
  return response;
};
exports.deleteDataViewFn = deleteDataViewFn;