"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSeverityType = getSeverityType;
var _anomaly_severity = require("./anomaly_severity");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a severity type (indicating a critical, major, minor, warning or low severity anomaly)
 * for the supplied normalized anomaly score (a value between 0 and 100).
 * @param normalizedScore - A normalized score between 0-100, which is based on the probability of the anomalousness of this record
 */
function getSeverityType(normalizedScore) {
  if (normalizedScore >= 75) {
    return _anomaly_severity.ML_ANOMALY_SEVERITY.CRITICAL;
  } else if (normalizedScore >= 50) {
    return _anomaly_severity.ML_ANOMALY_SEVERITY.MAJOR;
  } else if (normalizedScore >= 25) {
    return _anomaly_severity.ML_ANOMALY_SEVERITY.MINOR;
  } else if (normalizedScore >= 3) {
    return _anomaly_severity.ML_ANOMALY_SEVERITY.WARNING;
  } else if (normalizedScore >= 0) {
    return _anomaly_severity.ML_ANOMALY_SEVERITY.LOW;
  } else {
    return _anomaly_severity.ML_ANOMALY_SEVERITY.UNKNOWN;
  }
}