"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExperiencePlugin = void 0;
var _api = require("./api");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class MetricsExperiencePlugin {
  setup(core) {
    return {};
  }
  start(_core) {
    const isEnabled = _core.featureFlags.getBooleanValue(_constants.METRICS_EXPERIENCE_FEATURE_FLAG_KEY, true);
    return {
      metricsExperienceClient: isEnabled ? (0, _api.createMetricsExperienceClient)(_core) : undefined
    };
  }
  stop() {}
}
exports.MetricsExperiencePlugin = MetricsExperiencePlugin;