"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.init = void 0;
var _i18n = require("@kbn/i18n");
var _charts = require("@elastic/charts");
var _constants = require("../../../shared/charts/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const init = formulas => {
  var _formulas$get$label, _formulas$get$label2, _formulas$get$label3, _formulas$get$label4, _formulas$get$label5, _formulas$get$label6;
  const diskIOReadWrite = {
    id: 'diskIOReadWrite',
    chartType: 'xy',
    title: _constants.DISK_IOPS_LABEL,
    layers: [{
      seriesType: 'area',
      type: 'series',
      xAxis: '@timestamp',
      yAxis: [{
        ...formulas.get('diskIORead'),
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.read', {
          defaultMessage: 'Read'
        })
      }, {
        ...formulas.get('diskIOWrite'),
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.write', {
          defaultMessage: 'Write'
        })
      }]
    }],
    ..._constants.DEFAULT_XY_FITTING_FUNCTION,
    ..._constants.DEFAULT_XY_LEGEND,
    ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
  };
  const diskUsageByMountPoint = {
    id: 'diskUsageByMountPoint',
    chartType: 'xy',
    title: _constants.DISK_USAGE_BY_MOUNT_POINT_LABEL,
    layers: [{
      seriesType: 'area',
      type: 'series',
      xAxis: '@timestamp',
      breakdown: {
        type: 'topValues',
        field: formulas.schema === 'ecs' ? 'system.filesystem.mount_point' : 'attributes.mountpoint',
        size: 15
      },
      yAxis: [{
        ...formulas.get('diskUsageAverage'),
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.diskUsage.label.used', {
          defaultMessage: 'Used'
        })
      }]
    }],
    ..._constants.DEFAULT_XY_FITTING_FUNCTION,
    legend: {
      ..._constants.DEFAULT_XY_LEGEND.legend,
      legendStats: [_charts.LegendValue.Average, _charts.LegendValue.Min, _charts.LegendValue.Max, _charts.LegendValue.LastNonNullValue]
    },
    ..._constants.DEFAULT_XY_YBOUNDS,
    ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
  };
  const diskThroughputReadWrite = {
    id: 'diskThroughputReadWrite',
    chartType: 'xy',
    title: _constants.DISK_THROUGHPUT_LABEL,
    layers: [{
      seriesType: 'area',
      type: 'series',
      xAxis: '@timestamp',
      yAxis: [{
        ...formulas.get('diskReadThroughput'),
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.read', {
          defaultMessage: 'Read'
        })
      }, {
        ...formulas.get('diskWriteThroughput'),
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.write', {
          defaultMessage: 'Write'
        })
      }]
    }],
    ..._constants.DEFAULT_XY_FITTING_FUNCTION,
    ..._constants.DEFAULT_XY_LEGEND,
    ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
  };
  const diskSpaceAvailable = {
    id: 'diskSpaceAvailable',
    chartType: 'xy',
    title: (_formulas$get$label = formulas.get('diskSpaceAvailable').label) !== null && _formulas$get$label !== void 0 ? _formulas$get$label : '',
    layers: [{
      seriesType: 'line',
      type: 'series',
      xAxis: '@timestamp',
      yAxis: [formulas.get('diskSpaceAvailable')]
    }],
    ..._constants.DEFAULT_XY_FITTING_FUNCTION,
    ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
    ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
  };
  const diskIORead = {
    id: 'diskIORead',
    chartType: 'xy',
    title: (_formulas$get$label2 = formulas.get('diskIORead').label) !== null && _formulas$get$label2 !== void 0 ? _formulas$get$label2 : '',
    layers: [{
      seriesType: 'line',
      type: 'series',
      xAxis: '@timestamp',
      yAxis: [formulas.get('diskIORead')]
    }],
    ..._constants.DEFAULT_XY_FITTING_FUNCTION,
    ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
    ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
  };
  const diskIOWrite = {
    id: 'diskIOWrite',
    chartType: 'xy',
    title: (_formulas$get$label3 = formulas.get('diskIOWrite').label) !== null && _formulas$get$label3 !== void 0 ? _formulas$get$label3 : '',
    layers: [{
      seriesType: 'line',
      type: 'series',
      xAxis: '@timestamp',
      yAxis: [formulas.get('diskIOWrite')]
    }],
    ..._constants.DEFAULT_XY_FITTING_FUNCTION,
    ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
    ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
  };
  const diskReadThroughput = {
    id: 'diskReadThroughput',
    chartType: 'xy',
    title: (_formulas$get$label4 = formulas.get('diskReadThroughput').label) !== null && _formulas$get$label4 !== void 0 ? _formulas$get$label4 : '',
    layers: [{
      seriesType: 'line',
      type: 'series',
      xAxis: '@timestamp',
      yAxis: [formulas.get('diskReadThroughput')]
    }],
    ..._constants.DEFAULT_XY_FITTING_FUNCTION,
    ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
    ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
  };
  const diskWriteThroughput = {
    id: 'diskWriteThroughput',
    chartType: 'xy',
    title: (_formulas$get$label5 = formulas.get('diskWriteThroughput').label) !== null && _formulas$get$label5 !== void 0 ? _formulas$get$label5 : '',
    layers: [{
      seriesType: 'line',
      type: 'series',
      xAxis: '@timestamp',
      yAxis: [formulas.get('diskWriteThroughput')]
    }],
    ..._constants.DEFAULT_XY_FITTING_FUNCTION,
    ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
    ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
  };
  const diskUsageMetric = {
    id: 'diskUsage',
    chartType: 'metric',
    title: (_formulas$get$label6 = formulas.get('diskUsage').label) !== null && _formulas$get$label6 !== void 0 ? _formulas$get$label6 : '',
    trendLine: true,
    ...formulas.get('diskUsage')
  };
  return {
    xy: {
      diskThroughputReadWrite,
      diskUsageByMountPoint,
      diskIOReadWrite,
      diskSpaceAvailable,
      diskIORead,
      diskIOWrite,
      diskReadThroughput,
      diskWriteThroughput
    },
    metric: {
      diskUsage: diskUsageMetric
    }
  };
};
exports.init = init;