"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.network = void 0;
var _constants = require("../../../shared/charts/constants");
var _formulas = require("../formulas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dockerContainerRxTx = {
  id: 'rxTx',
  chartType: 'xy',
  title: _constants.NETWORK_LABEL,
  layers: [{
    seriesType: 'area',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [{
      ..._formulas.formulas.dockerContainerNetworkRx,
      label: _constants.RX_LABEL
    }, {
      ..._formulas.formulas.dockerContainerNetworkTx,
      label: _constants.TX_LABEL
    }]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const network = exports.network = {
  xy: {
    dockerContainerRxTx
  }
};