"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metrics = void 0;
var _aws_ec2_cpu_utilization = require("./tsvb/aws_ec2_cpu_utilization");
var _aws_ec2_network_traffic = require("./tsvb/aws_ec2_network_traffic");
var _aws_ec2_diskio_bytes = require("./tsvb/aws_ec2_diskio_bytes");
var _metrics_catalog = require("../../shared/metrics/metrics_catalog");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const metrics = exports.metrics = {
  tsvb: {
    awsEC2CpuUtilization: _aws_ec2_cpu_utilization.awsEC2CpuUtilization,
    awsEC2NetworkTraffic: _aws_ec2_network_traffic.awsEC2NetworkTraffic,
    awsEC2DiskIOBytes: _aws_ec2_diskio_bytes.awsEC2DiskIOBytes
  },
  requiredTsvb: ['awsEC2CpuUtilization', 'awsEC2NetworkTraffic', 'awsEC2DiskIOBytes'],
  getAggregations: async args => {
    const {
      snapshot
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./snapshot')));
    const catalog = new _metrics_catalog.MetricsCatalog(snapshot, args === null || args === void 0 ? void 0 : args.schema);
    return catalog;
  },
  getWaffleMapTooltipMetrics: () => ['cpu', 'rx', 'tx'],
  defaultSnapshot: 'cpu',
  defaultTimeRangeInSeconds: 14400 // 4 hours
};