/**
 * MapLibre GL JS
 * @license 3-Clause BSD. Full text of license: https://github.com/maplibre/maplibre-gl-js/blob/v5.3.0/LICENSE.txt
 */
var maplibregl=function(){"use strict";function t(t,e,r,n){return new(r||(r=Promise))((function(s,o){function a(t){try{u(n.next(t))}catch(t){o(t)}}function l(t){try{u(n.throw(t))}catch(t){o(t)}}function u(t){var e;t.done?s(t.value):(e=t.value,e instanceof r?e:new r((function(t){t(e)}))).then(a,l)}u((n=n.apply(t,e||[])).next())}))}function e(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var r,n;function s(){if(n)return r;function t(t,e){this.x=t,this.y=e}return n=1,r=t,t.prototype={clone:function(){return new t(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),r=Math.sin(t),n=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=n,this},_rotateAround:function(t,e){var r=Math.cos(t),n=Math.sin(t),s=e.y+n*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-n*(this.y-e.y),this.y=s,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},t.convert=function(e){return e instanceof t?e:Array.isArray(e)?new t(e[0],e[1]):e},r}"function"==typeof SuppressedError&&SuppressedError;var o,a,l=e(s()),u=function(){if(a)return o;function t(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n}return a=1,o=t,t.prototype={sampleCurveX:function(t){return((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return(3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var s=this.sampleCurveX(r)-t;if(Math.abs(s)<e)return r;var o=this.sampleCurveDerivativeX(r);if(Math.abs(o)<1e-6)break;r-=s/o}var a=0,l=1;for(r=t,n=0;n<20&&(s=this.sampleCurveX(r),!(Math.abs(s-t)<e));n++)t>s?a=r:l=r,r=.5*(l-a)+a;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},o}(),c=e(u);let h,p;var f,d="undefined"!=typeof Float32Array?Float32Array:Array;function y(t,e,r){var n=e[0],s=e[1],o=e[2],a=e[3];return t[0]=r[0]*n+r[4]*s+r[8]*o+r[12]*a,t[1]=r[1]*n+r[5]*s+r[9]*o+r[13]*a,t[2]=r[2]*n+r[6]*s+r[10]*o+r[14]*a,t[3]=r[3]*n+r[7]*s+r[11]*o+r[15]*a,t}Math.hypot||(Math.hypot=function(){for(var t=0,e=arguments.length;e--;)t+=arguments[e]*arguments[e];return Math.sqrt(t)}),f=new d(4),d!=Float32Array&&(f[0]=0,f[1]=0,f[2]=0,f[3]=0);const m=8192;function g(t,e,r){return Math.min(r,Math.max(e,t))}function x(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}function v(t,e,r){const n={};for(const r in t)n[r]=e.call(this,t[r],r,t);return n}function b(t){return Array.isArray(t)?t.map(b):"object"==typeof t&&t?v(t,b):t}new c(.25,.1,.25,1);const w={};function _(t){w[t]||("undefined"!=typeof console&&console.warn(t),w[t]=!0)}function S(t,e,r){return(r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function k(t){return"undefined"!=typeof WorkerGlobalScope&&void 0!==t&&t instanceof WorkerGlobalScope}function A(t){return"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap}let I,M;function P(t,e,r,n){return t.addEventListener(e,r,n),{unsubscribe:()=>{t.removeEventListener(e,r,n)}}}class z{constructor(t,e,r){const n=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;const s=new Int32Array(this.arrayBuffer);t=s[0],this.d=(e=s[1])+2*(r=s[2]);for(let t=0;t<this.d*this.d;t++){const e=s[3+t],r=s[3+t+1];n.push(e===r?null:s.subarray(e,r))}const o=s[3+n.length+1];this.keys=s.subarray(s[3+n.length],o),this.bboxes=s.subarray(o),this.insert=this._insertReadonly}else{this.d=e+2*r;for(let t=0;t<this.d*this.d;t++)n.push([]);this.keys=[],this.bboxes=[]}this.n=e,this.extent=t,this.padding=r,this.scale=e/t,this.uid=0;const s=r/e*t;this.min=-s,this.max=t+s}insert(t,e,r,n,s){this._forEachCell(e,r,n,s,this._insertCell,this.uid++,void 0,void 0),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(s)}_insertReadonly(){throw new Error("Cannot insert into a GridIndex created from an ArrayBuffer.")}_insertCell(t,e,r,n,s,o){this.cells[s].push(o)}query(t,e,r,n,s){const o=this.min,a=this.max;if(t<=o&&e<=o&&a<=r&&a<=n&&!s)return Array.prototype.slice.call(this.keys);{const o=[];return this._forEachCell(t,e,r,n,this._queryCell,o,{},s),o}}_queryCell(t,e,r,n,s,o,a,l){const u=this.cells[s];if(null!==u){const s=this.keys,c=this.bboxes;for(let h=0;h<u.length;h++){const p=u[h];if(void 0===a[p]){const u=4*p;(l?l(c[u+0],c[u+1],c[u+2],c[u+3]):t<=c[u+2]&&e<=c[u+3]&&r>=c[u+0]&&n>=c[u+1])?(a[p]=!0,o.push(s[p])):a[p]=!1}}}}_forEachCell(t,e,r,n,s,o,a,l){const u=this._convertToCellCoord(t),c=this._convertToCellCoord(e),h=this._convertToCellCoord(r),p=this._convertToCellCoord(n);for(let f=u;f<=h;f++)for(let u=c;u<=p;u++){const c=this.d*u+f;if((!l||l(this._convertFromCellCoord(f),this._convertFromCellCoord(u),this._convertFromCellCoord(f+1),this._convertFromCellCoord(u+1)))&&s.call(this,t,e,r,n,c,o,a,l))return}}_convertFromCellCoord(t){return(t-this.padding)/this.scale}_convertToCellCoord(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))}toArrayBuffer(){if(this.arrayBuffer)return this.arrayBuffer;const t=this.cells,e=3+this.cells.length+1+1;let r=0;for(let t=0;t<this.cells.length;t++)r+=this.cells[t].length;const n=new Int32Array(e+r+this.keys.length+this.bboxes.length);n[0]=this.extent,n[1]=this.n,n[2]=this.padding;let s=e;for(let e=0;e<t.length;e++){const r=t[e];n[3+e]=s,n.set(r,s),s+=r.length}return n[3+t.length]=s,n.set(this.keys,s),s+=this.keys.length,n[3+t.length+1]=s,n.set(this.bboxes,s),s+=this.bboxes.length,n.buffer}static serialize(t,e){const r=t.toArrayBuffer();return e&&e.push(r),{buffer:r}}static deserialize(t){return new z(t.buffer)}}var C={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number"},centerAltitude:{type:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},roll:{type:"number",default:0,units:"degrees"},light:{type:"light"},sky:{type:"sky"},projection:{type:"projection"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"sprite"},glyphs:{type:"string"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{},custom:{}},default:"mapbox"},redFactor:{type:"number",default:1},blueFactor:{type:"number",default:1},greenFactor:{type:"number",default:1},baseShift:{type:"number",default:0},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{required:!0,type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"*"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},background:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_background"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image",{"!":"icon-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"padding",default:[2],units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},"viewport-glyph":{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-variable-anchor-offset":{type:"variableAnchorOffsetCollection",requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field",{"!":"text-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},filter:{type:"array",value:"*"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"*",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},sky:{"sky-color":{type:"color","property-type":"data-constant",default:"#88C6FC",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-ground-blend":{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-fog-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"sky-horizon-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"atmosphere-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number",minimum:0,default:1}},projection:{type:{type:"projectionDefinition",default:"mercator","property-type":"data-constant",transition:!1,expression:{interpolated:!0,parameters:["zoom"]}}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_background"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"number",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"color",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}}};const T=["type","source","source-layer","minzoom","maxzoom","filter","layout"];class B{constructor(t,e,r,n){this.message=(t?`${t}: `:"")+r,n&&(this.identifier=n),null!=e&&e.__line__&&(this.line=e.__line__)}}function F(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}class V extends Error{constructor(t,e){super(e),this.message=e,this.key=t}}class E{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r}concat(t){return new E(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return!!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const D={kind:"null"},$={kind:"number"},L={kind:"string"},R={kind:"boolean"},O={kind:"color"},N={kind:"projectionDefinition"},j={kind:"object"},U={kind:"value"},q={kind:"collator"},G={kind:"formatted"},Z={kind:"padding"},J={kind:"resolvedImage"},X={kind:"variableAnchorOffsetCollection"};function Y(t,e){return{kind:"array",itemType:t,N:e}}function H(t){if("array"===t.kind){const e=H(t.itemType);return"number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const K=[D,$,L,R,O,N,G,j,Y(U),Z,J,X];function W(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!W(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else{if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of K)if(!W(t,e))return null}return`Expected ${H(t)} but found ${H(e)} instead.`}function Q(t,e){return e.some((e=>e.kind===t.kind))}function tt(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}function et(t,e){return"array"===t.kind&&"array"===e.kind?t.itemType.kind===e.itemType.kind&&"number"==typeof t.N:t.kind===e.kind}const rt=.96422,nt=.82521,it=4/29,st=6/29,ot=3*st*st,at=st*st*st,lt=Math.PI/180,ut=180/Math.PI;function ct(t){return(t%=360)<0&&(t+=360),t}function ht([t,e,r,n]){let s,o;const a=ft((.2225045*(t=pt(t))+.7168786*(e=pt(e))+.0606169*(r=pt(r)))/1);t===e&&e===r?s=o=a:(s=ft((.4360747*t+.3850649*e+.1430804*r)/rt),o=ft((.0139322*t+.0971045*e+.7141733*r)/nt));const l=116*a-16;return[l<0?0:l,500*(s-a),200*(a-o),n]}function pt(t){return t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function ft(t){return t>at?Math.pow(t,1/3):t/ot+it}function dt([t,e,r,n]){let s=(t+16)/116,o=isNaN(e)?s:s+e/500,a=isNaN(r)?s:s-r/200;return s=1*mt(s),o=rt*mt(o),a=nt*mt(a),[yt(3.1338561*o-1.6168667*s-.4906146*a),yt(-.9787684*o+1.9161415*s+.033454*a),yt(.0719453*o-.2289914*s+1.4052427*a),n]}function yt(t){return(t=t<=.00304?12.92*t:1.055*Math.pow(t,1/2.4)-.055)<0?0:t>1?1:t}function mt(t){return t>st?t*t*t:ot*(t-it)}function gt(t){return parseInt(t.padEnd(2,t),16)/255}function xt(t,e){return vt(e?t/100:t,0,1)}function vt(t,e,r){return Math.min(Math.max(e,t),r)}function bt(t){return!t.some(Number.isNaN)}const wt={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};function _t(t,e,r){return t+r*(e-t)}function At(t,e,r){return t.map(((t,n)=>_t(t,e[n],r)))}class St{constructor(t,e,r,n=1,s=!0){this.r=t,this.g=e,this.b=r,this.a=n,s||(this.r*=n,this.g*=n,this.b*=n,n||this.overwriteGetter("rgb",[t,e,r,n]))}static parse(t){if(t instanceof St)return t;if("string"!=typeof t)return;const e=function(t){if("transparent"===(t=t.toLowerCase().trim()))return[0,0,0,0];const e=wt[t];if(e){const[t,r,n]=e;return[t/255,r/255,n/255,1]}if(t.startsWith("#")&&/^#(?:[0-9a-f]{3,4}|[0-9a-f]{6}|[0-9a-f]{8})$/.test(t)){const e=t.length<6?1:2;let r=1;return[gt(t.slice(r,r+=e)),gt(t.slice(r,r+=e)),gt(t.slice(r,r+=e)),gt(t.slice(r,r+e)||"ff")]}if(t.startsWith("rgb")){const e=t.match(/^rgba?\(\s*([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(e){const[t,r,n,s,o,a,l,u,c,h,p,f]=e,d=[s||" ",l||" ",h].join("");if("  "===d||"  /"===d||",,"===d||",,,"===d){const t=[n,a,c].join(""),e="%%%"===t?100:""===t?255:0;if(e){const t=[vt(+r/e,0,1),vt(+o/e,0,1),vt(+u/e,0,1),p?xt(+p,f):1];if(bt(t))return t}}return}}const r=t.match(/^hsla?\(\s*([\de.+-]+)(?:deg)?(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(r){const[t,e,n,s,o,a,l,u,c]=r,h=[n||" ",o||" ",l].join("");if("  "===h||"  /"===h||",,"===h||",,,"===h){const t=[+e,vt(+s,0,100),vt(+a,0,100),u?xt(+u,c):1];if(bt(t))return function([t,e,r,n]){function s(n){const s=(n+t/30)%12,o=e*Math.min(r,1-r);return r-o*Math.max(-1,Math.min(s-3,9-s,1))}return t=ct(t),e/=100,r/=100,[s(0),s(8),s(4),n]}(t)}}}(t);return e?new St(...e,!1):void 0}get rgb(){const{r:t,g:e,b:r,a:n}=this,s=n||1/0;return this.overwriteGetter("rgb",[t/s,e/s,r/s,n])}get hcl(){return this.overwriteGetter("hcl",function(t){const[e,r,n,s]=ht(t),o=Math.sqrt(r*r+n*n);return[Math.round(1e4*o)?ct(Math.atan2(n,r)*ut):NaN,o,e,s]}(this.rgb))}get lab(){return this.overwriteGetter("lab",ht(this.rgb))}overwriteGetter(t,e){return Object.defineProperty(this,t,{value:e}),e}toString(){const[t,e,r,n]=this.rgb;return`rgba(${[t,e,r].map((t=>Math.round(255*t))).join(",")},${n})`}static interpolate(t,e,r,n="rgb"){switch(n){case"rgb":{const[n,s,o,a]=At(t.rgb,e.rgb,r);return new St(n,s,o,a,!1)}case"hcl":{const[n,s,o,a]=t.hcl,[l,u,c,h]=e.hcl;let p,f;if(isNaN(n)||isNaN(l))isNaN(n)?isNaN(l)?p=NaN:(p=l,1!==o&&0!==o||(f=u)):(p=n,1!==c&&0!==c||(f=s));else{let t=l-n;l>n&&t>180?t-=360:l<n&&n-l>180&&(t+=360),p=n+r*t}const[d,y,m,g]=function([t,e,r,n]){return t=isNaN(t)?0:t*lt,dt([r,Math.cos(t)*e,Math.sin(t)*e,n])}([p,null!=f?f:_t(s,u,r),_t(o,c,r),_t(a,h,r)]);return new St(d,y,m,g,!1)}case"lab":{const[n,s,o,a]=dt(At(t.lab,e.lab,r));return new St(n,s,o,a,!1)}}}}St.black=new St(0,0,0,1),St.white=new St(1,1,1,1),St.transparent=new St(0,0,0,0),St.red=new St(1,0,0,1);class kt{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"})}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}const Ct=["bottom","center","top"];class It{constructor(t,e,r,n,s,o){this.text=t,this.image=e,this.scale=r,this.fontStack=n,this.textColor=s,this.verticalAlign=o}}class Mt{constructor(t){this.sections=t}static fromString(t){return new Mt([new It(t,null,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&0!==t.image.name.length))}static factory(t){return t instanceof Mt?t:Mt.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}}class zt{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof zt)return t;if("number"==typeof t)return new zt([t,t,t,t]);if(Array.isArray(t)&&!(t.length<1||t.length>4)){for(const e of t)if("number"!=typeof e)return;switch(t.length){case 1:t=[t[0],t[0],t[0],t[0]];break;case 2:t=[t[0],t[1],t[0],t[1]];break;case 3:t=[t[0],t[1],t[2],t[1]]}return new zt(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r){return new zt(At(t.values,e.values,r))}}class Pt{constructor(t){this.name="ExpressionEvaluationError",this.message=t}toJSON(){return this.message}}const Et=new Set(["center","left","right","top","bottom","top-left","top-right","bottom-left","bottom-right"]);class Bt{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Bt)return t;if(Array.isArray(t)&&!(t.length<1)&&t.length%2==0){for(let e=0;e<t.length;e+=2){const r=t[e],n=t[e+1];if("string"!=typeof r||!Et.has(r))return;if(!Array.isArray(n)||2!==n.length||"number"!=typeof n[0]||"number"!=typeof n[1])return}return new Bt(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r){const n=t.values,s=e.values;if(n.length!==s.length)throw new Pt(`Cannot interpolate values of different length. from: ${t.toString()}, to: ${e.toString()}`);const o=[];for(let t=0;t<n.length;t+=2){if(n[t]!==s[t])throw new Pt(`Cannot interpolate values containing mismatched anchors. from[${t}]: ${n[t]}, to[${t}]: ${s[t]}`);o.push(n[t]);const[e,a]=n[t+1],[l,u]=s[t+1];o.push([_t(e,l,r),_t(a,u,r)])}return new Bt(o)}}class Tt{constructor(t){this.name=t.name,this.available=t.available}toString(){return this.name}static fromString(t){return t?new Tt({name:t,available:!1}):null}}class Vt{constructor(t,e,r){this.from=t,this.to=e,this.transition=r}static interpolate(t,e,r){return new Vt(t,e,r)}static parse(t){return t instanceof Vt?t:Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]?new Vt(t[0],t[1],t[2]):"object"==typeof t&&"string"==typeof t.from&&"string"==typeof t.to&&"number"==typeof t.transition?new Vt(t.from,t.to,t.transition):"string"==typeof t?new Vt(t,t,1):void 0}}function Ft(t,e,r,n){return"number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function Dt(t){if(null===t||"string"==typeof t||"boolean"==typeof t||"number"==typeof t||t instanceof Vt||t instanceof St||t instanceof kt||t instanceof Mt||t instanceof zt||t instanceof Bt||t instanceof Tt)return!0;if(Array.isArray(t)){for(const e of t)if(!Dt(e))return!1;return!0}if("object"==typeof t){for(const e in t)if(!Dt(t[e]))return!1;return!0}return!1}function Lt(t){if(null===t)return D;if("string"==typeof t)return L;if("boolean"==typeof t)return R;if("number"==typeof t)return $;if(t instanceof St)return O;if(t instanceof Vt)return N;if(t instanceof kt)return q;if(t instanceof Mt)return G;if(t instanceof zt)return Z;if(t instanceof Bt)return X;if(t instanceof Tt)return J;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=Lt(e);if(r){if(r===t)continue;r=U;break}r=t}return Y(r||U,e)}return j}function Ot(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof St||t instanceof Vt||t instanceof Mt||t instanceof zt||t instanceof Bt||t instanceof Tt?t.toString():JSON.stringify(t)}class $t{constructor(t,e){this.type=t,this.value=e}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!Dt(t[1]))return e.error("invalid value");const r=t[1];let n=Lt(r);const s=e.expectedType;return"array"!==n.kind||0!==n.N||!s||"array"!==s.kind||"number"==typeof s.N&&0!==s.N||(n=s),new $t(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return!0}}const Nt={string:L,number:$,boolean:R,object:j};class Rt{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,n=1;const s=t[0];if("array"===s){let s,o;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in Nt)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);s=Nt[r],n++}else s=U;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);o=t[2],n++}r=Y(s,o)}else{if(!Nt[s])throw new Error(`Types doesn't contain name = ${s}`);r=Nt[s]}const o=[];for(;n<t.length;n++){const r=e.parse(t[n],n,U);if(!r)return null;o.push(r)}return new Rt(r,o)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!W(this.type,Lt(r)))return r;if(e===this.args.length-1)throw new Pt(`Expected value to be of type ${H(this.type)}, but found ${H(Lt(r))} instead.`)}throw new Error}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const qt={"to-boolean":R,"to-color":O,"to-number":$,"to-string":L};class jt{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0];if(!qt[r])throw new Error(`Can't parse ${r} as it is not part of the known types`);if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");const n=qt[r],s=[];for(let r=1;r<t.length;r++){const n=e.parse(t[r],r,U);if(!n)return null;s.push(n)}return new jt(n,s)}evaluate(t){switch(this.type.kind){case"boolean":return Boolean(this.args[0].evaluate(t));case"color":{let e,r;for(const n of this.args){if(e=n.evaluate(t),r=null,e instanceof St)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rgba value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:Ft(e[0],e[1],e[2],e[3]),!r))return new St(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new Pt(r||`Could not parse color from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"padding":{let e;for(const r of this.args){e=r.evaluate(t);const n=zt.parse(e);if(n)return n}throw new Pt(`Could not parse padding from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"variableAnchorOffsetCollection":{let e;for(const r of this.args){e=r.evaluate(t);const n=Bt.parse(e);if(n)return n}throw new Pt(`Could not parse variableAnchorOffsetCollection from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"number":{let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const n=Number(e);if(!isNaN(n))return n}throw new Pt(`Could not convert ${JSON.stringify(e)} to number.`)}case"formatted":return Mt.fromString(Ot(this.args[0].evaluate(t)));case"resolvedImage":return Tt.fromString(Ot(this.args[0].evaluate(t)));case"projectionDefinition":return this.args[0].evaluate(t);default:return Ot(this.args[0].evaluate(t))}}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const te=["Unknown","Point","LineString","Polygon"];class Ut{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache={},this.availableImages=null,this.canonical=null}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?te[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(t){let e=this._parseColorCache[t];return e||(e=this._parseColorCache[t]=St.parse(t)),e}}class Gt{constructor(t,e,r=[],n,s=new E,o=[]){this.registry=t,this.path=r,this.key=r.map((t=>`[${t}]`)).join(""),this.scope=s,this.errors=o,this.expectedType=n,this._isConstant=e}parse(t,e,r,n,s={}){return e?this.concat(e,r,n)._parse(t,s):this._parse(t,s)}_parse(t,e){function r(t,e,r){return"assert"===r?new Rt(e,[t]):"coerce"===r?new jt(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n=t[0];if("string"!=typeof n)return this.error(`Expression name must be a string, but found ${typeof n} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const s=this.registry[n];if(s){let n=s.parse(t,this);if(!n)return null;if(this.expectedType){const t=this.expectedType,s=n.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==s.kind)if("projectionDefinition"!==t.kind||"string"!==s.kind&&"array"!==s.kind)if("color"!==t.kind&&"formatted"!==t.kind&&"resolvedImage"!==t.kind||"value"!==s.kind&&"string"!==s.kind)if("padding"!==t.kind||"value"!==s.kind&&"number"!==s.kind&&"array"!==s.kind)if("variableAnchorOffsetCollection"!==t.kind||"value"!==s.kind&&"array"!==s.kind){if(this.checkSubtype(t,s))return null}else n=r(n,t,e.typeAnnotation||"coerce");else n=r(n,t,e.typeAnnotation||"coerce");else n=r(n,t,e.typeAnnotation||"coerce");else n=r(n,t,e.typeAnnotation||"coerce");else n=r(n,t,e.typeAnnotation||"assert")}if(!(n instanceof $t)&&"resolvedImage"!==n.type.kind&&this._isConstant(n)){const e=new Ut;try{n=new $t(n.type,n.evaluate(e))}catch(t){return this.error(t.message),null}}return n}return this.error(`Unknown expression "${n}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r){const n="number"==typeof t?this.path.concat(t):this.path,s=r?this.scope.concat(r):this.scope;return new Gt(this.registry,this._isConstant,n,e||null,s,this.errors)}error(t,...e){const r=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new V(r,t))}checkSubtype(t,e){const r=W(t,e);return r&&this.error(r),r}}class Zt{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result)}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let n=1;n<t.length-1;n+=2){const s=t[n];if("string"!=typeof s)return e.error(`Expected string, but found ${typeof s} instead.`,n);if(/[^a-zA-Z0-9_]/.test(s))return e.error("Variable names must contain only alphanumeric characters or '_'.",n);const o=e.parse(t[n+1],n+1);if(!o)return null;r.push([s,o])}const n=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return n?new Zt(r,n):null}outputDefined(){return this.result.outputDefined()}}class Xt{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new Xt(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return!1}}class Ht{constructor(t,e,r){this.type=t,this.index=e,this.input=r}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,$),n=e.parse(t[2],2,Y(e.expectedType||U));return r&&n?new Ht(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new Pt(`Array index out of bounds: ${e} < 0.`);if(e>=r.length)throw new Pt(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e!==Math.floor(e))throw new Pt(`Array index must be an integer, but found ${e} instead.`);return r[e]}eachChild(t){t(this.index),t(this.input)}outputDefined(){return!1}}class Yt{constructor(t,e){this.type=R,this.needle=t,this.haystack=e}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,U),n=e.parse(t[2],2,U);return r&&n?Q(r.type,[R,L,$,D,U])?new Yt(r,n):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${H(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!r)return!1;if(!tt(e,["boolean","string","number","null"]))throw new Pt(`Expected first argument to be of type boolean, string, number or null, but found ${H(Lt(e))} instead.`);if(!tt(r,["string","array"]))throw new Pt(`Expected second argument to be of type array or string, but found ${H(Lt(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack)}outputDefined(){return!0}}class Jt{constructor(t,e,r){this.type=$,this.needle=t,this.haystack=e,this.fromIndex=r}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,U),n=e.parse(t[2],2,U);if(!r||!n)return null;if(!Q(r.type,[R,L,$,D,U]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${H(r.type)} instead`);if(4===t.length){const s=e.parse(t[3],3,$);return s?new Jt(r,n,s):null}return new Jt(r,n)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!tt(e,["boolean","string","number","null"]))throw new Pt(`Expected first argument to be of type boolean, string, number or null, but found ${H(Lt(e))} instead.`);let n;if(this.fromIndex&&(n=this.fromIndex.evaluate(t)),tt(r,["string"])){const t=r.indexOf(e,n);return-1===t?-1:[...r.slice(0,t)].length}if(tt(r,["array"]))return r.indexOf(e,n);throw new Pt(`Expected second argument to be of type array or string, but found ${H(Lt(r))} instead.`)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex)}outputDefined(){return!1}}class Kt{constructor(t,e,r,n,s,o){this.inputType=t,this.type=e,this.input=r,this.cases=n,this.outputs=s,this.otherwise=o}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,n;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);const s={},o=[];for(let a=2;a<t.length-1;a+=2){let l=t[a];const u=t[a+1];Array.isArray(l)||(l=[l]);const c=e.concat(a);if(0===l.length)return c.error("Expected at least one branch label.");for(const t of l){if("number"!=typeof t&&"string"!=typeof t)return c.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return c.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return c.error("Numeric branch labels must be integer values.");if(r){if(c.checkSubtype(r,Lt(t)))return null}else r=Lt(t);if(void 0!==s[String(t)])return c.error("Branch labels must be unique.");s[String(t)]=o.length}const h=e.parse(u,a,n);if(!h)return null;n=n||h.type,o.push(h)}const a=e.parse(t[1],1,U);if(!a)return null;const l=e.parse(t[t.length-1],t.length-1,n);return l?"value"!==a.type.kind&&e.concat(1).checkSubtype(r,a.type)?null:new Kt(r,n,a,s,o,l):null}evaluate(t){const e=this.input.evaluate(t);return(Lt(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}}class Wt{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n=[];for(let s=1;s<t.length-1;s+=2){const o=e.parse(t[s],s,R);if(!o)return null;const a=e.parse(t[s+1],s+1,r);if(!a)return null;n.push([o,a]),r=r||a.type}const s=e.parse(t[t.length-1],t.length-1,r);if(!s)return null;if(!r)throw new Error("Can't infer output type");return new Wt(r,n,s)}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise)}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}}class Qt{constructor(t,e,r,n){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=n}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,U),n=e.parse(t[2],2,$);if(!r||!n)return null;if(!Q(r.type,[Y(U),L,U]))return e.error(`Expected first argument to be of type array or string, but found ${H(r.type)} instead`);if(4===t.length){const s=e.parse(t[3],3,$);return s?new Qt(r.type,r,n,s):null}return new Qt(r.type,r,n)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);let n;if(this.endIndex&&(n=this.endIndex.evaluate(t)),tt(e,["string"]))return[...e].slice(r,n).join("");if(tt(e,["array"]))return e.slice(r,n);throw new Pt(`Expected first argument to be of type array or string, but found ${H(Lt(e))} instead.`)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex)}outputDefined(){return!1}}function re(t,e){const r=t.length-1;let n,s,o=0,a=r,l=0;for(;o<=a;)if(l=Math.floor((o+a)/2),n=t[l],s=t[l+1],n<=e){if(l===r||e<s)return l;o=l+1}else{if(!(n>e))throw new Pt("Input is not a number.");a=l-1}return 0}class ee{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e)}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,$);if(!r)return null;const n=[];let s=null;e.expectedType&&"value"!==e.expectedType.kind&&(s=e.expectedType);for(let r=1;r<t.length;r+=2){const o=1===r?-1/0:t[r],a=t[r+1],l=r,u=r+1;if("number"!=typeof o)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',l);if(n.length&&n[n.length-1][0]>=o)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',l);const c=e.parse(a,u,s);if(!c)return null;s=s||c.type,n.push([o,c])}return new ee(s,r,n)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const s=e.length;return n>=e[s-1]?r[s-1].evaluate(t):r[re(e,n)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}var ne,ie,se=function(){if(ie)return ne;function t(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n}return ie=1,ne=t,t.prototype={sampleCurveX:function(t){return((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return(3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var s=this.sampleCurveX(r)-t;if(Math.abs(s)<e)return r;var o=this.sampleCurveDerivativeX(r);if(Math.abs(o)<1e-6)break;r-=s/o}var a=0,l=1;for(r=t,n=0;n<20&&(s=this.sampleCurveX(r),!(Math.abs(s-t)<e));n++)t>s?a=r:l=r,r=.5*(l-a)+a;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},ne}(),oe=function(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}(se);class ae{constructor(t,e,r,n,s){this.type=t,this.operator=e,this.interpolation=r,this.input=n,this.labels=[],this.outputs=[];for(const[t,e]of s)this.labels.push(t),this.outputs.push(e)}static interpolationFactor(t,e,r,n){let s=0;if("exponential"===t.name)s=le(e,t.base,r,n);else if("linear"===t.name)s=le(e,1,r,n);else if("cubic-bezier"===t.name){const o=t.controlPoints;s=new oe(o[0],o[1],o[2],o[3]).solve(le(e,1,r,n))}return s}static parse(t,e){let[r,n,s,...o]=t;if(!Array.isArray(n)||0===n.length)return e.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const t=n[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:t}}else{if("cubic-bezier"!==n[0])return e.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const t=n.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:t}}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(s=e.parse(s,2,$),!s)return null;const a=[];let l=null;"interpolate-hcl"===r||"interpolate-lab"===r?l=O:e.expectedType&&"value"!==e.expectedType.kind&&(l=e.expectedType);for(let t=0;t<o.length;t+=2){const r=o[t],n=o[t+1],s=t+3,u=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',s);if(a.length&&a[a.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',s);const c=e.parse(n,u,l);if(!c)return null;l=l||c.type,a.push([r,c])}return et(l,$)||et(l,N)||et(l,O)||et(l,Z)||et(l,X)||et(l,Y($))?new ae(l,r,n,s,a):e.error(`Type ${H(l)} is not interpolatable.`)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const s=e.length;if(n>=e[s-1])return r[s-1].evaluate(t);const o=re(e,n),a=ae.interpolationFactor(this.interpolation,n,e[o],e[o+1]),l=r[o].evaluate(t),u=r[o+1].evaluate(t);switch(this.operator){case"interpolate":switch(this.type.kind){case"number":return _t(l,u,a);case"color":return St.interpolate(l,u,a);case"padding":return zt.interpolate(l,u,a);case"variableAnchorOffsetCollection":return Bt.interpolate(l,u,a);case"array":return At(l,u,a);case"projectionDefinition":return Vt.interpolate(l,u,a)}case"interpolate-hcl":return St.interpolate(l,u,a,"hcl");case"interpolate-lab":return St.interpolate(l,u,a,"lab")}}eachChild(t){t(this.input);for(const e of this.outputs)t(e)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function le(t,e,r,n){const s=n-r,o=t-r;return 0===s?0:1===e?o/s:(Math.pow(e,o)-1)/(Math.pow(e,s)-1)}const ue={color:St.interpolate,number:_t,padding:zt.interpolate,variableAnchorOffsetCollection:Bt.interpolate,array:At};class ce{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r=null;const n=e.expectedType;n&&"value"!==n.kind&&(r=n);const s=[];for(const n of t.slice(1)){const t=e.parse(n,1+s.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,s.push(t)}if(!r)throw new Error("No output type");const o=n&&s.some((t=>W(n,t.type)));return new ce(o?U:r,s)}evaluate(t){let e,r=null,n=0;for(const s of this.args)if(n++,r=s.evaluate(t),r&&r instanceof Tt&&!r.available&&(e||(e=r.name),r=null,n===this.args.length&&(r=e)),null!==r)break;return r}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}function he(t,e){return"=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function pe(t,e,r,n){return 0===n.compare(e,r)}function fe(t,e,r){const n="=="!==t&&"!="!==t;return class i{constructor(t,e,r){this.type=R,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let s=e.parse(t[1],1,U);if(!s)return null;if(!he(r,s.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${H(s.type)}'.`);let o=e.parse(t[2],2,U);if(!o)return null;if(!he(r,o.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${H(o.type)}'.`);if(s.type.kind!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return e.error(`Cannot compare types '${H(s.type)}' and '${H(o.type)}'.`);n&&("value"===s.type.kind&&"value"!==o.type.kind?s=new Rt(o.type,[s]):"value"!==s.type.kind&&"value"===o.type.kind&&(o=new Rt(s.type,[o])));let a=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return e.error("Cannot use collator to compare non-string types.");if(a=e.parse(t[3],3,q),!a)return null}return new i(s,o,a)}evaluate(s){const o=this.lhs.evaluate(s),a=this.rhs.evaluate(s);if(n&&this.hasUntypedArgument){const e=Lt(o),r=Lt(a);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new Pt(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const t=Lt(o),r=Lt(a);if("string"!==t.kind||"string"!==r.kind)return e(s,o,a)}return this.collator?r(s,o,a,this.collator.evaluate(s)):e(s,o,a)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator)}outputDefined(){return!0}}}const de=fe("==",(function(t,e,r){return e===r}),pe),ye=fe("!=",(function(t,e,r){return e!==r}),(function(t,e,r,n){return!pe(0,e,r,n)})),me=fe("<",(function(t,e,r){return e<r}),(function(t,e,r,n){return n.compare(e,r)<0})),ge=fe(">",(function(t,e,r){return e>r}),(function(t,e,r,n){return n.compare(e,r)>0})),xe=fe("<=",(function(t,e,r){return e<=r}),(function(t,e,r,n){return n.compare(e,r)<=0})),ve=fe(">=",(function(t,e,r){return e>=r}),(function(t,e,r,n){return n.compare(e,r)>=0}));class be{constructor(t,e,r){this.type=q,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const n=e.parse(void 0!==r["case-sensitive"]&&r["case-sensitive"],1,R);if(!n)return null;const s=e.parse(void 0!==r["diacritic-sensitive"]&&r["diacritic-sensitive"],1,R);if(!s)return null;let o=null;return r.locale&&(o=e.parse(r.locale,1,L),!o)?null:new be(n,s,o)}evaluate(t){return new kt(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale)}outputDefined(){return!1}}class we{constructor(t,e,r,n,s){this.type=L,this.number=t,this.locale=e,this.currency=r,this.minFractionDigits=n,this.maxFractionDigits=s}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,$);if(!r)return null;const n=t[2];if("object"!=typeof n||Array.isArray(n))return e.error("NumberFormat options argument must be an object.");let s=null;if(n.locale&&(s=e.parse(n.locale,1,L),!s))return null;let o=null;if(n.currency&&(o=e.parse(n.currency,1,L),!o))return null;let a=null;if(n["min-fraction-digits"]&&(a=e.parse(n["min-fraction-digits"],1,$),!a))return null;let l=null;return n["max-fraction-digits"]&&(l=e.parse(n["max-fraction-digits"],1,$),!l)?null:new we(r,s,o,a,l)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits)}outputDefined(){return!1}}class _e{constructor(t){this.type=G,this.sections=t}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const n=[];let s=!1;for(let r=1;r<=t.length-1;++r){const o=t[r];if(s&&"object"==typeof o&&!Array.isArray(o)){s=!1;let t=null;if(o["font-scale"]&&(t=e.parse(o["font-scale"],1,$),!t))return null;let r=null;if(o["text-font"]&&(r=e.parse(o["text-font"],1,Y(L)),!r))return null;let a=null;if(o["text-color"]&&(a=e.parse(o["text-color"],1,O),!a))return null;let l=null;if(o["vertical-align"]){if("string"==typeof o["vertical-align"]&&!Ct.includes(o["vertical-align"]))return e.error(`'vertical-align' must be one of: 'bottom', 'center', 'top' but found '${o["vertical-align"]}' instead.`);if(l=e.parse(o["vertical-align"],1,L),!l)return null}const u=n[n.length-1];u.scale=t,u.font=r,u.textColor=a,u.verticalAlign=l}else{const o=e.parse(t[r],1,U);if(!o)return null;const a=o.type.kind;if("string"!==a&&"value"!==a&&"null"!==a&&"resolvedImage"!==a)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");s=!0,n.push({content:o,scale:null,font:null,textColor:null,verticalAlign:null})}}return new _e(n)}evaluate(t){return new Mt(this.sections.map((e=>{const r=e.content.evaluate(t);return Lt(r)===J?new It("",r,null,null,null,e.verticalAlign?e.verticalAlign.evaluate(t):null):new It(Ot(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null,e.verticalAlign?e.verticalAlign.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor),e.verticalAlign&&t(e.verticalAlign)}outputDefined(){return!1}}class Se{constructor(t){this.type=J,this.input=t}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,L);return r?new Se(r):e.error("No image name provided.")}evaluate(t){const e=this.input.evaluate(t),r=Tt.fromString(e);return r&&t.availableImages&&(r.available=t.availableImages.indexOf(e)>-1),r}eachChild(t){t(this.input)}outputDefined(){return!1}}class ke{constructor(t){this.type=$,this.input=t}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${H(r.type)} instead.`):new ke(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return[...e].length;if(Array.isArray(e))return e.length;throw new Pt(`Expected value to be of type string or array, but found ${H(Lt(e))} instead.`)}eachChild(t){t(this.input)}outputDefined(){return!1}}const Ae=8192;function Ie(t,e){const r=(180+t[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,s=Math.pow(2,e.z);return[Math.round(r*s*Ae),Math.round(n*s*Ae)]}function Me(t,e){const r=Math.pow(2,e.z);return[(s=(t[0]/Ae+e.x)/r,360*s-180),(n=(t[1]/Ae+e.y)/r,360/Math.PI*Math.atan(Math.exp((180-360*n)*Math.PI/180))-90)];var n,s}function ze(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1])}function Be(t,e){return!(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function Pe(t,e,r){const n=t[0]-e[0],s=t[1]-e[1],o=t[0]-r[0],a=t[1]-r[1];return n*a-o*s==0&&n*o<=0&&s*a<=0}function Ce(t,e,r,n){return 0!=(s=[n[0]-r[0],n[1]-r[1]])[0]*(o=[e[0]-t[0],e[1]-t[1]])[1]-s[1]*o[0]&&!(!$e(t,e,r,n)||!$e(r,n,t,e));var s,o}function Te(t,e,r){for(const n of r)for(let r=0;r<n.length-1;++r)if(Ce(t,e,n[r],n[r+1]))return!0;return!1}function Ve(t,e,r=!1){let n=!1;for(const l of e)for(let e=0;e<l.length-1;e++){if(Pe(t,l[e],l[e+1]))return r;(o=l[e])[1]>(s=t)[1]!=(a=l[e+1])[1]>s[1]&&s[0]<(a[0]-o[0])*(s[1]-o[1])/(a[1]-o[1])+o[0]&&(n=!n)}var s,o,a;return n}function Ee(t,e){for(const r of e)if(Ve(t,r))return!0;return!1}function Fe(t,e){for(const r of t)if(!Ve(r,e))return!1;for(let r=0;r<t.length-1;++r)if(Te(t[r],t[r+1],e))return!1;return!0}function De(t,e){for(const r of e)if(Fe(t,r))return!0;return!1}function $e(t,e,r,n){const s=n[0]-r[0],o=n[1]-r[1],a=(t[0]-r[0])*o-s*(t[1]-r[1]),l=(e[0]-r[0])*o-s*(e[1]-r[1]);return a>0&&l<0||a<0&&l>0}function Le(t,e,r){const n=[];for(let s=0;s<t.length;s++){const o=[];for(let n=0;n<t[s].length;n++){const a=Ie(t[s][n],r);ze(e,a),o.push(a)}n.push(o)}return n}function Re(t,e,r){const n=[];for(let s=0;s<t.length;s++){const o=Le(t[s],e,r);n.push(o)}return n}function Oe(t,e,r,n){if(t[0]<r[0]||t[0]>r[2]){const e=.5*n;let s=t[0]-r[0]>e?-n:r[0]-t[0]>e?n:0;0===s&&(s=t[0]-r[2]>e?-n:r[2]-t[0]>e?n:0),t[0]+=s}ze(e,t)}function Ne(t,e,r,n){const s=Math.pow(2,n.z)*Ae,o=[n.x*Ae,n.y*Ae],a=[];for(const n of t)for(const t of n){const n=[t.x+o[0],t.y+o[1]];Oe(n,e,r,s),a.push(n)}return a}function je(t,e,r,n){const s=Math.pow(2,n.z)*Ae,o=[n.x*Ae,n.y*Ae],a=[];for(const r of t){const t=[];for(const n of r){const r=[n.x+o[0],n.y+o[1]];ze(e,r),t.push(r)}a.push(t)}if(e[2]-e[0]<=s/2){(l=e)[0]=l[1]=1/0,l[2]=l[3]=-1/0;for(const t of a)for(const n of t)Oe(n,e,r,s)}var l;return a}class qe{constructor(t,e){this.type=R,this.geojson=t,this.geometries=e}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Dt(t[1])){const e=t[1];if("FeatureCollection"===e.type){const t=[];for(const r of e.features){const{type:e,coordinates:n}=r.geometry;"Polygon"===e&&t.push(n),"MultiPolygon"===e&&t.push(...n)}if(t.length)return new qe(e,{type:"MultiPolygon",coordinates:t})}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new qe(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new qe(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],s=t.canonicalID();if("Polygon"===e.type){const o=Le(e.coordinates,n,s),a=Ne(t.geometry(),r,n,s);if(!Be(r,n))return!1;for(const t of a)if(!Ve(t,o))return!1}if("MultiPolygon"===e.type){const o=Re(e.coordinates,n,s),a=Ne(t.geometry(),r,n,s);if(!Be(r,n))return!1;for(const t of a)if(!Ee(t,o))return!1}return!0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],s=t.canonicalID();if("Polygon"===e.type){const o=Le(e.coordinates,n,s),a=je(t.geometry(),r,n,s);if(!Be(r,n))return!1;for(const t of a)if(!Fe(t,o))return!1}if("MultiPolygon"===e.type){const o=Re(e.coordinates,n,s),a=je(t.geometry(),r,n,s);if(!Be(r,n))return!1;for(const t of a)if(!De(t,o))return!1}return!0}(t,this.geometries)}return!1}eachChild(){}outputDefined(){return!0}}let Ue=class{constructor(t=[],e=(t,e)=>t<e?-1:t>e?1:0){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t)}push(t){this.data.push(t),this._up(this.length++)}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return--this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const s=t-1>>1,o=e[s];if(r(n,o)>=0)break;e[t]=o,t=s}e[t]=n}_down(t){const{data:e,compare:r}=this,n=this.length>>1,s=e[t];for(;t<n;){let n=1+(t<<1);const o=n+1;if(o<this.length&&r(e[o],e[n])<0&&(n=o),r(e[n],s)>=0)break;e[t]=e[n],t=n}e[t]=s}};function Ge(t,e,r=0,n=t.length-1,s=Je){for(;n>r;){if(n-r>600){const o=n-r+1,a=e-r+1,l=Math.log(o),u=.5*Math.exp(2*l/3),c=.5*Math.sqrt(l*u*(o-u)/o)*(a-o/2<0?-1:1);Ge(t,e,Math.max(r,Math.floor(e-a*u/o+c)),Math.min(n,Math.floor(e+(o-a)*u/o+c)),s)}const o=t[e];let a=r,l=n;for(Ze(t,r,e),s(t[n],o)>0&&Ze(t,r,n);a<l;){for(Ze(t,a,l),a++,l--;s(t[a],o)<0;)a++;for(;s(t[l],o)>0;)l--}0===s(t[r],o)?Ze(t,r,l):(l++,Ze(t,l,n)),l<=e&&(r=l+1),e<=l&&(n=l-1)}}function Ze(t,e,r){const n=t[e];t[e]=t[r],t[r]=n}function Je(t,e){return t<e?-1:t>e?1:0}function Xe(t,e){if(t.length<=1)return[t];const r=[];let n,s;for(const e of t){const t=He(e);0!==t&&(e.area=Math.abs(t),void 0===s&&(s=t<0),s===t<0?(n&&r.push(n),n=[e]):n.push(e))}if(n&&r.push(n),e>1)for(let t=0;t<r.length;t++)r[t].length<=e||(Ge(r[t],e,1,r[t].length-1,Ye),r[t]=r[t].slice(0,e));return r}function Ye(t,e){return e.area-t.area}function He(t){let e=0;for(let r,n,s=0,o=t.length,a=o-1;s<o;a=s++)r=t[s],n=t[a],e+=(n.x-r.x)*(r.y+n.y);return e}const Ke=1/298.257223563,We=Ke*(2-Ke),Qe=Math.PI/180;class tr{constructor(t){const e=6378.137*Qe*1e3,r=Math.cos(t*Qe),n=1/(1-We*(1-r*r)),s=Math.sqrt(n);this.kx=e*s*r,this.ky=e*s*n*(1-We)}distance(t,e){const r=this.wrap(t[0]-e[0])*this.kx,n=(t[1]-e[1])*this.ky;return Math.sqrt(r*r+n*n)}pointOnLine(t,e){let r,n,s,o,a=1/0;for(let l=0;l<t.length-1;l++){let u=t[l][0],c=t[l][1],h=this.wrap(t[l+1][0]-u)*this.kx,p=(t[l+1][1]-c)*this.ky,f=0;0===h&&0===p||(f=(this.wrap(e[0]-u)*this.kx*h+(e[1]-c)*this.ky*p)/(h*h+p*p),f>1?(u=t[l+1][0],c=t[l+1][1]):f>0&&(u+=h/this.kx*f,c+=p/this.ky*f)),h=this.wrap(e[0]-u)*this.kx,p=(e[1]-c)*this.ky;const d=h*h+p*p;d<a&&(a=d,r=u,n=c,s=l,o=f)}return{point:[r,n],index:s,t:Math.max(0,Math.min(1,o))}}wrap(t){for(;t<-180;)t+=360;for(;t>180;)t-=360;return t}}function er(t,e){return e[0]-t[0]}function rr(t){return t[1]-t[0]+1}function nr(t,e){return t[1]>=t[0]&&t[1]<e}function ir(t,e){if(t[0]>t[1])return[null,null];const r=rr(t);if(e){if(2===r)return[t,null];const e=Math.floor(r/2);return[[t[0],t[0]+e],[t[0]+e,t[1]]]}if(1===r)return[t,null];const n=Math.floor(r/2)-1;return[[t[0],t[0]+n],[t[0]+n+1,t[1]]]}function sr(t,e){if(!nr(e,t.length))return[1/0,1/0,-1/0,-1/0];const r=[1/0,1/0,-1/0,-1/0];for(let n=e[0];n<=e[1];++n)ze(r,t[n]);return r}function or(t){const e=[1/0,1/0,-1/0,-1/0];for(const r of t)for(const t of r)ze(e,t);return e}function ar(t){return t[0]!==-1/0&&t[1]!==-1/0&&t[2]!==1/0&&t[3]!==1/0}function lr(t,e,r){if(!ar(t)||!ar(e))return NaN;let n=0,s=0;return t[2]<e[0]&&(n=e[0]-t[2]),t[0]>e[2]&&(n=t[0]-e[2]),t[1]>e[3]&&(s=t[1]-e[3]),t[3]<e[1]&&(s=e[1]-t[3]),r.distance([0,0],[n,s])}function ur(t,e,r){const n=r.pointOnLine(e,t);return r.distance(t,n.point)}function cr(t,e,r,n,s){const o=Math.min(ur(t,[r,n],s),ur(e,[r,n],s)),a=Math.min(ur(r,[t,e],s),ur(n,[t,e],s));return Math.min(o,a)}function hr(t,e,r,n,s){if(!nr(e,t.length)||!nr(n,r.length))return 1/0;let o=1/0;for(let a=e[0];a<e[1];++a){const e=t[a],l=t[a+1];for(let t=n[0];t<n[1];++t){const n=r[t],a=r[t+1];if(Ce(e,l,n,a))return 0;o=Math.min(o,cr(e,l,n,a,s))}}return o}function pr(t,e,r,n,s){if(!nr(e,t.length)||!nr(n,r.length))return NaN;let o=1/0;for(let a=e[0];a<=e[1];++a)for(let e=n[0];e<=n[1];++e)if(o=Math.min(o,s.distance(t[a],r[e])),0===o)return o;return o}function fr(t,e,r){if(Ve(t,e,!0))return 0;let n=1/0;for(const s of e){const e=s[0],o=s[s.length-1];if(e!==o&&(n=Math.min(n,ur(t,[o,e],r)),0===n))return n;const a=r.pointOnLine(s,t);if(n=Math.min(n,r.distance(t,a.point)),0===n)return n}return n}function dr(t,e,r,n){if(!nr(e,t.length))return NaN;for(let n=e[0];n<=e[1];++n)if(Ve(t[n],r,!0))return 0;let s=1/0;for(let o=e[0];o<e[1];++o){const e=t[o],a=t[o+1];for(const t of r)for(let r=0,o=t.length,l=o-1;r<o;l=r++){const o=t[l],u=t[r];if(Ce(e,a,o,u))return 0;s=Math.min(s,cr(e,a,o,u,n))}}return s}function yr(t,e){for(const r of t)for(const t of r)if(Ve(t,e,!0))return!0;return!1}function mr(t,e,r,n=1/0){const s=or(t),o=or(e);if(n!==1/0&&lr(s,o,r)>=n)return n;if(Be(s,o)){if(yr(t,e))return 0}else if(yr(e,t))return 0;let a=1/0;for(const n of t)for(let t=0,s=n.length,o=s-1;t<s;o=t++){const s=n[o],l=n[t];for(const t of e)for(let e=0,n=t.length,o=n-1;e<n;o=e++){const n=t[o],u=t[e];if(Ce(s,l,n,u))return 0;a=Math.min(a,cr(s,l,n,u,r))}}return a}function gr(t,e,r,n,s,o){if(!o)return;const a=lr(sr(n,o),s,r);a<e&&t.push([a,o,[0,0]])}function xr(t,e,r,n,s,o,a){if(!o||!a)return;const l=lr(sr(n,o),sr(s,a),r);l<e&&t.push([l,o,a])}function vr(t,e,r,n,s=1/0){let o=Math.min(n.distance(t[0],r[0][0]),s);if(0===o)return o;const a=new Ue([[0,[0,t.length-1],[0,0]]],er),l=or(r);for(;a.length>0;){const s=a.pop();if(s[0]>=o)continue;const u=s[1],c=e?50:100;if(rr(u)<=c){if(!nr(u,t.length))return NaN;if(e){const e=dr(t,u,r,n);if(isNaN(e)||0===e)return e;o=Math.min(o,e)}else for(let e=u[0];e<=u[1];++e){const s=fr(t[e],r,n);if(o=Math.min(o,s),0===o)return 0}}else{const r=ir(u,e);gr(a,o,n,t,l,r[0]),gr(a,o,n,t,l,r[1])}}return o}function br(t,e,r,n,s,o=1/0){let a=Math.min(o,s.distance(t[0],r[0]));if(0===a)return a;const l=new Ue([[0,[0,t.length-1],[0,r.length-1]]],er);for(;l.length>0;){const o=l.pop();if(o[0]>=a)continue;const u=o[1],c=o[2],h=e?50:100,p=n?50:100;if(rr(u)<=h&&rr(c)<=p){if(!nr(u,t.length)&&nr(c,r.length))return NaN;let o;if(e&&n)o=hr(t,u,r,c,s),a=Math.min(a,o);else if(e&&!n){const e=t.slice(u[0],u[1]+1);for(let t=c[0];t<=c[1];++t)if(o=ur(r[t],e,s),a=Math.min(a,o),0===a)return a}else if(!e&&n){const e=r.slice(c[0],c[1]+1);for(let r=u[0];r<=u[1];++r)if(o=ur(t[r],e,s),a=Math.min(a,o),0===a)return a}else o=pr(t,u,r,c,s),a=Math.min(a,o)}else{const o=ir(u,e),h=ir(c,n);xr(l,a,s,t,r,o[0],h[0]),xr(l,a,s,t,r,o[0],h[1]),xr(l,a,s,t,r,o[1],h[0]),xr(l,a,s,t,r,o[1],h[1])}}return a}function wr(t){return"MultiPolygon"===t.type?t.coordinates.map((t=>({type:"Polygon",coordinates:t}))):"MultiLineString"===t.type?t.coordinates.map((t=>({type:"LineString",coordinates:t}))):"MultiPoint"===t.type?t.coordinates.map((t=>({type:"Point",coordinates:t}))):[t]}class _r{constructor(t,e){this.type=$,this.geojson=t,this.geometries=e}static parse(t,e){if(2!==t.length)return e.error(`'distance' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Dt(t[1])){const e=t[1];if("FeatureCollection"===e.type)return new _r(e,e.features.map((t=>wr(t.geometry))).flat());if("Feature"===e.type)return new _r(e,wr(e.geometry));if("type"in e&&"coordinates"in e)return new _r(e,wr(e))}return e.error("'distance' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=t.geometry(),n=r.flat().map((e=>Me([e.x,e.y],t.canonical)));if(0===r.length)return NaN;const s=new tr(n[0][1]);let o=1/0;for(const t of e){switch(t.type){case"Point":o=Math.min(o,br(n,!1,[t.coordinates],!1,s,o));break;case"LineString":o=Math.min(o,br(n,!1,t.coordinates,!0,s,o));break;case"Polygon":o=Math.min(o,vr(n,!1,t.coordinates,s,o))}if(0===o)return o}return o}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=t.geometry(),n=r.flat().map((e=>Me([e.x,e.y],t.canonical)));if(0===r.length)return NaN;const s=new tr(n[0][1]);let o=1/0;for(const t of e){switch(t.type){case"Point":o=Math.min(o,br(n,!0,[t.coordinates],!1,s,o));break;case"LineString":o=Math.min(o,br(n,!0,t.coordinates,!0,s,o));break;case"Polygon":o=Math.min(o,vr(n,!0,t.coordinates,s,o))}if(0===o)return o}return o}(t,this.geometries);if("Polygon"===t.geometryType())return function(t,e){const r=t.geometry();if(0===r.length||0===r[0].length)return NaN;const n=Xe(r,0).map((e=>e.map((e=>e.map((e=>Me([e.x,e.y],t.canonical))))))),s=new tr(n[0][0][0][1]);let o=1/0;for(const t of e)for(const e of n){switch(t.type){case"Point":o=Math.min(o,vr([t.coordinates],!1,e,s,o));break;case"LineString":o=Math.min(o,vr(t.coordinates,!0,e,s,o));break;case"Polygon":o=Math.min(o,mr(e,t.coordinates,s,o))}if(0===o)return o}return o}(t,this.geometries)}return NaN}eachChild(){}outputDefined(){return!0}}const Sr={"==":de,"!=":ye,">":ge,"<":me,">=":ve,"<=":xe,array:Rt,at:Ht,boolean:Rt,case:Wt,coalesce:ce,collator:be,format:_e,image:Se,in:Yt,"index-of":Jt,interpolate:ae,"interpolate-hcl":ae,"interpolate-lab":ae,length:ke,let:Zt,literal:$t,match:Kt,number:Rt,"number-format":we,object:Rt,slice:Qt,step:ee,string:Rt,"to-boolean":jt,"to-color":jt,"to-number":jt,"to-string":jt,var:Xt,within:qe,distance:_r};class kr{constructor(t,e,r,n){this.name=t,this.type=e,this._evaluate=r,this.args=n}evaluate(t){return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t)}outputDefined(){return!1}static parse(t,e){const r=t[0],n=kr.definitions[r];if(!n)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const s=Array.isArray(n)?n[0]:n.type,o=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,a=o.filter((([e])=>!Array.isArray(e)||e.length===t.length-1));let l=null;for(const[n,o]of a){l=new Gt(e.registry,Br,e.path,null,e.scope);const a=[];let u=!1;for(let e=1;e<t.length;e++){const r=t[e],s=Array.isArray(n)?n[e-1]:n.type,o=l.parse(r,1+a.length,s);if(!o){u=!0;break}a.push(o)}if(!u)if(Array.isArray(n)&&n.length!==a.length)l.error(`Expected ${n.length} arguments, but found ${a.length} instead.`);else{for(let t=0;t<a.length;t++){const e=Array.isArray(n)?n[t]:n.type,r=a[t];l.concat(t+1).checkSubtype(e,r.type)}if(0===l.errors.length)return new kr(r,s,o,a)}}if(1===a.length)e.errors.push(...l.errors);else{const r=(a.length?a:o).map((([t])=>{return e=t,Array.isArray(e)?`(${e.map(H).join(", ")})`:`(${H(e.type)}...)`;var e})).join(" | "),n=[];for(let r=1;r<t.length;r++){const s=e.parse(t[r],1+n.length);if(!s)return null;n.push(H(s.type))}e.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`)}return null}static register(t,e){kr.definitions=e;for(const r in e)t[r]=kr}}function Ar(t,[e,r,n,s]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const o=s?s.evaluate(t):1,a=Ft(e,r,n,o);if(a)throw new Pt(a);return new St(e/255,r/255,n/255,o,!1)}function Ir(t,e){return t in e}function Mr(t,e){const r=e[t];return void 0===r?null:r}function zr(t){return{type:t}}function Br(t){if(t instanceof Xt)return Br(t.boundExpression);if(t instanceof kr&&"error"===t.name)return!1;if(t instanceof be)return!1;if(t instanceof qe)return!1;if(t instanceof _r)return!1;const e=t instanceof jt||t instanceof Rt;let r=!0;return t.eachChild((t=>{r=e?r&&Br(t):r&&t instanceof $t})),!!r&&Pr(t)&&Tr(t,["zoom","heatmap-density","line-progress","accumulated","is-supported-script"])}function Pr(t){if(t instanceof kr){if("get"===t.name&&1===t.args.length)return!1;if("feature-state"===t.name)return!1;if("has"===t.name&&1===t.args.length)return!1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return!1;if(/^filter-/.test(t.name))return!1}if(t instanceof qe)return!1;if(t instanceof _r)return!1;let e=!0;return t.eachChild((t=>{e&&!Pr(t)&&(e=!1)})),e}function Cr(t){if(t instanceof kr&&"feature-state"===t.name)return!1;let e=!0;return t.eachChild((t=>{e&&!Cr(t)&&(e=!1)})),e}function Tr(t,e){if(t instanceof kr&&e.indexOf(t.name)>=0)return!1;let r=!0;return t.eachChild((t=>{r&&!Tr(t,e)&&(r=!1)})),r}function Vr(t){return{result:"success",value:t}}function Er(t){return{result:"error",value:t}}function Fr(t){return"data-driven"===t["property-type"]||"cross-faded-data-driven"===t["property-type"]}function Dr(t){return!!t.expression&&t.expression.parameters.indexOf("zoom")>-1}function $r(t){return!!t.expression&&t.expression.interpolated}function Lr(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}function Rr(t){return"object"==typeof t&&null!==t&&!Array.isArray(t)}function Or(t){return t}function Nr(t,e){const r="color"===e.type,n=t.stops&&"object"==typeof t.stops[0][0],s=n||!(n||void 0!==t.property),o=t.type||($r(e)?"exponential":"interval");if(r||"padding"===e.type){const n=r?St.parse:zt.parse;(t=F({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],n(t[1])]))),t.default=n(t.default?t.default:e.default)}if(t.colorSpace&&"rgb"!==(a=t.colorSpace)&&"hcl"!==a&&"lab"!==a)throw new Error(`Unknown color space: "${t.colorSpace}"`);var a;let l,u,c;if("exponential"===o)l=Gr;else if("interval"===o)l=qr;else if("categorical"===o){l=Ur,u=Object.create(null);for(const e of t.stops)u[e[0]]=e[1];c=typeof t.stops[0][0]}else{if("identity"!==o)throw new Error(`Unknown function type "${o}"`);l=Zr}if(n){const r={},n=[];for(let e=0;e<t.stops.length;e++){const s=t.stops[e],o=s[0].zoom;void 0===r[o]&&(r[o]={zoom:o,type:t.type,property:t.property,default:t.default,stops:[]},n.push(o)),r[o].stops.push([s[0].value,s[1]])}const s=[];for(const t of n)s.push([r[t].zoom,Nr(r[t],e)]);const o={name:"linear"};return{kind:"composite",interpolationType:o,interpolationFactor:ae.interpolationFactor.bind(void 0,o),zoomStops:s.map((t=>t[0])),evaluate:({zoom:r},n)=>Gr({stops:s,base:t.base},e,r).evaluate(r,n)}}if(s){const r="exponential"===o?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return{kind:"camera",interpolationType:r,interpolationFactor:ae.interpolationFactor.bind(void 0,r),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:r})=>l(t,e,r,u,c)}}return{kind:"source",evaluate(r,n){const s=n&&n.properties?n.properties[t.property]:void 0;return void 0===s?jr(t.default,e.default):l(t,e,s,u,c)}}}function jr(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function Ur(t,e,r,n,s){return jr(typeof r===s?n[r]:void 0,t.default,e.default)}function qr(t,e,r){if("number"!==Lr(r))return jr(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const s=re(t.stops.map((t=>t[0])),r);return t.stops[s][1]}function Gr(t,e,r){const n=void 0!==t.base?t.base:1;if("number"!==Lr(r))return jr(t.default,e.default);const s=t.stops.length;if(1===s)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[s-1][0])return t.stops[s-1][1];const o=re(t.stops.map((t=>t[0])),r),a=function(t,e,r,n){const s=n-r,o=t-r;return 0===s?0:1===e?o/s:(Math.pow(e,o)-1)/(Math.pow(e,s)-1)}(r,n,t.stops[o][0],t.stops[o+1][0]),l=t.stops[o][1],u=t.stops[o+1][1],c=ue[e.type]||Or;return"function"==typeof l.evaluate?{evaluate(...e){const r=l.evaluate.apply(void 0,e),n=u.evaluate.apply(void 0,e);if(void 0!==r&&void 0!==n)return c(r,n,a,t.colorSpace)}}:c(l,u,a,t.colorSpace)}function Zr(t,e,r){switch(e.type){case"color":r=St.parse(r);break;case"formatted":r=Mt.fromString(r.toString());break;case"resolvedImage":r=Tt.fromString(r.toString());break;case"padding":r=zt.parse(r);break;default:Lr(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0)}return jr(r,t.default,e.default)}kr.register(Sr,{error:[{kind:"error"},[L],(t,[e])=>{throw new Pt(e.evaluate(t))}],typeof:[L,[U],(t,[e])=>H(Lt(e.evaluate(t)))],"to-rgba":[Y($,4),[O],(t,[e])=>{const[r,n,s,o]=e.evaluate(t).rgb;return[255*r,255*n,255*s,o]}],rgb:[O,[$,$,$],Ar],rgba:[O,[$,$,$,$],Ar],has:{type:R,overloads:[[[L],(t,[e])=>Ir(e.evaluate(t),t.properties())],[[L,j],(t,[e,r])=>Ir(e.evaluate(t),r.evaluate(t))]]},get:{type:U,overloads:[[[L],(t,[e])=>Mr(e.evaluate(t),t.properties())],[[L,j],(t,[e,r])=>Mr(e.evaluate(t),r.evaluate(t))]]},"feature-state":[U,[L],(t,[e])=>Mr(e.evaluate(t),t.featureState||{})],properties:[j,[],t=>t.properties()],"geometry-type":[L,[],t=>t.geometryType()],id:[U,[],t=>t.id()],zoom:[$,[],t=>t.globals.zoom],"heatmap-density":[$,[],t=>t.globals.heatmapDensity||0],"line-progress":[$,[],t=>t.globals.lineProgress||0],accumulated:[U,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[$,zr($),(t,e)=>{let r=0;for(const n of e)r+=n.evaluate(t);return r}],"*":[$,zr($),(t,e)=>{let r=1;for(const n of e)r*=n.evaluate(t);return r}],"-":{type:$,overloads:[[[$,$],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[$],(t,[e])=>-e.evaluate(t)]]},"/":[$,[$,$],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[$,[$,$],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[$,[],()=>Math.LN2],pi:[$,[],()=>Math.PI],e:[$,[],()=>Math.E],"^":[$,[$,$],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[$,[$],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[$,[$],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[$,[$],(t,[e])=>Math.log(e.evaluate(t))],log2:[$,[$],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[$,[$],(t,[e])=>Math.sin(e.evaluate(t))],cos:[$,[$],(t,[e])=>Math.cos(e.evaluate(t))],tan:[$,[$],(t,[e])=>Math.tan(e.evaluate(t))],asin:[$,[$],(t,[e])=>Math.asin(e.evaluate(t))],acos:[$,[$],(t,[e])=>Math.acos(e.evaluate(t))],atan:[$,[$],(t,[e])=>Math.atan(e.evaluate(t))],min:[$,zr($),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[$,zr($),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[$,[$],(t,[e])=>Math.abs(e.evaluate(t))],round:[$,[$],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[$,[$],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[$,[$],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[R,[L,U],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[R,[U],(t,[e])=>t.id()===e.value],"filter-type-==":[R,[L],(t,[e])=>t.geometryType()===e.value],"filter-<":[R,[L,U],(t,[e,r])=>{const n=t.properties()[e.value],s=r.value;return typeof n==typeof s&&n<s}],"filter-id-<":[R,[U],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<n}],"filter->":[R,[L,U],(t,[e,r])=>{const n=t.properties()[e.value],s=r.value;return typeof n==typeof s&&n>s}],"filter-id->":[R,[U],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>n}],"filter-<=":[R,[L,U],(t,[e,r])=>{const n=t.properties()[e.value],s=r.value;return typeof n==typeof s&&n<=s}],"filter-id-<=":[R,[U],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<=n}],"filter->=":[R,[L,U],(t,[e,r])=>{const n=t.properties()[e.value],s=r.value;return typeof n==typeof s&&n>=s}],"filter-id->=":[R,[U],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>=n}],"filter-has":[R,[U],(t,[e])=>e.value in t.properties()],"filter-has-id":[R,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[R,[Y(L)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[R,[Y(U)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[R,[L,Y(U)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[R,[L,Y(U)],(t,[e,r])=>function(t,e,r,n){for(;r<=n;){const s=r+n>>1;if(e[s]===t)return!0;e[s]>t?n=s-1:r=s+1}return!1}(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:R,overloads:[[[R,R],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[zr(R),(t,e)=>{for(const r of e)if(!r.evaluate(t))return!1;return!0}]]},any:{type:R,overloads:[[[R,R],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[zr(R),(t,e)=>{for(const r of e)if(r.evaluate(t))return!0;return!1}]]},"!":[R,[R],(t,[e])=>!e.evaluate(t)],"is-supported-script":[R,[L],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return!r||r(e.evaluate(t))}],upcase:[L,[L],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[L,[L],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[L,zr(U),(t,e)=>e.map((e=>Ot(e.evaluate(t)))).join("")],"resolved-locale":[L,[q],(t,[e])=>e.evaluate(t).resolvedLocale()]});class Xr{constructor(t,e){var r;this.expression=t,this._warningHistory={},this._evaluator=new Ut,this._defaultValue=e?"color"===(r=e).type&&Rr(r.default)?new St(0,0,0,0):"color"===r.type?St.parse(r.default)||null:"padding"===r.type?zt.parse(r.default)||null:"variableAnchorOffsetCollection"===r.type?Bt.parse(r.default)||null:"projectionDefinition"===r.type?Vt.parse(r.default)||null:void 0===r.default?null:r.default:null,this._enumValues=e&&"enum"===e.type?e.values:null}evaluateWithoutErrorHandling(t,e,r,n,s,o){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=n,this._evaluator.availableImages=s||null,this._evaluator.formattedSection=o,this.expression.evaluate(this._evaluator)}evaluate(t,e,r,n,s,o){this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n,this._evaluator.availableImages=s||null,this._evaluator.formattedSection=o||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new Pt(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function Yr(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in Sr}function Hr(t,e){const r=new Gt(Sr,Br,[],e?function(t){const e={color:O,string:L,number:$,enum:L,boolean:R,formatted:G,padding:Z,projectionDefinition:N,resolvedImage:J,variableAnchorOffsetCollection:X};return"array"===t.type?Y(e[t.value]||U,t.length):e[t.type]}(e):void 0),n=r.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return n?Vr(new Xr(n,e)):Er(r.errors)}class Jr{constructor(t,e){this.kind=t,this._styleExpression=e,this.isStateDependent="constant"!==t&&!Cr(e.expression)}evaluateWithoutErrorHandling(t,e,r,n,s,o){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,s,o)}evaluate(t,e,r,n,s,o){return this._styleExpression.evaluate(t,e,r,n,s,o)}}class Kr{constructor(t,e,r,n){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!Cr(e.expression),this.interpolationType=n}evaluateWithoutErrorHandling(t,e,r,n,s,o){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,s,o)}evaluate(t,e,r,n,s,o){return this._styleExpression.evaluate(t,e,r,n,s,o)}interpolationFactor(t,e,r){return this.interpolationType?ae.interpolationFactor(this.interpolationType,t,e,r):0}}function Wr(t,e){const r=Hr(t,e);if("error"===r.result)return r;const n=r.value.expression,s=Pr(n);if(!s&&!Fr(e))return Er([new V("","data expressions not supported")]);const o=Tr(n,["zoom"]);if(!o&&!Dr(e))return Er([new V("","zoom expressions not supported")]);const a=tn(n);return a||o?a instanceof V?Er([a]):a instanceof ae&&!$r(e)?Er([new V("",'"interpolate" expressions cannot be used with this property')]):Vr(a?new Kr(s?"camera":"composite",r.value,a.labels,a instanceof ae?a.interpolation:void 0):new Jr(s?"constant":"source",r.value)):Er([new V("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class Qr{constructor(t,e){this._parameters=t,this._specification=e,F(this,Nr(this._parameters,this._specification))}static deserialize(t){return new Qr(t._parameters,t._specification)}static serialize(t){return{_parameters:t._parameters,_specification:t._specification}}}function tn(t){let e=null;if(t instanceof Zt)e=tn(t.result);else if(t instanceof ce){for(const r of t.args)if(e=tn(r),e)break}else(t instanceof ee||t instanceof ae)&&t.input instanceof kr&&"zoom"===t.input.name&&(e=t);return e instanceof V||t.eachChild((t=>{const r=tn(t);r instanceof V?e=r:!e&&r?e=new V("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):e&&r&&e!==r&&(e=new V("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'))})),e}function en(t){if(!0===t||!1===t)return!0;if(!Array.isArray(t)||0===t.length)return!1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return!1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!en(e)&&"boolean"!=typeof e)return!1;return!0;default:return!0}}const rn={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function nn(t){if(null==t)return{filter:()=>!0,needGeometry:!1};en(t)||(t=an(t));const e=Hr(t,rn);if("error"===e.result)throw new Error(e.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return{filter:(t,r,n)=>e.value.evaluate(t,r,{},n),needGeometry:on(t)}}function sn(t,e){return t<e?-1:t>e?1:0}function on(t){if(!Array.isArray(t))return!1;if("within"===t[0]||"distance"===t[0])return!0;for(let e=1;e<t.length;e++)if(on(t[e]))return!0;return!1}function an(t){if(!t)return!0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?ln(t[1],t[2],"=="):"!="===e?hn(ln(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?ln(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(an))):"all"===e?["all"].concat(t.slice(1).map(an)):"none"===e?["all"].concat(t.slice(1).map(an).map(hn)):"in"===e?un(t[1],t.slice(2)):"!in"===e?hn(un(t[1],t.slice(2))):"has"===e?cn(t[1]):"!has"!==e||hn(cn(t[1]));var r}function ln(t,e,r){switch(t){case"$type":return[`filter-type-${r}`,e];case"$id":return[`filter-id-${r}`,e];default:return[`filter-${r}`,t,e]}}function un(t,e){if(0===e.length)return!1;switch(t){case"$type":return["filter-type-in",["literal",e]];case"$id":return["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(sn)]]:["filter-in-small",t,["literal",e]]}}function cn(t){switch(t){case"$type":return!0;case"$id":return["filter-has-id"];default:return["filter-has",t]}}function hn(t){return["!",t]}function pn(t){const e=typeof t;if("number"===e||"boolean"===e||"string"===e||null==t)return JSON.stringify(t);if(Array.isArray(t)){let e="[";for(const r of t)e+=`${pn(r)},`;return`${e}]`}const r=Object.keys(t).sort();let n="{";for(let e=0;e<r.length;e++)n+=`${JSON.stringify(r[e])}:${pn(t[r[e]])},`;return`${n}}`}function fn(t){let e="";for(const r of T)e+=`/${pn(t[r])}`;return e}function dn(t){const e=t.value;return e?[new B(t.key,e,"constants have been deprecated as of v8")]:[]}function yn(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function mn(t){if(Array.isArray(t))return t.map(mn);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=mn(t[r]);return e}return yn(t)}function gn(t){const e=t.key,r=t.value,n=t.valueSpec||{},s=t.objectElementValidators||{},o=t.style,a=t.styleSpec,l=t.validateSpec;let u=[];const c=Lr(r);if("object"!==c)return[new B(e,r,`object expected, ${c} found`)];for(const t in r){const c=t.split(".")[0],h=n[c]||n["*"];let p;if(s[c])p=s[c];else if(n[c])p=l;else if(s["*"])p=s["*"];else{if(!n["*"]){u.push(new B(e,r[t],`unknown property "${t}"`));continue}p=l}u=u.concat(p({key:(e?`${e}.`:e)+t,value:r[t],valueSpec:h,style:o,styleSpec:a,object:r,objectKey:t,validateSpec:l},r))}for(const t in n)s[t]||n[t].required&&void 0===n[t].default&&void 0===r[t]&&u.push(new B(e,r,`missing required property "${t}"`));return u}function xn(t){const e=t.value,r=t.valueSpec,n=t.style,s=t.styleSpec,o=t.key,a=t.arrayElementValidator||t.validateSpec;if("array"!==Lr(e))return[new B(o,e,`array expected, ${Lr(e)} found`)];if(r.length&&e.length!==r.length)return[new B(o,e,`array length ${r.length} expected, length ${e.length} found`)];if(r["min-length"]&&e.length<r["min-length"])return[new B(o,e,`array length at least ${r["min-length"]} expected, length ${e.length} found`)];let l={type:r.value,values:r.values};s.$version<7&&(l.function=r.function),"object"===Lr(r.value)&&(l=r.value);let u=[];for(let r=0;r<e.length;r++)u=u.concat(a({array:e,arrayIndex:r,value:e[r],valueSpec:l,validateSpec:t.validateSpec,style:n,styleSpec:s,key:`${o}[${r}]`}));return u}function vn(t){const e=t.key,r=t.value,n=t.valueSpec;let s=Lr(r);return"number"===s&&r!=r&&(s="NaN"),"number"!==s?[new B(e,r,`number expected, ${s} found`)]:"minimum"in n&&r<n.minimum?[new B(e,r,`${r} is less than the minimum value ${n.minimum}`)]:"maximum"in n&&r>n.maximum?[new B(e,r,`${r} is greater than the maximum value ${n.maximum}`)]:[]}function bn(t){const e=t.valueSpec,r=yn(t.value.type);let n,s,o,a={};const l="categorical"!==r&&void 0===t.value.property,u=!l,c="array"===Lr(t.value.stops)&&"array"===Lr(t.value.stops[0])&&"object"===Lr(t.value.stops[0][0]),h=gn({key:t.key,value:t.value,valueSpec:t.styleSpec.function,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===r)return[new B(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const n=t.value;return e=e.concat(xn({key:t.key,value:n,valueSpec:t.valueSpec,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:p})),"array"===Lr(n)&&0===n.length&&e.push(new B(t.key,n,"array must have at least one stop")),e},default:function(t){return t.validateSpec({key:t.key,value:t.value,valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec})}}});return"identity"===r&&l&&h.push(new B(t.key,t.value,'missing required property "property"')),"identity"===r||t.value.stops||h.push(new B(t.key,t.value,'missing required property "stops"')),"exponential"===r&&t.valueSpec.expression&&!$r(t.valueSpec)&&h.push(new B(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(u&&!Fr(t.valueSpec)?h.push(new B(t.key,t.value,"property functions not supported")):l&&!Dr(t.valueSpec)&&h.push(new B(t.key,t.value,"zoom functions not supported"))),"categorical"!==r&&!c||void 0!==t.value.property||h.push(new B(t.key,t.value,'"property" property is required')),h;function p(t){let r=[];const n=t.value,l=t.key;if("array"!==Lr(n))return[new B(l,n,`array expected, ${Lr(n)} found`)];if(2!==n.length)return[new B(l,n,`array length 2 expected, length ${n.length} found`)];if(c){if("object"!==Lr(n[0]))return[new B(l,n,`object expected, ${Lr(n[0])} found`)];if(void 0===n[0].zoom)return[new B(l,n,"object stop key must have zoom")];if(void 0===n[0].value)return[new B(l,n,"object stop key must have value")];if(o&&o>yn(n[0].zoom))return[new B(l,n[0].zoom,"stop zoom values must appear in ascending order")];yn(n[0].zoom)!==o&&(o=yn(n[0].zoom),s=void 0,a={}),r=r.concat(gn({key:`${l}[0]`,value:n[0],valueSpec:{zoom:{}},validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:vn,value:f}}))}else r=r.concat(f({key:`${l}[0]`,value:n[0],validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec},n));return Yr(mn(n[1]))?r.concat([new B(`${l}[1]`,n[1],"expressions are not allowed in function stops.")]):r.concat(t.validateSpec({key:`${l}[1]`,value:n[1],valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec}))}function f(t,o){const l=Lr(t.value),u=yn(t.value),c=null!==t.value?t.value:o;if(n){if(l!==n)return[new B(t.key,c,`${l} stop domain type must match previous stop domain type ${n}`)]}else n=l;if("number"!==l&&"string"!==l&&"boolean"!==l)return[new B(t.key,c,"stop domain value must be a number, string, or boolean")];if("number"!==l&&"categorical"!==r){let n=`number expected, ${l} found`;return Fr(e)&&void 0===r&&(n+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new B(t.key,c,n)]}return"categorical"!==r||"number"!==l||isFinite(u)&&Math.floor(u)===u?"categorical"!==r&&"number"===l&&void 0!==s&&u<s?[new B(t.key,c,"stop domain values must appear in ascending order")]:(s=u,"categorical"===r&&u in a?[new B(t.key,c,"stop domain values must be unique")]:(a[u]=!0,[])):[new B(t.key,c,`integer expected, found ${u}`)]}}function wn(t){const e=("property"===t.expressionContext?Wr:Hr)(mn(t.value),t.valueSpec);if("error"===e.result)return e.value.map((e=>new B(`${t.key}${e.key}`,t.value,e.message)));const r=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!r.outputDefined())return[new B(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!Cr(r))return[new B(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext&&!Cr(r))return[new B(t.key,t.value,'"feature-state" data expressions are not supported with filters.')];if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!Tr(r,["zoom","feature-state"]))return[new B(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!Pr(r))return[new B(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return[]}function _n(t){const e=t.key,r=t.value,n=t.valueSpec,s=[];return Array.isArray(n.values)?-1===n.values.indexOf(yn(r))&&s.push(new B(e,r,`expected one of [${n.values.join(", ")}], ${JSON.stringify(r)} found`)):-1===Object.keys(n.values).indexOf(yn(r))&&s.push(new B(e,r,`expected one of [${Object.keys(n.values).join(", ")}], ${JSON.stringify(r)} found`)),s}function Sn(t){return en(mn(t.value))?wn(F({},t,{expressionContext:"filter",valueSpec:{value:"boolean"}})):kn(t)}function kn(t){const e=t.value,r=t.key;if("array"!==Lr(e))return[new B(r,e,`array expected, ${Lr(e)} found`)];const n=t.styleSpec;let s,o=[];if(e.length<1)return[new B(r,e,"filter array must have at least 1 element")];switch(o=o.concat(_n({key:`${r}[0]`,value:e[0],valueSpec:n.filter_operator,style:t.style,styleSpec:t.styleSpec})),yn(e[0])){case"<":case"<=":case">":case">=":e.length>=2&&"$type"===yn(e[1])&&o.push(new B(r,e,`"$type" cannot be use with operator "${e[0]}"`));case"==":case"!=":3!==e.length&&o.push(new B(r,e,`filter array for operator "${e[0]}" must have 3 elements`));case"in":case"!in":e.length>=2&&(s=Lr(e[1]),"string"!==s&&o.push(new B(`${r}[1]`,e[1],`string expected, ${s} found`)));for(let a=2;a<e.length;a++)s=Lr(e[a]),"$type"===yn(e[1])?o=o.concat(_n({key:`${r}[${a}]`,value:e[a],valueSpec:n.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==s&&"number"!==s&&"boolean"!==s&&o.push(new B(`${r}[${a}]`,e[a],`string, number, or boolean expected, ${s} found`));break;case"any":case"all":case"none":for(let n=1;n<e.length;n++)o=o.concat(kn({key:`${r}[${n}]`,value:e[n],style:t.style,styleSpec:t.styleSpec}));break;case"has":case"!has":s=Lr(e[1]),2!==e.length?o.push(new B(r,e,`filter array for "${e[0]}" operator must have 2 elements`)):"string"!==s&&o.push(new B(`${r}[1]`,e[1],`string expected, ${s} found`))}return o}function An(t,e){const r=t.key,n=t.validateSpec,s=t.style,o=t.styleSpec,a=t.value,l=t.objectKey,u=o[`${e}_${t.layerType}`];if(!u)return[];const c=l.match(/^(.*)-transition$/);if("paint"===e&&c&&u[c[1]]&&u[c[1]].transition)return n({key:r,value:a,valueSpec:o.transition,style:s,styleSpec:o});const h=t.valueSpec||u[l];if(!h)return[new B(r,a,`unknown property "${l}"`)];let p;if("string"===Lr(a)&&Fr(h)&&!h.tokens&&(p=/^{([^}]+)}$/.exec(a)))return[new B(r,a,`"${l}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(p[1])} }\`.`)];const f=[];return"symbol"===t.layerType&&("text-field"===l&&s&&!s.glyphs&&f.push(new B(r,a,'use of "text-field" requires a style "glyphs" property')),"text-font"===l&&Rr(mn(a))&&"identity"===yn(a.type)&&f.push(new B(r,a,'"text-font" does not support identity functions'))),f.concat(n({key:t.key,value:a,valueSpec:h,style:s,styleSpec:o,expressionContext:"property",propertyType:e,propertyKey:l}))}function In(t){return An(t,"paint")}function Mn(t){return An(t,"layout")}function zn(t){let e=[];const r=t.value,n=t.key,s=t.style,o=t.styleSpec;r.type||r.ref||e.push(new B(n,r,'either "type" or "ref" is required'));let a=yn(r.type);const l=yn(r.ref);if(r.id){const o=yn(r.id);for(let a=0;a<t.arrayIndex;a++){const t=s.layers[a];yn(t.id)===o&&e.push(new B(n,r.id,`duplicate layer id "${r.id}", previously used at line ${t.id.__line__}`))}}if("ref"in r){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in r&&e.push(new B(n,r[t],`"${t}" is prohibited for ref layers`))})),s.layers.forEach((e=>{yn(e.id)===l&&(t=e)})),t?t.ref?e.push(new B(n,r.ref,"ref cannot reference another ref layer")):a=yn(t.type):e.push(new B(n,r.ref,`ref layer "${l}" not found`))}else if("background"!==a)if(r.source){const t=s.sources&&s.sources[r.source],o=t&&yn(t.type);t?"vector"===o&&"raster"===a?e.push(new B(n,r.source,`layer "${r.id}" requires a raster source`)):"raster-dem"!==o&&"hillshade"===a?e.push(new B(n,r.source,`layer "${r.id}" requires a raster-dem source`)):"raster"===o&&"raster"!==a?e.push(new B(n,r.source,`layer "${r.id}" requires a vector source`)):"vector"!==o||r["source-layer"]?"raster-dem"===o&&"hillshade"!==a?e.push(new B(n,r.source,"raster-dem source can only be used with layer type 'hillshade'.")):"line"!==a||!r.paint||!r.paint["line-gradient"]||"geojson"===o&&t.lineMetrics||e.push(new B(n,r,`layer "${r.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new B(n,r,`layer "${r.id}" must specify a "source-layer"`)):e.push(new B(n,r.source,`source "${r.source}" not found`))}else e.push(new B(n,r,'missing required property "source"'));return e=e.concat(gn({key:n,value:r,valueSpec:o.layer,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":()=>[],type:()=>t.validateSpec({key:`${n}.type`,value:r.type,valueSpec:o.layer.type,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,object:r,objectKey:"type"}),filter:Sn,layout:t=>gn({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>Mn(F({layerType:a},t))}}),paint:t=>gn({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>In(F({layerType:a},t))}})}})),e}function Bn(t){const e=t.value,r=t.key,n=Lr(e);return"string"!==n?[new B(r,e,`string expected, ${n} found`)]:[]}const Pn={promoteId:function({key:t,value:e}){if("string"===Lr(e))return Bn({key:t,value:e});{const r=[];for(const n in e)r.push(...Bn({key:`${t}.${n}`,value:e[n]}));return r}}};function Cn(t){const e=t.value,r=t.key,n=t.styleSpec,s=t.style,o=t.validateSpec;if(!e.type)return[new B(r,e,'"type" is required')];const a=yn(e.type);let l;switch(a){case"vector":case"raster":return l=gn({key:r,value:e,valueSpec:n[`source_${a.replace("-","_")}`],style:t.style,styleSpec:n,objectElementValidators:Pn,validateSpec:o}),l;case"raster-dem":return l=function(t){var e;const r=null!==(e=t.sourceName)&&void 0!==e?e:"",n=t.value,s=t.styleSpec,o=s.source_raster_dem,a=t.style;let l=[];const u=Lr(n);if(void 0===n)return l;if("object"!==u)return l.push(new B("source_raster_dem",n,`object expected, ${u} found`)),l;const c="custom"===yn(n.encoding),h=["redFactor","greenFactor","blueFactor","baseShift"],p=t.value.encoding?`"${t.value.encoding}"`:"Default";for(const e in n)!c&&h.includes(e)?l.push(new B(e,n[e],`In "${r}": "${e}" is only valid when "encoding" is set to "custom". ${p} encoding found`)):o[e]?l=l.concat(t.validateSpec({key:e,value:n[e],valueSpec:o[e],validateSpec:t.validateSpec,style:a,styleSpec:s})):l.push(new B(e,n[e],`unknown property "${e}"`));return l}({sourceName:r,value:e,style:t.style,styleSpec:n,validateSpec:o}),l;case"geojson":if(l=gn({key:r,value:e,valueSpec:n.source_geojson,style:s,styleSpec:n,validateSpec:o,objectElementValidators:Pn}),e.cluster)for(const t in e.clusterProperties){const[n,s]=e.clusterProperties[t],o="string"==typeof n?[n,["accumulated"],["get",t]]:n;l.push(...wn({key:`${r}.${t}.map`,value:s,expressionContext:"cluster-map"})),l.push(...wn({key:`${r}.${t}.reduce`,value:o,expressionContext:"cluster-reduce"}))}return l;case"video":return gn({key:r,value:e,valueSpec:n.source_video,style:s,validateSpec:o,styleSpec:n});case"image":return gn({key:r,value:e,valueSpec:n.source_image,style:s,validateSpec:o,styleSpec:n});case"canvas":return[new B(r,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return _n({key:`${r}.type`,value:e.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]}})}}function Tn(t){const e=t.value,r=t.styleSpec,n=r.light,s=t.style;let o=[];const a=Lr(e);if(void 0===e)return o;if("object"!==a)return o=o.concat([new B("light",e,`object expected, ${a} found`)]),o;for(const a in e){const l=a.match(/^(.*)-transition$/);o=o.concat(l&&n[l[1]]&&n[l[1]].transition?t.validateSpec({key:a,value:e[a],valueSpec:r.transition,validateSpec:t.validateSpec,style:s,styleSpec:r}):n[a]?t.validateSpec({key:a,value:e[a],valueSpec:n[a],validateSpec:t.validateSpec,style:s,styleSpec:r}):[new B(a,e[a],`unknown property "${a}"`)])}return o}function Vn(t){const e=t.value,r=t.styleSpec,n=r.sky,s=t.style,o=Lr(e);if(void 0===e)return[];if("object"!==o)return[new B("sky",e,`object expected, ${o} found`)];let a=[];for(const o in e)a=a.concat(n[o]?t.validateSpec({key:o,value:e[o],valueSpec:n[o],style:s,styleSpec:r}):[new B(o,e[o],`unknown property "${o}"`)]);return a}function En(t){const e=t.value,r=t.styleSpec,n=r.terrain,s=t.style;let o=[];const a=Lr(e);if(void 0===e)return o;if("object"!==a)return o=o.concat([new B("terrain",e,`object expected, ${a} found`)]),o;for(const a in e)o=o.concat(n[a]?t.validateSpec({key:a,value:e[a],valueSpec:n[a],validateSpec:t.validateSpec,style:s,styleSpec:r}):[new B(a,e[a],`unknown property "${a}"`)]);return o}function Fn(t){let e=[];const r=t.value,n=t.key;if(Array.isArray(r)){const s=[],o=[];for(const a in r)r[a].id&&s.includes(r[a].id)&&e.push(new B(n,r,`all the sprites' ids must be unique, but ${r[a].id} is duplicated`)),s.push(r[a].id),r[a].url&&o.includes(r[a].url)&&e.push(new B(n,r,`all the sprites' URLs must be unique, but ${r[a].url} is duplicated`)),o.push(r[a].url),e=e.concat(gn({key:`${n}[${a}]`,value:r[a],valueSpec:{id:{type:"string",required:!0},url:{type:"string",required:!0}},validateSpec:t.validateSpec}));return e}return Bn({key:n,value:r})}const Dn={"*":()=>[],array:xn,boolean:function(t){const e=t.value,r=t.key,n=Lr(e);return"boolean"!==n?[new B(r,e,`boolean expected, ${n} found`)]:[]},number:vn,color:function(t){const e=t.key,r=t.value,n=Lr(r);return"string"!==n?[new B(e,r,`color expected, ${n} found`)]:St.parse(String(r))?[]:[new B(e,r,`color expected, "${r}" found`)]},constants:dn,enum:_n,filter:Sn,function:bn,layer:zn,object:gn,source:Cn,light:Tn,sky:Vn,terrain:En,projection:function(t){const e=t.value,r=t.styleSpec,n=r.projection,s=t.style,o=Lr(e);if(void 0===e)return[];if("object"!==o)return[new B("projection",e,`object expected, ${o} found`)];let a=[];for(const o in e)a=a.concat(n[o]?t.validateSpec({key:o,value:e[o],valueSpec:n[o],style:s,styleSpec:r}):[new B(o,e[o],`unknown property "${o}"`)]);return a},projectionDefinition:function(t){const e=t.key;let r=t.value;r=r instanceof String?r.valueOf():r;const n=Lr(r);return"array"!==n||function(t){return Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]}(r)||function(t){return!!["interpolate","step","literal"].includes(t[0])}(r)?["array","string"].includes(n)?[]:[new B(e,r,`projection expected, invalid type "${n}" found`)]:[new B(e,r,`projection expected, invalid array ${JSON.stringify(r)} found`)]},string:Bn,formatted:function(t){return 0===Bn(t).length?[]:wn(t)},resolvedImage:function(t){return 0===Bn(t).length?[]:wn(t)},padding:function(t){const e=t.key,r=t.value;if("array"===Lr(r)){if(r.length<1||r.length>4)return[new B(e,r,`padding requires 1 to 4 values; ${r.length} values found`)];const n={type:"number"};let s=[];for(let o=0;o<r.length;o++)s=s.concat(t.validateSpec({key:`${e}[${o}]`,value:r[o],validateSpec:t.validateSpec,valueSpec:n}));return s}return vn({key:e,value:r,valueSpec:{}})},variableAnchorOffsetCollection:function(t){const e=t.key,r=t.value,n=Lr(r),s=t.styleSpec;if("array"!==n||r.length<1||r.length%2!=0)return[new B(e,r,"variableAnchorOffsetCollection requires a non-empty array of even length")];let o=[];for(let n=0;n<r.length;n+=2)o=o.concat(_n({key:`${e}[${n}]`,value:r[n],valueSpec:s.layout_symbol["text-anchor"]})),o=o.concat(xn({key:`${e}[${n+1}]`,value:r[n+1],valueSpec:{length:2,value:"number"},validateSpec:t.validateSpec,style:t.style,styleSpec:s}));return o},sprite:Fn};function $n(t){const e=t.value,r=t.valueSpec,n=t.styleSpec;return t.validateSpec=$n,r.expression&&Rr(yn(e))?bn(t):r.expression&&Yr(mn(e))?wn(t):r.type&&Dn[r.type]?Dn[r.type](t):gn(F({},t,{valueSpec:r.type?n[r.type]:r}))}function Ln(t){const e=t.value,r=t.key,n=Bn(t);return n.length||(-1===e.indexOf("{fontstack}")&&n.push(new B(r,e,'"glyphs" url must include a "{fontstack}" token')),-1===e.indexOf("{range}")&&n.push(new B(r,e,'"glyphs" url must include a "{range}" token'))),n}function Rn(t,e=C){let r=[];return r=r.concat($n({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,validateSpec:$n,objectElementValidators:{glyphs:Ln,"*":()=>[]}})),t.constants&&(r=r.concat(dn({key:"constants",value:t.constants}))),Nn(r)}function On(t){return function(e){return t({...e,validateSpec:$n})}}function Nn(t){return[].concat(t).sort(((t,e)=>t.line-e.line))}function jn(t){return function(...e){return Nn(t.apply(this,e))}}Rn.source=jn(On(Cn)),Rn.sprite=jn(On(Fn)),Rn.glyphs=jn(On(Ln)),Rn.light=jn(On(Tn)),Rn.sky=jn(On(Vn)),Rn.terrain=jn(On(En)),Rn.layer=jn(On(zn)),Rn.filter=jn(On(Sn)),Rn.paintProperty=jn(On(In)),Rn.layoutProperty=jn(On(Mn));const Un="AbortError";function qn(){return new Error(Un)}const Gn={REGISTERED_PROTOCOLS:{}};function Zn(t,e){Gn.REGISTERED_PROTOCOLS[t]=e}function Jn(t){delete Gn.REGISTERED_PROTOCOLS[t]}const Xn="global-dispatcher";class Yn extends Error{constructor(t,e,r,n){super(`AJAXError: ${e} (${t}): ${r}`),this.status=t,this.statusText=e,this.url=r,this.body=n}}const Hn=()=>k(self)?self.worker&&self.worker.referrer:("blob:"===window.location.protocol?window.parent:window).location.href,Kn=function(e,r){if(/:\/\//.test(e.url)&&!/^https?:|^file:/.test(e.url)){const t=Gn.REGISTERED_PROTOCOLS[(n=e.url).substring(0,n.indexOf("://"))];if(t)return t(e,r);if(k(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:e,targetMapId:Xn},r)}var n;if(!(t=>/^file:/.test(t)||/^file:/.test(Hn())&&!/^\w+:/.test(t))(e.url)){if(fetch&&Request&&AbortController&&Object.prototype.hasOwnProperty.call(Request.prototype,"signal"))return function(e,r){return t(this,void 0,void 0,(function*(){const t=new Request(e.url,{method:e.method||"GET",body:e.body,credentials:e.credentials,headers:e.headers,cache:e.cache,referrer:Hn(),signal:r.signal});let n,s;"json"!==e.type||t.headers.has("Accept")||t.headers.set("Accept","application/json");try{n=yield fetch(t)}catch(t){throw new Yn(0,t.message,e.url,new Blob)}if(!n.ok){const t=yield n.blob();throw new Yn(n.status,n.statusText,e.url,t)}s="arrayBuffer"===e.type||"image"===e.type?n.arrayBuffer():"json"===e.type?n.json():n.text();const o=yield s;if(r.signal.aborted)throw qn();return{data:o,cacheControl:n.headers.get("Cache-Control"),expires:n.headers.get("Expires")}}))}(e,r);if(k(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:e,mustQueue:!0,targetMapId:Xn},r)}return function(t,e){return new Promise(((r,n)=>{var s;const o=new XMLHttpRequest;o.open(t.method||"GET",t.url,!0),"arrayBuffer"!==t.type&&"image"!==t.type||(o.responseType="arraybuffer");for(const e in t.headers)o.setRequestHeader(e,t.headers[e]);"json"===t.type&&(o.responseType="text",(null===(s=t.headers)||void 0===s?void 0:s.Accept)||o.setRequestHeader("Accept","application/json")),o.withCredentials="include"===t.credentials,o.onerror=()=>{n(new Error(o.statusText))},o.onload=()=>{if(!e.signal.aborted)if((o.status>=200&&o.status<300||0===o.status)&&null!==o.response){let e=o.response;if("json"===t.type)try{e=JSON.parse(o.response)}catch(t){return void n(t)}r({data:e,cacheControl:o.getResponseHeader("Cache-Control"),expires:o.getResponseHeader("Expires")})}else{const e=new Blob([o.response],{type:o.getResponseHeader("Content-Type")});n(new Yn(o.status,o.statusText,t.url,e))}},e.signal.addEventListener("abort",(()=>{o.abort(),n(qn())})),o.send(t.body)}))}(e,r)},Wn={};function Qn(t,e,r={}){if(Wn[t])throw new Error(`${t} is already registered.`);Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),Wn[t]={klass:e,omit:r.omit||[],shallow:r.shallow||[]}}Qn("Object",Object),Qn("TransferableGridIndex",z),Qn("Color",St),Qn("Error",Error),Qn("AJAXError",Yn),Qn("ResolvedImage",Tt),Qn("StylePropertyFunction",Qr),Qn("StyleExpression",Xr,{omit:["_evaluator"]}),Qn("ZoomDependentExpression",Kr),Qn("ZoomConstantExpression",Jr),Qn("CompoundExpression",kr,{omit:["_evaluate"]});for(const t in Sr)Sr[t]._classRegistryKey||Qn(`Expression_${t}`,Sr[t]);function ti(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function ei(t){return t.$name||t.constructor._classRegistryKey}function ri(t){return!function(t){if(null===t||"object"!=typeof t)return!1;const e=ei(t);return!(!e||"Object"===e)}(t)&&(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||t instanceof Blob||t instanceof Error||ti(t)||A(t)||ArrayBuffer.isView(t)||t instanceof ImageData)}function ni(t,e){if(ri(t))return(ti(t)||A(t))&&e&&e.push(t),ArrayBuffer.isView(t)&&e&&e.push(t.buffer),t instanceof ImageData&&e&&e.push(t.data.buffer),t;if(Array.isArray(t)){const r=[];for(const n of t)r.push(ni(n,e));return r}if("object"!=typeof t)throw new Error("can't serialize object of type "+typeof t);const r=ei(t);if(!r)throw new Error(`can't serialize object of unregistered class ${t.constructor.name}`);if(!Wn[r])throw new Error(`${r} is not registered.`);const{klass:n}=Wn[r],s=n.serialize?n.serialize(t,e):{};if(n.serialize){if(e&&s===e[e.length-1])throw new Error("statically serialized object won't survive transfer of $name property")}else{for(const n in t){if(!t.hasOwnProperty(n))continue;if(Wn[r].omit.indexOf(n)>=0)continue;const o=t[n];s[n]=Wn[r].shallow.indexOf(n)>=0?o:ni(o,e)}t instanceof Error&&(s.message=t.message)}if(s.$name)throw new Error("$name property is reserved for worker serialization logic.");return"Object"!==r&&(s.$name=r),s}function ii(t){if(ri(t))return t;if(Array.isArray(t))return t.map(ii);if("object"!=typeof t)throw new Error("can't deserialize object of type "+typeof t);const e=ei(t)||"Object";if(!Wn[e])throw new Error(`can't deserialize unregistered class ${e}`);const{klass:r}=Wn[e];if(!r)throw new Error(`can't deserialize unregistered class ${e}`);if(r.deserialize)return r.deserialize(t);const n=Object.create(r.prototype);for(const r of Object.keys(t)){if("$name"===r)continue;const s=t[r];n[r]=Wn[e].shallow.indexOf(r)>=0?s:ii(s)}return n}class si{constructor(t){this._methodToThrottle=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._methodToThrottle()})}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._methodToThrottle()}),0))}remove(){delete this._channel,this._methodToThrottle=()=>{}}}const oi={once:!0};class ai{constructor(t,e){this.target=t,this.mapId=e,this.resolveRejects={},this.tasks={},this.taskQueue=[],this.abortControllers={},this.messageHandlers={},this.invoker=new si((()=>this.process())),this.subscription=P(this.target,"message",(t=>this.receive(t)),!1),this.globalScope=k(self)?t:window}registerMessageHandler(t,e){this.messageHandlers[t]=e}sendAsync(t,e){return new Promise(((r,n)=>{const s=Math.round(1e18*Math.random()).toString(36).substring(0,10),o=e?P(e.signal,"abort",(()=>{null==o||o.unsubscribe(),delete this.resolveRejects[s];const e={id:s,type:"<cancel>",origin:location.origin,targetMapId:t.targetMapId,sourceMapId:this.mapId};this.target.postMessage(e)}),oi):null;this.resolveRejects[s]={resolve:t=>{null==o||o.unsubscribe(),r(t)},reject:t=>{null==o||o.unsubscribe(),n(t)}};const a=[],l=Object.assign(Object.assign({},t),{id:s,sourceMapId:this.mapId,origin:location.origin,data:ni(t.data,a)});this.target.postMessage(l,{transfer:a})}))}receive(t){const e=t.data,r=e.id;if(!("file://"!==e.origin&&"file://"!==location.origin&&"resource://android"!==e.origin&&"resource://android"!==location.origin&&e.origin!==location.origin||e.targetMapId&&this.mapId!==e.targetMapId)){if("<cancel>"===e.type){delete this.tasks[r];const t=this.abortControllers[r];return delete this.abortControllers[r],void(t&&t.abort())}if(k(self)||e.mustQueue)return this.tasks[r]=e,this.taskQueue.push(r),void this.invoker.trigger();this.processTask(r,e)}}process(){if(0===this.taskQueue.length)return;const t=this.taskQueue.shift(),e=this.tasks[t];delete this.tasks[t],this.taskQueue.length>0&&this.invoker.trigger(),e&&this.processTask(t,e)}processTask(e,r){return t(this,void 0,void 0,(function*(){if("<response>"===r.type){const t=this.resolveRejects[e];if(delete this.resolveRejects[e],!t)return;return void(r.error?t.reject(ii(r.error)):t.resolve(ii(r.data)))}if(!this.messageHandlers[r.type])return void this.completeTask(e,new Error(`Could not find a registered handler for ${r.type}, map ID: ${this.mapId}, available handlers: ${Object.keys(this.messageHandlers).join(", ")}`));const t=ii(r.data),n=new AbortController;this.abortControllers[e]=n;try{const s=yield this.messageHandlers[r.type](r.sourceMapId,t,n);this.completeTask(e,null,s)}catch(t){this.completeTask(e,t)}}))}completeTask(t,e,r){const n=[];delete this.abortControllers[t];const s={id:t,type:"<response>",sourceMapId:this.mapId,origin:location.origin,error:e?ni(e):null,data:ni(r,n)};this.target.postMessage(s,{transfer:n})}remove(){this.invoker.remove(),this.subscription.unsubscribe()}}function li(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e))}function ui(t,e,r){if(r&&r[t]){const n=r[t].indexOf(e);-1!==n&&r[t].splice(n,1)}}class ci{constructor(t,e={}){x(this,e),this.type=t}}class hi extends ci{constructor(t,e={}){super("error",x({error:t},e))}}class pi{on(t,e){return this._listeners=this._listeners||{},li(t,e,this._listeners),{unsubscribe:()=>{this.off(t,e)}}}off(t,e){return ui(t,e,this._listeners),ui(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},li(t,e,this._oneTimeListeners),this):new Promise((e=>this.once(t,e)))}fire(t,e){"string"==typeof t&&(t=new ci(t,e||{}));const r=t.type;if(this.listens(r)){t.target=this;const e=this._listeners&&this._listeners[r]?this._listeners[r].slice():[];for(const r of e)r.call(this,t);const n=this._oneTimeListeners&&this._oneTimeListeners[r]?this._oneTimeListeners[r].slice():[];for(const e of n)ui(r,e,this._oneTimeListeners),e.call(this,t);const s=this._eventedParent;s&&(x(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),s.fire(t))}else t instanceof hi&&console.error(t.error);return this}listens(t){return this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t)}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}const fi=Rn,di=fi.paintProperty,yi=fi.layoutProperty;class mi{constructor(){this.first=!0}update(t,e){const r=Math.floor(t);return this.first?(this.first=!1,this.lastIntegerZoom=r,this.lastIntegerZoomTime=0,this.lastZoom=t,this.lastFloorZoom=r,!0):(this.lastFloorZoom>r?(this.lastIntegerZoom=r+1,this.lastIntegerZoomTime=e):this.lastFloorZoom<r&&(this.lastIntegerZoom=r,this.lastIntegerZoomTime=e),t!==this.lastZoom&&(this.lastZoom=t,this.lastFloorZoom=r,!0))}}const gi=t=>t>=12272&&t<=12287,xi=t=>t>=12288&&t<=12351,vi=t=>t>=12448&&t<=12543,bi=t=>t>=12736&&t<=12783,wi=t=>t>=12800&&t<=13055,_i=t=>t>=13056&&t<=13311,Si=t=>t>=65040&&t<=65055,ki=t=>t>=65072&&t<=65103,Ai=t=>t>=65104&&t<=65135,Ii=t=>t>=65280&&t<=65519;function Mi(t){for(const e of t)if(Ki(e.charCodeAt(0)))return!0;return!1}function zi(t){for(const e of t)if(!Zi(e.charCodeAt(0)))return!1;return!0}function Pi(t){const e=t.map((t=>{try{return new RegExp(`\\p{sc=${t}}`,"u").source}catch(t){return null}})).filter((t=>t));return new RegExp(e.join("|"),"u")}const Ci=Pi(["Arab","Dupl","Mong","Ougr","Syrc"]);function Zi(t){return!Ci.test(String.fromCodePoint(t))}const Hi=Pi(["Bopo","Hani","Hira","Kana","Kits","Nshu","Tang","Yiii"]);function Ki(t){return!(746!==t&&747!==t&&(t<4352||!(ki(t)&&!(t>=65097&&t<=65103)||_i(t)||bi(t)||!(!xi(t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||wi(t)||gi(t)||(t=>t>=12688&&t<=12703)(t)||vi(t)&&12540!==t||!(!Ii(t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!Ai(t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||Si(t)||(t=>t>=19904&&t<=19967)(t)||/\p{sc=Cans}/u.test(String.fromCodePoint(t))||/\p{sc=Hang}/u.test(String.fromCodePoint(t))||Hi.test(String.fromCodePoint(t)))))}function Wi(t){return!(Ki(t)||function(t){return!!((t=>t>=128&&t<=255)(t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||(t=>t>=8192&&t<=8303)(t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||(t=>t>=8448&&t<=8527)(t)||(t=>t>=8528&&t<=8591)(t)||(t=>t>=8960&&t<=9215)(t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||(t=>t>=9216&&t<=9279)(t)&&9251!==t||(t=>t>=9280&&t<=9311)(t)||(t=>t>=9312&&t<=9471)(t)||(t=>t>=9632&&t<=9727)(t)||(t=>t>=9728&&t<=9983)(t)&&!(t>=9754&&t<=9759)||(t=>t>=11008&&t<=11263)(t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||xi(t)||vi(t)||(t=>t>=57344&&t<=63743)(t)||ki(t)||Ai(t)||Ii(t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t)}(t))}const Ys=Pi(["Adlm","Arab","Armi","Avst","Chrs","Cprt","Egyp","Elym","Gara","Hatr","Hebr","Hung","Khar","Lydi","Mand","Mani","Mend","Merc","Mero","Narb","Nbat","Nkoo","Orkh","Palm","Phli","Phlp","Phnx","Prti","Rohg","Samr","Sarb","Sogo","Syrc","Thaa","Todr","Yezi"]);function Hs(t){return Ys.test(String.fromCodePoint(t))}function Ks(t,e){return!(!e&&Hs(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||(t=>t>=6016&&t<=6143)(t))}function Ws(t){for(const e of t)if(Hs(e.charCodeAt(0)))return!0;return!1}const Qs=new class{constructor(){this.TIMEOUT=5e3,this.applyArabicShaping=null,this.processBidirectionalText=null,this.processStyledBidirectionalText=null,this.pluginStatus="unavailable",this.pluginURL=null,this.loadScriptResolve=()=>{}}setState(t){this.pluginStatus=t.pluginStatus,this.pluginURL=t.pluginURL}getState(){return{pluginStatus:this.pluginStatus,pluginURL:this.pluginURL}}setMethods(t){if(Qs.isParsed())throw new Error("RTL text plugin already registered.");this.applyArabicShaping=t.applyArabicShaping,this.processBidirectionalText=t.processBidirectionalText,this.processStyledBidirectionalText=t.processStyledBidirectionalText,this.loadScriptResolve()}isParsed(){return null!=this.applyArabicShaping&&null!=this.processBidirectionalText&&null!=this.processStyledBidirectionalText}getRTLTextPluginStatus(){return this.pluginStatus}syncState(e,r){return t(this,void 0,void 0,(function*(){if(this.isParsed())return this.getState();if("loading"!==e.pluginStatus)return this.setState(e),e;const t=e.pluginURL,n=new Promise((t=>{this.loadScriptResolve=t}));r(t);const s=new Promise((t=>setTimeout((()=>t()),this.TIMEOUT)));if(yield Promise.race([n,s]),this.isParsed()){const e={pluginStatus:"loaded",pluginURL:t};return this.setState(e),e}throw this.setState({pluginStatus:"error",pluginURL:""}),new Error(`RTL Text Plugin failed to import scripts from ${t}`)}))}};class Bi{constructor(t,e){this.zoom=t,e?(this.now=e.now,this.fadeDuration=e.fadeDuration,this.zoomHistory=e.zoomHistory,this.transition=e.transition):(this.now=0,this.fadeDuration=0,this.zoomHistory=new mi,this.transition={})}isSupportedScript(t){return function(t,e){for(const r of t)if(!Ks(r.charCodeAt(0),e))return!1;return!0}(t,"loaded"===Qs.getRTLTextPluginStatus())}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const t=this.zoom,e=t-Math.floor(t),r=this.crossFadingFactor();return t>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:e+(1-e)*r}:{fromScale:.5,toScale:1,t:1-(1-r)*e}}}class Ti{constructor(t,e){this.property=t,this.value=e,this.expression=function(t,e){if(Rr(t))return new Qr(t,e);if(Yr(t)){const r=Wr(t,e);if("error"===r.result)throw new Error(r.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return r.value}{let r=t;return"color"===e.type&&"string"==typeof t?r=St.parse(t):"padding"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"variableAnchorOffsetCollection"===e.type&&Array.isArray(t)?r=Bt.parse(t):"projectionDefinition"===e.type&&"string"==typeof t&&(r=Vt.parse(t)):r=zt.parse(t),{kind:"constant",evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification)}isDataDriven(){return"source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r)}}class Vi{constructor(t){this.property=t,this.value=new Ti(t,void 0)}transitioned(t,e){return new Fi(this.property,this.value,e,x({},t.transition,this.transition),t.now)}untransitioned(){return new Fi(this.property,this.value,null,{},0)}}class Ei{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues)}getValue(t){return b(this._values[t].value.value)}setValue(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Vi(this._values[t].property)),this._values[t].value=new Ti(this._values[t].property,null===e?void 0:b(e))}getTransition(t){return b(this._values[t].transition)}setTransition(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Vi(this._values[t].property)),this._values[t].transition=b(e)||void 0}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const n=this.getTransition(e);void 0!==n&&(t[`${e}-transition`]=n)}return t}transitioned(t,e){const r=new Di(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(t,e._values[n]);return r}untransitioned(){const t=new Di(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class Fi{constructor(t,e,r,n,s){this.property=t,this.value=e,this.begin=s+n.delay||0,this.end=this.begin+n.duration||0,t.specification.transition&&(n.delay||n.duration)&&(this.prior=r)}possiblyEvaluate(t,e,r){const n=t.now||0,s=this.value.possiblyEvaluate(t,e,r),o=this.prior;if(o){if(n>this.end)return this.prior=null,s;if(this.value.isDataDriven())return this.prior=null,s;if(n<this.begin)return o.possiblyEvaluate(t,e,r);{const a=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(o.possiblyEvaluate(t,e,r),s,function(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}(a))}}return s}}class Di{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues)}possiblyEvaluate(t,e,r){const n=new Oi(this._properties);for(const s of Object.keys(this._values))n._values[s]=this._values[s].possiblyEvaluate(t,e,r);return n}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return!0;return!1}}class Li{constructor(t){this._properties=t,this._values=Object.create(t.defaultPropertyValues)}hasValue(t){return void 0!==this._values[t].value}getValue(t){return b(this._values[t].value)}setValue(t,e){this._values[t]=new Ti(this._values[t].property,null===e?void 0:b(e))}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r)}return t}possiblyEvaluate(t,e,r){const n=new Oi(this._properties);for(const s of Object.keys(this._values))n._values[s]=this._values[s].possiblyEvaluate(t,e,r);return n}}class $i{constructor(t,e,r){this.property=t,this.value=e,this.parameters=r}isConstant(){return"constant"===this.value.kind}constantOr(t){return"constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,n){return this.property.evaluate(this.value,this.parameters,t,e,r,n)}}class Oi{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues)}get(t){return this._values[t]}}class Ri{constructor(t){this.specification=t}possiblyEvaluate(t,e){if(t.isDataDriven())throw new Error("Value should not be data driven");return t.expression.evaluate(e)}interpolate(t,e,r){const n=ue[this.specification.type];return n?n(t,e,r):t}}class Ni{constructor(t,e){this.specification=t,this.overrides=e}possiblyEvaluate(t,e,r,n){return new $i(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,n)}:t.expression,e)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new $i(this,{kind:"constant",value:void 0},t.parameters);const n=ue[this.specification.type];if(n){const s=n(t.value.value,e.value.value,r);return new $i(this,{kind:"constant",value:s},t.parameters)}return t}evaluate(t,e,r,n,s,o){return"constant"===t.kind?t.value:t.evaluate(e,r,n,s,o)}}class ji extends Ni{possiblyEvaluate(t,e,r,n){if(void 0===t.value)return new $i(this,{kind:"constant",value:void 0},e);if("constant"===t.expression.kind){const s=t.expression.evaluate(e,null,{},r,n),o="resolvedImage"===t.property.specification.type&&"string"!=typeof s?s.name:s,a=this._calculate(o,o,o,e);return new $i(this,{kind:"constant",value:a},e)}if("camera"===t.expression.kind){const r=this._calculate(t.expression.evaluate({zoom:e.zoom-1}),t.expression.evaluate({zoom:e.zoom}),t.expression.evaluate({zoom:e.zoom+1}),e);return new $i(this,{kind:"constant",value:r},e)}return new $i(this,t.expression,e)}evaluate(t,e,r,n,s,o){if("source"===t.kind){const a=t.evaluate(e,r,n,s,o);return this._calculate(a,a,a,e)}return"composite"===t.kind?this._calculate(t.evaluate({zoom:Math.floor(e.zoom)-1},r,n),t.evaluate({zoom:Math.floor(e.zoom)},r,n),t.evaluate({zoom:Math.floor(e.zoom)+1},r,n),e):t.value}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class qi{constructor(t){this.specification=t}possiblyEvaluate(t,e,r,n){if(void 0!==t.value){if("constant"===t.expression.kind){const s=t.expression.evaluate(e,null,{},r,n);return this._calculate(s,s,s,e)}return this._calculate(t.expression.evaluate(new Bi(Math.floor(e.zoom-1),e)),t.expression.evaluate(new Bi(Math.floor(e.zoom),e)),t.expression.evaluate(new Bi(Math.floor(e.zoom+1),e)),e)}}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class Ui{constructor(t){this.specification=t}possiblyEvaluate(t,e,r,n){return!!t.expression.evaluate(e,null,{},r,n)}interpolate(){return!1}}class Gi{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const e in t){const r=t[e];r.specification.overridable&&this.overridableProperties.push(e);const n=this.defaultPropertyValues[e]=new Ti(r,void 0),s=this.defaultTransitionablePropertyValues[e]=new Vi(r);this.defaultTransitioningPropertyValues[e]=s.untransitioned(),this.defaultPossiblyEvaluatedValues[e]=n.possiblyEvaluate({})}}}Qn("DataDrivenProperty",Ni),Qn("DataConstantProperty",Ri),Qn("CrossFadedDataDrivenProperty",ji),Qn("CrossFadedProperty",qi),Qn("ColorRampProperty",Ui);const to="-transition";class Xi extends pi{constructor(t,e){if(super(),this.id=t.id,this.type=t.type,this._featureFilter={filter:()=>!0,needGeometry:!1},"custom"!==t.type&&(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter),e.layout&&(this._unevaluatedLayout=new Li(e.layout)),e.paint)){this._transitionablePaint=new Ei(e.paint);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new Oi(e.paint)}}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(t){return"visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}setLayoutProperty(t,e,r={}){null!=e&&this._validate(yi,`layers.${this.id}.layout.${t}`,t,e,r)||("visibility"!==t?this._unevaluatedLayout.setValue(t,e):this.visibility=e)}getPaintProperty(t){return t.endsWith(to)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e,r={}){if(null!=e&&this._validate(di,`layers.${this.id}.paint.${t}`,t,e,r))return!1;if(t.endsWith(to))return this._transitionablePaint.setTransition(t.slice(0,-11),e||void 0),!1;{const r=this._transitionablePaint._values[t],n="cross-faded-data-driven"===r.property.specification["property-type"],s=r.value.isDataDriven(),o=r.value;this._transitionablePaint.setValue(t,e),this._handleSpecialPaintPropertyUpdate(t);const a=this._transitionablePaint._values[t].value;return a.isDataDriven()||s||n||this._handleOverridablePaintPropertyUpdate(t,o,a)}}_handleSpecialPaintPropertyUpdate(t){}_handleOverridablePaintPropertyUpdate(t,e,r){return!1}isHidden(t){return!!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint)}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){t.getCrossfadeParameters&&(this._crossfadeParameters=t.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e)}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{},t.layout.visibility=this.visibility),function(t,e){const r={};for(const n in t)e.call(this,t[n],n,t)&&(r[n]=t[n]);return r}(t,((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}_validate(t,e,r,n,s={}){return(!s||!1!==s.validate)&&function(t,e){let r=!1;if(e&&e.length)for(const n of e)t.fire(new hi(new Error(n.message))),r=!0;return r}(this,t.call(fi,{key:e,layerType:this.type,objectKey:r,value:n,styleSpec:C,style:{glyphs:!0,sprite:!0}}))}is3D(){return!1}isTileClipped(){return!1}hasOffscreenPass(){return!1}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof $i&&Fr(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return!0}return!1}}const eo={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class Yi{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8}}class Ji{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0)}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.push(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews())}clear(){this.length=0}resize(t){this.reserve(t),this.length=t}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e)}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function ro(t,e=1){let r=0,n=0;return{members:t.map((t=>{const s=eo[t.type].BYTES_PER_ELEMENT,o=r=no(r,Math.max(e,s)),a=t.components||1;return n=Math.max(n,s),r+=s*a,{name:t.name,type:t.type,components:a,offset:o}})),size:no(r,Math.max(n,e)),alignment:e}}function no(t,e){return Math.ceil(t/e)*e}class Qi extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.int16[n+0]=e,this.int16[n+1]=r,t}}Qi.prototype.bytesPerElement=4,Qn("StructArrayLayout2i4",Qi);class ts extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const s=3*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=n,t}}ts.prototype.bytesPerElement=6,Qn("StructArrayLayout3i6",ts);class es extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r,n){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n)}emplace(t,e,r,n,s){const o=4*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=s,t}}es.prototype.bytesPerElement=8,Qn("StructArrayLayout4i8",es);class rs extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,s,o){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,s,o)}emplace(t,e,r,n,s,o,a){const l=6*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.int16[l+2]=n,this.int16[l+3]=s,this.int16[l+4]=o,this.int16[l+5]=a,t}}rs.prototype.bytesPerElement=12,Qn("StructArrayLayout2i4i12",rs);class ns extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,s,o){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,s,o)}emplace(t,e,r,n,s,o,a){const l=4*t,u=8*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.uint8[u+4]=n,this.uint8[u+5]=s,this.uint8[u+6]=o,this.uint8[u+7]=a,t}}ns.prototype.bytesPerElement=8,Qn("StructArrayLayout2i4ub8",ns);class is extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.float32[n+0]=e,this.float32[n+1]=r,t}}is.prototype.bytesPerElement=8,Qn("StructArrayLayout2f8",is);class ss extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,s,o,a,l,u,c){const h=this.length;return this.resize(h+1),this.emplace(h,t,e,r,n,s,o,a,l,u,c)}emplace(t,e,r,n,s,o,a,l,u,c,h){const p=10*t;return this.uint16[p+0]=e,this.uint16[p+1]=r,this.uint16[p+2]=n,this.uint16[p+3]=s,this.uint16[p+4]=o,this.uint16[p+5]=a,this.uint16[p+6]=l,this.uint16[p+7]=u,this.uint16[p+8]=c,this.uint16[p+9]=h,t}}ss.prototype.bytesPerElement=20,Qn("StructArrayLayout10ui20",ss);class os extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,s,o,a,l,u,c,h,p){const f=this.length;return this.resize(f+1),this.emplace(f,t,e,r,n,s,o,a,l,u,c,h,p)}emplace(t,e,r,n,s,o,a,l,u,c,h,p,f){const d=12*t;return this.int16[d+0]=e,this.int16[d+1]=r,this.int16[d+2]=n,this.int16[d+3]=s,this.uint16[d+4]=o,this.uint16[d+5]=a,this.uint16[d+6]=l,this.uint16[d+7]=u,this.int16[d+8]=c,this.int16[d+9]=h,this.int16[d+10]=p,this.int16[d+11]=f,t}}os.prototype.bytesPerElement=24,Qn("StructArrayLayout4i4ui4i24",os);class as extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const s=3*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,t}}as.prototype.bytesPerElement=12,Qn("StructArrayLayout3f12",as);class ls extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}ls.prototype.bytesPerElement=4,Qn("StructArrayLayout1ul4",ls);class us extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,s,o,a,l,u){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,r,n,s,o,a,l,u)}emplace(t,e,r,n,s,o,a,l,u,c){const h=10*t,p=5*t;return this.int16[h+0]=e,this.int16[h+1]=r,this.int16[h+2]=n,this.int16[h+3]=s,this.int16[h+4]=o,this.int16[h+5]=a,this.uint32[p+3]=l,this.uint16[h+8]=u,this.uint16[h+9]=c,t}}us.prototype.bytesPerElement=20,Qn("StructArrayLayout6i1ul2ui20",us);class cs extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,s,o){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,s,o)}emplace(t,e,r,n,s,o,a){const l=6*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.int16[l+2]=n,this.int16[l+3]=s,this.int16[l+4]=o,this.int16[l+5]=a,t}}cs.prototype.bytesPerElement=12,Qn("StructArrayLayout2i2i2i12",cs);class hs extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,s)}emplace(t,e,r,n,s,o){const a=4*t,l=8*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=n,this.int16[l+6]=s,this.int16[l+7]=o,t}}hs.prototype.bytesPerElement=16,Qn("StructArrayLayout2f1f2i16",hs);class ps extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,s,o){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,s,o)}emplace(t,e,r,n,s,o,a){const l=16*t,u=4*t,c=8*t;return this.uint8[l+0]=e,this.uint8[l+1]=r,this.float32[u+1]=n,this.float32[u+2]=s,this.int16[c+6]=o,this.int16[c+7]=a,t}}ps.prototype.bytesPerElement=16,Qn("StructArrayLayout2ub2f2i16",ps);class fs extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const s=3*t;return this.uint16[s+0]=e,this.uint16[s+1]=r,this.uint16[s+2]=n,t}}fs.prototype.bytesPerElement=6,Qn("StructArrayLayout3ui6",fs);class ds extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,r,n,s,o,a,l,u,c,h,p,f,d,y,m,g){const x=this.length;return this.resize(x+1),this.emplace(x,t,e,r,n,s,o,a,l,u,c,h,p,f,d,y,m,g)}emplace(t,e,r,n,s,o,a,l,u,c,h,p,f,d,y,m,g,x){const v=24*t,b=12*t,w=48*t;return this.int16[v+0]=e,this.int16[v+1]=r,this.uint16[v+2]=n,this.uint16[v+3]=s,this.uint32[b+2]=o,this.uint32[b+3]=a,this.uint32[b+4]=l,this.uint16[v+10]=u,this.uint16[v+11]=c,this.uint16[v+12]=h,this.float32[b+7]=p,this.float32[b+8]=f,this.uint8[w+36]=d,this.uint8[w+37]=y,this.uint8[w+38]=m,this.uint32[b+10]=g,this.int16[v+22]=x,t}}ds.prototype.bytesPerElement=48,Qn("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",ds);class ys extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,r,n,s,o,a,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,k,A,I,M,P){const C=this.length;return this.resize(C+1),this.emplace(C,t,e,r,n,s,o,a,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,k,A,I,M,P)}emplace(t,e,r,n,s,o,a,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,k,A,I,M,P,C){const T=32*t,F=16*t;return this.int16[T+0]=e,this.int16[T+1]=r,this.int16[T+2]=n,this.int16[T+3]=s,this.int16[T+4]=o,this.int16[T+5]=a,this.int16[T+6]=l,this.int16[T+7]=u,this.uint16[T+8]=c,this.uint16[T+9]=h,this.uint16[T+10]=p,this.uint16[T+11]=f,this.uint16[T+12]=d,this.uint16[T+13]=y,this.uint16[T+14]=m,this.uint16[T+15]=g,this.uint16[T+16]=x,this.uint16[T+17]=v,this.uint16[T+18]=b,this.uint16[T+19]=w,this.uint16[T+20]=_,this.uint16[T+21]=S,this.uint16[T+22]=k,this.uint32[F+12]=A,this.float32[F+13]=I,this.float32[F+14]=M,this.uint16[T+30]=P,this.uint16[T+31]=C,t}}ys.prototype.bytesPerElement=64,Qn("StructArrayLayout8i15ui1ul2f2ui64",ys);class ms extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}ms.prototype.bytesPerElement=4,Qn("StructArrayLayout1f4",ms);class gs extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const s=3*t;return this.uint16[6*t+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,t}}gs.prototype.bytesPerElement=12,Qn("StructArrayLayout1ui2f12",gs);class xs extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const s=4*t;return this.uint32[2*t+0]=e,this.uint16[s+2]=r,this.uint16[s+3]=n,t}}xs.prototype.bytesPerElement=8,Qn("StructArrayLayout1ul2ui8",xs);class vs extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,t}}vs.prototype.bytesPerElement=4,Qn("StructArrayLayout2ui4",vs);class bs extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}bs.prototype.bytesPerElement=2,Qn("StructArrayLayout1ui2",bs);class ws extends Ji{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,r,n){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n)}emplace(t,e,r,n,s){const o=4*t;return this.float32[o+0]=e,this.float32[o+1]=r,this.float32[o+2]=n,this.float32[o+3]=s,t}}ws.prototype.bytesPerElement=16,Qn("StructArrayLayout4f16",ws);class _s extends Yi{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.int16[this._pos2+2]}get y1(){return this._structArray.int16[this._pos2+3]}get x2(){return this._structArray.int16[this._pos2+4]}get y2(){return this._structArray.int16[this._pos2+5]}get featureIndex(){return this._structArray.uint32[this._pos4+3]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+8]}get bucketIndex(){return this._structArray.uint16[this._pos2+9]}get anchorPoint(){return new l(this.anchorPointX,this.anchorPointY)}}_s.prototype.size=20;class Ss extends us{get(t){return new _s(this,t)}}Qn("CollisionBoxArray",Ss);class ks extends Yi{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(t){this._structArray.uint8[this._pos1+37]=t}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(t){this._structArray.uint8[this._pos1+38]=t}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(t){this._structArray.uint32[this._pos4+10]=t}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}ks.prototype.size=48;class As extends ds{get(t){return new ks(this,t)}}Qn("PlacedSymbolArray",As);class Is extends Yi{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(t){this._structArray.uint32[this._pos4+12]=t}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+14]}get textAnchorOffsetStartIndex(){return this._structArray.uint16[this._pos2+30]}get textAnchorOffsetEndIndex(){return this._structArray.uint16[this._pos2+31]}}Is.prototype.size=64;class Ms extends ys{get(t){return new Is(this,t)}}Qn("SymbolInstanceArray",Ms);class zs extends ms{getoffsetX(t){return this.float32[1*t+0]}}Qn("GlyphOffsetArray",zs);class Ps extends ts{getx(t){return this.int16[3*t+0]}gety(t){return this.int16[3*t+1]}gettileUnitDistanceFromAnchor(t){return this.int16[3*t+2]}}Qn("SymbolLineVertexArray",Ps);class Cs extends Yi{get textAnchor(){return this._structArray.uint16[this._pos2+0]}get textOffset0(){return this._structArray.float32[this._pos4+1]}get textOffset1(){return this._structArray.float32[this._pos4+2]}}Cs.prototype.size=12;class Bs extends gs{get(t){return new Cs(this,t)}}Qn("TextAnchorOffsetArray",Bs);class Ts extends Yi{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}}Ts.prototype.size=8;class Vs extends xs{get(t){return new Ts(this,t)}}Qn("FeatureIndexArray",Vs);class Es extends Qi{}class Fs extends Qi{}class Ds extends Qi{}class Ls extends rs{}class $s extends ns{}class Os extends is{}class Rs extends ss{}class Ns extends os{}class js extends as{}class qs extends ls{}class Us extends cs{}class Gs extends ps{}class Zs extends fs{}class Xs extends vs{}const io=ro([{name:"a_pos",components:2,type:"Int16"}],4),{members:so}=io;class Js{constructor(t=[]){this._forceNewSegmentOnNextPrepare=!1,this.segments=t}prepareSegment(t,e,r,n){const s=this.segments[this.segments.length-1];return t>Js.MAX_VERTEX_ARRAY_LENGTH&&_(`Max vertices per segment is ${Js.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}. Consider using the \`fillLargeMeshArrays\` function if you require meshes with more than ${Js.MAX_VERTEX_ARRAY_LENGTH} vertices.`),this._forceNewSegmentOnNextPrepare||!s||s.vertexLength+t>Js.MAX_VERTEX_ARRAY_LENGTH||s.sortKey!==n?this.createNewSegment(e,r,n):s}createNewSegment(t,e,r){const n={vertexOffset:t.length,primitiveOffset:e.length,vertexLength:0,primitiveLength:0,vaos:{}};return void 0!==r&&(n.sortKey=r),this._forceNewSegmentOnNextPrepare=!1,this.segments.push(n),n}getOrCreateLatestSegment(t,e,r){return this.prepareSegment(0,t,e,r)}forceNewSegmentOnNextPrepare(){this._forceNewSegmentOnNextPrepare=!0}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy()}static simpleSegment(t,e,r,n){return new Js([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}function oo(t,e){return 256*(t=g(Math.floor(t),0,255))+g(Math.floor(e),0,255)}Js.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,Qn("SegmentVector",Js);const lo=ro([{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"}]);var uo,co,mo,ko={exports:{}},Ao={exports:{}},Io={exports:{}},Mo=function(){if(mo)return ko.exports;mo=1;var t=(uo||(uo=1,Ao.exports=function(t,e){var r,n,s,o,a,l,u,c;for(n=t.length-(r=3&t.length),s=e,a=3432918353,l=461845907,c=0;c<n;)u=255&t.charCodeAt(c)|(255&t.charCodeAt(++c))<<8|(255&t.charCodeAt(++c))<<16|(255&t.charCodeAt(++c))<<24,++c,s=27492+(65535&(o=5*(65535&(s=(s^=u=(65535&(u=(u=(65535&u)*a+(((u>>>16)*a&65535)<<16)&4294967295)<<15|u>>>17))*l+(((u>>>16)*l&65535)<<16)&4294967295)<<13|s>>>19))+((5*(s>>>16)&65535)<<16)&4294967295))+((58964+(o>>>16)&65535)<<16);switch(u=0,r){case 3:u^=(255&t.charCodeAt(c+2))<<16;case 2:u^=(255&t.charCodeAt(c+1))<<8;case 1:s^=u=(65535&(u=(u=(65535&(u^=255&t.charCodeAt(c)))*a+(((u>>>16)*a&65535)<<16)&4294967295)<<15|u>>>17))*l+(((u>>>16)*l&65535)<<16)&4294967295}return s^=t.length,s=2246822507*(65535&(s^=s>>>16))+((2246822507*(s>>>16)&65535)<<16)&4294967295,s=3266489909*(65535&(s^=s>>>13))+((3266489909*(s>>>16)&65535)<<16)&4294967295,(s^=s>>>16)>>>0}),Ao.exports),e=(co||(co=1,Io.exports=function(t,e){for(var r,n=t.length,s=e^n,o=0;n>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(o)|(255&t.charCodeAt(++o))<<8|(255&t.charCodeAt(++o))<<16|(255&t.charCodeAt(++o))<<24))+((1540483477*(r>>>16)&65535)<<16),s=1540483477*(65535&s)+((1540483477*(s>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++o;switch(n){case 3:s^=(255&t.charCodeAt(o+2))<<16;case 2:s^=(255&t.charCodeAt(o+1))<<8;case 1:s=1540483477*(65535&(s^=255&t.charCodeAt(o)))+((1540483477*(s>>>16)&65535)<<16)}return s=1540483477*(65535&(s^=s>>>13))+((1540483477*(s>>>16)&65535)<<16),(s^=s>>>15)>>>0}),Io.exports);return ko.exports=t,ko.exports.murmur3=t,ko.exports.murmur2=e,ko.exports}(),zo=e(Mo);class ao{constructor(){this.ids=[],this.positions=[],this.indexed=!1}add(t,e,r,n){this.ids.push(Bo(t)),this.positions.push(e,r,n)}getPositions(t){if(!this.indexed)throw new Error("Trying to get index, but feature positions are not indexed");const e=Bo(t);let r=0,n=this.ids.length-1;for(;r<n;){const t=r+n>>1;this.ids[t]>=e?n=t:r=t+1}const s=[];for(;this.ids[r]===e;)s.push({index:this.positions[3*r],start:this.positions[3*r+1],end:this.positions[3*r+2]}),r++;return s}static serialize(t,e){const r=new Float64Array(t.ids),n=new Uint32Array(t.positions);return Po(r,n,0,r.length-1),e&&e.push(r.buffer,n.buffer),{ids:r,positions:n}}static deserialize(t){const e=new ao;return e.ids=t.ids,e.positions=t.positions,e.indexed=!0,e}}function Bo(t){const e=+t;return!isNaN(e)&&e<=Number.MAX_SAFE_INTEGER?e:zo(String(t))}function Po(t,e,r,n){for(;r<n;){const s=t[r+n>>1];let o=r-1,a=n+1;for(;;){do{o++}while(t[o]<s);do{a--}while(t[a]>s);if(o>=a)break;Co(t,o,a),Co(e,3*o,3*a),Co(e,3*o+1,3*a+1),Co(e,3*o+2,3*a+2)}a-r<n-a?(Po(t,e,r,a),r=a+1):(Po(t,e,a+1,n),n=a)}}function Co(t,e,r){const n=t[e];t[e]=t[r],t[r]=n}Qn("FeaturePositionMap",ao);class ho{constructor(t,e){this.gl=t.gl,this.location=e}}class po extends ho{constructor(t,e){super(t,e),this.current=0}set(t){this.current!==t&&(this.current=t,this.gl.uniform1f(this.location,t))}}class fo extends ho{constructor(t,e){super(t,e),this.current=[0,0,0,0]}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]&&t[3]===this.current[3]||(this.current=t,this.gl.uniform4f(this.location,t[0],t[1],t[2],t[3]))}}class yo extends ho{constructor(t,e){super(t,e),this.current=St.transparent}set(t){t.r===this.current.r&&t.g===this.current.g&&t.b===this.current.b&&t.a===this.current.a||(this.current=t,this.gl.uniform4f(this.location,t.r,t.g,t.b,t.a))}}function Vo(t){return[oo(255*t.r,255*t.g),oo(255*t.b,255*t.a)]}class go{constructor(t,e,r){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=r}setUniform(t,e,r){t.set(r.constantOr(this.value))}getBinding(t,e,r){return"color"===this.type?new yo(t,e):new po(t,e)}}class xo{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1}setConstantPatternPositions(t,e){this.pixelRatioFrom=e.pixelRatio,this.pixelRatioTo=t.pixelRatio,this.patternFrom=e.tlbr,this.patternTo=t.tlbr}setUniform(t,e,r,n){const s="u_pattern_to"===n?this.patternTo:"u_pattern_from"===n?this.patternFrom:"u_pixel_ratio_to"===n?this.pixelRatioTo:"u_pixel_ratio_from"===n?this.pixelRatioFrom:null;s&&t.set(s)}getBinding(t,e,r){return"u_pattern"===r.substr(0,9)?new fo(t,e):new po(t,e)}}class vo{constructor(t,e,r,n){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0}))),this.paintVertexArray=new n}populatePaintArray(t,e,r,n,s){const o=this.paintVertexArray.length,a=this.expression.evaluate(new Bi(0),e,{},n,[],s);this.paintVertexArray.resize(t),this._setPaintValue(o,t,a)}updatePaintArray(t,e,r,n){const s=this.expression.evaluate({zoom:0},r,n);this._setPaintValue(t,e,s)}_setPaintValue(t,e,r){if("color"===this.type){const n=Vo(r);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1])}else{for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r))}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}}class bo{constructor(t,e,r,n,s,o){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=r,this.useIntegerZoom=n,this.zoom=s,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0}))),this.paintVertexArray=new o}populatePaintArray(t,e,r,n,s){const o=this.expression.evaluate(new Bi(this.zoom),e,{},n,[],s),a=this.expression.evaluate(new Bi(this.zoom+1),e,{},n,[],s),l=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(l,t,o,a)}updatePaintArray(t,e,r,n){const s=this.expression.evaluate({zoom:this.zoom},r,n),o=this.expression.evaluate({zoom:this.zoom+1},r,n);this._setPaintValue(t,e,s,o)}_setPaintValue(t,e,r,n){if("color"===this.type){const s=Vo(r),o=Vo(n);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,s[0],s[1],o[0],o[1])}else{for(let s=t;s<e;s++)this.paintVertexArray.emplace(s,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n))}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}setUniform(t,e){const r=this.useIntegerZoom?Math.floor(e.zoom):e.zoom,n=g(this.expression.interpolationFactor(r,this.zoom,this.zoom+1),0,1);t.set(n)}getBinding(t,e,r){return new po(t,e)}}class wo{constructor(t,e,r,n,s,o){this.expression=t,this.type=e,this.useIntegerZoom=r,this.zoom=n,this.layerId=o,this.zoomInPaintVertexArray=new s,this.zoomOutPaintVertexArray=new s}populatePaintArray(t,e,r){const n=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(t),this.zoomOutPaintVertexArray.resize(t),this._setPaintValues(n,t,e.patterns&&e.patterns[this.layerId],r)}updatePaintArray(t,e,r,n,s){this._setPaintValues(t,e,r.patterns&&r.patterns[this.layerId],s)}_setPaintValues(t,e,r,n){if(!n||!r)return;const{min:s,mid:o,max:a}=r,l=n[s],u=n[o],c=n[a];if(l&&u&&c)for(let r=t;r<e;r++)this.zoomInPaintVertexArray.emplace(r,u.tl[0],u.tl[1],u.br[0],u.br[1],l.tl[0],l.tl[1],l.br[0],l.br[1],u.pixelRatio,l.pixelRatio),this.zoomOutPaintVertexArray.emplace(r,u.tl[0],u.tl[1],u.br[0],u.br[1],c.tl[0],c.tl[1],c.br[0],c.br[1],u.pixelRatio,c.pixelRatio)}upload(t){this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer&&(this.zoomInPaintVertexBuffer=t.createVertexBuffer(this.zoomInPaintVertexArray,lo.members,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=t.createVertexBuffer(this.zoomOutPaintVertexArray,lo.members,this.expression.isStateDependent))}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy()}}class _o{constructor(t,e,r){this.binders={},this._buffers=[];const n=[];for(const s in t.paint._values){if(!r(s))continue;const o=t.paint.get(s);if(!(o instanceof $i&&Fr(o.property.specification)))continue;const a=Eo(s,t.type),l=o.value,u=o.property.specification.type,c=o.property.useIntegerZoom,h=o.property.specification["property-type"],p="cross-faded"===h||"cross-faded-data-driven"===h;if("constant"===l.kind)this.binders[s]=p?new xo(l.value,a):new go(l.value,a,u),n.push(`/u_${s}`);else if("source"===l.kind||p){const r=Fo(s,u,"source");this.binders[s]=p?new wo(l,u,c,e,r,t.id):new vo(l,a,u,r),n.push(`/a_${s}`)}else{const t=Fo(s,u,"composite");this.binders[s]=new bo(l,a,u,c,e,t),n.push(`/z_${s}`)}}this.cacheKey=n.sort().join("")}getMaxValue(t){const e=this.binders[t];return e instanceof vo||e instanceof bo?e.maxValue:0}populatePaintArrays(t,e,r,n,s){for(const o in this.binders){const a=this.binders[o];(a instanceof vo||a instanceof bo||a instanceof wo)&&a.populatePaintArray(t,e,r,n,s)}}setConstantPatternPositions(t,e){for(const r in this.binders){const n=this.binders[r];n instanceof xo&&n.setConstantPatternPositions(t,e)}}updatePaintArrays(t,e,r,n,s){let o=!1;for(const a in t){const l=e.getPositions(a);for(const e of l){const l=r.feature(e.index);for(const r in this.binders){const u=this.binders[r];if((u instanceof vo||u instanceof bo||u instanceof wo)&&!0===u.expression.isStateDependent){const c=n.paint.get(r);u.expression=c.value,u.updatePaintArray(e.start,e.end,l,t[a],s),o=!0}}}}return o}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof go||r instanceof xo)&&t.push(...r.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)))}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof vo||r instanceof bo)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);else if(r instanceof wo)for(let e=0;e<lo.members.length;e++)t.push(lo.members[e].name)}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof go||r instanceof xo||r instanceof bo)for(const e of r.uniformNames)t.push(e)}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t,e){const r=[];for(const n in this.binders){const s=this.binders[n];if(s instanceof go||s instanceof xo||s instanceof bo)for(const o of s.uniformNames)if(e[o]){const a=s.getBinding(t,e[o],o);r.push({name:o,property:n,binding:a})}}return r}setUniforms(t,e,r,n){for(const{name:t,property:s,binding:o}of e)this.binders[s].setUniform(o,n,r.get(s),t)}updatePaintBuffers(t){this._buffers=[];for(const e in this.binders){const r=this.binders[e];if(t&&r instanceof wo){const e=2===t.fromScale?r.zoomInPaintVertexBuffer:r.zoomOutPaintVertexBuffer;e&&this._buffers.push(e)}else(r instanceof vo||r instanceof bo)&&r.paintVertexBuffer&&this._buffers.push(r.paintVertexBuffer)}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof vo||r instanceof bo||r instanceof wo)&&r.upload(t)}this.updatePaintBuffers()}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof vo||e instanceof bo||e instanceof wo)&&e.destroy()}}}class So{constructor(t,e,r=()=>!0){this.programConfigurations={};for(const n of t)this.programConfigurations[n.id]=new _o(n,e,r);this.needsUpload=!1,this._featureMap=new ao,this._bufferOffset=0}populatePaintArrays(t,e,r,n,s,o){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,n,s,o);void 0!==e.id&&this._featureMap.add(e.id,r,this._bufferOffset,t),this._bufferOffset=t,this.needsUpload=!0}updatePaintArrays(t,e,r,n){for(const s of r)this.needsUpload=this.programConfigurations[s.id].updatePaintArrays(t,this._featureMap,e,s,n)||this.needsUpload}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy()}}function Eo(t,e){return{"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}function Fo(t,e,r){const n={color:{source:is,composite:ws},number:{source:ms,composite:is}},s=function(t){return{"line-pattern":{source:Rs,composite:Rs},"fill-pattern":{source:Rs,composite:Rs},"fill-extrusion-pattern":{source:Rs,composite:Rs}}[t]}(t);return s&&s[r]||n[e][r]}Qn("ConstantBinder",go),Qn("CrossFadedConstantBinder",xo),Qn("SourceExpressionBinder",vo),Qn("CrossFadedCompositeBinder",wo),Qn("CompositeExpressionBinder",bo),Qn("ProgramConfiguration",_o,{omit:["_buffers"]}),Qn("ProgramConfigurationSet",So);const Do=Math.pow(2,14)-1,$o=-Do-1;function Lo(t){const e=m/t.extent,r=t.loadGeometry();for(let t=0;t<r.length;t++){const n=r[t];for(let t=0;t<n.length;t++){const r=n[t],s=Math.round(r.x*e),o=Math.round(r.y*e);r.x=g(s,$o,Do),r.y=g(o,$o,Do),(s<r.x||s>r.x+1||o<r.y||o>r.y+1)&&_("Geometry exceeds allowed extent, reduce your vector tile buffer size")}}return r}function Ro(t,e){return{type:t.type,id:t.id,properties:t.properties,geometry:e?Lo(t):[]}}const Oo=-32768;function No(t,e,r,n,s){t.emplaceBack(Oo+8*e+n,Oo+8*r+s)}class To{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new Fs,this.indexArray=new Zs,this.segments=new Js,this.programConfigurations=new So(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,r){const n=this.layers[0],s=[];let o=null,a=!1,l="heatmap"===n.type;if("circle"===n.type){const t=n;o=t.layout.get("circle-sort-key"),a=!o.isConstant(),l=l||"map"===t.paint.get("circle-pitch-alignment")}const u=l?e.subdivisionGranularity.circle:1;for(const{feature:e,id:n,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=Ro(e,t);if(!this.layers[0]._featureFilter.filter(new Bi(this.zoom),c,r))continue;const h=a?o.evaluate(c,{},r):void 0,p={id:n,properties:e.properties,type:e.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:Lo(e),patterns:{},sortKey:h};s.push(p)}a&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:s,index:o,sourceLayerIndex:a}=n,l=t[o].feature;this.addFeature(n,s,o,r,u),e.featureIndex.insert(l,s,o,a,this.index)}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,so),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}addFeature(t,e,r,n,s=1){let o;switch(s){case 1:o=[0,7];break;case 3:o=[0,2,5,7];break;case 5:o=[0,1,3,4,6,7];break;case 7:o=[0,1,2,3,4,5,6,7];break;default:throw new Error(`Invalid circle bucket granularity: ${s}; valid values are 1, 3, 5, 7.`)}const a=o.length;for(const r of e)for(const e of r){const r=e.x,n=e.y;if(r<0||r>=m||n<0||n>=m)continue;const s=this.segments.prepareSegment(a*a,this.layoutVertexArray,this.indexArray,t.sortKey),l=s.vertexLength;for(let t=0;t<a;t++)for(let e=0;e<a;e++)No(this.layoutVertexArray,r,n,o[e],o[t]);for(let t=0;t<a-1;t++)for(let e=0;e<a-1;e++){const r=l+t*a+e,n=l+(t+1)*a+e;this.indexArray.emplaceBack(r,n+1,r+1),this.indexArray.emplaceBack(r,n,n+1)}s.vertexLength+=a*a,s.primitiveLength+=(a-1)*(a-1)*2}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{},n)}}function jo(t,e){for(let r=0;r<t.length;r++)if(Qo(e,t[r]))return!0;for(let r=0;r<e.length;r++)if(Qo(t,e[r]))return!0;return!!Zo(t,e)}function Uo(t,e,r){return!!Qo(t,e)||!!Yo(e,t,r)}function qo(t,e){if(1===t.length)return Ko(e,t[0]);for(let r=0;r<e.length;r++){const n=e[r];for(let e=0;e<n.length;e++)if(Qo(t,n[e]))return!0}for(let r=0;r<t.length;r++)if(Ko(e,t[r]))return!0;for(let r=0;r<e.length;r++)if(Zo(t,e[r]))return!0;return!1}function Go(t,e,r){if(t.length>1){if(Zo(t,e))return!0;for(let n=0;n<e.length;n++)if(Yo(e[n],t,r))return!0}for(let n=0;n<t.length;n++)if(Yo(t[n],e,r))return!0;return!1}function Zo(t,e){if(0===t.length||0===e.length)return!1;for(let r=0;r<t.length-1;r++){const n=t[r],s=t[r+1];for(let t=0;t<e.length-1;t++)if(Xo(n,s,e[t],e[t+1]))return!0}return!1}function Xo(t,e,r,n){return S(t,r,n)!==S(e,r,n)&&S(t,e,r)!==S(t,e,n)}function Yo(t,e,r){const n=r*r;if(1===e.length)return t.distSqr(e[0])<n;for(let r=1;r<e.length;r++)if(Ho(t,e[r-1],e[r])<n)return!0;return!1}function Ho(t,e,r){const n=e.distSqr(r);if(0===n)return t.distSqr(e);const s=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/n;return t.distSqr(s<0?e:s>1?r:r.sub(e)._mult(s)._add(e))}function Ko(t,e){for(let r=0;r<t.length;r++)if(Qo(t[r],e))return!0;return!1}function Qo(t,e){let r=!1;for(let n=0,s=t.length-1;n<t.length;s=n++){const o=t[n],a=t[s];o.y>e.y!=a.y>e.y&&e.x<(a.x-o.x)*(e.y-o.y)/(a.y-o.y)+o.x&&(r=!r)}return r}function ta(t,e,r){const n=r[0],s=r[2];if(t.x<n.x&&e.x<n.x||t.x>s.x&&e.x>s.x||t.y<n.y&&e.y<n.y||t.y>s.y&&e.y>s.y)return!1;const o=S(t,e,r[0]);return o!==S(t,e,r[1])||o!==S(t,e,r[2])||o!==S(t,e,r[3])}function ea(t,e,r){const n=e.paint.get(t).value;return"constant"===n.kind?n.value:r.programConfigurations.get(e.id).getMaxValue(t)}function ra(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function na(t,e,r,n,s){if(!e[0]&&!e[1])return t;const o=l.convert(e)._mult(s);"viewport"===r&&o._rotate(-n);const a=[];for(let e=0;e<t.length;e++)a.push(t[e].sub(o));return a}let oa,la;Qn("CircleBucket",To,{omit:["layers"]});var ua={get paint(){return la=la||new Gi({"circle-radius":new Ni(C.paint_circle["circle-radius"]),"circle-color":new Ni(C.paint_circle["circle-color"]),"circle-blur":new Ni(C.paint_circle["circle-blur"]),"circle-opacity":new Ni(C.paint_circle["circle-opacity"]),"circle-translate":new Ri(C.paint_circle["circle-translate"]),"circle-translate-anchor":new Ri(C.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new Ri(C.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new Ri(C.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new Ni(C.paint_circle["circle-stroke-width"]),"circle-stroke-color":new Ni(C.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new Ni(C.paint_circle["circle-stroke-opacity"])})},get layout(){return oa=oa||new Gi({"circle-sort-key":new Ni(C.layout_circle["circle-sort-key"])})}};class Jo extends Xi{constructor(t){super(t,ua)}createBucket(t){return new To(t)}queryRadius(t){const e=t;return ea("circle-radius",this,e)+ea("circle-stroke-width",this,e)+ra(this.paint.get("circle-translate"))}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:r,geometry:n,transform:s,pixelsToTileUnits:o,unwrappedTileID:a,getElevation:l}){const u=na(t,this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),-s.bearingInRadians,o),c=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r),h="map"===this.paint.get("circle-pitch-alignment"),p=h?u:function(t,e,r,n){return t.map((t=>ha(t,e,r,n)))}(u,s,a,l),f=h?c*o:c;for(const t of n)for(const e of t){const t=h?e:ha(e,s,a,l);let r=f;const n=s.projectTileCoordinates(e.x,e.y,a,l).signedDistanceFromCamera;if("viewport"===this.paint.get("circle-pitch-scale")&&"map"===this.paint.get("circle-pitch-alignment")?r*=n/s.cameraToCenterDistance:"map"===this.paint.get("circle-pitch-scale")&&"viewport"===this.paint.get("circle-pitch-alignment")&&(r*=s.cameraToCenterDistance/n),Uo(p,t,r))return!0}return!1}}function ha(t,e,r,n){const s=e.projectTileCoordinates(t.x,t.y,r,n).point;return new l((.5*s.x+.5)*e.width,(.5*-s.y+.5)*e.height)}class Wo extends To{}let pa;Qn("HeatmapBucket",Wo,{omit:["layers"]});var fa={get paint(){return pa=pa||new Gi({"heatmap-radius":new Ni(C.paint_heatmap["heatmap-radius"]),"heatmap-weight":new Ni(C.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new Ri(C.paint_heatmap["heatmap-intensity"]),"heatmap-color":new Ui(C.paint_heatmap["heatmap-color"]),"heatmap-opacity":new Ri(C.paint_heatmap["heatmap-opacity"])})}};function da(t,{width:e,height:r},n,s){if(s){if(s instanceof Uint8ClampedArray)s=new Uint8Array(s.buffer);else if(s.length!==e*r*n)throw new RangeError(`mismatched image size. expected: ${s.length} but got: ${e*r*n}`)}else s=new Uint8Array(e*r*n);return t.width=e,t.height=r,t.data=s,t}function ya(t,{width:e,height:r},n){if(e===t.width&&r===t.height)return;const s=da({},{width:e,height:r},n);ma(t,s,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,e),height:Math.min(t.height,r)},n),t.width=e,t.height=r,t.data=s.data}function ma(t,e,r,n,s,o){if(0===s.width||0===s.height)return e;if(s.width>t.width||s.height>t.height||r.x>t.width-s.width||r.y>t.height-s.height)throw new RangeError("out of range source coordinates for image copy");if(s.width>e.width||s.height>e.height||n.x>e.width-s.width||n.y>e.height-s.height)throw new RangeError("out of range destination coordinates for image copy");const a=t.data,l=e.data;if(a===l)throw new Error("srcData equals dstData, so image is already copied");for(let u=0;u<s.height;u++){const c=((r.y+u)*t.width+r.x)*o,h=((n.y+u)*e.width+n.x)*o;for(let t=0;t<s.width*o;t++)l[h+t]=a[c+t]}return e}class ia{constructor(t,e){da(this,t,1,e)}resize(t){ya(this,t,1)}clone(){return new ia({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,s){ma(t,e,r,n,s,1)}}class sa{constructor(t,e){da(this,t,4,e)}resize(t){ya(this,t,4)}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t}clone(){return new sa({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,s){ma(t,e,r,n,s,4)}}Qn("AlphaImage",ia),Qn("RGBAImage",sa);const ga="big-fb";class aa extends Xi{createBucket(t){return new Wo(t)}constructor(t){super(t,fa),this.heatmapFbos=new Map,this._updateColorRamp()}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp()}_updateColorRamp(){this.colorRamp=function(t){const e={},r=t.resolution||256,n=t.clips?t.clips.length:1,s=t.image||new sa({width:r,height:n});if(Math.log(r)/Math.LN2%1!=0)throw new Error(`width is not a power of 2 - ${r}`);const o=(r,n,o)=>{e[t.evaluationKey]=o;const a=t.expression.evaluate(e);s.data[r+n+0]=Math.floor(255*a.r/a.a),s.data[r+n+1]=Math.floor(255*a.g/a.a),s.data[r+n+2]=Math.floor(255*a.b/a.a),s.data[r+n+3]=Math.floor(255*a.a)};if(t.clips)for(let e=0,s=0;e<n;++e,s+=4*r)for(let n=0,a=0;n<r;n++,a+=4){const l=n/(r-1),{start:u,end:c}=t.clips[e];o(s,a,u*(1-l)+c*l)}else for(let t=0,e=0;t<r;t++,e+=4)o(0,e,t/(r-1));return s}({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null}resize(){this.heatmapFbos.has(ga)&&this.heatmapFbos.delete(ga)}queryRadius(){return 0}queryIntersectsFeature(){return!1}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}}let xa;var va={get paint(){return xa=xa||new Gi({"hillshade-illumination-direction":new Ri(C.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new Ri(C.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new Ri(C.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new Ri(C.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new Ri(C.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new Ri(C.paint_hillshade["hillshade-accent-color"])})}};class ca extends Xi{constructor(t){super(t,va)}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}}const ba=ro([{name:"a_pos",components:2,type:"Int16"}],4),{members:wa}=ba;function _a(t,e,r){const n=r.patternDependencies;let s=!1;for(const r of e){const e=r.paint.get(`${t}-pattern`);e.isConstant()||(s=!0);const o=e.constantOr(null);o&&(s=!0,n[o.to]=!0,n[o.from]=!0)}return s}function Sa(t,e,r,n,s){const o=s.patternDependencies;for(const a of e){const e=a.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:n-1},r,{},s.availableImages),l=e.evaluate({zoom:n},r,{},s.availableImages),u=e.evaluate({zoom:n+1},r,{},s.availableImages);t=t&&t.name?t.name:t,l=l&&l.name?l.name:l,u=u&&u.name?u.name:u,o[t]=!0,o[l]=!0,o[u]=!0,r.patterns[a.id]={min:t,mid:l,max:u}}}return r}function ka(t,e,r,n,s){let o;if(s===function(t,e,r,n){let s=0;for(let o=e,a=r-n;o<r;o+=n)s+=(t[a]-t[o])*(t[o+1]+t[a+1]),a=o;return s}(t,e,r,n)>0)for(let s=e;s<r;s+=n)o=Ha(s/n|0,t[s],t[s+1],o);else for(let s=r-n;s>=e;s-=n)o=Ha(s/n|0,t[s],t[s+1],o);return o&&ja(o,o.next)&&(Ka(o),o=o.next),o}function Aa(t,e){if(!t)return t;e||(e=t);let r,n=t;do{if(r=!1,n.steiner||!ja(n,n.next)&&0!==Oa(n.prev,n,n.next))n=n.next;else{if(Ka(n),n=e=n.prev,n===n.next)break;r=!0}}while(r||n!==e);return e}function Ia(t,e,r,n,s,o,a){if(!t)return;!a&&o&&function(t,e,r,n){let s=t;do{0===s.z&&(s.z=Ea(s.x,s.y,e,r,n)),s.prevZ=s.prev,s.nextZ=s.next,s=s.next}while(s!==t);s.prevZ.nextZ=null,s.prevZ=null,function(t){let e,r=1;do{let n,s=t;t=null;let o=null;for(e=0;s;){e++;let a=s,l=0;for(let t=0;t<r&&(l++,a=a.nextZ,a);t++);let u=r;for(;l>0||u>0&&a;)0!==l&&(0===u||!a||s.z<=a.z)?(n=s,s=s.nextZ,l--):(n=a,a=a.nextZ,u--),o?o.nextZ=n:t=n,n.prevZ=o,o=n;s=a}o.nextZ=null,r*=2}while(e>1)}(s)}(t,n,s,o);let l=t;for(;t.prev!==t.next;){const u=t.prev,c=t.next;if(o?za(t,n,s,o):Ma(t))e.push(u.i,t.i,c.i),Ka(t),t=c.next,l=c.next;else if((t=c)===l){a?1===a?Ia(t=Ba(Aa(t),e),e,r,n,s,o,2):2===a&&Pa(t,e,r,n,s,o):Ia(Aa(t),e,r,n,s,o,1);break}}}function Ma(t){const e=t.prev,r=t,n=t.next;if(Oa(e,r,n)>=0)return!1;const s=e.x,o=r.x,a=n.x,l=e.y,u=r.y,c=n.y,h=Math.min(s,o,a),p=Math.min(l,u,c),f=Math.max(s,o,a),d=Math.max(l,u,c);let y=n.next;for(;y!==e;){if(y.x>=h&&y.x<=f&&y.y>=p&&y.y<=d&&$a(s,l,o,u,a,c,y.x,y.y)&&Oa(y.prev,y,y.next)>=0)return!1;y=y.next}return!0}function za(t,e,r,n){const s=t.prev,o=t,a=t.next;if(Oa(s,o,a)>=0)return!1;const l=s.x,u=o.x,c=a.x,h=s.y,p=o.y,f=a.y,d=Math.min(l,u,c),y=Math.min(h,p,f),m=Math.max(l,u,c),g=Math.max(h,p,f),x=Ea(d,y,e,r,n),v=Ea(m,g,e,r,n);let b=t.prevZ,w=t.nextZ;for(;b&&b.z>=x&&w&&w.z<=v;){if(b.x>=d&&b.x<=m&&b.y>=y&&b.y<=g&&b!==s&&b!==a&&$a(l,h,u,p,c,f,b.x,b.y)&&Oa(b.prev,b,b.next)>=0)return!1;if(b=b.prevZ,w.x>=d&&w.x<=m&&w.y>=y&&w.y<=g&&w!==s&&w!==a&&$a(l,h,u,p,c,f,w.x,w.y)&&Oa(w.prev,w,w.next)>=0)return!1;w=w.nextZ}for(;b&&b.z>=x;){if(b.x>=d&&b.x<=m&&b.y>=y&&b.y<=g&&b!==s&&b!==a&&$a(l,h,u,p,c,f,b.x,b.y)&&Oa(b.prev,b,b.next)>=0)return!1;b=b.prevZ}for(;w&&w.z<=v;){if(w.x>=d&&w.x<=m&&w.y>=y&&w.y<=g&&w!==s&&w!==a&&$a(l,h,u,p,c,f,w.x,w.y)&&Oa(w.prev,w,w.next)>=0)return!1;w=w.nextZ}return!0}function Ba(t,e){let r=t;do{const n=r.prev,s=r.next.next;!ja(n,s)&&qa(n,r,r.next,s)&&Xa(n,s)&&Xa(s,n)&&(e.push(n.i,r.i,s.i),Ka(r),Ka(r.next),r=t=s),r=r.next}while(r!==t);return Aa(r)}function Pa(t,e,r,n,s,o){let a=t;do{let t=a.next.next;for(;t!==a.prev;){if(a.i!==t.i&&La(a,t)){let l=Ya(a,t);return a=Aa(a,a.next),l=Aa(l,l.next),Ia(a,e,r,n,s,o,0),void Ia(l,e,r,n,s,o,0)}t=t.next}a=a.next}while(a!==t)}function Ca(t,e){let r=t.x-e.x;return 0===r&&(r=t.y-e.y,0===r)&&(r=(t.next.y-t.y)/(t.next.x-t.x)-(e.next.y-e.y)/(e.next.x-e.x)),r}function Ta(t,e){const r=function(t,e){let r=e;const n=t.x,s=t.y;let o,a=-1/0;if(ja(t,r))return r;do{if(ja(t,r.next))return r.next;if(s<=r.y&&s>=r.next.y&&r.next.y!==r.y){const t=r.x+(s-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(t<=n&&t>a&&(a=t,o=r.x<r.next.x?r:r.next,t===n))return o}r=r.next}while(r!==e);if(!o)return null;const l=o,u=o.x,c=o.y;let h=1/0;r=o;do{if(n>=r.x&&r.x>=u&&n!==r.x&&Da(s<c?n:a,s,u,c,s<c?a:n,s,r.x,r.y)){const e=Math.abs(s-r.y)/(n-r.x);Xa(r,t)&&(e<h||e===h&&(r.x>o.x||r.x===o.x&&Va(o,r)))&&(o=r,h=e)}r=r.next}while(r!==l);return o}(t,e);if(!r)return e;const n=Ya(r,t);return Aa(n,n.next),Aa(r,r.next)}function Va(t,e){return Oa(t.prev,t,e.prev)<0&&Oa(e.next,t,t.next)<0}function Ea(t,e,r,n,s){return(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*s|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-n)*s|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function Fa(t){let e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next}while(e!==t);return r}function Da(t,e,r,n,s,o,a,l){return(s-a)*(e-l)>=(t-a)*(o-l)&&(t-a)*(n-l)>=(r-a)*(e-l)&&(r-a)*(o-l)>=(s-a)*(n-l)}function $a(t,e,r,n,s,o,a,l){return!(t===a&&e===l)&&Da(t,e,r,n,s,o,a,l)}function La(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){let r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&qa(r,r.next,t,e))return!0;r=r.next}while(r!==t);return!1}(t,e)&&(Xa(t,e)&&Xa(e,t)&&function(t,e){let r=t,n=!1;const s=(t.x+e.x)/2,o=(t.y+e.y)/2;do{r.y>o!=r.next.y>o&&r.next.y!==r.y&&s<(r.next.x-r.x)*(o-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next}while(r!==t);return n}(t,e)&&(Oa(t.prev,t,e.prev)||Oa(t,e.prev,e))||ja(t,e)&&Oa(t.prev,t,t.next)>0&&Oa(e.prev,e,e.next)>0)}function Oa(t,e,r){return(e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function ja(t,e){return t.x===e.x&&t.y===e.y}function qa(t,e,r,n){const s=Za(Oa(t,e,r)),o=Za(Oa(t,e,n)),a=Za(Oa(r,n,t)),l=Za(Oa(r,n,e));return s!==o&&a!==l||!(0!==s||!Ga(t,r,e))||!(0!==o||!Ga(t,n,e))||!(0!==a||!Ga(r,t,n))||!(0!==l||!Ga(r,e,n))}function Ga(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function Za(t){return t>0?1:t<0?-1:0}function Xa(t,e){return Oa(t.prev,t,t.next)<0?Oa(t,e,t.next)>=0&&Oa(t,t.prev,e)>=0:Oa(t,e,t.prev)<0||Oa(t,t.next,e)<0}function Ya(t,e){const r=Wa(t.i,t.x,t.y),n=Wa(e.i,e.x,e.y),s=t.next,o=e.prev;return t.next=e,e.prev=t,r.next=s,s.prev=r,n.next=r,r.prev=n,o.next=n,n.prev=o,n}function Ha(t,e,r,n){const s=Wa(t,e,r);return n?(s.next=n.next,s.prev=n,n.next.prev=s,n.next=s):(s.prev=s,s.next=s),s}function Ka(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ)}function Wa(t,e,r){return{i:t,x:e,y:r,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}class Ra{constructor(t,e){if(e>t)throw new Error("Min granularity must not be greater than base granularity.");this._baseZoomGranularity=t,this._minGranularity=e}getGranularityForZoomLevel(t){return Math.max(Math.floor(this._baseZoomGranularity/(1<<t)),this._minGranularity,1)}}class Na{constructor(t){this.fill=t.fill,this.line=t.line,this.tile=t.tile,this.stencil=t.stencil,this.circle=t.circle}}Na.noSubdivision=new Na({fill:new Ra(0,0),line:new Ra(0,0),tile:new Ra(0,0),stencil:new Ra(0,0),circle:1}),Qn("SubdivisionGranularityExpression",Ra),Qn("SubdivisionGranularitySetting",Na);const Qa=-32768,el=32767;class Ua{constructor(t,e){this._vertexBuffer=[],this._vertexDictionary=new Map,this._used=!1,this._granularity=t,this._granularityCellSize=m/t,this._canonical=e}_getKey(t,e){return(t+=32768)<<16|e+32768}_vertexToIndex(t,e){if(t<-32768||e<-32768||t>32767||e>32767)throw new Error("Vertex coordinates are out of signed 16 bit integer range.");const r=0|Math.round(t),n=0|Math.round(e),s=this._getKey(r,n);if(this._vertexDictionary.has(s))return this._vertexDictionary.get(s);const o=this._vertexBuffer.length/2;return this._vertexDictionary.set(s,o),this._vertexBuffer.push(r,n),o}_subdivideTrianglesScanline(t){if(this._granularity<2)return function(t,e){const r=[];for(let n=0;n<e.length;n+=3){const s=e[n],o=e[n+1],a=e[n+2],l=t[2*s],u=t[2*s+1];(t[2*o]-l)*(t[2*a+1]-u)-(t[2*o+1]-u)*(t[2*a]-l)>0?(r.push(s),r.push(a),r.push(o)):(r.push(s),r.push(o),r.push(a))}return r}(this._vertexBuffer,t);const e=[],r=t.length;for(let n=0;n<r;n+=3){const r=[t[n+0],t[n+1],t[n+2]],s=[this._vertexBuffer[2*t[n+0]+0],this._vertexBuffer[2*t[n+0]+1],this._vertexBuffer[2*t[n+1]+0],this._vertexBuffer[2*t[n+1]+1],this._vertexBuffer[2*t[n+2]+0],this._vertexBuffer[2*t[n+2]+1]];let o=1/0,a=1/0,l=-1/0,u=-1/0;for(let t=0;t<3;t++){const e=s[2*t],r=s[2*t+1];o=Math.min(o,e),l=Math.max(l,e),a=Math.min(a,r),u=Math.max(u,r)}if(o===l||a===u)continue;const c=Math.floor(o/this._granularityCellSize),h=Math.ceil(l/this._granularityCellSize),p=Math.floor(a/this._granularityCellSize),f=Math.ceil(u/this._granularityCellSize);if(c!==h||p!==f)for(let t=p;t<f;t++){const n=this._scanlineGenerateVertexRingForCellRow(t,s,r);il(this._vertexBuffer,n,e)}else e.push(...r)}return e}_scanlineGenerateVertexRingForCellRow(t,e,r){const n=t*this._granularityCellSize,s=n+this._granularityCellSize,o=[];for(let t=0;t<3;t++){const a=e[2*t],l=e[2*t+1],u=e[2*(t+1)%6],c=e[(2*(t+1)+1)%6],h=e[2*(t+2)%6],p=e[(2*(t+2)+1)%6],f=u-a,d=c-l,y=0===f,m=0===d,g=(n-l)/d,x=(s-l)/d,v=Math.min(g,x),b=Math.max(g,x);if(!m&&(v>=1||b<=0)||m&&(l<n||l>s)){c>=n&&c<=s&&o.push(r[(t+1)%3]);continue}!m&&v>0&&o.push(this._vertexToIndex(a+f*v,l+d*v));const w=a+f*Math.max(v,0),_=a+f*Math.min(b,1);y||this._generateIntraEdgeVertices(o,a,l,u,c,w,_),!m&&b<1&&o.push(this._vertexToIndex(a+f*b,l+d*b)),(m||c>=n&&c<=s)&&o.push(r[(t+1)%3]),!m&&(c<=n||c>=s)&&this._generateInterEdgeVertices(o,a,l,u,c,h,p,_,n,s)}return o}_generateIntraEdgeVertices(t,e,r,n,s,o,a){const l=n-e,u=s-r,c=0===u,h=c?Math.min(e,n):Math.min(o,a),p=c?Math.max(e,n):Math.max(o,a),f=Math.floor(h/this._granularityCellSize)+1,d=Math.ceil(p/this._granularityCellSize)-1;if(c?e<n:o<a)for(let n=f;n<=d;n++){const s=n*this._granularityCellSize;t.push(this._vertexToIndex(s,r+u*(s-e)/l))}else for(let n=d;n>=f;n--){const s=n*this._granularityCellSize;t.push(this._vertexToIndex(s,r+u*(s-e)/l))}}_generateInterEdgeVertices(t,e,r,n,s,o,a,l,u,c){const h=s-r,p=o-n,f=a-s,d=(u-s)/f,y=(c-s)/f,m=Math.min(d,y),g=Math.max(d,y),x=n+p*m;let v=Math.floor(Math.min(x,l)/this._granularityCellSize)+1,b=Math.ceil(Math.max(x,l)/this._granularityCellSize)-1,w=l<x;const _=0===f;if(_&&(a===u||a===c))return;if(_||m>=1||g<=0){const t=r-a,n=o+(e-o)*Math.min((u-a)/t,(c-a)/t);v=Math.floor(Math.min(n,l)/this._granularityCellSize)+1,b=Math.ceil(Math.max(n,l)/this._granularityCellSize)-1,w=l<n}const S=h>0?c:u;if(w)for(let e=v;e<=b;e++)t.push(this._vertexToIndex(e*this._granularityCellSize,S));else for(let e=b;e>=v;e--)t.push(this._vertexToIndex(e*this._granularityCellSize,S))}_generateOutline(t){const e=[];for(const r of t){const t=nl(r,this._granularity,!0),n=this._pointArrayToIndices(t),s=[];for(let t=1;t<n.length;t++)s.push(n[t-1]),s.push(n[t]);e.push(s)}return e}_handlePoles(t){let e=!1,r=!1;this._canonical&&(0===this._canonical.y&&(e=!0),this._canonical.y===(1<<this._canonical.z)-1&&(r=!0)),(e||r)&&this._fillPoles(t,e,r)}_ensureNoPoleVertices(){const t=this._vertexBuffer;for(let e=0;e<t.length;e+=2){const r=t[e+1];r===Qa&&(t[e+1]=-32767),r===el&&(t[e+1]=32766)}}_generatePoleQuad(t,e,r,n,s,o){n>s!=(o===Qa)?(t.push(e),t.push(r),t.push(this._vertexToIndex(n,o)),t.push(r),t.push(this._vertexToIndex(s,o)),t.push(this._vertexToIndex(n,o))):(t.push(r),t.push(e),t.push(this._vertexToIndex(n,o)),t.push(this._vertexToIndex(s,o)),t.push(r),t.push(this._vertexToIndex(n,o)))}_fillPoles(t,e,r){const n=this._vertexBuffer,s=m,o=t.length;for(let a=2;a<o;a+=3){const o=t[a-2],l=t[a-1],u=t[a],c=n[2*o],h=n[2*o+1],p=n[2*l],f=n[2*l+1],d=n[2*u],y=n[2*u+1];e&&(0===h&&0===f&&this._generatePoleQuad(t,o,l,c,p,Qa),0===f&&0===y&&this._generatePoleQuad(t,l,u,p,d,Qa),0===y&&0===h&&this._generatePoleQuad(t,u,o,d,c,Qa)),r&&(h===s&&f===s&&this._generatePoleQuad(t,o,l,c,p,el),f===s&&y===s&&this._generatePoleQuad(t,l,u,p,d,el),y===s&&h===s&&this._generatePoleQuad(t,u,o,d,c,el))}}_initializeVertices(t){for(let e=0;e<t.length;e+=2)this._vertexToIndex(t[e],t[e+1])}subdividePolygonInternal(t,e){if(this._used)throw new Error("Subdivision: multiple use not allowed.");this._used=!0;const{flattened:r,holeIndices:n}=function(t){const e=[],r=[];for(const n of t)if(0!==n.length){n!==t[0]&&e.push(r.length/2);for(let t=0;t<n.length;t++)r.push(n[t].x),r.push(n[t].y)}return{flattened:r,holeIndices:e}}(t);let s;this._initializeVertices(r);try{const t=function(t,e,r=2){const n=e&&e.length,s=n?e[0]*r:t.length;let o=ka(t,0,s,r,!0);const a=[];if(!o||o.next===o.prev)return a;let l,u,c;if(n&&(o=function(t,e,r,n){const s=[];for(let r=0,o=e.length;r<o;r++){const a=ka(t,e[r]*n,r<o-1?e[r+1]*n:t.length,n,!1);a===a.next&&(a.steiner=!0),s.push(Fa(a))}s.sort(Ca);for(let t=0;t<s.length;t++)r=Ta(s[t],r);return r}(t,e,o,r)),t.length>80*r){l=1/0,u=1/0;let e=-1/0,n=-1/0;for(let o=r;o<s;o+=r){const r=t[o],s=t[o+1];r<l&&(l=r),s<u&&(u=s),r>e&&(e=r),s>n&&(n=s)}c=Math.max(e-l,n-u),c=0!==c?32767/c:0}return Ia(o,a,r,l,u,c,0),a}(r,n),e=this._convertIndices(r,t);s=this._subdivideTrianglesScanline(e)}catch(t){console.error(t)}let o=[];return e&&(o=this._generateOutline(t)),this._ensureNoPoleVertices(),this._handlePoles(s),{verticesFlattened:this._vertexBuffer,indicesTriangles:s,indicesLineList:o}}_convertIndices(t,e){const r=[];for(let n=0;n<e.length;n++)r.push(this._vertexToIndex(t[2*e[n]],t[2*e[n]+1]));return r}_pointArrayToIndices(t){const e=[];for(let r=0;r<t.length;r++){const n=t[r];e.push(this._vertexToIndex(n.x,n.y))}return e}}function rl(t,e,r,n=!0){return new Ua(r,e).subdividePolygonInternal(t,n)}function nl(t,e,r=!1){if(!t||t.length<1)return[];if(t.length<2)return[];const n=t[0],s=t[t.length-1],o=r&&(n.x!==s.x||n.y!==s.y);if(e<2)return o?[...t,t[0]]:[...t];const a=Math.floor(m/e),u=[];u.push(new l(t[0].x,t[0].y));const c=t.length,h=o?c:c-1;for(let e=0;e<h;e++){const r=t[e],n=e<c-1?t[e+1]:t[0],s=r.x,o=r.y,h=n.x,p=n.y,f=s!==h,d=o!==p;if(!f&&!d)continue;const y=h-s,m=p-o,g=Math.abs(y),x=Math.abs(m);let v=s,b=o;for(;;){const t=y>0?(Math.floor(v/a)+1)*a:(Math.ceil(v/a)-1)*a,e=m>0?(Math.floor(b/a)+1)*a:(Math.ceil(b/a)-1)*a,r=Math.abs(v-t),n=Math.abs(b-e),s=Math.abs(v-h),o=Math.abs(b-p),c=f?r/g:Number.POSITIVE_INFINITY,w=d?n/x:Number.POSITIVE_INFINITY;if((s<=r||!f)&&(o<=n||!d))break;if(c<w&&f||!d){v=t,b+=m*c;const e=new l(v,Math.round(b));u[u.length-1].x===e.x&&u[u.length-1].y===e.y||u.push(e)}else{v+=y*w,b=e;const t=new l(Math.round(v),b);u[u.length-1].x===t.x&&u[u.length-1].y===t.y||u.push(t)}}const w=new l(h,p);u[u.length-1].x===w.x&&u[u.length-1].y===w.y||u.push(w)}return u}function il(t,e,r){if(0===e.length)throw new Error("Subdivision vertex ring is empty.");let n=0,s=t[2*e[0]];for(let r=1;r<e.length;r++){const o=t[2*e[r]];o<s&&(s=o,n=r)}const o=e.length;let a=n,l=(a+1)%o;for(;;){const n=a-1>=0?a-1:o-1,s=(l+1)%o,u=t[2*e[n]],c=t[2*e[s]],h=t[2*e[a]],p=t[2*e[a]+1],f=t[2*e[l]+1];let d=!1;if(u<c)d=!0;else if(u>c)d=!1;else{const r=f-p,o=-(t[2*e[l]]-h),a=p<f?1:-1;((u-h)*r+(t[2*e[n]+1]-p)*o)*a>((c-h)*r+(t[2*e[s]+1]-p)*o)*a&&(d=!0)}if(d){const t=e[n],s=e[a],u=e[l];t!==s&&t!==u&&s!==u&&r.push(u,s,t),a--,a<0&&(a=o-1)}else{const t=e[s],n=e[a],u=e[l];t!==n&&t!==u&&n!==u&&r.push(u,n,t),l++,l>=o&&(l=0)}if(n===s)break}}function sl(t,e,r,n,s,o,a,l,u){const c=s.length/2,h=a&&l&&u;if(c<Js.MAX_VERTEX_ARRAY_LENGTH){const p=e.prepareSegment(c,r,n),f=p.vertexLength;for(let t=0;t<o.length;t+=3)n.emplaceBack(f+o[t],f+o[t+1],f+o[t+2]);let d,y;p.vertexLength+=c,p.primitiveLength+=o.length/3,h&&(y=a.prepareSegment(c,r,l),d=y.vertexLength,y.vertexLength+=c);for(let e=0;e<s.length;e+=2)t(s[e],s[e+1]);if(h)for(let t=0;t<u.length;t++){const e=u[t];for(let t=1;t<e.length;t+=2)l.emplaceBack(d+e[t-1],d+e[t]);y.primitiveLength+=e.length/2}}else!function(t,e,r,n,s,o){const a=[];for(let t=0;t<n.length/2;t++)a.push(-1);const l={count:0};let u=0,c=t.getOrCreateLatestSegment(e,r),h=c.vertexLength;for(let p=2;p<s.length;p+=3){const f=s[p-2],d=s[p-1],y=s[p];let m=a[f]<u,g=a[d]<u,x=a[y]<u;c.vertexLength+((m?1:0)+(g?1:0)+(x?1:0))>Js.MAX_VERTEX_ARRAY_LENGTH&&(c=t.createNewSegment(e,r),u=l.count,m=!0,g=!0,x=!0,h=0);const v=ol(a,n,o,l,f,m,c),b=ol(a,n,o,l,d,g,c),w=ol(a,n,o,l,y,x,c);r.emplaceBack(h+v-u,h+b-u,h+w-u),c.primitiveLength++}}(e,r,n,s,o,t),h&&function(t,e,r,n,s,o){const a=[];for(let t=0;t<n.length/2;t++)a.push(-1);const l={count:0};let u=0,c=t.getOrCreateLatestSegment(e,r),h=c.vertexLength;for(let p=0;p<s.length;p++){const f=s[p];for(let d=1;d<s[p].length;d+=2){const s=f[d-1],p=f[d];let y=a[s]<u,m=a[p]<u;c.vertexLength+((y?1:0)+(m?1:0))>Js.MAX_VERTEX_ARRAY_LENGTH&&(c=t.createNewSegment(e,r),u=l.count,y=!0,m=!0,h=0);const g=ol(a,n,o,l,s,y,c),x=ol(a,n,o,l,p,m,c);r.emplaceBack(h+g-u,h+x-u),c.primitiveLength++}}}(a,r,l,s,u,t),e.forceNewSegmentOnNextPrepare(),null==a||a.forceNewSegmentOnNextPrepare()}function ol(t,e,r,n,s,o,a){if(o){const o=n.count;return r(e[2*s],e[2*s+1]),t[s]=n.count,n.count++,a.vertexLength++,o}return t[s]}class Ja{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new Ds,this.indexArray=new Zs,this.indexArray2=new Xs,this.programConfigurations=new So(t.layers,t.zoom),this.segments=new Js,this.segments2=new Js,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,r){this.hasPattern=_a("fill",this.layers,e);const n=this.layers[0].layout.get("fill-sort-key"),s=!n.isConstant(),o=[];for(const{feature:a,id:l,index:u,sourceLayerIndex:c}of t){const t=this.layers[0]._featureFilter.needGeometry,h=Ro(a,t);if(!this.layers[0]._featureFilter.filter(new Bi(this.zoom),h,r))continue;const p=s?n.evaluate(h,{},r,e.availableImages):void 0,f={id:l,properties:a.properties,type:a.type,sourceLayerIndex:c,index:u,geometry:t?h.geometry:Lo(a),patterns:{},sortKey:p};o.push(f)}s&&o.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of o){const{geometry:s,index:o,sourceLayerIndex:a}=n;if(this.hasPattern){const t=Sa("fill",this.layers,n,this.zoom,e);this.patternFeatures.push(t)}else this.addFeature(n,s,o,r,{},e.subdivisionGranularity);e.featureIndex.insert(t[o].feature,s,o,a,this.index)}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r)}addFeatures(t,e,r){for(const n of this.patternFeatures)this.addFeature(n,n.geometry,n.index,e,r,t.subdivisionGranularity)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,wa),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy())}addFeature(t,e,r,n,s,o){for(const t of Xe(e,500)){const e=rl(t,n,o.fill.getGranularityForZoomLevel(n.z)),r=this.layoutVertexArray;sl(((t,e)=>{r.emplaceBack(t,e)}),this.segments,this.layoutVertexArray,this.indexArray,e.verticesFlattened,e.indicesTriangles,this.segments2,this.indexArray2,e.indicesLineList)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,s,n)}}let al,ll;Qn("FillBucket",Ja,{omit:["layers","patternFeatures"]});var ul={get paint(){return ll=ll||new Gi({"fill-antialias":new Ri(C.paint_fill["fill-antialias"]),"fill-opacity":new Ni(C.paint_fill["fill-opacity"]),"fill-color":new Ni(C.paint_fill["fill-color"]),"fill-outline-color":new Ni(C.paint_fill["fill-outline-color"]),"fill-translate":new Ri(C.paint_fill["fill-translate"]),"fill-translate-anchor":new Ri(C.paint_fill["fill-translate-anchor"]),"fill-pattern":new ji(C.paint_fill["fill-pattern"])})},get layout(){return al=al||new Gi({"fill-sort-key":new Ni(C.layout_fill["fill-sort-key"])})}};class tl extends Xi{constructor(t){super(t,ul)}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"])}createBucket(t){return new Ja(t)}queryRadius(){return ra(this.paint.get("fill-translate"))}queryIntersectsFeature({queryGeometry:t,geometry:e,transform:r,pixelsToTileUnits:n}){return qo(na(t,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),-r.bearingInRadians,n),e)}isTileClipped(){return!0}}const cl=ro([{name:"a_pos",components:2,type:"Int16"},{name:"a_normal_ed",components:4,type:"Int16"}],4),hl=ro([{name:"a_centroid",components:2,type:"Int16"}],4),{members:pl}=cl;var fl,dl,yl,ml,gl,xl,bl,wl={};function _l(){if(dl)return fl;dl=1;var t=s();function e(t,e,n,s,o){this.properties={},this.extent=n,this.type=0,this._pbf=t,this._geometry=-1,this._keys=s,this._values=o,t.readFields(r,this,e)}function r(t,e,r){1==t?e.id=r.readVarint():2==t?function(t,e){for(var r=t.readVarint()+t.pos;t.pos<r;){var n=e._keys[t.readVarint()],s=e._values[t.readVarint()];e.properties[n]=s}}(r,e):3==t?e.type=r.readVarint():4==t&&(e._geometry=r.pos)}function n(t){for(var e,r,n=0,s=0,o=t.length,a=o-1;s<o;a=s++)n+=((r=t[a]).x-(e=t[s]).x)*(e.y+r.y);return n}return fl=e,e.types=["Unknown","Point","LineString","Polygon"],e.prototype.loadGeometry=function(){var e=this._pbf;e.pos=this._geometry;for(var r,n=e.readVarint()+e.pos,s=1,o=0,a=0,l=0,u=[];e.pos<n;){if(o<=0){var c=e.readVarint();s=7&c,o=c>>3}if(o--,1===s||2===s)a+=e.readSVarint(),l+=e.readSVarint(),1===s&&(r&&u.push(r),r=[]),r.push(new t(a,l));else{if(7!==s)throw new Error("unknown command "+s);r&&r.push(r[0].clone())}}return r&&u.push(r),u},e.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,r=1,n=0,s=0,o=0,a=1/0,l=-1/0,u=1/0,c=-1/0;t.pos<e;){if(n<=0){var h=t.readVarint();r=7&h,n=h>>3}if(n--,1===r||2===r)(s+=t.readSVarint())<a&&(a=s),s>l&&(l=s),(o+=t.readSVarint())<u&&(u=o),o>c&&(c=o);else if(7!==r)throw new Error("unknown command "+r)}return[a,u,l,c]},e.prototype.toGeoJSON=function(t,r,s){var o,a,l=this.extent*Math.pow(2,s),u=this.extent*t,c=this.extent*r,h=this.loadGeometry(),p=e.types[this.type];function f(t){for(var e=0;e<t.length;e++){var r=t[e];t[e]=[360*(r.x+u)/l-180,360/Math.PI*Math.atan(Math.exp((180-360*(r.y+c)/l)*Math.PI/180))-90]}}switch(this.type){case 1:var d=[];for(o=0;o<h.length;o++)d[o]=h[o][0];f(h=d);break;case 2:for(o=0;o<h.length;o++)f(h[o]);break;case 3:for(h=function(t){var e=t.length;if(e<=1)return[t];for(var r,s,o=[],a=0;a<e;a++){var l=n(t[a]);0!==l&&(void 0===s&&(s=l<0),s===l<0?(r&&o.push(r),r=[t[a]]):r.push(t[a]))}return r&&o.push(r),o}(h),o=0;o<h.length;o++)for(a=0;a<h[o].length;a++)f(h[o][a])}1===h.length?h=h[0]:p="Multi"+p;var y={type:"Feature",geometry:{type:p,coordinates:h},properties:this.properties};return"id"in this&&(y.id=this.id),y},fl}function Sl(){if(ml)return yl;ml=1;var t=_l();function e(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(r,this,e),this.length=this._features.length}function r(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){for(var e=null,r=t.readVarint()+t.pos;t.pos<r;){var n=t.readVarint()>>3;e=1===n?t.readString():2===n?t.readFloat():3===n?t.readDouble():4===n?t.readVarint64():5===n?t.readVarint():6===n?t.readSVarint():7===n?t.readBoolean():null}return e}(r))}return yl=e,e.prototype.feature=function(e){if(e<0||e>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[e];var r=this._pbf.readVarint()+this._pbf.pos;return new t(this._pbf,r,this.extent,this._keys,this._values)},yl}function kl(){return bl||(bl=1,wl.VectorTile=function(){if(xl)return gl;xl=1;var t=Sl();function e(e,r,n){if(3===e){var s=new t(n,n.readVarint()+n.pos);s.length&&(r[s.name]=s)}}return gl=function(t,r){this.layers=t.readFields(e,{},r)},gl}(),wl.VectorTileFeature=_l(),wl.VectorTileLayer=Sl()),wl}var Il=e(kl());const Ml=Il.VectorTileFeature.types,zl=Math.pow(2,13);function Bl(t,e,r,n,s,o,a,l){t.emplaceBack(e,r,2*Math.floor(n*zl)+a,s*zl*2,o*zl*2,Math.round(l))}class vl{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new Ls,this.centroidVertexArray=new Es,this.indexArray=new Zs,this.programConfigurations=new So(t.layers,t.zoom),this.segments=new Js,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,r){this.features=[],this.hasPattern=_a("fill-extrusion",this.layers,e);for(const{feature:n,id:s,index:o,sourceLayerIndex:a}of t){const t=this.layers[0]._featureFilter.needGeometry,l=Ro(n,t);if(!this.layers[0]._featureFilter.filter(new Bi(this.zoom),l,r))continue;const u={id:s,sourceLayerIndex:a,index:o,geometry:t?l.geometry:Lo(n),properties:n.properties,type:n.type,patterns:{}};this.hasPattern?this.features.push(Sa("fill-extrusion",this.layers,u,this.zoom,e)):this.addFeature(u,u.geometry,o,r,{},e.subdivisionGranularity),e.featureIndex.insert(n,u.geometry,o,a,this.index,!0)}}addFeatures(t,e,r){for(const n of this.features){const{geometry:s}=n;this.addFeature(n,s,n.index,e,r,t.subdivisionGranularity)}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r)}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.centroidVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,pl),this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,hl.members,!0),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.centroidVertexBuffer.destroy())}addFeature(t,e,r,n,s,o){for(const r of Xe(e,500)){const e={x:0,y:0,sampleCount:0},s=this.layoutVertexArray.length;this.processPolygon(e,n,t,r,o);const a=this.layoutVertexArray.length-s,l=Math.floor(e.x/e.sampleCount),u=Math.floor(e.y/e.sampleCount);for(let t=0;t<a;t++)this.centroidVertexArray.emplaceBack(l,u)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,s,n)}processPolygon(t,e,r,n,s){if(n.length<1)return;if(Tl(n[0]))return;for(const e of n)0!==e.length&&Pl(t,e);const o={segment:this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray)},a=s.fill.getGranularityForZoomLevel(e.z),l="Polygon"===Ml[r.type];for(const t of n){if(0===t.length)continue;if(Tl(t))continue;const e=nl(t,a,l);this._generateSideFaces(e,o)}if(!l)return;const u=rl(n,e,a,!1),c=this.layoutVertexArray;sl(((t,e)=>{Bl(c,t,e,0,0,1,1,0)}),this.segments,this.layoutVertexArray,this.indexArray,u.verticesFlattened,u.indicesTriangles)}_generateSideFaces(t,e){let r=0;for(let n=1;n<t.length;n++){const s=t[n],o=t[n-1];if(Cl(s,o))continue;e.segment.vertexLength+4>Js.MAX_VERTEX_ARRAY_LENGTH&&(e.segment=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const a=s.sub(o)._perp()._unit(),l=o.dist(s);r+l>32768&&(r=0),Bl(this.layoutVertexArray,s.x,s.y,a.x,a.y,0,0,r),Bl(this.layoutVertexArray,s.x,s.y,a.x,a.y,0,1,r),r+=l,Bl(this.layoutVertexArray,o.x,o.y,a.x,a.y,0,0,r),Bl(this.layoutVertexArray,o.x,o.y,a.x,a.y,0,1,r);const u=e.segment.vertexLength;this.indexArray.emplaceBack(u,u+2,u+1),this.indexArray.emplaceBack(u+1,u+2,u+3),e.segment.vertexLength+=4,e.segment.primitiveLength+=2}}}function Pl(t,e){for(let r=0;r<e.length;r++){const n=e[r];r===e.length-1&&e[0].x===n.x&&e[0].y===n.y||(t.x+=n.x,t.y+=n.y,t.sampleCount++)}}function Cl(t,e){return t.x===e.x&&(t.x<0||t.x>m)||t.y===e.y&&(t.y<0||t.y>m)}function Tl(t){return t.every((t=>t.x<0))||t.every((t=>t.x>m))||t.every((t=>t.y<0))||t.every((t=>t.y>m))}let Vl;Qn("FillExtrusionBucket",vl,{omit:["layers","features"]});var El={get paint(){return Vl=Vl||new Gi({"fill-extrusion-opacity":new Ri(C["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new Ni(C["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new Ri(C["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new Ri(C["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new ji(C["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new Ni(C["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new Ni(C["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new Ri(C["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})}};class Al extends Xi{constructor(t){super(t,El)}createBucket(t){return new vl(t)}queryRadius(){return ra(this.paint.get("fill-extrusion-translate"))}is3D(){return!0}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:r,geometry:n,transform:s,pixelsToTileUnits:o,pixelPosMatrix:a}){const u=na(t,this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),-s.bearingInRadians,o),c=this.paint.get("fill-extrusion-height").evaluate(e,r),h=this.paint.get("fill-extrusion-base").evaluate(e,r),p=function(t,e){const r=[];for(const n of t){const t=[n.x,n.y,0,1];y(t,t,e),r.push(new l(t[0]/t[3],t[1]/t[3]))}return r}(u,a),f=function(t,e,r,n){const s=[],o=[],a=n[8]*e,u=n[9]*e,c=n[10]*e,h=n[11]*e,p=n[8]*r,f=n[9]*r,d=n[10]*r,y=n[11]*r;for(const e of t){const t=[],r=[];for(const s of e){const e=s.x,o=s.y,m=n[0]*e+n[4]*o+n[12],g=n[1]*e+n[5]*o+n[13],x=n[2]*e+n[6]*o+n[14],v=n[3]*e+n[7]*o+n[15],b=x+c,w=v+h,_=m+p,S=g+f,k=x+d,A=v+y,I=new l((m+a)/w,(g+u)/w);I.z=b/w,t.push(I);const M=new l(_/A,S/A);M.z=k/A,r.push(M)}s.push(t),o.push(r)}return[s,o]}(n,h,c,a);return function(t,e,r){let n=1/0;qo(r,e)&&(n=$l(r,e[0]));for(let s=0;s<e.length;s++){const o=e[s],a=t[s];for(let t=0;t<o.length-1;t++){const e=o[t],s=[e,o[t+1],a[t+1],a[t],e];jo(r,s)&&(n=Math.min(n,$l(r,s)))}}return n!==1/0&&n}(f[0],f[1],p)}}function Dl(t,e){return t.x*e.x+t.y*e.y}function $l(t,e){if(1===t.length){let r=0;const n=e[r++];let s;for(;!s||n.equals(s);)if(s=e[r++],!s)return 1/0;for(;r<e.length;r++){const o=e[r],a=t[0],l=s.sub(n),u=o.sub(n),c=a.sub(n),h=Dl(l,l),p=Dl(l,u),f=Dl(u,u),d=Dl(c,l),y=Dl(c,u),m=h*f-p*p,g=(f*d-p*y)/m,x=(h*y-p*d)/m,v=n.z*(1-g-x)+s.z*g+o.z*x;if(isFinite(v))return v}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}const Ll=ro([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"}],4),{members:Rl}=Ll,jl=ro([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:Ul}=jl,ql=Il.VectorTileFeature.types,Gl=Math.cos(Math.PI/180*37.5),Zl=Math.pow(2,14)/.5;class Fl{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={}})),this.layoutVertexArray=new $s,this.layoutVertexArray2=new Os,this.indexArray=new Zs,this.programConfigurations=new So(t.layers,t.zoom),this.segments=new Js,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,r){this.hasPattern=_a("line",this.layers,e);const n=this.layers[0].layout.get("line-sort-key"),s=!n.isConstant(),o=[];for(const{feature:e,id:a,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=Ro(e,t);if(!this.layers[0]._featureFilter.filter(new Bi(this.zoom),c,r))continue;const h=s?n.evaluate(c,{},r):void 0,p={id:a,properties:e.properties,type:e.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:Lo(e),patterns:{},sortKey:h};o.push(p)}s&&o.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of o){const{geometry:s,index:o,sourceLayerIndex:a}=n;if(this.hasPattern){const t=Sa("line",this.layers,n,this.zoom,e);this.patternFeatures.push(t)}else this.addFeature(n,s,o,r,{},e.subdivisionGranularity);e.featureIndex.insert(t[o].feature,s,o,a,this.index)}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r)}addFeatures(t,e,r){for(const n of this.patternFeatures)this.addFeature(n,n.geometry,n.index,e,r,t.subdivisionGranularity)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,Ul)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Rl),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}lineFeatureClips(t){if(t.properties&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_start")&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_end"))return{start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,r,n,s,o){const a=this.layers[0].layout,l=a.get("line-join").evaluate(t,{}),u=a.get("line-cap"),c=a.get("line-miter-limit"),h=a.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const r of e)this.addLine(r,t,l,u,c,h,n,o);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,s,n)}addLine(t,e,r,n,s,o,a,l){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,t=nl(t,a?l.line.getGranularityForZoomLevel(a.z):1),this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance)}const u="Polygon"===ql[e.type];let c=t.length;for(;c>=2&&t[c-1].equals(t[c-2]);)c--;let h=0;for(;h<c-1&&t[h].equals(t[h+1]);)h++;if(c<(u?3:2))return;"bevel"===r&&(s=1.05);const p=this.overscaling<=16?15*m/(512*this.overscaling):0,f=this.segments.prepareSegment(10*c,this.layoutVertexArray,this.indexArray);let d,y,g,x,v;this.e1=this.e2=-1,u&&(d=t[c-2],v=t[h].sub(d)._unit()._perp());for(let e=h;e<c;e++){if(g=e===c-1?u?t[h+1]:void 0:t[e+1],g&&t[e].equals(g))continue;v&&(x=v),d&&(y=d),d=t[e],v=g?g.sub(d)._unit()._perp():x,x=x||v;let a=x.add(v);0===a.x&&0===a.y||a._unit();const l=x.x*v.x+x.y*v.y,m=a.x*v.x+a.y*v.y,b=0!==m?1/m:1/0,w=2*Math.sqrt(2-2*m),_=m<Gl&&y&&g,S=x.x*v.y-x.y*v.x>0;if(_&&e>h){const t=d.dist(y);if(t>2*p){const e=d.sub(d.sub(y)._mult(p/t)._round());this.updateDistance(y,e),this.addCurrentVertex(e,x,0,0,f),y=e}}const k=y&&g;let A=k?r:u?"butt":n;if(k&&"round"===A&&(b<o?A="miter":b<=2&&(A="fakeround")),"miter"===A&&b>s&&(A="bevel"),"bevel"===A&&(b>2&&(A="flipbevel"),b<s&&(A="miter")),y&&this.updateDistance(y,d),"miter"===A)a._mult(b),this.addCurrentVertex(d,a,0,0,f);else if("flipbevel"===A){if(b>100)a=v.mult(-1);else{const t=b*x.add(v).mag()/x.sub(v).mag();a._perp()._mult(t*(S?-1:1))}this.addCurrentVertex(d,a,0,0,f),this.addCurrentVertex(d,a.mult(-1),0,0,f)}else if("bevel"===A||"fakeround"===A){const t=-Math.sqrt(b*b-1),e=S?t:0,r=S?0:t;if(y&&this.addCurrentVertex(d,x,e,r,f),"fakeround"===A){const t=Math.round(180*w/Math.PI/20);for(let e=1;e<t;e++){let r=e/t;if(.5!==r){const t=r-.5;r+=r*t*(r-1)*((1.0904+l*(l*(3.55645-1.43519*l)-3.2452))*t*t+(.848013+l*(.215638*l-1.06021)))}const n=v.sub(x)._mult(r)._add(x)._unit()._mult(S?-1:1);this.addHalfVertex(d,n.x,n.y,!1,S,0,f)}}g&&this.addCurrentVertex(d,v,-e,-r,f)}else if("butt"===A)this.addCurrentVertex(d,a,0,0,f);else if("square"===A){const t=y?1:-1;this.addCurrentVertex(d,a,t,t,f)}else"round"===A&&(y&&(this.addCurrentVertex(d,x,0,0,f),this.addCurrentVertex(d,x,1,1,f,!0)),g&&(this.addCurrentVertex(d,v,-1,-1,f,!0),this.addCurrentVertex(d,v,0,0,f)));if(_&&e<c-1){const t=d.dist(g);if(t>2*p){const e=d.add(g.sub(d)._mult(p/t)._round());this.updateDistance(d,e),this.addCurrentVertex(e,v,0,0,f),d=e}}}}addCurrentVertex(t,e,r,n,s,o=!1){const a=e.y*n-e.x,l=-e.y-e.x*n;this.addHalfVertex(t,e.x+e.y*r,e.y-e.x*r,o,!1,r,s),this.addHalfVertex(t,a,l,o,!0,-n,s),this.distance>Zl/2&&0===this.totalDistance&&(this.distance=0,this.updateScaledDistance(),this.addCurrentVertex(t,e,r,n,s,o))}addHalfVertex({x:t,y:e},r,n,s,o,a,l){const u=.5*(this.lineClips?this.scaledDistance*(Zl-1):this.scaledDistance);this.layoutVertexArray.emplaceBack((t<<1)+(s?1:0),(e<<1)+(o?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===a?0:a<0?-1:1)|(63&u)<<2,u>>6),this.lineClips&&this.layoutVertexArray2.emplaceBack((this.scaledDistance-this.lineClips.start)/(this.lineClips.end-this.lineClips.start),this.lineClipsArray.length);const c=l.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,c,this.e2),l.primitiveLength++),o?this.e2=c:this.e1=c}updateScaledDistance(){this.scaledDistance=this.lineClips?this.lineClips.start+(this.lineClips.end-this.lineClips.start)*this.distance/this.totalDistance:this.distance}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance()}}let Jl,Xl;Qn("LineBucket",Fl,{omit:["layers","patternFeatures"]});var Yl={get paint(){return Xl=Xl||new Gi({"line-opacity":new Ni(C.paint_line["line-opacity"]),"line-color":new Ni(C.paint_line["line-color"]),"line-translate":new Ri(C.paint_line["line-translate"]),"line-translate-anchor":new Ri(C.paint_line["line-translate-anchor"]),"line-width":new Ni(C.paint_line["line-width"]),"line-gap-width":new Ni(C.paint_line["line-gap-width"]),"line-offset":new Ni(C.paint_line["line-offset"]),"line-blur":new Ni(C.paint_line["line-blur"]),"line-dasharray":new qi(C.paint_line["line-dasharray"]),"line-pattern":new ji(C.paint_line["line-pattern"]),"line-gradient":new Ui(C.paint_line["line-gradient"])})},get layout(){return Jl=Jl||new Gi({"line-cap":new Ri(C.layout_line["line-cap"]),"line-join":new Ni(C.layout_line["line-join"]),"line-miter-limit":new Ri(C.layout_line["line-miter-limit"]),"line-round-limit":new Ri(C.layout_line["line-round-limit"]),"line-sort-key":new Ni(C.layout_line["line-sort-key"])})}};class Ol extends Ni{possiblyEvaluate(t,e){return e=new Bi(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,zoomHistory:e.zoomHistory,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,r,n){return e=x({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,n)}}let Hl;class Nl extends Xi{constructor(t){super(t,Yl),this.gradientVersion=0,Hl||(Hl=new Ol(Yl.paint.properties["line-width"].specification),Hl.useIntegerZoom=!0)}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this.gradientExpression();this.stepInterpolant=!!function(t){return void 0!==t._styleExpression}(t)&&t._styleExpression.expression instanceof ee,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=Hl.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t)}createBucket(t){return new Fl(t)}queryRadius(t){const e=t,r=Kl(ea("line-width",this,e),ea("line-gap-width",this,e)),n=ea("line-offset",this,e);return r/2+Math.abs(n)+ra(this.paint.get("line-translate"))}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:r,geometry:n,transform:s,pixelsToTileUnits:o}){const a=na(t,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),-s.bearingInRadians,o),u=o/2*Kl(this.paint.get("line-width").evaluate(e,r),this.paint.get("line-gap-width").evaluate(e,r)),c=this.paint.get("line-offset").evaluate(e,r);return c&&(n=function(t,e){const r=[];for(let n=0;n<t.length;n++){const s=t[n],o=[];for(let t=0;t<s.length;t++){const r=s[t-1],n=s[t],a=s[t+1],u=0===t?new l(0,0):n.sub(r)._unit()._perp(),c=t===s.length-1?new l(0,0):a.sub(n)._unit()._perp(),h=u._add(c)._unit(),p=h.x*c.x+h.y*c.y;0!==p&&h._mult(1/p),o.push(h._mult(e)._add(n))}r.push(o)}return r}(n,c*o)),function(t,e,r){for(let n=0;n<e.length;n++){const s=e[n];if(t.length>=3)for(let e=0;e<s.length;e++)if(Qo(t,s[e]))return!0;if(Go(t,s,r))return!0}return!1}(a,n,u)}isTileClipped(){return!0}}function Kl(t,e){return e>0?e+2*t:t}const Wl=ro([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),Ql=ro([{name:"a_projected_pos",components:3,type:"Float32"}],4);ro([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const tu=ro([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_box_real",components:2,type:"Int16"}]);ro([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Int16",name:"x1"},{type:"Int16",name:"y1"},{type:"Int16",name:"x2"},{type:"Int16",name:"y2"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const eu=ro([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4);function ru(t,e,r){return t.sections.forEach((t=>{t.text=function(t,e,r){const n=e.layout.get("text-transform").evaluate(r,{});return"uppercase"===n?t=t.toLocaleUpperCase():"lowercase"===n&&(t=t.toLocaleLowerCase()),Qs.applyArabicShaping&&(t=Qs.applyArabicShaping(t)),t}(t.text,e,r)})),t}ro([{name:"a_pos",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4),ro([{name:"triangle",components:3,type:"Uint16"}]),ro([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),ro([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Uint16",name:"textAnchorOffsetStartIndex"},{type:"Uint16",name:"textAnchorOffsetEndIndex"}]),ro([{type:"Float32",name:"offsetX"}]),ro([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]),ro([{type:"Uint16",name:"textAnchor"},{type:"Float32",components:2,name:"textOffset"}]);const nu={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"};var iu,su,lu,uu=24,pu={};function fu(){if(lu)return su;lu=1,su=e;var t=(iu||(iu=1,pu.read=function(t,e,r,n,s){var o,a,l=8*s-n-1,u=(1<<l)-1,c=u>>1,h=-7,p=r?s-1:0,f=r?-1:1,d=t[e+p];for(p+=f,o=d&(1<<-h)-1,d>>=-h,h+=l;h>0;o=256*o+t[e+p],p+=f,h-=8);for(a=o&(1<<-h)-1,o>>=-h,h+=n;h>0;a=256*a+t[e+p],p+=f,h-=8);if(0===o)o=1-c;else{if(o===u)return a?NaN:1/0*(d?-1:1);a+=Math.pow(2,n),o-=c}return(d?-1:1)*a*Math.pow(2,o-n)},pu.write=function(t,e,r,n,s,o){var a,l,u,c=8*o-s-1,h=(1<<c)-1,p=h>>1,f=23===s?Math.pow(2,-24)-Math.pow(2,-77):0,d=n?0:o-1,y=n?1:-1,m=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(l=isNaN(e)?1:0,a=h):(a=Math.floor(Math.log(e)/Math.LN2),e*(u=Math.pow(2,-a))<1&&(a--,u*=2),(e+=a+p>=1?f/u:f*Math.pow(2,1-p))*u>=2&&(a++,u/=2),a+p>=h?(l=0,a=h):a+p>=1?(l=(e*u-1)*Math.pow(2,s),a+=p):(l=e*Math.pow(2,p-1)*Math.pow(2,s),a=0));s>=8;t[r+d]=255&l,d+=y,l/=256,s-=8);for(a=a<<s|l,c+=s;c>0;t[r+d]=255&a,d+=y,a/=256,c-=8);t[r+d-y]|=128*m}),pu);function e(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length}e.Varint=0,e.Fixed64=1,e.Bytes=2,e.Fixed32=5;var r=4294967296,n=1/r,s="undefined"==typeof TextDecoder?null:new TextDecoder("utf-8");function o(t){return t.type===e.Bytes?t.readVarint()+t.pos:t.pos+1}function a(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function l(t,e,r){var n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(n);for(var s=r.pos-1;s>=t;s--)r.buf[s+n]=r.buf[s]}function u(t,e){for(var r=0;r<t.length;r++)e.writeVarint(t[r])}function c(t,e){for(var r=0;r<t.length;r++)e.writeSVarint(t[r])}function h(t,e){for(var r=0;r<t.length;r++)e.writeFloat(t[r])}function p(t,e){for(var r=0;r<t.length;r++)e.writeDouble(t[r])}function f(t,e){for(var r=0;r<t.length;r++)e.writeBoolean(t[r])}function d(t,e){for(var r=0;r<t.length;r++)e.writeFixed32(t[r])}function y(t,e){for(var r=0;r<t.length;r++)e.writeSFixed32(t[r])}function m(t,e){for(var r=0;r<t.length;r++)e.writeFixed64(t[r])}function g(t,e){for(var r=0;r<t.length;r++)e.writeSFixed64(t[r])}function x(t,e){return(t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function v(t,e,r){t[r]=e,t[r+1]=e>>>8,t[r+2]=e>>>16,t[r+3]=e>>>24}function b(t,e){return(t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}return e.prototype={destroy:function(){this.buf=null},readFields:function(t,e,r){for(r=r||this.length;this.pos<r;){var n=this.readVarint(),s=n>>3,o=this.pos;this.type=7&n,t(s,e,this),this.pos===o&&this.skip(n)}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=x(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=b(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=x(this.buf,this.pos)+x(this.buf,this.pos+4)*r;return this.pos+=8,t},readSFixed64:function(){var t=x(this.buf,this.pos)+b(this.buf,this.pos+4)*r;return this.pos+=8,t},readFloat:function(){var e=t.read(this.buf,this.pos,!0,23,4);return this.pos+=4,e},readDouble:function(){var e=t.read(this.buf,this.pos,!0,52,8);return this.pos+=8,e},readVarint:function(t){var e,r,n=this.buf;return e=127&(r=n[this.pos++]),r<128?e:(e|=(127&(r=n[this.pos++]))<<7,r<128?e:(e|=(127&(r=n[this.pos++]))<<14,r<128?e:(e|=(127&(r=n[this.pos++]))<<21,r<128?e:function(t,e,r){var n,s,o=r.buf;if(n=(112&(s=o[r.pos++]))>>4,s<128)return a(t,n,e);if(n|=(127&(s=o[r.pos++]))<<3,s<128)return a(t,n,e);if(n|=(127&(s=o[r.pos++]))<<10,s<128)return a(t,n,e);if(n|=(127&(s=o[r.pos++]))<<17,s<128)return a(t,n,e);if(n|=(127&(s=o[r.pos++]))<<24,s<128)return a(t,n,e);if(n|=(1&(s=o[r.pos++]))<<31,s<128)return a(t,n,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(r=n[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&s?function(t,e,r){return s.decode(t.subarray(e,r))}(this.buf,e,t):function(t,e,r){for(var n="",s=e;s<r;){var o,a,l,u=t[s],c=null,h=u>239?4:u>223?3:u>191?2:1;if(s+h>r)break;1===h?u<128&&(c=u):2===h?128==(192&(o=t[s+1]))&&(c=(31&u)<<6|63&o)<=127&&(c=null):3===h?(a=t[s+2],128==(192&(o=t[s+1]))&&128==(192&a)&&((c=(15&u)<<12|(63&o)<<6|63&a)<=2047||c>=55296&&c<=57343)&&(c=null)):4===h&&(a=t[s+2],l=t[s+3],128==(192&(o=t[s+1]))&&128==(192&a)&&128==(192&l)&&((c=(15&u)<<18|(63&o)<<12|(63&a)<<6|63&l)<=65535||c>=1114112)&&(c=null)),null===c?(c=65533,h=1):c>65535&&(c-=65536,n+=String.fromCharCode(c>>>10&1023|55296),c=56320|1023&c),n+=String.fromCharCode(c),s+=h}return n}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,r){if(this.type!==e.Bytes)return t.push(this.readVarint(r));var n=o(this);for(t=t||[];this.pos<n;)t.push(this.readVarint(r));return t},readPackedSVarint:function(t){if(this.type!==e.Bytes)return t.push(this.readSVarint());var r=o(this);for(t=t||[];this.pos<r;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==e.Bytes)return t.push(this.readBoolean());var r=o(this);for(t=t||[];this.pos<r;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==e.Bytes)return t.push(this.readFloat());var r=o(this);for(t=t||[];this.pos<r;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==e.Bytes)return t.push(this.readDouble());var r=o(this);for(t=t||[];this.pos<r;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==e.Bytes)return t.push(this.readFixed32());var r=o(this);for(t=t||[];this.pos<r;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==e.Bytes)return t.push(this.readSFixed32());var r=o(this);for(t=t||[];this.pos<r;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==e.Bytes)return t.push(this.readFixed64());var r=o(this);for(t=t||[];this.pos<r;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==e.Bytes)return t.push(this.readSFixed64());var r=o(this);for(t=t||[];this.pos<r;)t.push(this.readSFixed64());return t},skip:function(t){var r=7&t;if(r===e.Varint)for(;this.buf[this.pos++]>127;);else if(r===e.Bytes)this.pos=this.readVarint()+this.pos;else if(r===e.Fixed32)this.pos+=4;else{if(r!==e.Fixed64)throw new Error("Unimplemented type: "+r);this.pos+=8}},writeTag:function(t,e){this.writeVarint(t<<3|e)},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var r=new Uint8Array(e);r.set(this.buf),this.buf=r,this.length=e}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),v(this.buf,t,this.pos),this.pos+=4},writeSFixed32:function(t){this.realloc(4),v(this.buf,t,this.pos),this.pos+=4},writeFixed64:function(t){this.realloc(8),v(this.buf,-1&t,this.pos),v(this.buf,Math.floor(t*n),this.pos+4),this.pos+=8},writeSFixed64:function(t){this.realloc(8),v(this.buf,-1&t,this.pos),v(this.buf,Math.floor(t*n),this.pos+4),this.pos+=8},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var r,n;if(t>=0?(r=t%4294967296|0,n=t/4294967296|0):(n=~(-t/4294967296),4294967295^(r=~(-t%4294967296))?r=r+1|0:(r=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7)}(r,0,e),function(t,e){var r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))))}(n,e)}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))))},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t)},writeBoolean:function(t){this.writeVarint(Boolean(t))},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,r){for(var n,s,o=0;o<e.length;o++){if((n=e.charCodeAt(o))>55295&&n<57344){if(!s){n>56319||o+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):s=n;continue}if(n<56320){t[r++]=239,t[r++]=191,t[r++]=189,s=n;continue}n=s-55296<<10|n-56320|65536,s=null}else s&&(t[r++]=239,t[r++]=191,t[r++]=189,s=null);n<128?t[r++]=n:(n<2048?t[r++]=n>>6|192:(n<65536?t[r++]=n>>12|224:(t[r++]=n>>18|240,t[r++]=n>>12&63|128),t[r++]=n>>6&63|128),t[r++]=63&n|128)}return r}(this.buf,t,this.pos);var r=this.pos-e;r>=128&&l(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r},writeFloat:function(e){this.realloc(4),t.write(this.buf,e,this.pos,!0,23,4),this.pos+=4},writeDouble:function(e){this.realloc(8),t.write(this.buf,e,this.pos,!0,52,8),this.pos+=8},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var r=0;r<e;r++)this.buf[this.pos++]=t[r]},writeRawMessage:function(t,e){this.pos++;var r=this.pos;t(e,this);var n=this.pos-r;n>=128&&l(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n},writeMessage:function(t,r,n){this.writeTag(t,e.Bytes),this.writeRawMessage(r,n)},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,u,e)},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,c,e)},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,f,e)},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,h,e)},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,p,e)},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,d,e)},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,y,e)},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,m,e)},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,g,e)},writeBytesField:function(t,r){this.writeTag(t,e.Bytes),this.writeBytes(r)},writeFixed32Field:function(t,r){this.writeTag(t,e.Fixed32),this.writeFixed32(r)},writeSFixed32Field:function(t,r){this.writeTag(t,e.Fixed32),this.writeSFixed32(r)},writeFixed64Field:function(t,r){this.writeTag(t,e.Fixed64),this.writeFixed64(r)},writeSFixed64Field:function(t,r){this.writeTag(t,e.Fixed64),this.writeSFixed64(r)},writeVarintField:function(t,r){this.writeTag(t,e.Varint),this.writeVarint(r)},writeSVarintField:function(t,r){this.writeTag(t,e.Varint),this.writeSVarint(r)},writeStringField:function(t,r){this.writeTag(t,e.Bytes),this.writeString(r)},writeFloatField:function(t,r){this.writeTag(t,e.Fixed32),this.writeFloat(r)},writeDoubleField:function(t,r){this.writeTag(t,e.Fixed64),this.writeDouble(r)},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e))}},su}var du,yu=e(fu());function mu(t){let e=0,r=0;for(const n of t)e+=n.w*n.h,r=Math.max(r,n.w);t.sort(((t,e)=>e.h-t.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let s=0,o=0;for(const e of t)for(let t=n.length-1;t>=0;t--){const r=n[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,o=Math.max(o,e.y+e.h),s=Math.max(s,e.x+e.w),e.w===r.w&&e.h===r.h){const e=n.pop();t<n.length&&(n[t]=e)}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(n.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break}}return{w:s,h:o,fill:e/(s*o)||0}}class ou{constructor(t,{pixelRatio:e,version:r,stretchX:n,stretchY:s,content:o,textFitWidth:a,textFitHeight:l}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=n,this.stretchY=s,this.content=o,this.version=r,this.textFitWidth=a,this.textFitHeight=l}get tl(){return[this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return[this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return[(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}class au{constructor(t,e){const r={},n={};this.haveRenderCallbacks=[];const s=[];this.addImages(t,r,s),this.addImages(e,n,s);const{w:o,h:a}=mu(s),l=new sa({width:o||1,height:a||1});for(const e in t){const n=t[e],s=r[e].paddedRect;sa.copy(n.data,l,{x:0,y:0},{x:s.x+1,y:s.y+1},n.data)}for(const t in e){const r=e[t],s=n[t].paddedRect,o=s.x+1,a=s.y+1,u=r.data.width,c=r.data.height;sa.copy(r.data,l,{x:0,y:0},{x:o,y:a},r.data),sa.copy(r.data,l,{x:0,y:c-1},{x:o,y:a-1},{width:u,height:1}),sa.copy(r.data,l,{x:0,y:0},{x:o,y:a+c},{width:u,height:1}),sa.copy(r.data,l,{x:u-1,y:0},{x:o-1,y:a},{width:1,height:c}),sa.copy(r.data,l,{x:0,y:0},{x:o+u,y:a},{width:1,height:c})}this.image=l,this.iconPositions=r,this.patternPositions=n}addImages(t,e,r){for(const n in t){const s=t[n],o={x:0,y:0,w:s.data.width+2,h:s.data.height+2};r.push(o),e[n]=new ou(o,s),s.hasRenderCallback&&this.haveRenderCallbacks.push(n)}}patchUpdatedImages(t,e){t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const r in t.updatedImages)this.patchUpdatedImage(this.iconPositions[r],t.getImage(r),e),this.patchUpdatedImage(this.patternPositions[r],t.getImage(r),e)}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[n,s]=t.tl;r.update(e.data,void 0,{x:n,y:s})}}Qn("ImagePosition",ou),Qn("ImageAtlas",au),function(t){t[t.none=0]="none",t[t.horizontal=1]="horizontal",t[t.vertical=2]="vertical",t[t.horizontalOnly=3]="horizontalOnly"}(du||(du={}));class cu{constructor(){this.scale=1,this.fontStack="",this.imageName=null,this.verticalAlign="bottom"}static forText(t,e,r){const n=new cu;return n.scale=t||1,n.fontStack=e,n.verticalAlign=r||"bottom",n}static forImage(t,e){const r=new cu;return r.imageName=t,r.verticalAlign=e||"bottom",r}}class hu{constructor(){this.text="",this.sectionIndex=[],this.sections=[],this.imageSectionID=null}static fromFeature(t,e){const r=new hu;for(let n=0;n<t.sections.length;n++){const s=t.sections[n];s.image?r.addImageSection(s):r.addTextSection(s,e)}return r}length(){return this.text.length}getSection(t){return this.sections[this.sectionIndex[t]]}getSectionIndex(t){return this.sectionIndex[t]}getCharCode(t){return this.text.charCodeAt(t)}verticalizePunctuation(){this.text=function(t){let e="";for(let r=0;r<t.length;r++){const n=t.charCodeAt(r+1)||null,s=t.charCodeAt(r-1)||null;e+=n&&Wi(n)&&!nu[t[r+1]]||s&&Wi(s)&&!nu[t[r-1]]||!nu[t[r]]?t[r]:nu[t[r]]}return e}(this.text)}trim(){let t=0;for(let e=0;e<this.text.length&&xu[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&xu[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e),this.sectionIndex=this.sectionIndex.slice(t,e)}substring(t,e){const r=new hu;return r.text=this.text.substring(t,e),r.sectionIndex=this.sectionIndex.slice(t,e),r.sections=this.sections,r}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((t,e)=>Math.max(t,this.sections[e].scale)),0)}getMaxImageSize(t){let e=0,r=0;for(let n=0;n<this.length();n++){const s=this.getSection(n);if(s.imageName){const n=t[s.imageName];if(!n)continue;const o=n.displaySize;e=Math.max(e,o[0]),r=Math.max(r,o[1])}}return{maxImageWidth:e,maxImageHeight:r}}addTextSection(t,e){this.text+=t.text,this.sections.push(cu.forText(t.scale,t.fontStack||e,t.verticalAlign));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r)}addImageSection(t){const e=t.image?t.image.name:"";if(0===e.length)return void _("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCharCode(r),this.sections.push(cu.forImage(e,t.verticalAlign)),this.sectionIndex.push(this.sections.length-1)):_("Reached maximum number of images 6401")}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}}function gu(t,e,r,n,s,o,a,l,u,c,h,p,f,d,y){const m=hu.fromFeature(t,s);let g;p===du.vertical&&m.verticalizePunctuation();const{processBidirectionalText:x,processStyledBidirectionalText:v}=Qs;if(x&&1===m.sections.length){g=[];const t=x(m.toString(),Iu(m,c,o,e,n,d));for(const e of t){const t=new hu;t.text=e,t.sections=m.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);g.push(t)}}else if(v){g=[];const t=v(m.text,m.sectionIndex,Iu(m,c,o,e,n,d));for(const e of t){const t=new hu;t.text=e[0],t.sectionIndex=e[1],t.sections=m.sections,g.push(t)}}else g=function(t,e){const r=[],n=t.text;let s=0;for(const n of e)r.push(t.substring(s,n)),s=n;return s<n.length&&r.push(t.substring(s,n.length)),r}(m,Iu(m,c,o,e,n,d));const b=[],w={positionedLines:b,text:m.toString(),top:h[1],bottom:h[1],left:h[0],right:h[0],writingMode:p,iconsInText:!1,verticalizable:!1};return function(t,e,r,n,s,o,a,l,u,c,h,p){let f=0,d=0,y=0,m=0;const g="right"===l?1:"left"===l?0:.5,x=uu/p;let v=0;for(const a of s){a.trim();const s=a.getMaxScale(),l={positionedGlyphs:[],lineOffset:0};t.positionedLines[v]=l;const p=l.positionedGlyphs;let b=0;if(!a.length()){d+=o,++v;continue}const w=zu(n,a,x);for(let o=0;o<a.length();o++){const l=a.getSection(o),y=a.getSectionIndex(o),m=a.getCharCode(o),g=Pu(u,h,m);let v;if(l.imageName){if(t.iconsInText=!0,l.scale=l.scale*x,v=Tu(l,g,s,w,n),!v)continue;b=Math.max(b,v.imageOffset)}else if(v=Cu(l,m,g,w,e,r),!v)continue;const{rect:_,metrics:S,baselineOffset:k}=v;p.push({glyph:m,imageName:l.imageName,x:f,y:d+k+-17,vertical:g,scale:l.scale,fontStack:l.fontStack,sectionIndex:y,metrics:S,rect:_}),g?(t.verticalizable=!0,f+=(l.imageName?S.advance:uu)*l.scale+c):f+=S.advance*l.scale+c}0!==p.length&&(y=Math.max(f-c,y),Vu(p,0,p.length-1,g)),f=0,l.lineOffset=Math.max(b,(s-1)*uu);const _=o*s+b;d+=_,m=Math.max(_,m),++v}const{horizontalAlign:b,verticalAlign:w}=Mu(a);(function(t,e,r,n,s,o,a,l,u){const c=(e-r)*s;let h=0;h=o!==a?-l*n- -17:-n*u*a+.5*a;for(const e of t)for(const t of e.positionedGlyphs)t.x+=c,t.y+=h})(t.positionedLines,g,b,w,y,m,o,d,s.length),t.top+=-w*d,t.bottom=t.top+d,t.left+=-b*y,t.right=t.left+y}(w,e,r,n,g,a,l,u,p,c,f,y),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return!1;return!0}(b)&&w}const xu={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},vu={10:!0,32:!0,38:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0},bu={40:!0};function wu(t,e,r,n,s,o){if(e.imageName){const t=n[e.imageName];return t?t.displaySize[0]*e.scale*uu/o+s:0}{const n=r[e.fontStack],o=n&&n[t];return o?o.metrics.advance*e.scale+s:0}}function _u(t,e,r,n){const s=Math.pow(t-e,2);return n?t<e?s/2:2*s:s+Math.abs(r)*r}function Su(t,e,r){let n=0;return 10===t&&(n-=1e4),r&&(n+=150),40!==t&&65288!==t||(n+=50),41!==e&&65289!==e||(n+=50),n}function ku(t,e,r,n,s,o){let a=null,l=_u(e,r,s,o);for(const t of n){const n=_u(e-t.x,r,s,o)+t.badness;n<=l&&(a=t,l=n)}return{index:t,x:e,priorBreak:a,badness:l}}function Au(t){return t?Au(t.priorBreak).concat(t.index):[]}function Iu(t,e,r,n,s,o){if(!t)return[];const a=[],l=function(t,e,r,n,s,o){let a=0;for(let r=0;r<t.length();r++){const l=t.getSection(r);a+=wu(t.getCharCode(r),l,n,s,e,o)}return a/Math.max(1,Math.ceil(a/r))}(t,e,r,n,s,o),u=t.text.indexOf("​")>=0;let c=0;for(let r=0;r<t.length();r++){const p=t.getSection(r),f=t.getCharCode(r);if(xu[f]||(c+=wu(f,p,n,s,e,o)),r<t.length()-1){const e=!((h=f)<11904)&&(!!ki(h)||!!_i(h)||!!bi(h)||!!xi(h)||!!wi(h)||!!Ii(h)||!!gi(h)||!!Si(h)||Hi.test(String.fromCodePoint(h)));(vu[f]||e||p.imageName||r!==t.length()-2&&bu[t.getCharCode(r+1)])&&a.push(ku(r+1,c,l,a,Su(f,t.getCharCode(r+1),e&&u),!1))}}var h;return Au(ku(t.length(),c,l,a,0,!0))}function Mu(t){let e=.5,r=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0}switch(t){case"bottom":case"bottom-right":case"bottom-left":r=1;break;case"top":case"top-right":case"top-left":r=0}return{horizontalAlign:e,verticalAlign:r}}function zu(t,e,r){const n=e.getMaxScale()*uu,{maxImageWidth:s,maxImageHeight:o}=e.getMaxImageSize(t),a=Math.max(n,o*r);return{verticalLineContentWidth:Math.max(n,s*r),horizontalLineContentHeight:a}}function Bu(t){switch(t){case"top":return 0;case"center":return.5;default:return 1}}function Pu(t,e,r){return!(t===du.horizontal||!e&&!Ki(r)||e&&(xu[r]||(n=r,/\p{sc=Arab}/u.test(String.fromCodePoint(n)))));var n}function Cu(t,e,r,n,s,o){const a=o[t.fontStack],l=function(t,e,r,n){if(t&&t.rect)return t;const s=e[r.fontStack],o=s&&s[n];return o?{rect:null,metrics:o.metrics}:null}(a&&a[e],s,t,e);if(null===l)return null;let u;if(r)u=n.verticalLineContentWidth-t.scale*uu;else{const e=Bu(t.verticalAlign);u=(n.horizontalLineContentHeight-t.scale*uu)*e}return{rect:l.rect,metrics:l.metrics,baselineOffset:u}}function Tu(t,e,r,n,s){const o=s[t.imageName];if(!o)return null;const a=o.paddedRect,l=o.displaySize,u={width:l[0],height:l[1],left:1,top:-3,advance:e?l[1]:l[0]};let c;if(e)c=n.verticalLineContentWidth-l[1]*t.scale;else{const e=Bu(t.verticalAlign);c=(n.horizontalLineContentHeight-l[1]*t.scale)*e}return{rect:a,metrics:u,baselineOffset:c,imageOffset:(e?l[0]:l[1])*t.scale-uu*r}}function Vu(t,e,r,n){if(0===n)return;const s=t[r],o=(t[r].x+s.metrics.advance*s.scale)*n;for(let n=e;n<=r;n++)t[n].x-=o}function Eu(t,e,r){const{horizontalAlign:n,verticalAlign:s}=Mu(r),o=e[0]-t.displaySize[0]*n,a=e[1]-t.displaySize[1]*s;return{image:t,top:a,bottom:a+t.displaySize[1],left:o,right:o+t.displaySize[0]}}function Fu(t){var e,r;let n=t.left,s=t.top,o=t.right-n,a=t.bottom-s;const l=null!==(e=t.image.textFitWidth)&&void 0!==e?e:"stretchOrShrink",u=null!==(r=t.image.textFitHeight)&&void 0!==r?r:"stretchOrShrink",c=(t.image.content[2]-t.image.content[0])/(t.image.content[3]-t.image.content[1]);if("proportional"===u){if("stretchOnly"===l&&o/a<c||"proportional"===l){const t=Math.ceil(a*c);n*=t/o,o=t}}else if("proportional"===l&&"stretchOnly"===u&&0!==c&&o/a>c){const t=Math.ceil(o/c);s*=t/a,a=t}return{x1:n,y1:s,x2:n+o,y2:s+a}}function Du(t,e,r,n,s,o){const a=t.image;let l;if(a.content){const t=a.content,e=a.pixelRatio||1;l=[t[0]/e,t[1]/e,a.displaySize[0]-t[2]/e,a.displaySize[1]-t[3]/e]}const u=e.left*o,c=e.right*o;let h,p,f,d;"width"===r||"both"===r?(d=s[0]+u-n[3],p=s[0]+c+n[1]):(d=s[0]+(u+c-a.displaySize[0])/2,p=d+a.displaySize[0]);const y=e.top*o,m=e.bottom*o;return"height"===r||"both"===r?(h=s[1]+y-n[0],f=s[1]+m+n[2]):(h=s[1]+(y+m-a.displaySize[1])/2,f=h+a.displaySize[1]),{image:a,top:h,right:p,bottom:f,left:d,collisionPadding:l}}const $u=128,Lu=32640;function Ru(t,e){const{expression:r}=e;if("constant"===r.kind)return{kind:"constant",layoutSize:r.evaluate(new Bi(t+1))};if("source"===r.kind)return{kind:"source"};{const{zoomStops:e,interpolationType:n}=r;let s=0;for(;s<e.length&&e[s]<=t;)s++;s=Math.max(0,s-1);let o=s;for(;o<e.length&&e[o]<t+1;)o++;o=Math.min(e.length-1,o);const a=e[s],l=e[o];return"composite"===r.kind?{kind:"composite",minZoom:a,maxZoom:l,interpolationType:n}:{kind:"camera",minZoom:a,maxZoom:l,minSize:r.evaluate(new Bi(a)),maxSize:r.evaluate(new Bi(l)),interpolationType:n}}}function Ou(t,e,r){let n="never";const s=t.get(e);return s?n=s:t.get(r)&&(n="always"),n}const Nu=Il.VectorTileFeature.types,Gu=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function Zu(t,e,r,n,s,o,a,l,u,c,h,p,f){const d=l?Math.min(Lu,Math.round(l[0])):0,y=l?Math.min(Lu,Math.round(l[1])):0;t.emplaceBack(e,r,Math.round(32*n),Math.round(32*s),o,a,(d<<1)+(u?1:0),y,16*c,16*h,256*p,256*f)}function Ju(t,e,r){t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r)}function Xu(t){for(const e of t.sections)if(Ws(e.text))return!0;return!1}class ju{constructor(t){this.layoutVertexArray=new Ns,this.indexArray=new Zs,this.programConfigurations=t,this.segments=new Js,this.dynamicLayoutVertexArray=new js,this.opacityVertexArray=new qs,this.hasVisibleVertices=!1,this.placedSymbolArray=new As}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(t,e,r,n){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Wl.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,Ql.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,Gu,!0),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(t))}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy())}}Qn("SymbolBuffers",ju);class qu{constructor(t,e,r){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new r,this.segments=new Js,this.collisionVertexArray=new Gs}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,tu.members,!0)}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy())}}Qn("CollisionBuffers",qu);class Uu{constructor(t){this.collisionBoxArray=t.collisionBoxArray,this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.pixelRatio=t.pixelRatio,this.sourceLayerIndex=t.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[];const e=this.layers[0]._unevaluatedLayout._values;this.textSizeData=Ru(this.zoom,e["text-size"]),this.iconSizeData=Ru(this.zoom,e["icon-size"]);const r=this.layers[0].layout,n=r.get("symbol-sort-key"),s=r.get("symbol-z-order");this.canOverlap="never"!==Ou(r,"text-overlap","text-allow-overlap")||"never"!==Ou(r,"icon-overlap","icon-allow-overlap")||r.get("text-ignore-placement")||r.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==s&&!n.isConstant(),this.sortFeaturesByY=("viewport-y"===s||"auto"===s&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===r.get("symbol-placement")&&(this.writingModes=r.get("text-writing-mode").map((t=>du[t]))),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=t.sourceID}createArrays(){this.text=new ju(new So(this.layers,this.zoom,(t=>/^text/.test(t)))),this.icon=new ju(new So(this.layers,this.zoom,(t=>/^icon/.test(t)))),this.glyphOffsetArray=new zs,this.lineVertexArray=new Ps,this.symbolInstances=new Ms,this.textAnchorOffsets=new Bs}calculateGlyphDependencies(t,e,r,n,s){for(let o=0;o<t.length;o++)if(e[t.charCodeAt(o)]=!0,(r||n)&&s){const r=nu[t.charAt(o)];r&&(e[r.charCodeAt(0)]=!0)}}populate(t,e,r){const n=this.layers[0],s=n.layout,o=s.get("text-font"),a=s.get("text-field"),l=s.get("icon-image"),u=("constant"!==a.value.kind||a.value.value instanceof Mt&&!a.value.value.isEmpty()||a.value.value.toString().length>0)&&("constant"!==o.value.kind||o.value.value.length>0),c="constant"!==l.value.kind||!!l.value.value||Object.keys(l.parameters).length>0,h=s.get("symbol-sort-key");if(this.features=[],!u&&!c)return;const p=e.iconDependencies,f=e.glyphDependencies,d=e.availableImages,y=new Bi(this.zoom);for(const{feature:e,id:a,index:l,sourceLayerIndex:m}of t){const t=n._featureFilter.needGeometry,g=Ro(e,t);if(!n._featureFilter.filter(y,g,r))continue;let x,v;if(t||(g.geometry=Lo(e)),u){const t=n.getValueAndResolveTokens("text-field",g,r,d),e=Mt.factory(t),s=this.hasRTLText=this.hasRTLText||Xu(e);(!s||"unavailable"===Qs.getRTLTextPluginStatus()||s&&Qs.isParsed())&&(x=ru(e,n,g))}if(c){const t=n.getValueAndResolveTokens("icon-image",g,r,d);v=t instanceof Tt?t:Tt.fromString(t)}if(!x&&!v)continue;const b=this.sortFeaturesByKey?h.evaluate(g,{},r):void 0;if(this.features.push({id:a,text:x,icon:v,index:l,sourceLayerIndex:m,geometry:g.geometry,properties:e.properties,type:Nu[e.type],sortKey:b}),v&&(p[v.name]=!0),x){const t=o.evaluate(g,{},r).join(","),e="viewport"!==s.get("text-rotation-alignment")&&"point"!==s.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(du.vertical)>=0;for(const r of x.sections)if(r.image)p[r.image.name]=!0;else{const n=Mi(x.toString()),s=r.fontStack||t,o=f[s]=f[s]||{};this.calculateGlyphDependencies(r.text,o,e,this.allowVerticalPlacement,n)}}}"line"===s.get("symbol-placement")&&(this.features=function(t){const e={},r={},n=[];let s=0;function o(e){n.push(t[e]),s++}function a(t,e,s){const o=r[t];return delete r[t],r[e]=o,n[o].geometry[0].pop(),n[o].geometry[0]=n[o].geometry[0].concat(s[0]),o}function l(t,r,s){const o=e[r];return delete e[r],e[t]=o,n[o].geometry[0].shift(),n[o].geometry[0]=s[0].concat(n[o].geometry[0]),o}function u(t,e,r){const n=r?e[0][e[0].length-1]:e[0][0];return`${t}:${n.x}:${n.y}`}for(let c=0;c<t.length;c++){const h=t[c],p=h.geometry,f=h.text?h.text.toString():null;if(!f){o(c);continue}const d=u(f,p),y=u(f,p,!0);if(d in r&&y in e&&r[d]!==e[y]){const t=l(d,y,p),s=a(d,y,n[t].geometry);delete e[d],delete r[y],r[u(f,n[s].geometry,!0)]=s,n[t].geometry=null}else d in r?a(d,y,p):y in e?l(d,y,p):(o(c),e[d]=s-1,r[y]=s-1)}return n.filter((t=>t.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey))}update(t,e,r){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,r),this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,r))}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return!this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy()}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData()}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment){let r=t.dist(e[t.segment+1]),n=t.dist(e[t.segment]);const s={};for(let n=t.segment+1;n<e.length;n++)s[n]={x:e[n].x,y:e[n].y,tileUnitDistanceFromAnchor:r},n<e.length-1&&(r+=e[n+1].dist(e[n]));for(let r=t.segment||0;r>=0;r--)s[r]={x:e[r].x,y:e[r].y,tileUnitDistanceFromAnchor:n},r>0&&(n+=e[r-1].dist(e[r]));for(let t=0;t<e.length;t++){const e=s[t];this.lineVertexArray.emplaceBack(e.x,e.y,e.tileUnitDistanceFromAnchor)}}return{lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(t,e,r,n,s,o,a,l,u,c,h,p){const f=t.indexArray,d=t.layoutVertexArray,y=t.segments.prepareSegment(4*e.length,d,f,this.canOverlap?o.sortKey:void 0),m=this.glyphOffsetArray.length,g=y.vertexLength,x=this.allowVerticalPlacement&&a===du.vertical?Math.PI/2:0,v=o.text&&o.text.sections;for(let n=0;n<e.length;n++){const{tl:s,tr:a,bl:u,br:c,tex:h,pixelOffsetTL:m,pixelOffsetBR:g,minFontScaleX:b,minFontScaleY:w,glyphOffset:_,isSDF:S,sectionIndex:k}=e[n],A=y.vertexLength,I=_[1];Zu(d,l.x,l.y,s.x,I+s.y,h.x,h.y,r,S,m.x,m.y,b,w),Zu(d,l.x,l.y,a.x,I+a.y,h.x+h.w,h.y,r,S,g.x,m.y,b,w),Zu(d,l.x,l.y,u.x,I+u.y,h.x,h.y+h.h,r,S,m.x,g.y,b,w),Zu(d,l.x,l.y,c.x,I+c.y,h.x+h.w,h.y+h.h,r,S,g.x,g.y,b,w),Ju(t.dynamicLayoutVertexArray,l,x),f.emplaceBack(A,A+2,A+1),f.emplaceBack(A+1,A+2,A+3),y.vertexLength+=4,y.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(_[0]),n!==e.length-1&&k===e[n+1].sectionIndex||t.programConfigurations.populatePaintArrays(d.length,o,o.index,{},p,v&&v[k])}t.placedSymbolArray.emplaceBack(l.x,l.y,m,this.glyphOffsetArray.length-m,g,u,c,l.segment,r?r[0]:0,r?r[1]:0,n[0],n[1],a,0,!1,0,h)}_addCollisionDebugVertex(t,e,r,n,s,o){return e.emplaceBack(0,0),t.emplaceBack(r.x,r.y,n,s,Math.round(o.x),Math.round(o.y))}addCollisionDebugVertices(t,e,r,n,s,o,a){const u=s.segments.prepareSegment(4,s.layoutVertexArray,s.indexArray),c=u.vertexLength,h=s.layoutVertexArray,p=s.collisionVertexArray,f=a.anchorX,d=a.anchorY;this._addCollisionDebugVertex(h,p,o,f,d,new l(t,e)),this._addCollisionDebugVertex(h,p,o,f,d,new l(r,e)),this._addCollisionDebugVertex(h,p,o,f,d,new l(r,n)),this._addCollisionDebugVertex(h,p,o,f,d,new l(t,n)),u.vertexLength+=4;const y=s.indexArray;y.emplaceBack(c,c+1),y.emplaceBack(c+1,c+2),y.emplaceBack(c+2,c+3),y.emplaceBack(c+3,c),u.primitiveLength+=4}addDebugCollisionBoxes(t,e,r,n){for(let s=t;s<e;s++){const t=this.collisionBoxArray.get(s);this.addCollisionDebugVertices(t.x1,t.y1,t.x2,t.y2,n?this.textCollisionBox:this.iconCollisionBox,t.anchorPoint,r)}}generateCollisionDebugBuffers(){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new qu(Us,eu.members,Xs),this.iconCollisionBox=new qu(Us,eu.members,Xs);for(let t=0;t<this.symbolInstances.length;t++){const e=this.symbolInstances.get(t);this.addDebugCollisionBoxes(e.textBoxStartIndex,e.textBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.verticalTextBoxStartIndex,e.verticalTextBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.iconBoxStartIndex,e.iconBoxEndIndex,e,!1),this.addDebugCollisionBoxes(e.verticalIconBoxStartIndex,e.verticalIconBoxEndIndex,e,!1)}}_deserializeCollisionBoxesForSymbol(t,e,r,n,s,o,a,l,u){const c={};for(let n=e;n<r;n++){const e=t.get(n);c.textBox={x1:e.x1,y1:e.y1,x2:e.x2,y2:e.y2,anchorPointX:e.anchorPointX,anchorPointY:e.anchorPointY},c.textFeatureIndex=e.featureIndex;break}for(let e=n;e<s;e++){const r=t.get(e);c.verticalTextBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},c.verticalTextFeatureIndex=r.featureIndex;break}for(let e=o;e<a;e++){const r=t.get(e);c.iconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},c.iconFeatureIndex=r.featureIndex;break}for(let e=l;e<u;e++){const r=t.get(e);c.verticalIconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},c.verticalIconFeatureIndex=r.featureIndex;break}return c}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex))}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),n=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<n;e+=4)t.indexArray.emplaceBack(e,e+2,e+1),t.indexArray.emplaceBack(e+1,e+2,e+3)}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),n=[],s=[],o=[];for(let t=0;t<this.symbolInstances.length;++t){o.push(t);const a=this.symbolInstances.get(t);n.push(0|Math.round(e*a.anchorX+r*a.anchorY)),s.push(a.featureIndex)}return o.sort(((t,e)=>n[t]-n[e]||s[e]-s[t])),o}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1})}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex),[e.rightJustifiedTextSymbolIndex,e.centerJustifiedTextSymbolIndex,e.leftJustifiedTextSymbolIndex].forEach(((t,e,r)=>{t>=0&&r.indexOf(t)===e&&this.addIndicesForPlacedSymbol(this.text,t)})),e.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,e.verticalPlacedTextSymbolIndex),e.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.placedIconSymbolIndex),e.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.verticalPlacedIconSymbolIndex)}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray)}}}let Ku,Qu;Qn("SymbolBucket",Uu,{omit:["layers","collisionBoxArray","features","compareText"]}),Uu.MAX_GLYPHS=65535,Uu.addDynamicAttributes=Ju;var tc={get paint(){return Qu=Qu||new Gi({"icon-opacity":new Ni(C.paint_symbol["icon-opacity"]),"icon-color":new Ni(C.paint_symbol["icon-color"]),"icon-halo-color":new Ni(C.paint_symbol["icon-halo-color"]),"icon-halo-width":new Ni(C.paint_symbol["icon-halo-width"]),"icon-halo-blur":new Ni(C.paint_symbol["icon-halo-blur"]),"icon-translate":new Ri(C.paint_symbol["icon-translate"]),"icon-translate-anchor":new Ri(C.paint_symbol["icon-translate-anchor"]),"text-opacity":new Ni(C.paint_symbol["text-opacity"]),"text-color":new Ni(C.paint_symbol["text-color"],{runtimeType:O,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new Ni(C.paint_symbol["text-halo-color"]),"text-halo-width":new Ni(C.paint_symbol["text-halo-width"]),"text-halo-blur":new Ni(C.paint_symbol["text-halo-blur"]),"text-translate":new Ri(C.paint_symbol["text-translate"]),"text-translate-anchor":new Ri(C.paint_symbol["text-translate-anchor"])})},get layout(){return Ku=Ku||new Gi({"symbol-placement":new Ri(C.layout_symbol["symbol-placement"]),"symbol-spacing":new Ri(C.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new Ri(C.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new Ni(C.layout_symbol["symbol-sort-key"]),"symbol-z-order":new Ri(C.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new Ri(C.layout_symbol["icon-allow-overlap"]),"icon-overlap":new Ri(C.layout_symbol["icon-overlap"]),"icon-ignore-placement":new Ri(C.layout_symbol["icon-ignore-placement"]),"icon-optional":new Ri(C.layout_symbol["icon-optional"]),"icon-rotation-alignment":new Ri(C.layout_symbol["icon-rotation-alignment"]),"icon-size":new Ni(C.layout_symbol["icon-size"]),"icon-text-fit":new Ri(C.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new Ri(C.layout_symbol["icon-text-fit-padding"]),"icon-image":new Ni(C.layout_symbol["icon-image"]),"icon-rotate":new Ni(C.layout_symbol["icon-rotate"]),"icon-padding":new Ni(C.layout_symbol["icon-padding"]),"icon-keep-upright":new Ri(C.layout_symbol["icon-keep-upright"]),"icon-offset":new Ni(C.layout_symbol["icon-offset"]),"icon-anchor":new Ni(C.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new Ri(C.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new Ri(C.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new Ri(C.layout_symbol["text-rotation-alignment"]),"text-field":new Ni(C.layout_symbol["text-field"]),"text-font":new Ni(C.layout_symbol["text-font"]),"text-size":new Ni(C.layout_symbol["text-size"]),"text-max-width":new Ni(C.layout_symbol["text-max-width"]),"text-line-height":new Ri(C.layout_symbol["text-line-height"]),"text-letter-spacing":new Ni(C.layout_symbol["text-letter-spacing"]),"text-justify":new Ni(C.layout_symbol["text-justify"]),"text-radial-offset":new Ni(C.layout_symbol["text-radial-offset"]),"text-variable-anchor":new Ri(C.layout_symbol["text-variable-anchor"]),"text-variable-anchor-offset":new Ni(C.layout_symbol["text-variable-anchor-offset"]),"text-anchor":new Ni(C.layout_symbol["text-anchor"]),"text-max-angle":new Ri(C.layout_symbol["text-max-angle"]),"text-writing-mode":new Ri(C.layout_symbol["text-writing-mode"]),"text-rotate":new Ni(C.layout_symbol["text-rotate"]),"text-padding":new Ri(C.layout_symbol["text-padding"]),"text-keep-upright":new Ri(C.layout_symbol["text-keep-upright"]),"text-transform":new Ni(C.layout_symbol["text-transform"]),"text-offset":new Ni(C.layout_symbol["text-offset"]),"text-allow-overlap":new Ri(C.layout_symbol["text-allow-overlap"]),"text-overlap":new Ri(C.layout_symbol["text-overlap"]),"text-ignore-placement":new Ri(C.layout_symbol["text-ignore-placement"]),"text-optional":new Ri(C.layout_symbol["text-optional"])})}};class Hu{constructor(t){if(void 0===t.property.overrides)throw new Error("overrides must be provided to instantiate FormatSectionOverride class");this.type=t.property.overrides?t.property.overrides.runtimeType:D,this.defaultValue=t}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression)}outputDefined(){return!1}serialize(){return null}}Qn("FormatSectionOverride",Hu,{omit:["defaultValue"]});class Yu extends Xi{constructor(t){super(t,tc)}recalculate(t,e){if(super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]="map"===this.layout.get("text-rotation-alignment")?"map":"viewport"),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const t=this.layout.get("text-writing-mode");if(t){const e=[];for(const r of t)e.indexOf(r)<0&&e.push(r);this.layout._values["text-writing-mode"]=e}else this.layout._values["text-writing-mode"]=["horizontal"]}this._setPaintOverrides()}getValueAndResolveTokens(t,e,r,n){const s=this.layout.get(t).evaluate(e,{},r,n),o=this._unevaluatedLayout._values[t];return o.isDataDriven()||Yr(o.value)||!s?s:function(t,e){return e.replace(/{([^{}]+)}/g,((e,r)=>t&&r in t?String(t[r]):""))}(e.properties,s)}createBucket(t){return new Uu(t)}queryRadius(){return 0}queryIntersectsFeature(){throw new Error("Should take a different path in FeatureIndex")}_setPaintOverrides(){for(const t of tc.paint.overridableProperties){if(!Yu.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new Hu(e),n=new Xr(r,e.property.specification);let s=null;s="constant"===e.value.kind||"source"===e.value.kind?new Jr("source",n):new Kr("composite",n,e.value.zoomStops),this.paint._values[t]=new $i(e.property,s,e.parameters)}}_handleOverridablePaintPropertyUpdate(t,e,r){return!(!this.layout||e.isDataDriven()||r.isDataDriven())&&Yu.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),n=tc.paint.properties[e];let s=!1;const o=t=>{for(const e of t)if(n.overrides&&n.overrides.hasOverride(e))return void(s=!0)};if("constant"===r.value.kind&&r.value.value instanceof Mt)o(r.value.value.sections);else if("source"===r.value.kind){const t=e=>{s||(e instanceof $t&&Lt(e.value)===G?o(e.value.sections):e instanceof _e?o(e.sections):e.eachChild(t))},e=r.value;e._styleExpression&&t(e._styleExpression.expression)}return s}}let nc;var lc={get paint(){return nc=nc||new Gi({"background-color":new Ri(C.paint_background["background-color"]),"background-pattern":new qi(C.paint_background["background-pattern"]),"background-opacity":new Ri(C.paint_background["background-opacity"])})}};class Wu extends Xi{constructor(t){super(t,lc)}}let uc;var cc,pc={get paint(){return uc=uc||new Gi({"raster-opacity":new Ri(C.paint_raster["raster-opacity"]),"raster-hue-rotate":new Ri(C.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new Ri(C.paint_raster["raster-brightness-min"]),"raster-brightness-max":new Ri(C.paint_raster["raster-brightness-max"]),"raster-saturation":new Ri(C.paint_raster["raster-saturation"]),"raster-contrast":new Ri(C.paint_raster["raster-contrast"]),"raster-resampling":new Ri(C.paint_raster["raster-resampling"]),"raster-fade-duration":new Ri(C.paint_raster["raster-fade-duration"])})}};class ec extends Xi{constructor(t){super(t,pc)}}class rc extends Xi{constructor(t){super(t,{}),this.onAdd=t=>{this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl)},this.onRemove=t=>{this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl)},this.implementation=t}is3D(){return"3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){return!1}serialize(){throw new Error("Custom layers cannot be serialized")}}function fc(t){if("custom"===t.type)return new rc(t);switch(t.type){case"background":return new Wu(t);case"circle":return new Jo(t);case"fill":return new tl(t);case"fill-extrusion":return new Al(t);case"heatmap":return new aa(t);case"hillshade":return new ca(t);case"line":return new Nl(t);case"raster":return new ec(t);case"symbol":return new Yu(t)}}class ic{constructor(t){this.keyCache={},t&&this.replace(t)}replace(t){this._layerConfigs={},this._layers={},this.update(t,[])}update(t,e){for(const e of t){this._layerConfigs[e.id]=e;const t=this._layers[e.id]=fc(e);t._featureFilter=nn(t.filter),this.keyCache[e.id]&&delete this.keyCache[e.id]}for(const t of e)delete this.keyCache[t],delete this._layerConfigs[t],delete this._layers[t];this.familiesBySource={};const r=function(t,e){const r={};for(let n=0;n<t.length;n++){const s=e&&e[t[n].id]||fn(t[n]);e&&(e[t[n].id]=s);let o=r[s];o||(o=r[s]=[]),o.push(t[n])}const n=[];for(const t in r)n.push(r[t]);return n}(Object.values(this._layerConfigs),this.keyCache);for(const t of r){const e=t.map((t=>this._layers[t.id])),r=e[0];if("none"===r.visibility)continue;const n=r.source||"";let s=this.familiesBySource[n];s||(s=this.familiesBySource[n]={});const o=r.sourceLayer||"_geojsonTileLayer";let a=s[o];a||(a=s[o]=[]),a.push(e)}}}class sc{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r}}encode(t){return this._stringToNumber[t]}decode(t){if(t>=this._numberToString.length)throw new Error(`Out of bounds. Index requested n=${t} can't be >= this._numberToString.length ${this._numberToString.length}`);return this._numberToString[t]}}class oc{constructor(t,e,r,n,s){this.type="Feature",this._vectorTileFeature=t,t._z=e,t._x=r,t._y=n,this.properties=t.properties,this.id=s}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._vectorTileFeature._x,this._vectorTileFeature._y,this._vectorTileFeature._z).geometry),this._geometry}set geometry(t){this._geometry=t}toJSON(){const t={geometry:this.geometry};for(const e in this)"_geometry"!==e&&"_vectorTileFeature"!==e&&(t[e]=this[e]);return t}}class ac{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new z(m,16,0),this.grid3D=new z(m,16,0),this.featureIndexArray=new Vs,this.promoteId=e}insert(t,e,r,n,s,o){const a=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,s);const l=o?this.grid3D:this.grid;for(let t=0;t<e.length;t++){const r=e[t],n=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];n[0]=Math.min(n[0],e.x),n[1]=Math.min(n[1],e.y),n[2]=Math.max(n[2],e.x),n[3]=Math.max(n[3],e.y)}n[0]<m&&n[1]<m&&n[2]>=0&&n[3]>=0&&l.insert(a,n[0],n[1],n[2],n[3])}}loadVTLayers(){return this.vtLayers||(this.vtLayers=new Il.VectorTile(new yu(this.rawTileData)).layers,this.sourceLayerCoder=new sc(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"])),this.vtLayers}query(t,e,r,n){this.loadVTLayers();const s=t.params,o=m/t.tileSize/t.scale,a=nn(s.filter),u=t.queryGeometry,c=t.queryPadding*o,h=yc(u),p=this.grid.query(h.minX-c,h.minY-c,h.maxX+c,h.maxY+c),f=yc(t.cameraQueryGeometry),d=this.grid3D.query(f.minX-c,f.minY-c,f.maxX+c,f.maxY+c,((e,r,n,s)=>function(t,e,r,n,s){for(const o of t)if(e<=o.x&&r<=o.y&&n>=o.x&&s>=o.y)return!0;const o=[new l(e,r),new l(e,s),new l(n,s),new l(n,r)];if(t.length>2)for(const e of o)if(Qo(t,e))return!0;for(let e=0;e<t.length-1;e++)if(ta(t[e],t[e+1],o))return!0;return!1}(t.cameraQueryGeometry,e-c,r-c,n+c,s+c)));for(const t of d)p.push(t);p.sort(mc);const y={};let g;for(let l=0;l<p.length;l++){const c=p[l];if(c===g)continue;g=c;const h=this.featureIndexArray.get(c);let f=null;this.loadMatchingFeature(y,h.bucketIndex,h.sourceLayerIndex,h.featureIndex,a,s.layers,s.availableImages,e,r,n,((e,r,n)=>(f||(f=Lo(e)),r.queryIntersectsFeature({queryGeometry:u,feature:e,featureState:n,geometry:f,zoom:this.z,transform:t.transform,pixelsToTileUnits:o,pixelPosMatrix:t.pixelPosMatrix,unwrappedTileID:this.tileID.toUnwrapped(),getElevation:t.getElevation}))))}return y}loadMatchingFeature(t,e,r,n,s,o,a,l,u,c,h){const p=this.bucketLayerIDs[e];if(o&&!p.some((t=>o.has(t))))return;const f=this.sourceLayerCoder.decode(r),d=this.vtLayers[f].feature(n);if(s.needGeometry){const t=Ro(d,!0);if(!s.filter(new Bi(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!s.filter(new Bi(this.tileID.overscaledZ),d))return;const y=this.getId(d,f);for(let e=0;e<p.length;e++){const r=p[e];if(o&&!o.has(r))continue;const s=l[r];if(!s)continue;let f={};y&&c&&(f=c.getState(s.sourceLayer||"_geojsonTileLayer",y));const m=x({},u[r]);m.paint=dc(m.paint,s.paint,d,f,a),m.layout=dc(m.layout,s.layout,d,f,a);const g=!h||h(d,s,f);if(!g)continue;const v=new oc(d,this.z,this.x,this.y,y);v.layer=m;let b=t[r];void 0===b&&(b=t[r]=[]),b.push({featureIndex:n,feature:v,intersectionZ:g})}}lookupSymbolFeatures(t,e,r,n,s,o,a,l){const u={};this.loadVTLayers();const c=nn(s);for(const s of t)this.loadMatchingFeature(u,r,n,s,c,o,a,l,e);return u}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return!0;return!1}getId(t,e){var r;let n=t.id;return this.promoteId&&(n=t.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[e]],"boolean"==typeof n&&(n=Number(n)),void 0===n&&(null===(r=t.properties)||void 0===r?void 0:r.cluster)&&this.promoteId&&(n=Number(t.properties.cluster_id))),n}}function dc(t,e,r,n,s){return v(t,((t,o)=>{const a=e instanceof Oi?e.get(o):null;return a&&a.evaluate?a.evaluate(r,n,s):a}))}function yc(t){let e=1/0,r=1/0,n=-1/0,s=-1/0;for(const o of t)e=Math.min(e,o.x),r=Math.min(r,o.y),n=Math.max(n,o.x),s=Math.max(s,o.y);return{minX:e,minY:r,maxX:n,maxY:s}}function mc(t,e){return e-t}Qn("FeatureIndex",ac,{omit:["rawTileData","sourceLayerCoder"]});class hc extends l{constructor(t,e,r,n){super(t,e),this.angle=r,void 0!==n&&(this.segment=n)}clone(){return new hc(this.x,this.y,this.angle,this.segment)}}function gc(t,e,r,n,s){if(void 0===e.segment||0===r)return!0;let o=e,a=e.segment+1,l=0;for(;l>-r/2;){if(a--,a<0)return!1;l-=t[a].dist(o),o=t[a]}l+=t[a].dist(t[a+1]),a++;const u=[];let c=0;for(;l<r/2;){const e=t[a],r=t[a+1];if(!r)return!1;let o=t[a-1].angleTo(e)-e.angleTo(r);for(o=Math.abs((o+3*Math.PI)%(2*Math.PI)-Math.PI),u.push({distance:l,angleDelta:o}),c+=o;l-u[0].distance>n;)c-=u.shift().angleDelta;if(c>s)return!1;a++,l+=e.dist(r)}return!0}function xc(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function vc(t,e,r){return t?.6*e*r:0}function bc(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function wc(t,e,r,n,s,o){const a=vc(r,s,o),l=bc(r,n)*o;let u=0;const c=xc(t)/2;for(let r=0;r<t.length-1;r++){const n=t[r],s=t[r+1],o=n.dist(s);if(u+o>c){const h=(c-u)/o,p=ue.number(n.x,s.x,h),f=ue.number(n.y,s.y,h),d=new hc(p,f,s.angleTo(n),r);return d._round(),!a||gc(t,d,l,a,e)?d:void 0}u+=o}}function _c(t,e,r,n,s,o,a,l,u){const c=vc(n,o,a),h=bc(n,s),p=h*a,f=0===t[0].x||t[0].x===u||0===t[0].y||t[0].y===u;return e-p<e/4&&(e=p+e/4),Sc(t,f?e/2*l%e:(h/2+2*o)*a*l%e,e,c,r,p,f,!1,u)}function Sc(t,e,r,n,s,o,a,l,u){const c=o/2,h=xc(t);let p=0,f=e-r,d=[];for(let e=0;e<t.length-1;e++){const a=t[e],l=t[e+1],y=a.dist(l),m=l.angleTo(a);for(;f+r<p+y;){f+=r;const g=(f-p)/y,x=ue.number(a.x,l.x,g),v=ue.number(a.y,l.y,g);if(x>=0&&x<u&&v>=0&&v<u&&f-c>=0&&f+c<=h){const r=new hc(x,v,m,e);r._round(),n&&!gc(t,r,o,n,s)||d.push(r)}}p+=y}return l||d.length||a||(d=Sc(t,p/2,r,n,s,o,a,!0,u)),d}function kc(t,e,r,n){const s=[],o=t.image,a=o.pixelRatio,u=o.paddedRect.w-2,c=o.paddedRect.h-2;let h={x1:t.left,y1:t.top,x2:t.right,y2:t.bottom};const p=o.stretchX||[[0,u]],f=o.stretchY||[[0,c]],d=(t,e)=>t+e[1]-e[0],y=p.reduce(d,0),m=f.reduce(d,0),g=u-y,x=c-m;let v=0,b=y,w=0,_=m,S=0,k=g,A=0,I=x;if(o.content&&n){const e=o.content,r=e[2]-e[0],n=e[3]-e[1];(o.textFitWidth||o.textFitHeight)&&(h=Fu(t)),v=Mc(p,0,e[0]),w=Mc(f,0,e[1]),b=Mc(p,e[0],e[2]),_=Mc(f,e[1],e[3]),S=e[0]-v,A=e[1]-w,k=r-b,I=n-_}const M=h.x1,P=h.y1,C=h.x2-M,T=h.y2-P,F=(t,n,s,u)=>{const c=Bc(t.stretch-v,b,C,M),h=Pc(t.fixed-S,k,t.stretch,y),p=Bc(n.stretch-w,_,T,P),f=Pc(n.fixed-A,I,n.stretch,m),d=Bc(s.stretch-v,b,C,M),g=Pc(s.fixed-S,k,s.stretch,y),x=Bc(u.stretch-w,_,T,P),F=Pc(u.fixed-A,I,u.stretch,m),D=new l(c,p),$=new l(d,p),L=new l(d,x),R=new l(c,x),O=new l(h/a,f/a),N=new l(g/a,F/a),j=e*Math.PI/180;if(j){const t=Math.sin(j),e=Math.cos(j),r=[e,-t,t,e];D._matMult(r),$._matMult(r),R._matMult(r),L._matMult(r)}const U=t.stretch+t.fixed,q=n.stretch+n.fixed;return{tl:D,tr:$,bl:R,br:L,tex:{x:o.paddedRect.x+1+U,y:o.paddedRect.y+1+q,w:s.stretch+s.fixed-U,h:u.stretch+u.fixed-q},writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:O,pixelOffsetBR:N,minFontScaleX:k/a/C,minFontScaleY:I/a/T,isSDF:r}};if(n&&(o.stretchX||o.stretchY)){const t=zc(p,g,y),e=zc(f,x,m);for(let r=0;r<t.length-1;r++){const n=t[r],o=t[r+1];for(let t=0;t<e.length-1;t++)s.push(F(n,e[t],o,e[t+1]))}}else s.push(F({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:u+1},{fixed:0,stretch:c+1}));return s}function Mc(t,e,r){let n=0;for(const s of t)n+=Math.max(e,Math.min(r,s[1]))-Math.max(e,Math.min(r,s[0]));return n}function zc(t,e,r){const n=[{fixed:-1,stretch:0}];for(const[e,r]of t){const t=n[n.length-1];n.push({fixed:e-t.stretch,stretch:t.stretch}),n.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)})}return n.push({fixed:e+1,stretch:r}),n}function Bc(t,e,r,n){return t/e*r+n}function Pc(t,e,r,n){return t-e*r/n}Qn("Anchor",hc);class Ac{constructor(t,e,r,n,s,o,a,u,c,h){var p;if(this.boxStartIndex=t.length,c){let t=o.top,e=o.bottom;const r=o.collisionPadding;r&&(t-=r[1],e+=r[3]);let n=e-t;n>0&&(n=Math.max(10,n),this.circleDiameter=n)}else{const c=(null===(p=o.image)||void 0===p?void 0:p.content)&&(o.image.textFitWidth||o.image.textFitHeight)?Fu(o):{x1:o.left,y1:o.top,x2:o.right,y2:o.bottom};c.y1=c.y1*a-u[0],c.y2=c.y2*a+u[2],c.x1=c.x1*a-u[3],c.x2=c.x2*a+u[1];const f=o.collisionPadding;if(f&&(c.x1-=f[0]*a,c.y1-=f[1]*a,c.x2+=f[2]*a,c.y2+=f[3]*a),h){const t=new l(c.x1,c.y1),e=new l(c.x2,c.y1),r=new l(c.x1,c.y2),n=new l(c.x2,c.y2),s=h*Math.PI/180;t._rotate(s),e._rotate(s),r._rotate(s),n._rotate(s),c.x1=Math.min(t.x,e.x,r.x,n.x),c.x2=Math.max(t.x,e.x,r.x,n.x),c.y1=Math.min(t.y,e.y,r.y,n.y),c.y2=Math.max(t.y,e.y,r.y,n.y)}t.emplaceBack(e.x,e.y,c.x1,c.y1,c.x2,c.y2,r,n,s)}this.boxEndIndex=t.length}}class Ic{constructor(t=[],e=(t,e)=>t<e?-1:t>e?1:0){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t)}push(t){this.data.push(t),this._up(this.length++)}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return--this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const s=t-1>>1,o=e[s];if(r(n,o)>=0)break;e[t]=o,t=s}e[t]=n}_down(t){const{data:e,compare:r}=this,n=this.length>>1,s=e[t];for(;t<n;){let n=1+(t<<1);const o=n+1;if(o<this.length&&r(e[o],e[n])<0&&(n=o),r(e[n],s)>=0)break;e[t]=e[n],t=n}e[t]=s}}function Cc(t,e=1,r=!1){let n=1/0,s=1/0,o=-1/0,a=-1/0;const u=t[0];for(let t=0;t<u.length;t++){const e=u[t];(!t||e.x<n)&&(n=e.x),(!t||e.y<s)&&(s=e.y),(!t||e.x>o)&&(o=e.x),(!t||e.y>a)&&(a=e.y)}const c=Math.min(o-n,a-s);let h=c/2;const p=new Ic([],Tc);if(0===c)return new l(n,s);for(let e=n;e<o;e+=c)for(let r=s;r<a;r+=c)p.push(new Vc(e+h,r+h,h,t));let f=function(t){let e=0,r=0,n=0;const s=t[0];for(let t=0,o=s.length,a=o-1;t<o;a=t++){const o=s[t],l=s[a],u=o.x*l.y-l.x*o.y;r+=(o.x+l.x)*u,n+=(o.y+l.y)*u,e+=3*u}return new Vc(r/e,n/e,0,t)}(t),d=p.length;for(;p.length;){const n=p.pop();(n.d>f.d||!f.d)&&(f=n,r&&console.log("found best %d after %d probes",Math.round(1e4*n.d)/1e4,d)),n.max-f.d<=e||(h=n.h/2,p.push(new Vc(n.p.x-h,n.p.y-h,h,t)),p.push(new Vc(n.p.x+h,n.p.y-h,h,t)),p.push(new Vc(n.p.x-h,n.p.y+h,h,t)),p.push(new Vc(n.p.x+h,n.p.y+h,h,t)),d+=4)}return r&&(console.log(`num probes: ${d}`),console.log(`best distance: ${f.d}`)),f.p}function Tc(t,e){return e.max-t.max}function Vc(t,e,r,n){this.p=new l(t,e),this.h=r,this.d=function(t,e){let r=!1,n=1/0;for(let s=0;s<e.length;s++){const o=e[s];for(let e=0,s=o.length,a=s-1;e<s;a=e++){const s=o[e],l=o[a];s.y>t.y!=l.y>t.y&&t.x<(l.x-s.x)*(t.y-s.y)/(l.y-s.y)+s.x&&(r=!r),n=Math.min(n,Ho(t,s,l))}}return(r?1:-1)*Math.sqrt(n)}(this.p,n),this.max=this.d+this.h*Math.SQRT2}!function(t){t[t.center=1]="center",t[t.left=2]="left",t[t.right=3]="right",t[t.top=4]="top",t[t.bottom=5]="bottom",t[t["top-left"]=6]="top-left",t[t["top-right"]=7]="top-right",t[t["bottom-left"]=8]="bottom-left",t[t["bottom-right"]=9]="bottom-right"}(cc||(cc={}));const Ec=Number.POSITIVE_INFINITY;function Fc(t,e){return e[1]!==Ec?function(t,e,r){let n=0,s=0;switch(e=Math.abs(e),r=Math.abs(r),t){case"top-right":case"top-left":case"top":s=r-7;break;case"bottom-right":case"bottom-left":case"bottom":s=7-r}switch(t){case"top-right":case"bottom-right":case"right":n=-e;break;case"top-left":case"bottom-left":case"left":n=e}return[n,s]}(t,e[0],e[1]):function(t,e){let r=0,n=0;e<0&&(e=0);const s=e/Math.SQRT2;switch(t){case"top-right":case"top-left":n=s-7;break;case"bottom-right":case"bottom-left":n=7-s;break;case"bottom":n=7-e;break;case"top":n=e-7}switch(t){case"top-right":case"bottom-right":r=-s;break;case"top-left":case"bottom-left":r=s;break;case"left":r=e;break;case"right":r=-e}return[r,n]}(t,e[0])}function Dc(t,e,r){var n;const s=t.layout,o=null===(n=s.get("text-variable-anchor-offset"))||void 0===n?void 0:n.evaluate(e,{},r);if(o){const t=o.values,e=[];for(let r=0;r<t.length;r+=2){const n=e[r]=t[r],s=t[r+1].map((t=>t*uu));n.startsWith("top")?s[1]-=7:n.startsWith("bottom")&&(s[1]+=7),e[r+1]=s}return new Bt(e)}const a=s.get("text-variable-anchor");if(a){let n;n=void 0!==t._unevaluatedLayout.getValue("text-radial-offset")?[s.get("text-radial-offset").evaluate(e,{},r)*uu,Ec]:s.get("text-offset").evaluate(e,{},r).map((t=>t*uu));const o=[];for(const t of a)o.push(t,Fc(t,n));return new Bt(o)}return null}function $c(t){t.bucket.createArrays(),t.bucket.tilePixelRatio=m/(512*t.bucket.overscaling),t.bucket.compareText={},t.bucket.iconsNeedLinear=!1;const e=t.bucket.layers[0],r=e.layout,n=e._unevaluatedLayout._values,s={layoutIconSize:n["icon-size"].possiblyEvaluate(new Bi(t.bucket.zoom+1),t.canonical),layoutTextSize:n["text-size"].possiblyEvaluate(new Bi(t.bucket.zoom+1),t.canonical),textMaxSize:n["text-size"].possiblyEvaluate(new Bi(18))};if("composite"===t.bucket.textSizeData.kind){const{minZoom:e,maxZoom:r}=t.bucket.textSizeData;s.compositeTextSizes=[n["text-size"].possiblyEvaluate(new Bi(e),t.canonical),n["text-size"].possiblyEvaluate(new Bi(r),t.canonical)]}if("composite"===t.bucket.iconSizeData.kind){const{minZoom:e,maxZoom:r}=t.bucket.iconSizeData;s.compositeIconSizes=[n["icon-size"].possiblyEvaluate(new Bi(e),t.canonical),n["icon-size"].possiblyEvaluate(new Bi(r),t.canonical)]}const o=r.get("text-line-height")*uu,a="viewport"!==r.get("text-rotation-alignment")&&"point"!==r.get("symbol-placement"),l=r.get("text-keep-upright"),u=r.get("text-size");for(const n of t.bucket.features){const c=r.get("text-font").evaluate(n,{},t.canonical).join(","),h=u.evaluate(n,{},t.canonical),p=s.layoutTextSize.evaluate(n,{},t.canonical),f=s.layoutIconSize.evaluate(n,{},t.canonical),d={horizontal:{},vertical:void 0},y=n.text;let m,g=[0,0];if(y){const s=y.toString(),u=r.get("text-letter-spacing").evaluate(n,{},t.canonical)*uu,f=zi(s)?u:0,m=r.get("text-anchor").evaluate(n,{},t.canonical),x=Dc(e,n,t.canonical);if(!x){const e=r.get("text-radial-offset").evaluate(n,{},t.canonical);g=e?Fc(m,[e*uu,Ec]):r.get("text-offset").evaluate(n,{},t.canonical).map((t=>t*uu))}let v=a?"center":r.get("text-justify").evaluate(n,{},t.canonical);const b="point"===r.get("symbol-placement")?r.get("text-max-width").evaluate(n,{},t.canonical)*uu:1/0,w=()=>{t.bucket.allowVerticalPlacement&&Mi(s)&&(d.vertical=gu(y,t.glyphMap,t.glyphPositions,t.imagePositions,c,b,o,m,"left",f,g,du.vertical,!0,p,h))};if(!a&&x){const e=new Set;if("auto"===v)for(let t=0;t<x.values.length;t+=2)e.add(Lc(x.values[t]));else e.add(v);let r=!1;for(const n of e)if(!d.horizontal[n])if(r)d.horizontal[n]=d.horizontal[0];else{const e=gu(y,t.glyphMap,t.glyphPositions,t.imagePositions,c,b,o,"center",n,f,g,du.horizontal,!1,p,h);e&&(d.horizontal[n]=e,r=1===e.positionedLines.length)}w()}else{"auto"===v&&(v=Lc(m));const e=gu(y,t.glyphMap,t.glyphPositions,t.imagePositions,c,b,o,m,v,f,g,du.horizontal,!1,p,h);e&&(d.horizontal[v]=e),w(),Mi(s)&&a&&l&&(d.vertical=gu(y,t.glyphMap,t.glyphPositions,t.imagePositions,c,b,o,m,v,f,g,du.vertical,!1,p,h))}}let x=!1;if(n.icon&&n.icon.name){const e=t.imageMap[n.icon.name];e&&(m=Eu(t.imagePositions[n.icon.name],r.get("icon-offset").evaluate(n,{},t.canonical),r.get("icon-anchor").evaluate(n,{},t.canonical)),x=!!e.sdf,void 0===t.bucket.sdfIcons?t.bucket.sdfIcons=x:t.bucket.sdfIcons!==x&&_("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(e.pixelRatio!==t.bucket.pixelRatio||0!==r.get("icon-rotate").constantOr(1))&&(t.bucket.iconsNeedLinear=!0))}const v=jc(d.horizontal)||d.vertical;t.bucket.iconsInText=!!v&&v.iconsInText,(v||m)&&Rc(t.bucket,n,d,m,t.imageMap,s,p,f,g,x,t.canonical,t.subdivisionGranularity)}t.showCollisionBoxes&&t.bucket.generateCollisionDebugBuffers()}function Lc(t){switch(t){case"right":case"top-right":case"bottom-right":return"right";case"left":case"top-left":case"bottom-left":return"left"}return"center"}function Rc(t,e,r,n,s,o,a,u,c,h,p,f){let d=o.textMaxSize.evaluate(e,{});void 0===d&&(d=a);const y=t.layers[0].layout,g=y.get("icon-offset").evaluate(e,{},p),x=jc(r.horizontal),v=a/24,b=t.tilePixelRatio*v,w=t.tilePixelRatio*d/24,S=t.tilePixelRatio*u,k=t.tilePixelRatio*y.get("symbol-spacing"),A=y.get("text-padding")*t.tilePixelRatio,I=function(t,e,r,n=1){const s=t.get("icon-padding").evaluate(e,{},r),o=s&&s.values;return[o[0]*n,o[1]*n,o[2]*n,o[3]*n]}(y,e,p,t.tilePixelRatio),M=y.get("text-max-angle")/180*Math.PI,P="viewport"!==y.get("text-rotation-alignment")&&"point"!==y.get("symbol-placement"),C="map"===y.get("icon-rotation-alignment")&&"point"!==y.get("symbol-placement"),T=y.get("symbol-placement"),F=k/2,D=y.get("icon-text-fit");let $;n&&"none"!==D&&(t.allowVerticalPlacement&&r.vertical&&($=Du(n,r.vertical,D,y.get("icon-text-fit-padding"),g,v)),x&&(n=Du(n,x,D,y.get("icon-text-fit-padding"),g,v)));const L=p?f.line.getGranularityForZoomLevel(p.z):1,R=(l,u)=>{u.x<0||u.x>=m||u.y<0||u.y>=m||function(t,e,r,n,s,o,a,l,u,c,h,p,f,d,y,m,g,x,v,b,w,S,k,A,I){const M=t.addToLineVertexArray(e,r);let P,C,T,F,D=0,$=0,L=0,R=0,O=-1,N=-1;const j={};let U=zo("");if(t.allowVerticalPlacement&&n.vertical){const t=l.layout.get("text-rotate").evaluate(w,{},A)+90;T=new Ac(u,e,c,h,p,n.vertical,f,d,y,t),a&&(F=new Ac(u,e,c,h,p,a,g,x,y,t))}if(s){const r=l.layout.get("icon-rotate").evaluate(w,{}),n="none"!==l.layout.get("icon-text-fit"),o=kc(s,r,k,n),f=a?kc(a,r,k,n):void 0;C=new Ac(u,e,c,h,p,s,g,x,!1,r),D=4*o.length;const d=t.iconSizeData;let y=null;"source"===d.kind?(y=[$u*l.layout.get("icon-size").evaluate(w,{})],y[0]>Lu&&_(`${t.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)):"composite"===d.kind&&(y=[$u*S.compositeIconSizes[0].evaluate(w,{},A),$u*S.compositeIconSizes[1].evaluate(w,{},A)],(y[0]>Lu||y[1]>Lu)&&_(`${t.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)),t.addSymbols(t.icon,o,y,b,v,w,du.none,e,M.lineStartIndex,M.lineLength,-1,A),O=t.icon.placedSymbolArray.length-1,f&&($=4*f.length,t.addSymbols(t.icon,f,y,b,v,w,du.vertical,e,M.lineStartIndex,M.lineLength,-1,A),N=t.icon.placedSymbolArray.length-1)}const q=Object.keys(n.horizontal);for(const r of q){const s=n.horizontal[r];if(!P){U=zo(s.text);const t=l.layout.get("text-rotate").evaluate(w,{},A);P=new Ac(u,e,c,h,p,s,f,d,y,t)}const a=1===s.positionedLines.length;if(L+=Oc(t,e,s,o,l,y,w,m,M,n.vertical?du.horizontal:du.horizontalOnly,a?q:[r],j,O,S,A),a)break}n.vertical&&(R+=Oc(t,e,n.vertical,o,l,y,w,m,M,du.vertical,["vertical"],j,N,S,A));const G=P?P.boxStartIndex:t.collisionBoxArray.length,Z=P?P.boxEndIndex:t.collisionBoxArray.length,J=T?T.boxStartIndex:t.collisionBoxArray.length,X=T?T.boxEndIndex:t.collisionBoxArray.length,Y=C?C.boxStartIndex:t.collisionBoxArray.length,H=C?C.boxEndIndex:t.collisionBoxArray.length,K=F?F.boxStartIndex:t.collisionBoxArray.length,W=F?F.boxEndIndex:t.collisionBoxArray.length;let Q=-1;const tt=(t,e)=>t&&t.circleDiameter?Math.max(t.circleDiameter,e):e;Q=tt(P,Q),Q=tt(T,Q),Q=tt(C,Q),Q=tt(F,Q);const et=Q>-1?1:0;et&&(Q*=I/uu),t.glyphOffsetArray.length>=Uu.MAX_GLYPHS&&_("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==w.sortKey&&t.addToSortKeyRanges(t.symbolInstances.length,w.sortKey);const rt=Dc(l,w,A),[nt,it]=function(t,e){const r=t.length,n=null==e?void 0:e.values;if((null==n?void 0:n.length)>0)for(let e=0;e<n.length;e+=2){const r=n[e+1];t.emplaceBack(cc[n[e]],r[0],r[1])}return[r,t.length]}(t.textAnchorOffsets,rt);t.symbolInstances.emplaceBack(e.x,e.y,j.right>=0?j.right:-1,j.center>=0?j.center:-1,j.left>=0?j.left:-1,j.vertical||-1,O,N,U,G,Z,J,X,Y,H,K,W,c,L,R,D,$,et,0,f,Q,nt,it)}(t,u,l,r,n,s,$,t.layers[0],t.collisionBoxArray,e.index,e.sourceLayerIndex,t.index,b,[A,A,A,A],P,c,S,I,C,g,e,o,h,p,a)};if("line"===T)for(const s of function(t,e,r,n,s){const o=[];for(let e=0;e<t.length;e++){const r=t[e];let a;for(let t=0;t<r.length-1;t++){let e=r[t],u=r[t+1];e.x<0&&u.x<0||(e.x<0?e=new l(0,e.y+(0-e.x)/(u.x-e.x)*(u.y-e.y))._round():u.x<0&&(u=new l(0,e.y+(0-e.x)/(u.x-e.x)*(u.y-e.y))._round()),e.y<0&&u.y<0||(e.y<0?e=new l(e.x+(0-e.y)/(u.y-e.y)*(u.x-e.x),0)._round():u.y<0&&(u=new l(e.x+(0-e.y)/(u.y-e.y)*(u.x-e.x),0)._round()),e.x>=n&&u.x>=n||(e.x>=n?e=new l(n,e.y+(n-e.x)/(u.x-e.x)*(u.y-e.y))._round():u.x>=n&&(u=new l(n,e.y+(n-e.x)/(u.x-e.x)*(u.y-e.y))._round()),e.y>=s&&u.y>=s||(e.y>=s?e=new l(e.x+(s-e.y)/(u.y-e.y)*(u.x-e.x),s)._round():u.y>=s&&(u=new l(e.x+(s-e.y)/(u.y-e.y)*(u.x-e.x),s)._round()),a&&e.equals(a[a.length-1])||(a=[e],o.push(a)),a.push(u)))))}}return o}(e.geometry,0,0,m,m)){const e=nl(s,L),o=_c(e,k,M,r.vertical||x,n,24,w,t.overscaling,m);for(const r of o)x&&qc(t,x.text,F,r)||R(e,r)}else if("line-center"===T){for(const t of e.geometry)if(t.length>1){const e=nl(t,L),s=wc(e,M,r.vertical||x,n,24,w);s&&R(e,s)}}else if("Polygon"===e.type)for(const t of Xe(e.geometry,0)){const e=Cc(t,16);R(nl(t[0],L,!0),new hc(e.x,e.y,0))}else if("LineString"===e.type)for(const t of e.geometry){const e=nl(t,L);R(e,new hc(e[0].x,e[0].y,0))}else if("Point"===e.type)for(const t of e.geometry)for(const e of t)R([e],new hc(e.x,e.y,0))}function Oc(t,e,r,n,s,o,a,u,c,h,p,f,d,y,m){const g=function(t,e,r,n,s,o,a,u){const c=n.layout.get("text-rotate").evaluate(o,{})*Math.PI/180,h=[];for(const t of e.positionedLines)for(const n of t.positionedGlyphs){if(!n.rect)continue;const o=n.rect||{};let p=4,f=!0,d=1,y=0;const m=(s||u)&&n.vertical,g=n.metrics.advance*n.scale/2;if(u&&e.verticalizable&&(y=t.lineOffset/2-(n.imageName?-(uu-n.metrics.width*n.scale)/2:(n.scale-1)*uu)),n.imageName){const t=a[n.imageName];f=t.sdf,d=t.pixelRatio,p=1/d}const x=s?[n.x+g,n.y]:[0,0];let v=s?[0,0]:[n.x+g+r[0],n.y+r[1]-y],b=[0,0];m&&(b=v,v=[0,0]);const w=n.metrics.isDoubleResolution?2:1,_=(n.metrics.left-p)*n.scale-g+v[0],S=(-n.metrics.top-p)*n.scale+v[1],k=_+o.w/w*n.scale/d,A=S+o.h/w*n.scale/d,I=new l(_,S),M=new l(k,S),P=new l(_,A),C=new l(k,A);if(m){const t=new l(-g,g- -17),e=-Math.PI/2,r=12-g,s=new l(22-r,-(n.imageName?r:0)),o=new l(...b);I._rotateAround(e,t)._add(s)._add(o),M._rotateAround(e,t)._add(s)._add(o),P._rotateAround(e,t)._add(s)._add(o),C._rotateAround(e,t)._add(s)._add(o)}if(c){const t=Math.sin(c),e=Math.cos(c),r=[e,-t,t,e];I._matMult(r),M._matMult(r),P._matMult(r),C._matMult(r)}const T=new l(0,0),F=new l(0,0);h.push({tl:I,tr:M,bl:P,br:C,tex:o,writingMode:e.writingMode,glyphOffset:x,sectionIndex:n.sectionIndex,isSDF:f,pixelOffsetTL:T,pixelOffsetBR:F,minFontScaleX:0,minFontScaleY:0})}return h}(0,r,u,s,o,a,n,t.allowVerticalPlacement),x=t.textSizeData;let v=null;"source"===x.kind?(v=[$u*s.layout.get("text-size").evaluate(a,{})],v[0]>Lu&&_(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)):"composite"===x.kind&&(v=[$u*y.compositeTextSizes[0].evaluate(a,{},m),$u*y.compositeTextSizes[1].evaluate(a,{},m)],(v[0]>Lu||v[1]>Lu)&&_(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)),t.addSymbols(t.text,g,v,u,o,a,h,e,c.lineStartIndex,c.lineLength,d,m);for(const e of p)f[e]=t.text.placedSymbolArray.length-1;return 4*g.length}function jc(t){for(const e in t)return t[e];return null}function qc(t,e,r,n){const s=t.compareText;if(e in s){const t=s[e];for(let e=t.length-1;e>=0;e--)if(n.dist(t[e])<r)return!0}else s[e]=[];return s[e].push(n),!1}class Nc{constructor(t){const e={},r=[];for(const n in t){const s=t[n],o=e[n]={};for(const t in s){const e=s[+t];if(!e||0===e.bitmap.width||0===e.bitmap.height)continue;const n={x:0,y:0,w:e.bitmap.width+2,h:e.bitmap.height+2};r.push(n),o[t]={rect:n,metrics:e.metrics}}}const{w:n,h:s}=mu(r),o=new ia({width:n||1,height:s||1});for(const r in t){const n=t[r];for(const t in n){const s=n[+t];if(!s||0===s.bitmap.width||0===s.bitmap.height)continue;const a=e[r][t].rect;ia.copy(s.bitmap,o,{x:0,y:0},{x:a.x+1,y:a.y+1},s.bitmap)}}this.image=o,this.positions=e}}function Gc(t,e,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return[t*n-2*Math.PI*6378137/2,e*n-2*Math.PI*6378137/2]}Qn("GlyphAtlas",Nc);const Zc=6371008.8;class Uc{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new Uc(function(t,e){const r=((t-e)%360+360)%360+e;return r===e?180:r}(this.lng,-180),this.lat)}toArray(){return[this.lng,this.lat]}toString(){return`LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,n=t.lat*e,s=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((t.lng-this.lng)*e);return Zc*Math.acos(Math.min(s,1))}static convert(t){if(t instanceof Uc)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new Uc(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new Uc(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}const Xc=2*Math.PI*Zc;function Wc(t){return Xc*Math.cos(t*Math.PI/180)}function th(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}class Hc{constructor(t,e,r=0){this.x=+t,this.y=+e,this.z=+r}static fromLngLat(t,e=0){const r=Uc.convert(t);return new Hc((180+r.lng)/360,(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+r.lat*Math.PI/360)))/360,function(t,e){return t/Wc(e)}(e,r.lat))}toLngLat(){return new Uc(360*this.x-180,th(this.y))}toAltitude(){return this.z*Wc(th(this.y))}meterInMercatorCoordinateUnits(){return 1/Xc*(t=th(this.y),1/Math.cos(t*Math.PI/180));var t}}class Yc{constructor(t,e,r){if(!function(t,e,r){return!(t<0||t>25||r<0||r>=Math.pow(2,t)||e<0||e>=Math.pow(2,t))}(t,e,r))throw new Error(`x=${e}, y=${r}, z=${t} outside of bounds. 0<=x<${Math.pow(2,t)}, 0<=y<${Math.pow(2,t)} 0<=z<=25 `);this.z=t,this.x=e,this.y=r,this.key=eh(0,t,t,e,r)}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e,r){const n=(o=this.y,a=this.z,l=Gc(256*(s=this.x),256*(o=Math.pow(2,a)-o-1),a),u=Gc(256*(s+1),256*(o+1),a),l[0]+","+l[1]+","+u[0]+","+u[1]);var s,o,a,l,u;const c=function(t,e,r){let n,s="";for(let o=t;o>0;o--)n=1<<o-1,s+=(e&n?1:0)+(r&n?2:0);return s}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace(/{prefix}/g,(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===r?Math.pow(2,this.z)-this.y-1:this.y)).replace(/{ratio}/g,e>1?"@2x":"").replace(/{quadkey}/g,c).replace(/{bbox-epsg-3857}/g,n)}isChildOf(t){const e=this.z-t.z;return e>0&&t.x===this.x>>e&&t.y===this.y>>e}getTilePoint(t){const e=Math.pow(2,this.z);return new l((t.x*e-this.x)*m,(t.y*e-this.y)*m)}toString(){return`${this.z}/${this.x}/${this.y}`}}class Jc{constructor(t,e){this.wrap=t,this.canonical=e,this.key=eh(t,e.z,e.z,e.x,e.y)}}class Kc{constructor(t,e,r,n,s){if(this.terrainRttPosMatrix32f=null,t<r)throw new Error(`overscaledZ should be >= z; overscaledZ = ${t}; z = ${r}`);this.overscaledZ=t,this.wrap=e,this.canonical=new Yc(r,+n,+s),this.key=eh(e,t,r,n,s)}clone(){return new Kc(this.overscaledZ,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const e=this.canonical.z-t;return t>this.canonical.z?new Kc(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new Kc(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const r=this.canonical.z-t;return t>this.canonical.z?eh(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y):eh(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}isChildOf(t){if(t.wrap!==this.wrap)return!1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return[new Kc(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return[new Kc(e,this.wrap,e,r,n),new Kc(e,this.wrap,e,r+1,n),new Kc(e,this.wrap,e,r,n+1),new Kc(e,this.wrap,e,r+1,n+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new Kc(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new Kc(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new Jc(this.wrap,this.canonical)}toString(){return`${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(t){return this.canonical.getTilePoint(new Hc(t.x-this.wrap,t.y))}}function eh(t,e,r,n,s){(t*=2)<0&&(t=-1*t-1);const o=1<<r;return(o*o*t+o*s+n).toString(36)+r.toString(36)+e.toString(36)}Qn("CanonicalTileID",Yc),Qn("OverscaledTileID",Kc,{omit:["terrainRttPosMatrix32f"]});class Qc{constructor(t){this.tileID=new Kc(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.uid=t.uid,this.zoom=t.zoom,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.collectResourceTiming,this.returnDependencies=!!t.returnDependencies,this.promoteId=t.promoteId,this.inFlightDependencies=[]}parse(e,r,n,s,o){return t(this,void 0,void 0,(function*(){this.status="parsing",this.data=e,this.collisionBoxArray=new Ss;const t=new sc(Object.keys(e.layers).sort()),a=new ac(this.tileID,this.promoteId);a.bucketLayerIDs=[];const l={},u={featureIndex:a,iconDependencies:{},patternDependencies:{},glyphDependencies:{},availableImages:n,subdivisionGranularity:o},c=r.familiesBySource[this.source];for(const r in c){const s=e.layers[r];if(!s)continue;1===s.version&&_(`Vector tile source "${this.source}" layer "${r}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const o=t.encode(r),h=[];for(let t=0;t<s.length;t++){const e=s.feature(t),n=a.getId(e,r);h.push({feature:e,id:n,index:t,sourceLayerIndex:o})}for(const t of c[r]){const e=t[0];e.source!==this.source&&_(`layer.source = ${e.source} does not equal this.source = ${this.source}`),e.minzoom&&this.zoom<Math.floor(e.minzoom)||e.maxzoom&&this.zoom>=e.maxzoom||"none"!==e.visibility&&(rh(t,this.zoom,n),(l[e.id]=e.createBucket({index:a.bucketLayerIDs.length,layers:t,zoom:this.zoom,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:o,sourceID:this.source})).populate(h,u,this.tileID.canonical),a.bucketLayerIDs.push(t.map((t=>t.id))))}}const h=v(u.glyphDependencies,(t=>Object.keys(t).map(Number)));this.inFlightDependencies.forEach((t=>null==t?void 0:t.abort())),this.inFlightDependencies=[];let p=Promise.resolve({});if(Object.keys(h).length){const t=new AbortController;this.inFlightDependencies.push(t),p=s.sendAsync({type:"GG",data:{stacks:h,source:this.source,tileID:this.tileID,type:"glyphs"}},t)}const f=Object.keys(u.iconDependencies);let d=Promise.resolve({});if(f.length){const t=new AbortController;this.inFlightDependencies.push(t),d=s.sendAsync({type:"GI",data:{icons:f,source:this.source,tileID:this.tileID,type:"icons"}},t)}const y=Object.keys(u.patternDependencies);let m=Promise.resolve({});if(y.length){const t=new AbortController;this.inFlightDependencies.push(t),m=s.sendAsync({type:"GI",data:{icons:y,source:this.source,tileID:this.tileID,type:"patterns"}},t)}const[g,x,b]=yield Promise.all([p,d,m]),w=new Nc(g),S=new au(x,b);for(const t in l){const e=l[t];e instanceof Uu?(rh(e.layers,this.zoom,n),$c({bucket:e,glyphMap:g,glyphPositions:w.positions,imageMap:x,imagePositions:S.iconPositions,showCollisionBoxes:this.showCollisionBoxes,canonical:this.tileID.canonical,subdivisionGranularity:u.subdivisionGranularity})):e.hasPattern&&(e instanceof Fl||e instanceof Ja||e instanceof vl)&&(rh(e.layers,this.zoom,n),e.addFeatures(u,this.tileID.canonical,S.patternPositions))}return this.status="done",{buckets:Object.values(l).filter((t=>!t.isEmpty())),featureIndex:a,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:w.image,imageAtlas:S,glyphMap:this.returnDependencies?g:null,iconMap:this.returnDependencies?x:null,glyphPositions:this.returnDependencies?w.positions:null}}))}}function rh(t,e,r){const n=new Bi(e);for(const e of t)e.recalculate(n,r)}var nh,lh,uh;!function(t){t.create="create",t.load="load",t.fullLoad="fullLoad"}(nh||(nh={}));class ih{constructor(t){this._marks={start:[t.url,"start"].join("#"),end:[t.url,"end"].join("#"),measure:t.url.toString()},performance.mark(this._marks.start)}finish(){performance.mark(this._marks.end);let t=performance.getEntriesByName(this._marks.measure);return 0===t.length&&(performance.measure(this._marks.measure,this._marks.start,this._marks.end),t=performance.getEntriesByName(this._marks.measure),performance.clearMarks(this._marks.start),performance.clearMarks(this._marks.end),performance.clearMeasures(this._marks.measure)),t}}class sh{constructor(t,e,r){this.actor=t,this.layerIndex=e,this.availableImages=r,this.fetching={},this.loading={},this.loaded={}}loadVectorTile(e,r){return t(this,void 0,void 0,(function*(){const t=yield((t,e)=>Kn(x(t,{type:"arrayBuffer"}),e))(e.request,r);try{return{vectorTile:new Il.VectorTile(new yu(t.data)),rawData:t.data,cacheControl:t.cacheControl,expires:t.expires}}catch(r){const n=new Uint8Array(t.data);let s=`Unable to parse the tile at ${e.request.url}, `;throw s+=31===n[0]&&139===n[1]?"please make sure the data is not gzipped and that you have configured the relevant header in the server":`got error: ${r.message}`,new Error(s)}}))}loadTile(e){return t(this,void 0,void 0,(function*(){const t=e.uid,r=!!(e&&e.request&&e.request.collectResourceTiming)&&new ih(e.request),n=new Qc(e);this.loading[t]=n;const s=new AbortController;n.abort=s;try{const o=yield this.loadVectorTile(e,s);if(delete this.loading[t],!o)return null;const a=o.rawData,l={};o.expires&&(l.expires=o.expires),o.cacheControl&&(l.cacheControl=o.cacheControl);const u={};if(r){const t=r.finish();t&&(u.resourceTiming=JSON.parse(JSON.stringify(t)))}n.vectorTile=o.vectorTile;const c=n.parse(o.vectorTile,this.layerIndex,this.availableImages,this.actor,e.subdivisionGranularity);this.loaded[t]=n,this.fetching[t]={rawTileData:a,cacheControl:l,resourceTiming:u};try{const t=yield c;return x({rawTileData:a.slice(0)},t,l,u)}finally{delete this.fetching[t]}}catch(e){throw delete this.loading[t],n.status="done",this.loaded[t]=n,e}}))}reloadTile(e){return t(this,void 0,void 0,(function*(){const t=e.uid;if(!this.loaded||!this.loaded[t])throw new Error("Should not be trying to reload a tile that was never loaded or has been removed");const r=this.loaded[t];if(r.showCollisionBoxes=e.showCollisionBoxes,"parsing"===r.status){const n=yield r.parse(r.vectorTile,this.layerIndex,this.availableImages,this.actor,e.subdivisionGranularity);let s;if(this.fetching[t]){const{rawTileData:e,cacheControl:r,resourceTiming:o}=this.fetching[t];delete this.fetching[t],s=x({rawTileData:e.slice(0)},n,r,o)}else s=n;return s}if("done"===r.status&&r.vectorTile)return r.parse(r.vectorTile,this.layerIndex,this.availableImages,this.actor,e.subdivisionGranularity)}))}abortTile(e){return t(this,void 0,void 0,(function*(){const t=this.loading,r=e.uid;t&&t[r]&&t[r].abort&&(t[r].abort.abort(),delete t[r])}))}removeTile(e){return t(this,void 0,void 0,(function*(){this.loaded&&this.loaded[e.uid]&&delete this.loaded[e.uid]}))}}class oh{constructor(t,e,r,n=1,s=1,o=1,a=0){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&!["mapbox","terrarium","custom"].includes(r))return void _(`"${r}" is not a valid encoding type. Valid types include "mapbox", "terrarium" and "custom".`);this.stride=e.height;const l=this.dim=e.height-2;switch(this.data=new Uint32Array(e.data.buffer),r){case"terrarium":this.redFactor=256,this.greenFactor=1,this.blueFactor=1/256,this.baseShift=32768;break;case"custom":this.redFactor=n,this.greenFactor=s,this.blueFactor=o,this.baseShift=a;break;default:this.redFactor=6553.6,this.greenFactor=25.6,this.blueFactor=.1,this.baseShift=1e4}for(let t=0;t<l;t++)this.data[this._idx(-1,t)]=this.data[this._idx(0,t)],this.data[this._idx(l,t)]=this.data[this._idx(l-1,t)],this.data[this._idx(t,-1)]=this.data[this._idx(t,0)],this.data[this._idx(t,l)]=this.data[this._idx(t,l-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(l,-1)]=this.data[this._idx(l-1,0)],this.data[this._idx(-1,l)]=this.data[this._idx(0,l-1)],this.data[this._idx(l,l)]=this.data[this._idx(l-1,l-1)],this.min=Number.MAX_SAFE_INTEGER,this.max=Number.MIN_SAFE_INTEGER;for(let t=0;t<l;t++)for(let e=0;e<l;e++){const r=this.get(t,e);r>this.max&&(this.max=r),r<this.min&&(this.min=r)}}get(t,e){const r=new Uint8Array(this.data.buffer),n=4*this._idx(t,e);return this.unpack(r[n],r[n+1],r[n+2])}getUnpackVector(){return[this.redFactor,this.greenFactor,this.blueFactor,this.baseShift]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return(e+1)*this.stride+(t+1)}unpack(t,e,r){return t*this.redFactor+e*this.greenFactor+r*this.blueFactor-this.baseShift}getPixels(){return new sa({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let n=e*this.dim,s=e*this.dim+this.dim,o=r*this.dim,a=r*this.dim+this.dim;switch(e){case-1:n=s-1;break;case 1:s=n+1}switch(r){case-1:o=a-1;break;case 1:a=o+1}const l=-e*this.dim,u=-r*this.dim;for(let e=o;e<a;e++)for(let r=n;r<s;r++)this.data[this._idx(r,e)]=t.data[this._idx(r+l,e+u)]}}Qn("DEMData",oh);class ah{constructor(){this.loaded={}}loadTile(e){return t(this,void 0,void 0,(function*(){const{uid:r,encoding:n,rawImageData:s,redFactor:o,greenFactor:a,blueFactor:l,baseShift:u}=e,c=s.width+2,f=s.height+2,d=A(s)?new sa({width:c,height:f},yield function(e,r,n,s,o){return t(this,void 0,void 0,(function*(){if(function(){if(null==p&&(p=!1,null==h&&(h="undefined"!=typeof OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof createImageBitmap),h)){const t=5,e=new OffscreenCanvas(t,t).getContext("2d",{willReadFrequently:!0});if(e){for(let r=0;r<t*t;r++){const n=4*r;e.fillStyle=`rgb(${n},${n+1},${n+2})`,e.fillRect(r%t,Math.floor(r/t),1,1)}const r=e.getImageData(0,0,t,t).data;for(let e=0;e<t*t*4;e++)if(e%4!=3&&r[e]!==e){p=!0;break}}}return p||!1}())try{return yield function(e,r,n,s,o){return t(this,void 0,void 0,(function*(){if("undefined"==typeof VideoFrame)throw new Error("VideoFrame not supported");const t=new VideoFrame(e,{timestamp:0});try{const r=null==t?void 0:t.format;if(!r||!r.startsWith("BGR")&&!r.startsWith("RGB"))throw new Error(`Unrecognized format ${r}`);const n=r.startsWith("BGR"),a=new Uint8ClampedArray(s*o*4);if(yield t.copyTo(a,function(t,e,r,n,s){const o=4*Math.max(1,0),a=(Math.max(0,-1)- -1)*n*4+o,l=4*n,u=Math.max(0,-1),c=Math.max(0,-1);return{rect:{x:u,y:c,width:Math.min(t.width,-1+n)-u,height:Math.min(t.height,-1+s)-c},layout:[{offset:a,stride:l}]}}(e,0,0,s,o)),n)for(let t=0;t<a.length;t+=4){const e=a[t];a[t]=a[t+2],a[t+2]=e}return a}finally{t.close()}}))}(e,0,0,s,o)}catch(t){}return function(t,e,r,n,s){const o=t.width,a=t.height;I&&M||(I=new OffscreenCanvas(o,a),M=I.getContext("2d",{willReadFrequently:!0})),I.width=o,I.height=a,M.drawImage(t,0,0,o,a);const l=M.getImageData(-1,-1,n,s);return M.clearRect(0,0,o,a),l.data}(e,0,0,s,o)}))}(s,0,0,c,f)):s,y=new oh(r,d,n,o,a,l,u);return this.loaded=this.loaded||{},this.loaded[r]=y,y}))}removeTile(t){const e=this.loaded,r=t.uid;e&&e[r]&&delete e[r]}}var ch=function(){if(uh)return lh;function t(t,r){if(0!==t.length){e(t[0],r);for(var n=1;n<t.length;n++)e(t[n],!r)}}function e(t,e){for(var r=0,n=0,s=0,o=t.length,a=o-1;s<o;a=s++){var l=(t[s][0]-t[a][0])*(t[a][1]+t[s][1]),u=r+l;n+=Math.abs(r)>=Math.abs(l)?r-u+l:l-u+r,r=u}r+n>=0!=!!e&&t.reverse()}return uh=1,lh=function e(r,n){var s,o=r&&r.type;if("FeatureCollection"===o)for(s=0;s<r.features.length;s++)e(r.features[s],n);else if("GeometryCollection"===o)for(s=0;s<r.geometries.length;s++)e(r.geometries[s],n);else if("Feature"===o)e(r.geometry,n);else if("Polygon"===o)t(r.coordinates,n);else if("MultiPolygon"===o)for(s=0;s<r.coordinates.length;s++)t(r.coordinates[s],n);return r}}(),fh=e(ch);const dh=Il.VectorTileFeature.prototype.toGeoJSON;class hh{constructor(t){this._feature=t,this.extent=m,this.type=t.type,this.properties=t.tags,"id"in t&&!isNaN(t.id)&&(this.id=parseInt(t.id,10))}loadGeometry(){if(1===this._feature.type){const t=[];for(const e of this._feature.geometry)t.push([new l(e[0],e[1])]);return t}{const t=[];for(const e of this._feature.geometry){const r=[];for(const t of e)r.push(new l(t[0],t[1]));t.push(r)}return t}}toGeoJSON(t,e,r){return dh.call(this,t,e,r)}}class ph{constructor(t){this.layers={_geojsonTileLayer:this},this.name="_geojsonTileLayer",this.extent=m,this.length=t.length,this._features=t}feature(t){return new hh(this._features[t])}}var yh,mh,gh,xh={exports:{}},vh=function(){if(gh)return xh.exports;gh=1;var t=fu(),e=function(){if(mh)return yh;mh=1;var t=s(),e=kl().VectorTileFeature;function r(t,e){this.options=e||{},this.features=t,this.length=t.length}function n(t,e){this.id="number"==typeof t.id?t.id:void 0,this.type=t.type,this.rawGeometry=1===t.type?[t.geometry]:t.geometry,this.properties=t.tags,this.extent=e||4096}return yh=r,r.prototype.feature=function(t){return new n(this.features[t],this.options.extent)},n.prototype.loadGeometry=function(){var e=this.rawGeometry;this.geometry=[];for(var r=0;r<e.length;r++){for(var n=e[r],s=[],o=0;o<n.length;o++)s.push(new t(n[o][0],n[o][1]));this.geometry.push(s)}return this.geometry},n.prototype.bbox=function(){this.geometry||this.loadGeometry();for(var t=this.geometry,e=1/0,r=-1/0,n=1/0,s=-1/0,o=0;o<t.length;o++)for(var a=t[o],l=0;l<a.length;l++){var u=a[l];e=Math.min(e,u.x),r=Math.max(r,u.x),n=Math.min(n,u.y),s=Math.max(s,u.y)}return[e,n,r,s]},n.prototype.toGeoJSON=e.prototype.toGeoJSON,yh}();function r(e){var r=new t;return function(t,e){for(var r in t.layers)e.writeMessage(3,n,t.layers[r])}(e,r),r.finish()}function n(t,e){var r;e.writeVarintField(15,t.version||1),e.writeStringField(1,t.name||""),e.writeVarintField(5,t.extent||4096);var n={keys:[],values:[],keycache:{},valuecache:{}};for(r=0;r<t.length;r++)n.feature=t.feature(r),e.writeMessage(2,o,n);var s=n.keys;for(r=0;r<s.length;r++)e.writeStringField(3,s[r]);var a=n.values;for(r=0;r<a.length;r++)e.writeMessage(4,h,a[r])}function o(t,e){var r=t.feature;void 0!==r.id&&e.writeVarintField(1,r.id),e.writeMessage(2,a,t),e.writeVarintField(3,r.type),e.writeMessage(4,c,r)}function a(t,e){var r=t.feature,n=t.keys,s=t.values,o=t.keycache,a=t.valuecache;for(var l in r.properties){var u=r.properties[l],c=o[l];if(null!==u){void 0===c&&(n.push(l),o[l]=c=n.length-1),e.writeVarint(c);var h=typeof u;"string"!==h&&"boolean"!==h&&"number"!==h&&(u=JSON.stringify(u));var p=h+":"+u,f=a[p];void 0===f&&(s.push(u),a[p]=f=s.length-1),e.writeVarint(f)}}}function l(t,e){return(e<<3)+(7&t)}function u(t){return t<<1^t>>31}function c(t,e){for(var r=t.loadGeometry(),n=t.type,s=0,o=0,a=r.length,c=0;c<a;c++){var h=r[c],p=1;1===n&&(p=h.length),e.writeVarint(l(1,p));for(var f=3===n?h.length-1:h.length,d=0;d<f;d++){1===d&&1!==n&&e.writeVarint(l(2,f-1));var y=h[d].x-s,m=h[d].y-o;e.writeVarint(u(y)),e.writeVarint(u(m)),s+=y,o+=m}3===n&&e.writeVarint(l(7,1))}}function h(t,e){var r=typeof t;"string"===r?e.writeStringField(1,t):"boolean"===r?e.writeBooleanField(7,t):"number"===r&&(t%1!=0?e.writeDoubleField(3,t):t<0?e.writeSVarintField(6,t):e.writeVarintField(5,t))}return xh.exports=r,xh.exports.fromVectorTileJs=r,xh.exports.fromGeojsonVt=function(t,n){n=n||{};var s={};for(var o in t)s[o]=new e(t[o].features,n),s[o].name=o,s[o].version=n.version,s[o].extent=n.extent;return r({layers:s})},xh.exports.GeoJSONWrapper=e,xh.exports}(),wh=e(vh);const _h=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class bh{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,r]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const n=r>>4;if(1!==n)throw new Error(`Got v${n} data when expected v1.`);const s=_h[15&r];if(!s)throw new Error("Unrecognized array type.");const[o]=new Uint16Array(t,2,1),[a]=new Uint32Array(t,4,1);return new bh(a,o,s,t)}constructor(t,e=64,r=Float64Array,n){if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=r,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const s=_h.indexOf(this.ArrayType),o=2*t*this.ArrayType.BYTES_PER_ELEMENT,a=t*this.IndexArrayType.BYTES_PER_ELEMENT,l=(8-a%8)%8;if(s<0)throw new Error(`Unexpected typed array class: ${r}.`);n&&n instanceof ArrayBuffer?(this.data=n,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+l,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+o+a+l),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+l,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+s]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t)}add(t,e){const r=this._pos>>1;return this.ids[r]=r,this.coords[this._pos++]=t,this.coords[this._pos++]=e,r}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return Sh(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(t,e,r,n){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:s,coords:o,nodeSize:a}=this,l=[0,s.length-1,0],u=[];for(;l.length;){const c=l.pop()||0,h=l.pop()||0,p=l.pop()||0;if(h-p<=a){for(let a=p;a<=h;a++){const l=o[2*a],c=o[2*a+1];l>=t&&l<=r&&c>=e&&c<=n&&u.push(s[a])}continue}const f=p+h>>1,d=o[2*f],y=o[2*f+1];d>=t&&d<=r&&y>=e&&y<=n&&u.push(s[f]),(0===c?t<=d:e<=y)&&(l.push(p),l.push(f-1),l.push(1-c)),(0===c?r>=d:n>=y)&&(l.push(f+1),l.push(h),l.push(1-c))}return u}within(t,e,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:s,nodeSize:o}=this,a=[0,n.length-1,0],l=[],u=r*r;for(;a.length;){const c=a.pop()||0,h=a.pop()||0,p=a.pop()||0;if(h-p<=o){for(let r=p;r<=h;r++)Mh(s[2*r],s[2*r+1],t,e)<=u&&l.push(n[r]);continue}const f=p+h>>1,d=s[2*f],y=s[2*f+1];Mh(d,y,t,e)<=u&&l.push(n[f]),(0===c?t-r<=d:e-r<=y)&&(a.push(p),a.push(f-1),a.push(1-c)),(0===c?t+r>=d:e+r>=y)&&(a.push(f+1),a.push(h),a.push(1-c))}return l}}function Sh(t,e,r,n,s,o){if(s-n<=r)return;const a=n+s>>1;kh(t,e,a,n,s,o),Sh(t,e,r,n,a-1,1-o),Sh(t,e,r,a+1,s,1-o)}function kh(t,e,r,n,s,o){for(;s>n;){if(s-n>600){const a=s-n+1,l=r-n+1,u=Math.log(a),c=.5*Math.exp(2*u/3),h=.5*Math.sqrt(u*c*(a-c)/a)*(l-a/2<0?-1:1);kh(t,e,r,Math.max(n,Math.floor(r-l*c/a+h)),Math.min(s,Math.floor(r+(a-l)*c/a+h)),o)}const a=e[2*r+o];let l=n,u=s;for(Ah(t,e,n,r),e[2*s+o]>a&&Ah(t,e,n,s);l<u;){for(Ah(t,e,l,u),l++,u--;e[2*l+o]<a;)l++;for(;e[2*u+o]>a;)u--}e[2*n+o]===a?Ah(t,e,n,u):(u++,Ah(t,e,u,s)),u<=r&&(n=u+1),r<=u&&(s=u-1)}}function Ah(t,e,r,n){Ih(t,r,n),Ih(e,2*r,2*n),Ih(e,2*r+1,2*n+1)}function Ih(t,e,r){const n=t[e];t[e]=t[r],t[r]=n}function Mh(t,e,r,n){const s=t-r,o=e-n;return s*s+o*o}const zh={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:t=>t},Bh=Math.fround||(Ph=new Float32Array(1),t=>(Ph[0]=+t,Ph[0]));var Ph;class Th{constructor(t){this.options=Object.assign(Object.create(zh),t),this.trees=new Array(this.options.maxZoom+1),this.stride=this.options.reduce?7:6,this.clusterProps=[]}load(t){const{log:e,minZoom:r,maxZoom:n}=this.options;e&&console.time("total time");const s=`prepare ${t.length} points`;e&&console.time(s),this.points=t;const o=[];for(let e=0;e<t.length;e++){const r=t[e];if(!r.geometry)continue;const[n,s]=r.geometry.coordinates,a=Bh(Eh(n)),l=Bh(Fh(s));o.push(a,l,1/0,e,-1,1),this.options.reduce&&o.push(0)}let a=this.trees[n+1]=this._createTree(o);e&&console.timeEnd(s);for(let t=n;t>=r;t--){const r=+Date.now();a=this.trees[t]=this._createTree(this._cluster(a,t)),e&&console.log("z%d: %d clusters in %dms",t,a.numItems,+Date.now()-r)}return e&&console.timeEnd("total time"),this}getClusters(t,e){let r=((t[0]+180)%360+360)%360-180;const n=Math.max(-90,Math.min(90,t[1]));let s=180===t[2]?180:((t[2]+180)%360+360)%360-180;const o=Math.max(-90,Math.min(90,t[3]));if(t[2]-t[0]>=360)r=-180,s=180;else if(r>s){const t=this.getClusters([r,n,180,o],e),a=this.getClusters([-180,n,s,o],e);return t.concat(a)}const a=this.trees[this._limitZoom(e)],l=a.range(Eh(r),Fh(o),Eh(s),Fh(n)),u=a.data,c=[];for(const t of l){const e=this.stride*t;c.push(u[e+5]>1?Ch(u,e,this.clusterProps):this.points[u[e+3]])}return c}getChildren(t){const e=this._getOriginId(t),r=this._getOriginZoom(t),n="No cluster with the specified id.",s=this.trees[r];if(!s)throw new Error(n);const o=s.data;if(e*this.stride>=o.length)throw new Error(n);const a=this.options.radius/(this.options.extent*Math.pow(2,r-1)),l=s.within(o[e*this.stride],o[e*this.stride+1],a),u=[];for(const e of l){const r=e*this.stride;o[r+4]===t&&u.push(o[r+5]>1?Ch(o,r,this.clusterProps):this.points[o[r+3]])}if(0===u.length)throw new Error(n);return u}getLeaves(t,e,r){const n=[];return this._appendLeaves(n,t,e=e||10,r=r||0,0),n}getTile(t,e,r){const n=this.trees[this._limitZoom(t)],s=Math.pow(2,t),{extent:o,radius:a}=this.options,l=a/o,u=(r-l)/s,c=(r+1+l)/s,h={features:[]};return this._addTileFeatures(n.range((e-l)/s,u,(e+1+l)/s,c),n.data,e,r,s,h),0===e&&this._addTileFeatures(n.range(1-l/s,u,1,c),n.data,s,r,s,h),e===s-1&&this._addTileFeatures(n.range(0,u,l/s,c),n.data,-1,r,s,h),h.features.length?h:null}getClusterExpansionZoom(t){let e=this._getOriginZoom(t)-1;for(;e<=this.options.maxZoom;){const r=this.getChildren(t);if(e++,1!==r.length)break;t=r[0].properties.cluster_id}return e}_appendLeaves(t,e,r,n,s){const o=this.getChildren(e);for(const e of o){const o=e.properties;if(o&&o.cluster?s+o.point_count<=n?s+=o.point_count:s=this._appendLeaves(t,o.cluster_id,r,n,s):s<n?s++:t.push(e),t.length===r)break}return s}_createTree(t){const e=new bh(t.length/this.stride|0,this.options.nodeSize,Float32Array);for(let r=0;r<t.length;r+=this.stride)e.add(t[r],t[r+1]);return e.finish(),e.data=t,e}_addTileFeatures(t,e,r,n,s,o){for(const a of t){const t=a*this.stride,l=e[t+5]>1;let u,c,h;if(l)u=Vh(e,t,this.clusterProps),c=e[t],h=e[t+1];else{const r=this.points[e[t+3]];u=r.properties;const[n,s]=r.geometry.coordinates;c=Eh(n),h=Fh(s)}const p={type:1,geometry:[[Math.round(this.options.extent*(c*s-r)),Math.round(this.options.extent*(h*s-n))]],tags:u};let f;f=l||this.options.generateId?e[t+3]:this.points[e[t+3]].id,void 0!==f&&(p.id=f),o.features.push(p)}}_limitZoom(t){return Math.max(this.options.minZoom,Math.min(Math.floor(+t),this.options.maxZoom+1))}_cluster(t,e){const{radius:r,extent:n,reduce:s,minPoints:o}=this.options,a=r/(n*Math.pow(2,e)),l=t.data,u=[],c=this.stride;for(let r=0;r<l.length;r+=c){if(l[r+2]<=e)continue;l[r+2]=e;const n=l[r],h=l[r+1],p=t.within(l[r],l[r+1],a),f=l[r+5];let d=f;for(const t of p){const r=t*c;l[r+2]>e&&(d+=l[r+5])}if(d>f&&d>=o){let t,o=n*f,a=h*f,y=-1;const m=(r/c<<5)+(e+1)+this.points.length;for(const n of p){const u=n*c;if(l[u+2]<=e)continue;l[u+2]=e;const h=l[u+5];o+=l[u]*h,a+=l[u+1]*h,l[u+4]=m,s&&(t||(t=this._map(l,r,!0),y=this.clusterProps.length,this.clusterProps.push(t)),s(t,this._map(l,u)))}l[r+4]=m,u.push(o/d,a/d,1/0,m,-1,d),s&&u.push(y)}else{for(let t=0;t<c;t++)u.push(l[r+t]);if(d>1)for(const t of p){const r=t*c;if(!(l[r+2]<=e)){l[r+2]=e;for(let t=0;t<c;t++)u.push(l[r+t])}}}}return u}_getOriginId(t){return t-this.points.length>>5}_getOriginZoom(t){return(t-this.points.length)%32}_map(t,e,r){if(t[e+5]>1){const n=this.clusterProps[t[e+6]];return r?Object.assign({},n):n}const n=this.points[t[e+3]].properties,s=this.options.map(n);return r&&s===n?Object.assign({},s):s}}function Ch(t,e,r){return{type:"Feature",id:t[e+3],properties:Vh(t,e,r),geometry:{type:"Point",coordinates:[(n=t[e],360*(n-.5)),Dh(t[e+1])]}};var n}function Vh(t,e,r){const n=t[e+5],s=n>=1e4?`${Math.round(n/1e3)}k`:n>=1e3?Math.round(n/100)/10+"k":n,o=t[e+6],a=-1===o?{}:Object.assign({},r[o]);return Object.assign(a,{cluster:!0,cluster_id:t[e+3],point_count:n,point_count_abbreviated:s})}function Eh(t){return t/360+.5}function Fh(t){const e=Math.sin(t*Math.PI/180),r=.5-.25*Math.log((1+e)/(1-e))/Math.PI;return r<0?0:r>1?1:r}function Dh(t){const e=(180-360*t)*Math.PI/180;return 360*Math.atan(Math.exp(e))/Math.PI-90}function $h(t,e,r,n){let s=n;const o=e+(r-e>>1);let a,l=r-e;const u=t[e],c=t[e+1],h=t[r],p=t[r+1];for(let n=e+3;n<r;n+=3){const e=Lh(t[n],t[n+1],u,c,h,p);if(e>s)a=n,s=e;else if(e===s){const t=Math.abs(n-o);t<l&&(a=n,l=t)}}s>n&&(a-e>3&&$h(t,e,a,n),t[a+2]=s,r-a>3&&$h(t,a,r,n))}function Lh(t,e,r,n,s,o){let a=s-r,l=o-n;if(0!==a||0!==l){const u=((t-r)*a+(e-n)*l)/(a*a+l*l);u>1?(r=s,n=o):u>0&&(r+=a*u,n+=l*u)}return a=t-r,l=e-n,a*a+l*l}function Rh(t,e,r,n){const s={id:null==t?null:t,type:e,geometry:r,tags:n,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};if("Point"===e||"MultiPoint"===e||"LineString"===e)Oh(s,r);else if("Polygon"===e)Oh(s,r[0]);else if("MultiLineString"===e)for(const t of r)Oh(s,t);else if("MultiPolygon"===e)for(const t of r)Oh(s,t[0]);return s}function Oh(t,e){for(let r=0;r<e.length;r+=3)t.minX=Math.min(t.minX,e[r]),t.minY=Math.min(t.minY,e[r+1]),t.maxX=Math.max(t.maxX,e[r]),t.maxY=Math.max(t.maxY,e[r+1])}function Nh(t,e,r,n){if(!e.geometry)return;const s=e.geometry.coordinates;if(s&&0===s.length)return;const o=e.geometry.type,a=Math.pow(r.tolerance/((1<<r.maxZoom)*r.extent),2);let l=[],u=e.id;if(r.promoteId?u=e.properties[r.promoteId]:r.generateId&&(u=n||0),"Point"===o)jh(s,l);else if("MultiPoint"===o)for(const t of s)jh(t,l);else if("LineString"===o)Uh(s,l,a,!1);else if("MultiLineString"===o){if(r.lineMetrics){for(const r of s)l=[],Uh(r,l,a,!1),t.push(Rh(u,"LineString",l,e.properties));return}qh(s,l,a,!1)}else if("Polygon"===o)qh(s,l,a,!0);else{if("MultiPolygon"!==o){if("GeometryCollection"===o){for(const s of e.geometry.geometries)Nh(t,{id:u,geometry:s,properties:e.properties},r,n);return}throw new Error("Input data is not a valid GeoJSON object.")}for(const t of s){const e=[];qh(t,e,a,!0),l.push(e)}}t.push(Rh(u,o,l,e.properties))}function jh(t,e){e.push(Gh(t[0]),Zh(t[1]),0)}function Uh(t,e,r,n){let s,o,a=0;for(let r=0;r<t.length;r++){const l=Gh(t[r][0]),u=Zh(t[r][1]);e.push(l,u,0),r>0&&(a+=n?(s*u-l*o)/2:Math.sqrt(Math.pow(l-s,2)+Math.pow(u-o,2))),s=l,o=u}const l=e.length-3;e[2]=1,$h(e,0,l,r),e[l+2]=1,e.size=Math.abs(a),e.start=0,e.end=e.size}function qh(t,e,r,n){for(let s=0;s<t.length;s++){const o=[];Uh(t[s],o,r,n),e.push(o)}}function Gh(t){return t/360+.5}function Zh(t){const e=Math.sin(t*Math.PI/180),r=.5-.25*Math.log((1+e)/(1-e))/Math.PI;return r<0?0:r>1?1:r}function Jh(t,e,r,n,s,o,a,l){if(n/=e,o>=(r/=e)&&a<n)return t;if(a<r||o>=n)return null;const u=[];for(const e of t){const t=e.geometry;let o=e.type;const a=0===s?e.minX:e.minY,c=0===s?e.maxX:e.maxY;if(a>=r&&c<n){u.push(e);continue}if(c<r||a>=n)continue;let h=[];if("Point"===o||"MultiPoint"===o)Xh(t,h,r,n,s);else if("LineString"===o)Yh(t,h,r,n,s,!1,l.lineMetrics);else if("MultiLineString"===o)Kh(t,h,r,n,s,!1);else if("Polygon"===o)Kh(t,h,r,n,s,!0);else if("MultiPolygon"===o)for(const e of t){const t=[];Kh(e,t,r,n,s,!0),t.length&&h.push(t)}if(h.length){if(l.lineMetrics&&"LineString"===o){for(const t of h)u.push(Rh(e.id,o,t,e.tags));continue}"LineString"!==o&&"MultiLineString"!==o||(1===h.length?(o="LineString",h=h[0]):o="MultiLineString"),"Point"!==o&&"MultiPoint"!==o||(o=3===h.length?"Point":"MultiPoint"),u.push(Rh(e.id,o,h,e.tags))}}return u.length?u:null}function Xh(t,e,r,n,s){for(let o=0;o<t.length;o+=3){const a=t[o+s];a>=r&&a<=n&&Wh(e,t[o],t[o+1],t[o+2])}}function Yh(t,e,r,n,s,o,a){let l=Hh(t);const u=0===s?Qh:tp;let c,h,p=t.start;for(let f=0;f<t.length-3;f+=3){const d=t[f],y=t[f+1],m=t[f+2],g=t[f+3],x=t[f+4],v=0===s?d:y,b=0===s?g:x;let w=!1;a&&(c=Math.sqrt(Math.pow(d-g,2)+Math.pow(y-x,2))),v<r?b>r&&(h=u(l,d,y,g,x,r),a&&(l.start=p+c*h)):v>n?b<n&&(h=u(l,d,y,g,x,n),a&&(l.start=p+c*h)):Wh(l,d,y,m),b<r&&v>=r&&(h=u(l,d,y,g,x,r),w=!0),b>n&&v<=n&&(h=u(l,d,y,g,x,n),w=!0),!o&&w&&(a&&(l.end=p+c*h),e.push(l),l=Hh(t)),a&&(p+=c)}let f=t.length-3;const d=t[f],y=t[f+1],m=0===s?d:y;m>=r&&m<=n&&Wh(l,d,y,t[f+2]),f=l.length-3,o&&f>=3&&(l[f]!==l[0]||l[f+1]!==l[1])&&Wh(l,l[0],l[1],l[2]),l.length&&e.push(l)}function Hh(t){const e=[];return e.size=t.size,e.start=t.start,e.end=t.end,e}function Kh(t,e,r,n,s,o){for(const a of t)Yh(a,e,r,n,s,o,!1)}function Wh(t,e,r,n){t.push(e,r,n)}function Qh(t,e,r,n,s,o){const a=(o-e)/(n-e);return Wh(t,o,r+(s-r)*a,1),a}function tp(t,e,r,n,s,o){const a=(o-r)/(s-r);return Wh(t,e+(n-e)*a,o,1),a}function ep(t,e){const r=[];for(let n=0;n<t.length;n++){const s=t[n],o=s.type;let a;if("Point"===o||"MultiPoint"===o||"LineString"===o)a=rp(s.geometry,e);else if("MultiLineString"===o||"Polygon"===o){a=[];for(const t of s.geometry)a.push(rp(t,e))}else if("MultiPolygon"===o){a=[];for(const t of s.geometry){const r=[];for(const n of t)r.push(rp(n,e));a.push(r)}}r.push(Rh(s.id,o,a,s.tags))}return r}function rp(t,e){const r=[];r.size=t.size,void 0!==t.start&&(r.start=t.start,r.end=t.end);for(let n=0;n<t.length;n+=3)r.push(t[n]+e,t[n+1],t[n+2]);return r}function np(t,e){if(t.transformed)return t;const r=1<<t.z,n=t.x,s=t.y;for(const o of t.features){const t=o.geometry,a=o.type;if(o.geometry=[],1===a)for(let a=0;a<t.length;a+=2)o.geometry.push(ip(t[a],t[a+1],e,r,n,s));else for(let a=0;a<t.length;a++){const l=[];for(let o=0;o<t[a].length;o+=2)l.push(ip(t[a][o],t[a][o+1],e,r,n,s));o.geometry.push(l)}}return t.transformed=!0,t}function ip(t,e,r,n,s,o){return[Math.round(r*(t*n-s)),Math.round(r*(e*n-o))]}function sp(t,e,r,n,s){const o=e===s.maxZoom?0:s.tolerance/((1<<e)*s.extent),a={features:[],numPoints:0,numSimplified:0,numFeatures:t.length,source:null,x:r,y:n,z:e,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0};for(const e of t)op(a,e,o,s);return a}function op(t,e,r,n){const s=e.geometry,o=e.type,a=[];if(t.minX=Math.min(t.minX,e.minX),t.minY=Math.min(t.minY,e.minY),t.maxX=Math.max(t.maxX,e.maxX),t.maxY=Math.max(t.maxY,e.maxY),"Point"===o||"MultiPoint"===o)for(let e=0;e<s.length;e+=3)a.push(s[e],s[e+1]),t.numPoints++,t.numSimplified++;else if("LineString"===o)ap(a,s,t,r,!1,!1);else if("MultiLineString"===o||"Polygon"===o)for(let e=0;e<s.length;e++)ap(a,s[e],t,r,"Polygon"===o,0===e);else if("MultiPolygon"===o)for(let e=0;e<s.length;e++){const n=s[e];for(let e=0;e<n.length;e++)ap(a,n[e],t,r,!0,0===e)}if(a.length){let r=e.tags||null;if("LineString"===o&&n.lineMetrics){r={};for(const t in e.tags)r[t]=e.tags[t];r.mapbox_clip_start=s.start/s.size,r.mapbox_clip_end=s.end/s.size}const l={geometry:a,type:"Polygon"===o||"MultiPolygon"===o?3:"LineString"===o||"MultiLineString"===o?2:1,tags:r};null!==e.id&&(l.id=e.id),t.features.push(l)}}function ap(t,e,r,n,s,o){const a=n*n;if(n>0&&e.size<(s?a:n))return void(r.numPoints+=e.length/3);const l=[];for(let t=0;t<e.length;t+=3)(0===n||e[t+2]>a)&&(r.numSimplified++,l.push(e[t],e[t+1])),r.numPoints++;s&&function(t,e){let r=0;for(let e=0,n=t.length,s=n-2;e<n;s=e,e+=2)r+=(t[e]-t[s])*(t[e+1]+t[s+1]);if(r>0===e)for(let e=0,r=t.length;e<r/2;e+=2){const n=t[e],s=t[e+1];t[e]=t[r-2-e],t[e+1]=t[r-1-e],t[r-2-e]=n,t[r-1-e]=s}}(l,o),t.push(l)}const lp={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0};class cp{constructor(t,e){const r=(e=this.options=function(t,e){for(const r in e)t[r]=e[r];return t}(Object.create(lp),e)).debug;if(r&&console.time("preprocess data"),e.maxZoom<0||e.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(e.promoteId&&e.generateId)throw new Error("promoteId and generateId cannot be used together.");let n=function(t,e){const r=[];if("FeatureCollection"===t.type)for(let n=0;n<t.features.length;n++)Nh(r,t.features[n],e,n);else Nh(r,"Feature"===t.type?t:{geometry:t},e);return r}(t,e);this.tiles={},this.tileCoords=[],r&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",e.indexMaxZoom,e.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),n=function(t,e){const r=e.buffer/e.extent;let n=t;const s=Jh(t,1,-1-r,r,0,-1,2,e),o=Jh(t,1,1-r,2+r,0,-1,2,e);return(s||o)&&(n=Jh(t,1,-r,1+r,0,-1,2,e)||[],s&&(n=ep(s,1).concat(n)),o&&(n=n.concat(ep(o,-1)))),n}(n,e),n.length&&this.splitTile(n,0,0,0),r&&(n.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)))}splitTile(t,e,r,n,s,o,a){const l=[t,e,r,n],u=this.options,c=u.debug;for(;l.length;){n=l.pop(),r=l.pop(),e=l.pop(),t=l.pop();const h=1<<e,p=up(e,r,n);let f=this.tiles[p];if(!f&&(c>1&&console.time("creation"),f=this.tiles[p]=sp(t,e,r,n,u),this.tileCoords.push({z:e,x:r,y:n}),c)){c>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",e,r,n,f.numFeatures,f.numPoints,f.numSimplified),console.timeEnd("creation"));const t=`z${e}`;this.stats[t]=(this.stats[t]||0)+1,this.total++}if(f.source=t,null==s){if(e===u.indexMaxZoom||f.numPoints<=u.indexMaxPoints)continue}else{if(e===u.maxZoom||e===s)continue;if(null!=s){const t=s-e;if(r!==o>>t||n!==a>>t)continue}}if(f.source=null,0===t.length)continue;c>1&&console.time("clipping");const d=.5*u.buffer/u.extent,y=.5-d,m=.5+d,g=1+d;let x=null,v=null,b=null,w=null,_=Jh(t,h,r-d,r+m,0,f.minX,f.maxX,u),S=Jh(t,h,r+y,r+g,0,f.minX,f.maxX,u);t=null,_&&(x=Jh(_,h,n-d,n+m,1,f.minY,f.maxY,u),v=Jh(_,h,n+y,n+g,1,f.minY,f.maxY,u),_=null),S&&(b=Jh(S,h,n-d,n+m,1,f.minY,f.maxY,u),w=Jh(S,h,n+y,n+g,1,f.minY,f.maxY,u),S=null),c>1&&console.timeEnd("clipping"),l.push(x||[],e+1,2*r,2*n),l.push(v||[],e+1,2*r,2*n+1),l.push(b||[],e+1,2*r+1,2*n),l.push(w||[],e+1,2*r+1,2*n+1)}}getTile(t,e,r){t=+t,e=+e,r=+r;const n=this.options,{extent:s,debug:o}=n;if(t<0||t>24)return null;const a=1<<t,l=up(t,e=e+a&a-1,r);if(this.tiles[l])return np(this.tiles[l],s);o>1&&console.log("drilling down to z%d-%d-%d",t,e,r);let u,c=t,h=e,p=r;for(;!u&&c>0;)c--,h>>=1,p>>=1,u=this.tiles[up(c,h,p)];return u&&u.source?(o>1&&(console.log("found parent tile z%d-%d-%d",c,h,p),console.time("drilling down")),this.splitTile(u.source,c,h,p,t,e,r),o>1&&console.timeEnd("drilling down"),this.tiles[l]?np(this.tiles[l],s):null):null}}function up(t,e,r){return 32*((1<<t)*r+e)+t}function hp(t,e){return e?t.properties[e]:t.id}function pp(t,e){if(null==t)return!0;if("Feature"===t.type)return null!=hp(t,e);if("FeatureCollection"===t.type){const r=new Set;for(const n of t.features){const t=hp(n,e);if(null==t)return!1;if(r.has(t))return!1;r.add(t)}return!0}return!1}function fp(t,e){const r=new Map;if(null==t);else if("Feature"===t.type)r.set(hp(t,e),t);else for(const n of t.features)r.set(hp(n,e),n);return r}class yp extends sh{constructor(){super(...arguments),this._dataUpdateable=new Map}loadVectorTile(e,r){return t(this,void 0,void 0,(function*(){const t=e.tileID.canonical;if(!this._geoJSONIndex)throw new Error("Unable to parse the data into a cluster or geojson");const r=this._geoJSONIndex.getTile(t.z,t.x,t.y);if(!r)return null;const n=new ph(r.features);let s=wh(n);return 0===s.byteOffset&&s.byteLength===s.buffer.byteLength||(s=new Uint8Array(s)),{vectorTile:n,rawData:s.buffer}}))}loadData(e){return t(this,void 0,void 0,(function*(){var t;null===(t=this._pendingRequest)||void 0===t||t.abort();const r=!!(e&&e.request&&e.request.collectResourceTiming)&&new ih(e.request);this._pendingRequest=new AbortController;try{this._pendingData=this.loadAndProcessGeoJSON(e,this._pendingRequest),this._geoJSONIndex=e.cluster?new Th(function({superclusterOptions:t,clusterProperties:e}){if(!e||!t)return t;const r={},n={},s={accumulated:null,zoom:0},o={properties:null},a=Object.keys(e);for(const t of a){const[s,o]=e[t],a=Hr(o),l=Hr("string"==typeof s?[s,["accumulated"],["get",t]]:s);r[t]=a.value,n[t]=l.value}return t.map=t=>{o.properties=t;const e={};for(const t of a)e[t]=r[t].evaluate(s,o);return e},t.reduce=(t,e)=>{o.properties=e;for(const e of a)s.accumulated=t[e],t[e]=n[e].evaluate(s,o)},t}(e)).load((yield this._pendingData).features):(n=yield this._pendingData,new cp(n,e.geojsonVtOptions)),this.loaded={};const t={};if(r){const n=r.finish();n&&(t.resourceTiming={},t.resourceTiming[e.source]=JSON.parse(JSON.stringify(n)))}return t}catch(t){if(delete this._pendingRequest,function(t){return t.message===Un}(t))return{abandoned:!0};throw t}var n}))}getData(){return t(this,void 0,void 0,(function*(){return this._pendingData}))}reloadTile(t){const e=this.loaded;return e&&e[t.uid]?super.reloadTile(t):this.loadTile(t)}loadAndProcessGeoJSON(e,r){return t(this,void 0,void 0,(function*(){let t=yield this.loadGeoJSON(e,r);if(delete this._pendingRequest,"object"!=typeof t)throw new Error(`Input data given to '${e.source}' is not a valid GeoJSON object.`);if(fh(t,!0),e.filter){const r=Hr(e.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===r.result)throw new Error(r.value.map((t=>`${t.key}: ${t.message}`)).join(", "));const n=t.features.filter((t=>r.value.evaluate({zoom:0},t)));t={type:"FeatureCollection",features:n}}return t}))}loadGeoJSON(e,r){return t(this,void 0,void 0,(function*(){const{promoteId:t}=e;if(e.request){const n=yield((t,e)=>Kn(x(t,{type:"json"}),e))(e.request,r);return this._dataUpdateable=pp(n.data,t)?fp(n.data,t):void 0,n.data}if("string"==typeof e.data)try{const r=JSON.parse(e.data);return this._dataUpdateable=pp(r,t)?fp(r,t):void 0,r}catch(t){throw new Error(`Input data given to '${e.source}' is not a valid GeoJSON object.`)}if(!e.dataDiff)throw new Error(`Input data given to '${e.source}' is not a valid GeoJSON object.`);if(!this._dataUpdateable)throw new Error(`Cannot update existing geojson data in ${e.source}`);return function(t,e,r){var n,s,o,a;if(e.removeAll&&t.clear(),e.remove)for(const r of e.remove)t.delete(r);if(e.add)for(const n of e.add){const e=hp(n,r);null!=e&&t.set(e,n)}if(e.update)for(const r of e.update){let e=t.get(r.id);if(null==e)continue;const l=!r.removeAllProperties&&((null===(n=r.removeProperties)||void 0===n?void 0:n.length)>0||(null===(s=r.addOrUpdateProperties)||void 0===s?void 0:s.length)>0);if((r.newGeometry||r.removeAllProperties||l)&&(e=Object.assign({},e),t.set(r.id,e),l&&(e.properties=Object.assign({},e.properties))),r.newGeometry&&(e.geometry=r.newGeometry),r.removeAllProperties)e.properties={};else if((null===(o=r.removeProperties)||void 0===o?void 0:o.length)>0)for(const t of r.removeProperties)Object.prototype.hasOwnProperty.call(e.properties,t)&&delete e.properties[t];if((null===(a=r.addOrUpdateProperties)||void 0===a?void 0:a.length)>0)for(const{key:t,value:n}of r.addOrUpdateProperties)e.properties[t]=n}}(this._dataUpdateable,e.dataDiff,t),{type:"FeatureCollection",features:Array.from(this._dataUpdateable.values())}}))}removeSource(e){return t(this,void 0,void 0,(function*(){this._pendingRequest&&this._pendingRequest.abort()}))}getClusterExpansionZoom(t){return this._geoJSONIndex.getClusterExpansionZoom(t.clusterId)}getClusterChildren(t){return this._geoJSONIndex.getChildren(t.clusterId)}getClusterLeaves(t){return this._geoJSONIndex.getLeaves(t.clusterId,t.limit,t.offset)}}class mp{constructor(e){this.self=e,this.actor=new ai(e),this.layerIndexes={},this.availableImages={},this.workerSources={},this.demWorkerSources={},this.externalWorkerSourceTypes={},this.self.registerWorkerSource=(t,e)=>{if(this.externalWorkerSourceTypes[t])throw new Error(`Worker source with name "${t}" already registered.`);this.externalWorkerSourceTypes[t]=e},this.self.addProtocol=Zn,this.self.removeProtocol=Jn,this.self.registerRTLTextPlugin=t=>{Qs.setMethods(t)},this.actor.registerMessageHandler("LDT",((t,e)=>this._getDEMWorkerSource(t,e.source).loadTile(e))),this.actor.registerMessageHandler("RDT",((e,r)=>t(this,void 0,void 0,(function*(){this._getDEMWorkerSource(e,r.source).removeTile(r)})))),this.actor.registerMessageHandler("GCEZ",((e,r)=>t(this,void 0,void 0,(function*(){return this._getWorkerSource(e,r.type,r.source).getClusterExpansionZoom(r)})))),this.actor.registerMessageHandler("GCC",((e,r)=>t(this,void 0,void 0,(function*(){return this._getWorkerSource(e,r.type,r.source).getClusterChildren(r)})))),this.actor.registerMessageHandler("GCL",((e,r)=>t(this,void 0,void 0,(function*(){return this._getWorkerSource(e,r.type,r.source).getClusterLeaves(r)})))),this.actor.registerMessageHandler("LD",((t,e)=>this._getWorkerSource(t,e.type,e.source).loadData(e))),this.actor.registerMessageHandler("GD",((t,e)=>this._getWorkerSource(t,e.type,e.source).getData())),this.actor.registerMessageHandler("LT",((t,e)=>this._getWorkerSource(t,e.type,e.source).loadTile(e))),this.actor.registerMessageHandler("RT",((t,e)=>this._getWorkerSource(t,e.type,e.source).reloadTile(e))),this.actor.registerMessageHandler("AT",((t,e)=>this._getWorkerSource(t,e.type,e.source).abortTile(e))),this.actor.registerMessageHandler("RMT",((t,e)=>this._getWorkerSource(t,e.type,e.source).removeTile(e))),this.actor.registerMessageHandler("RS",((e,r)=>t(this,void 0,void 0,(function*(){if(!this.workerSources[e]||!this.workerSources[e][r.type]||!this.workerSources[e][r.type][r.source])return;const t=this.workerSources[e][r.type][r.source];delete this.workerSources[e][r.type][r.source],void 0!==t.removeSource&&t.removeSource(r)})))),this.actor.registerMessageHandler("RM",(e=>t(this,void 0,void 0,(function*(){delete this.layerIndexes[e],delete this.availableImages[e],delete this.workerSources[e],delete this.demWorkerSources[e]})))),this.actor.registerMessageHandler("SR",((e,r)=>t(this,void 0,void 0,(function*(){this.referrer=r})))),this.actor.registerMessageHandler("SRPS",((t,e)=>this._syncRTLPluginState(t,e))),this.actor.registerMessageHandler("IS",((e,r)=>t(this,void 0,void 0,(function*(){this.self.importScripts(r)})))),this.actor.registerMessageHandler("SI",((t,e)=>this._setImages(t,e))),this.actor.registerMessageHandler("UL",((e,r)=>t(this,void 0,void 0,(function*(){this._getLayerIndex(e).update(r.layers,r.removedIds)})))),this.actor.registerMessageHandler("SL",((e,r)=>t(this,void 0,void 0,(function*(){this._getLayerIndex(e).replace(r)}))))}_setImages(e,r){return t(this,void 0,void 0,(function*(){this.availableImages[e]=r;for(const t in this.workerSources[e]){const n=this.workerSources[e][t];for(const t in n)n[t].availableImages=r}}))}_syncRTLPluginState(e,r){return t(this,void 0,void 0,(function*(){return yield Qs.syncState(r,this.self.importScripts)}))}_getAvailableImages(t){let e=this.availableImages[t];return e||(e=[]),e}_getLayerIndex(t){let e=this.layerIndexes[t];return e||(e=this.layerIndexes[t]=new ic),e}_getWorkerSource(t,e,r){if(this.workerSources[t]||(this.workerSources[t]={}),this.workerSources[t][e]||(this.workerSources[t][e]={}),!this.workerSources[t][e][r]){const n={sendAsync:(e,r)=>(e.targetMapId=t,this.actor.sendAsync(e,r))};switch(e){case"vector":this.workerSources[t][e][r]=new sh(n,this._getLayerIndex(t),this._getAvailableImages(t));break;case"geojson":this.workerSources[t][e][r]=new yp(n,this._getLayerIndex(t),this._getAvailableImages(t));break;default:this.workerSources[t][e][r]=new this.externalWorkerSourceTypes[e](n,this._getLayerIndex(t),this._getAvailableImages(t))}}return this.workerSources[t][e][r]}_getDEMWorkerSource(t,e){return this.demWorkerSources[t]||(this.demWorkerSources[t]={}),this.demWorkerSources[t][e]||(this.demWorkerSources[t][e]=new ah),this.demWorkerSources[t][e]}}return k(self)&&(self.worker=new mp(self)),mp}();