"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourceSchema = exports.kibanaTilemapSourceSchema = exports.XYZTMSSourceSchema = exports.WMSSourceSchema = exports.TiledSingleLayerVectorSourceSchema = exports.MVTFieldSchema = exports.EMSTMSSourceSchema = exports.EMSFileSourceSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("../../../../../common");
var _constants = require("../../../../../common/constants");
var _es_agg_source_schemas = require("./es_agg_source_schemas");
var _es_source_schemas = require("./es_source_schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMSFileSourceSchema = exports.EMSFileSourceSchema = _configSchema.schema.object({
  id: _configSchema.schema.string({
    meta: {
      description: 'Administrative boundaries layer id from Elastic Maps Service (EMS).'
    }
  }),
  type: _configSchema.schema.literal(_common.SOURCE_TYPES.EMS_FILE),
  tooltipProperties: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    meta: {
      description: 'Administrative boundary properties displayed in tooltip.'
    }
  }))
}, {
  meta: {
    description: 'Administrative boundaries from Elastic Maps Service (EMS).'
  },
  unknowns: 'forbid'
});
const EMSTMSSourceSchema = exports.EMSTMSSourceSchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Tile Map Service (TMS) layer id from Elastic Maps Service (EMS). Required when isAutoSelect is false.'
    }
  })),
  type: _configSchema.schema.literal(_common.SOURCE_TYPES.EMS_TMS),
  isAutoSelect: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: false,
    meta: {
      description: 'When true, EMS TMS layer mirrors the Kibana theme, displaying light basemap tiles with light theme and dark basemap tiles with dark theme.'
    }
  })),
  lightModeDefault: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'BWC flag to preserve auto selected bright basemap tiles for maps created before 8.0.'
    }
  }))
}, {
  meta: {
    description: 'Basemap from Elastic Maps Service (EMS) Tile Map Service (TMS).'
  },
  unknowns: 'forbid'
});
const kibanaTilemapSourceSchema = exports.kibanaTilemapSourceSchema = _configSchema.schema.object({
  type: _configSchema.schema.literal(_common.SOURCE_TYPES.KIBANA_TILEMAP)
}, {
  meta: {
    description: `Tile map service configured by 'map.tilemap.url' kibana.yml setting.`
  },
  unknowns: 'forbid'
});
const WMSSourceSchema = exports.WMSSourceSchema = _configSchema.schema.object({
  serviceUrl: _configSchema.schema.uri({
    meta: {
      description: 'WMS URL'
    }
  }),
  layers: _configSchema.schema.string({
    meta: {
      description: 'Comma separated list of layer names'
    }
  }),
  styles: _configSchema.schema.string({
    meta: {
      description: 'Comma separated list of style names'
    }
  }),
  type: _configSchema.schema.literal(_common.SOURCE_TYPES.WMS)
}, {
  meta: {
    description: 'Raster source from Web Map Service (WMS)'
  },
  unknowns: 'forbid'
});
const XYZTMSSourceSchema = exports.XYZTMSSourceSchema = _configSchema.schema.object({
  urlTemplate: _configSchema.schema.uri({
    meta: {
      description: 'TMS URL'
    }
  }),
  type: _configSchema.schema.literal(_common.SOURCE_TYPES.EMS_XYZ)
}, {
  meta: {
    description: 'Raster source from Tile Map Service (TMS)'
  },
  unknowns: 'forbid'
});
const MVTFieldSchema = exports.MVTFieldSchema = _configSchema.schema.object({
  name: _configSchema.schema.string(),
  type: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.MVT_FIELD_TYPE.NUMBER), _configSchema.schema.literal(_constants.MVT_FIELD_TYPE.STRING)])
});
const TiledSingleLayerVectorSourceSchema = exports.TiledSingleLayerVectorSourceSchema = _configSchema.schema.object({
  fields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(MVTFieldSchema)),
  layerName: _configSchema.schema.string({
    meta: {
      description: 'source layer name'
    }
  }),
  maxSourceZoom: _configSchema.schema.maybe(_configSchema.schema.number({
    max: 24,
    min: 0,
    defaultValue: 24,
    meta: {
      description: 'Maximum zoom levels of the availability of the a particular layerName in the tileset at urlTemplate.'
    }
  })),
  minSourceZoom: _configSchema.schema.number({
    max: 24,
    min: 0,
    defaultValue: 0,
    meta: {
      description: 'Minimum zoom levels of the availability of the a particular layerName in the tileset at urlTemplate.'
    }
  }),
  urlTemplate: _configSchema.schema.uri({
    meta: {
      description: 'MVT URL'
    }
  }),
  tooltipProperties: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    meta: {
      description: 'Vector feature properties displayed in tooltip.'
    }
  })),
  type: _configSchema.schema.literal(_common.SOURCE_TYPES.MVT_SINGLE_LAYER)
}, {
  meta: {
    description: 'Vector tile source that displays a single source layer'
  },
  unknowns: 'forbid'
});
const sourceSchema = exports.sourceSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  type: _configSchema.schema.string()
}, {
  unknowns: 'allow'
}), EMSFileSourceSchema, EMSTMSSourceSchema, kibanaTilemapSourceSchema, WMSSourceSchema, XYZTMSSourceSchema, TiledSingleLayerVectorSourceSchema, _es_agg_source_schemas.ESGeoGridSourceSchema, _es_agg_source_schemas.ESGeoLineSourceSchema, _es_agg_source_schemas.ESPewPewSourceSchema, _es_source_schemas.ESSearchSourceSchema, _es_source_schemas.ESQLSourceSchema]);