"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAddMapPanelAction = getAddMapPanelAction;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/embeddable-plugin/public");
var _maps_vis_type_alias = require("../maps_vis_type_alias");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAddMapPanelAction(deps) {
  return {
    id: 'addMapPanelAction',
    getIconType: () => _maps_vis_type_alias.mapsVisTypeAlias.icon,
    order: _maps_vis_type_alias.mapsVisTypeAlias.order,
    isCompatible: async () => true,
    execute: async ({
      embeddable
    }) => {
      var _embeddable$getAppCon, _embeddable$getAppCon2;
      const stateTransferService = deps.embeddable.getStateTransfer();
      stateTransferService.navigateToEditor(_maps_vis_type_alias.mapsVisTypeAlias.alias.app, {
        path: _maps_vis_type_alias.mapsVisTypeAlias.alias.path,
        state: {
          originatingApp: (0, _presentationPublishing.apiHasAppContext)(embeddable) ? embeddable.getAppContext().currentAppId : '',
          originatingPath: (0, _presentationPublishing.apiHasAppContext)(embeddable) ? (_embeddable$getAppCon = (_embeddable$getAppCon2 = embeddable.getAppContext()).getCurrentPath) === null || _embeddable$getAppCon === void 0 ? void 0 : _embeddable$getAppCon.call(_embeddable$getAppCon2) : undefined,
          searchSessionId: deps.data.search.session.getSessionId()
        }
      });
    },
    grouping: [_public.ADD_PANEL_VISUALIZATION_GROUP],
    getDisplayName: () => _maps_vis_type_alias.mapsVisTypeAlias.title,
    getDisplayNameTooltip: () => _maps_vis_type_alias.mapsVisTypeAlias.description
  };
}