"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_MAP_STORE_STATE = void 0;
exports.createMapStore = createMapStore;
var _redux = require("redux");
var _reduxThunk = _interopRequireDefault(require("redux-thunk"));
var _ui = require("./ui");
var _map = require("./map");
var _non_serializable_instances = require("./non_serializable_instances");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-line import/named

const DEFAULT_MAP_STORE_STATE = exports.DEFAULT_MAP_STORE_STATE = {
  ui: {
    ..._ui.DEFAULT_MAP_UI_STATE
  },
  map: {
    ..._map.DEFAULT_MAP_STATE
  },
  nonSerializableInstances: {}
};
function createMapStore() {
  const enhancers = [(0, _redux.applyMiddleware)(_reduxThunk.default)];
  const combinedReducers = (0, _redux.combineReducers)({
    map: _map.map,
    ui: _ui.ui,
    nonSerializableInstances: _non_serializable_instances.nonSerializableInstances
  });
  const storeConfig = {};
  const composeEnhancers = window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ || _redux.compose;
  return (0, _redux.createStore)(combinedReducers, storeConfig, composeEnhancers(...enhancers));
}