"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVisualization = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _public = require("@kbn/lens-plugin/public");
var _chartIcons = require("@kbn/chart-icons");
var _suggestions_lazy = require("./suggestions_lazy");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/lens/choropleth_chart/visualization.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const REGION_KEY_GROUP_ID = 'region_key';
const METRIC_GROUP_ID = 'metric';
const CHART_LABEL = _i18n.i18n.translate('xpack.maps.lens.choropleth.label', {
  defaultMessage: 'Region map'
});
const getVisualization = ({
  paletteService,
  theme
}) => ({
  id: 'lnsChoropleth',
  getVisualizationTypeId() {
    return this.id;
  },
  visualizationTypes: [{
    id: 'lnsChoropleth',
    icon: _chartIcons.IconRegionMap,
    label: CHART_LABEL,
    sortPriority: 10,
    description: _i18n.i18n.translate('xpack.maps.regionMap.visualizationDescription', {
      defaultMessage: 'Show geographic data using colored regions.'
    })
  }],
  clearLayer(state) {
    const newState = {
      ...state
    };
    delete newState.emsLayerId;
    delete newState.emsField;
    delete newState.regionAccessor;
    delete newState.valueAccessor;
    return newState;
  },
  getLayerIds(state) {
    return [state.layerId];
  },
  getDescription() {
    return {
      icon: _chartIcons.IconRegionMap,
      label: CHART_LABEL
    };
  },
  getSuggestions(suggestionRequest) {
    return (0, _suggestions_lazy.getSuggestionsLazy)(suggestionRequest);
  },
  initialize(addNewLayer, state) {
    return state || {
      layerId: addNewLayer(),
      layerType: _public.layerTypes.DATA
    };
  },
  getConfiguration({
    state
  }) {
    return {
      groups: [{
        groupId: REGION_KEY_GROUP_ID,
        groupLabel: _i18n.i18n.translate('xpack.maps.lens.choroplethChart.regionKeyLabel', {
          defaultMessage: 'Region key'
        }),
        layerId: state.layerId,
        accessors: state.regionAccessor ? [{
          columnId: state.regionAccessor
        }] : [],
        supportsMoreColumns: !state.regionAccessor,
        filterOperations: op => op.isBucketed && op.dataType === 'string',
        enableDimensionEditor: true,
        requiredMinDimensionCount: 1,
        dataTestSubj: 'lnsChoropleth_regionKeyDimensionPanel'
      }, {
        groupId: METRIC_GROUP_ID,
        groupLabel: _i18n.i18n.translate('xpack.maps.lens.choroplethChart.metricValueLabel', {
          defaultMessage: 'Metric'
        }),
        layerId: state.layerId,
        accessors: state.valueAccessor ? [{
          columnId: state.valueAccessor
        }] : [],
        supportsMoreColumns: !state.valueAccessor,
        filterOperations: op => !op.isBucketed && op.dataType === 'number',
        enableDimensionEditor: true,
        isMetricDimension: true,
        requiredMinDimensionCount: 1,
        dataTestSubj: 'lnsChoropleth_valueDimensionPanel'
      }]
    };
  },
  getSupportedLayers() {
    return [{
      type: _public.layerTypes.DATA,
      label: _i18n.i18n.translate('xpack.maps.lens.choroplethChart.addLayer', {
        defaultMessage: 'Add visualization layer'
      })
    }];
  },
  getLayerType(layerId, state) {
    if ((state === null || state === void 0 ? void 0 : state.layerId) === layerId) {
      return _public.layerTypes.DATA;
    }
  },
  toExpression: (state, datasourceLayers, attributes, datasourceExpressionsByLayers = {}) => {
    if (!state.regionAccessor || !state.valueAccessor) {
      return null;
    }
    const datasourceExpression = datasourceExpressionsByLayers[state.layerId];
    return {
      type: 'expression',
      chain: [...(datasourceExpression ? datasourceExpression.chain : []), {
        type: 'function',
        function: 'lens_choropleth_chart',
        arguments: {
          title: [(attributes === null || attributes === void 0 ? void 0 : attributes.title) || ''],
          layerId: [state.layerId],
          emsField: state.emsField ? [state.emsField] : [],
          emsLayerId: state.emsLayerId ? [state.emsLayerId] : [],
          regionAccessor: [state.regionAccessor],
          valueAccessor: [state.valueAccessor]
        }
      }]
    };
  },
  toPreviewExpression: (state, datasourceLayers) => {
    return null;
  },
  setDimension({
    columnId,
    groupId,
    prevState
  }) {
    const update = {};
    if (groupId === REGION_KEY_GROUP_ID) {
      update.regionAccessor = columnId;
    } else if (groupId === METRIC_GROUP_ID) {
      update.valueAccessor = columnId;
    }
    return {
      ...prevState,
      ...update
    };
  },
  removeDimension({
    prevState,
    layerId,
    columnId
  }) {
    const update = {
      ...prevState
    };
    if (prevState.regionAccessor === columnId) {
      delete update.regionAccessor;
      delete update.emsLayerId;
      delete update.emsField;
    } else if (prevState.valueAccessor === columnId) {
      delete update.valueAccessor;
    }
    return update;
  },
  DimensionEditorComponent(props) {
    if (props.groupId === REGION_KEY_GROUP_ID) {
      const DimensionEditor = (0, _sharedUxUtility.dynamic)(async () => {
        const {
          RegionKeyEditor
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./region_key_editor')));
        return {
          default: RegionKeyEditor
        };
      });
      return /*#__PURE__*/_react.default.createElement(DimensionEditor, {
        state: props.state,
        setState: props.setState,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 14
        }
      });
    }
    return null;
  }
});
exports.getVisualization = getVisualization;