"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toExpressionAst = void 0;
var _public = require("@kbn/expressions-plugin/public");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toExpressionAst = vis => {
  const regionMap = (0, _public.buildExpressionFunction)('regionmap', {
    visConfig: JSON.stringify({
      ...vis.params,
      mapCenter: vis.uiState.get('mapCenter', [0, 0]),
      mapZoom: parseInt(vis.uiState.get('mapZoom', 2), 10),
      layerDescriptorParams: (0, _utils.extractLayerDescriptorParams)(vis)
    })
  });
  const ast = (0, _public.buildExpression)([regionMap]);
  return ast.toAst();
};
exports.toExpressionAst = toExpressionAst;