"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAggregatableGeoFieldTypes = getAggregatableGeoFieldTypes;
exports.getFieldsWithGeoTileAgg = getFieldsWithGeoTileAgg;
exports.getGeoFields = getGeoFields;
exports.getGeoPointFields = getGeoPointFields;
exports.getGeoTileAggNotSupportedReason = getGeoTileAggNotSupportedReason;
exports.getIndexPatternsFromIds = getIndexPatternsFromIds;
exports.getIsTimeseries = getIsTimeseries;
exports.getSortFields = getSortFields;
exports.getSourceFields = getSourceFields;
exports.getTermsFields = getTermsFields;
exports.supportsGeoTileAgg = supportsGeoTileAgg;
var _i18n = require("@kbn/i18n");
var _std = require("@kbn/std");
var _public = require("@kbn/data-plugin/public");
var _kibana_services = require("./kibana_services");
var _constants = require("../common/constants");
var _licensed_features = require("./licensed_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getIsTimeseries(dataView) {
  return dataView.fields.some(field => {
    return field.timeSeriesDimension || field.timeSeriesMetric;
  });
}
function getGeoTileAggNotSupportedReason(field) {
  if (!field.aggregatable) {
    return _i18n.i18n.translate('xpack.maps.geoTileAgg.disabled.docValues', {
      defaultMessage: 'Clustering requires aggregations. Enable aggregations by setting doc_values to true.'
    });
  }
  if (field.type === _constants.ES_GEO_FIELD_TYPE.GEO_SHAPE && !(0, _licensed_features.getIsGoldPlus)()) {
    return _i18n.i18n.translate('xpack.maps.geoTileAgg.disabled.license', {
      defaultMessage: 'Geo_shape clustering requires a Gold license.'
    });
  }
  return null;
}
async function getIndexPatternsFromIds(indexPatternIds = []) {
  const results = await (0, _std.asyncMap)(indexPatternIds, async indexPatternId => {
    try {
      return await (0, _kibana_services.getIndexPatternService)().get(indexPatternId);
    } catch (error) {
      // Unable to load index pattern, better to not throw error so map can render
      // Error will be surfaced by layer since it too will be unable to locate the index pattern
      return null;
    }
  });
  return results.filter(r => r !== null);
}
function getTermsFields(fields) {
  return fields.filter(field => {
    return field.aggregatable && !_public.indexPatterns.isNestedField(field) && ['number', 'boolean', 'date', 'ip', 'string'].includes(field.type);
  });
}
function getSortFields(fields) {
  return fields.filter(field => {
    return field.sortable && !_public.indexPatterns.isNestedField(field);
  });
}
function getAggregatableGeoFieldTypes() {
  const aggregatableFieldTypes = [_constants.ES_GEO_FIELD_TYPE.GEO_POINT];
  if ((0, _licensed_features.getIsGoldPlus)()) {
    aggregatableFieldTypes.push(_constants.ES_GEO_FIELD_TYPE.GEO_SHAPE);
  }
  return aggregatableFieldTypes;
}
function getGeoFields(fields) {
  return fields.filter(field => {
    return !_public.indexPatterns.isNestedField(field) && _constants.ES_GEO_FIELD_TYPES.includes(field.type);
  });
}
function getGeoPointFields(fields) {
  return fields.filter(field => {
    return !_public.indexPatterns.isNestedField(field) && _constants.ES_GEO_FIELD_TYPE.GEO_POINT === field.type;
  });
}
function getFieldsWithGeoTileAgg(fields) {
  return fields.filter(supportsGeoTileAgg);
}
function supportsGeoTileAgg(field) {
  return !!field && !!field.aggregatable && !_public.indexPatterns.isNestedField(field) && getAggregatableGeoFieldTypes().includes(field.type);
}
function getSourceFields(fields) {
  return fields.filter(field => {
    // Multi fields are not stored in _source and only exist in index.
    return !field.isSubtypeMulti() && !field.isSubtypeNested();
  });
}