"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidatedNumberInput = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = _interopRequireDefault(require("lodash"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/components/validated_number_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getErrorMessage(min, max) {
  return _i18n.i18n.translate('xpack.maps.validatedNumberInput.invalidClampErrorMessage', {
    defaultMessage: 'Must be between {min} and {max}',
    values: {
      min,
      max
    }
  });
}
function isNumberValid(value, min, max) {
  const parsedValue = parseFloat(value.toString());
  if (isNaN(parsedValue)) {
    return {
      isValid: false,
      errorMessage: getErrorMessage(min, max)
    };
  }
  const isValid = parsedValue >= min && parsedValue <= max;
  return {
    parsedValue,
    isValid,
    errorMessage: isValid ? '' : getErrorMessage(min, max)
  };
}
class ValidatedNumberInput extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_submit", _lodash.default.debounce(value => {
      this.props.onChange(value);
    }, 250));
    (0, _defineProperty2.default)(this, "_onChange", e => {
      const value = e.target.value;
      const {
        isValid,
        errorMessage,
        parsedValue
      } = isNumberValid(value, this.props.min, this.props.max);
      this.setState({
        value,
        errorMessage,
        isValid
      });
      if (isValid) {
        this._submit(parsedValue);
      }
    });
    const {
      isValid: _isValid,
      errorMessage: _errorMessage
    } = isNumberValid(props.initialValue, this.props.min, this.props.max);
    this.state = {
      value: props.initialValue,
      errorMessage: _errorMessage,
      isValid: _isValid
    };
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: this.props.label,
      isInvalid: !this.state.isValid,
      error: this.state.errorMessage ? [this.state.errorMessage] : [],
      display: this.props.display,
      helpText: this.props.helpText,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      isInvalid: !this.state.isValid,
      min: this.props.min,
      max: this.props.max,
      value: this.state.value,
      onChange: this._onChange,
      "aria-label": `${this.props.label} number input`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 9
      }
    }));
  }
}
exports.ValidatedNumberInput = ValidatedNumberInput;