"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VectorStyle = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _vector_style_editor = require("./components/vector_style_editor");
var _vector_style_defaults = require("./vector_style_defaults");
var _constants = require("../../../../common/constants");
var _style_meta = require("./style_meta");
var _symbol_utils = require("./symbol_utils");
var _vector_icon = require("./components/legend/vector_icon");
var _vector_style_legend = require("./components/legend/vector_style_legend");
var _style_util = require("./style_util");
var _static_style_property = require("./properties/static_style_property");
var _dynamic_style_property = require("./properties/dynamic_style_property");
var _dynamic_size_property = require("./properties/dynamic_size_property");
var _static_size_property = require("./properties/static_size_property");
var _static_color_property = require("./properties/static_color_property");
var _dynamic_color_property = require("./properties/dynamic_color_property");
var _static_orientation_property = require("./properties/static_orientation_property");
var _dynamic_orientation_property = require("./properties/dynamic_orientation_property");
var _static_text_property = require("./properties/static_text_property");
var _dynamic_text_property = require("./properties/dynamic_text_property");
var _label_zoom_range_property = require("./properties/label_zoom_range_property");
var _label_border_size_property = require("./properties/label_border_size_property");
var _label_position_property = require("./properties/label_position_property");
var _extract_color_from_style_property = require("./components/legend/extract_color_from_style_property");
var _symbolize_as_property = require("./properties/symbolize_as_property");
var _static_icon_property = require("./properties/static_icon_property");
var _dynamic_icon_property = require("./properties/dynamic_icon_property");
var _style_fields_helper = require("./style_fields_helper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/vector_style.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class VectorStyle {
  static createDescriptor(properties = {}, isTimeAware = true) {
    return {
      type: _constants.LAYER_STYLE_TYPE.VECTOR,
      properties: {
        ...(0, _vector_style_defaults.getDefaultStaticProperties)(),
        ...properties
      },
      isTimeAware
    };
  }
  static createDefaultStyleProperties(mapColors) {
    return (0, _vector_style_defaults.getDefaultStaticProperties)(mapColors);
  }
  constructor(descriptor, source, layer, customIcons, chartsPaletteServiceGetColor) {
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    (0, _defineProperty2.default)(this, "_layer", void 0);
    (0, _defineProperty2.default)(this, "_customIcons", void 0);
    (0, _defineProperty2.default)(this, "_source", void 0);
    (0, _defineProperty2.default)(this, "_styleMeta", void 0);
    (0, _defineProperty2.default)(this, "_symbolizeAs", void 0);
    (0, _defineProperty2.default)(this, "_lineColor", void 0);
    (0, _defineProperty2.default)(this, "_fillColor", void 0);
    (0, _defineProperty2.default)(this, "_lineWidth", void 0);
    (0, _defineProperty2.default)(this, "_icon", void 0);
    (0, _defineProperty2.default)(this, "_iconSize", void 0);
    (0, _defineProperty2.default)(this, "_iconOrientation", void 0);
    (0, _defineProperty2.default)(this, "_label", void 0);
    (0, _defineProperty2.default)(this, "_labelZoomRange", void 0);
    (0, _defineProperty2.default)(this, "_labelSize", void 0);
    (0, _defineProperty2.default)(this, "_labelColor", void 0);
    (0, _defineProperty2.default)(this, "_labelBorderColor", void 0);
    (0, _defineProperty2.default)(this, "_labelBorderSize", void 0);
    (0, _defineProperty2.default)(this, "_labelPosition", void 0);
    (0, _defineProperty2.default)(this, "getIsPointsOnly", () => {
      return this._styleMeta.isPointsOnly();
    });
    (0, _defineProperty2.default)(this, "_getIsLinesOnly", () => {
      return this._styleMeta.isLinesOnly();
    });
    (0, _defineProperty2.default)(this, "_getIsPolygonsOnly", () => {
      return this._styleMeta.isPolygonsOnly();
    });
    (0, _defineProperty2.default)(this, "_getFieldFormatter", fieldName => {
      const dynamicProp = this._getDynamicPropertyByFieldName(fieldName);
      if (!dynamicProp) {
        return null;
      }
      let dataRequestId;
      if (dynamicProp.getFieldOrigin() === _constants.FIELD_ORIGIN.SOURCE) {
        dataRequestId = _constants.SOURCE_FORMATTERS_DATA_REQUEST_ID;
      } else {
        const targetJoin = this._layer.getValidJoins().find(join => {
          return !!join.getRightJoinSource().getFieldByName(fieldName);
        });
        if (targetJoin) {
          dataRequestId = targetJoin.getSourceFormattersDataRequestId();
        }
      }
      if (!dataRequestId) {
        return null;
      }
      const formattersDataRequest = this._layer.getDataRequest(dataRequestId);
      if (!formattersDataRequest || !formattersDataRequest.hasData()) {
        return null;
      }
      const formatters = formattersDataRequest.getData();
      // @ts-expect-error
      return formatters ? formatters[fieldName] : null;
    });
    (0, _defineProperty2.default)(this, "_getLegendDetailStyleProperties", () => {
      const hasLabels = this.hasLabels();
      return this.getDynamicPropertiesArray().filter(styleProperty => {
        const styleName = styleProperty.getStyleName();
        if ([_constants.VECTOR_STYLES.ICON_ORIENTATION, _constants.VECTOR_STYLES.LABEL_TEXT].includes(styleName)) {
          return false;
        }
        if (!hasLabels && _vector_style_defaults.LABEL_STYLES.includes(styleName)) {
          // do not render legend for label styles when there is no label
          return false;
        }
        if (this._getIsLinesOnly()) {
          return _vector_style_defaults.LINE_STYLES.includes(styleName);
        }
        if (this._getIsPolygonsOnly()) {
          return _vector_style_defaults.POLYGON_STYLES.includes(styleName);
        }
        return true;
      });
    });
    this._source = source;
    this._layer = layer;
    this._customIcons = customIcons;
    this._descriptor = descriptor ? {
      ...descriptor,
      ...VectorStyle.createDescriptor(descriptor.properties, descriptor.isTimeAware)
    } : VectorStyle.createDescriptor();
    this._styleMeta = new _style_meta.StyleMeta(this._descriptor.__styleMeta);
    this._symbolizeAs = new _symbolize_as_property.SymbolizeAsProperty(this._descriptor.properties[_constants.VECTOR_STYLES.SYMBOLIZE_AS].options, _constants.VECTOR_STYLES.SYMBOLIZE_AS);
    this._lineColor = this._makeColorProperty(this._descriptor.properties[_constants.VECTOR_STYLES.LINE_COLOR], _constants.VECTOR_STYLES.LINE_COLOR, chartsPaletteServiceGetColor);
    this._fillColor = this._makeColorProperty(this._descriptor.properties[_constants.VECTOR_STYLES.FILL_COLOR], _constants.VECTOR_STYLES.FILL_COLOR, chartsPaletteServiceGetColor);
    this._lineWidth = this._makeSizeProperty(this._descriptor.properties[_constants.VECTOR_STYLES.LINE_WIDTH], _constants.VECTOR_STYLES.LINE_WIDTH, this._symbolizeAs.isSymbolizedAsIcon());
    this._icon = this._makeIconProperty(this._descriptor.properties[_constants.VECTOR_STYLES.ICON]);
    this._iconSize = this._makeSizeProperty(this._descriptor.properties[_constants.VECTOR_STYLES.ICON_SIZE], _constants.VECTOR_STYLES.ICON_SIZE, this._symbolizeAs.isSymbolizedAsIcon());
    this._iconOrientation = this._makeOrientationProperty(this._descriptor.properties[_constants.VECTOR_STYLES.ICON_ORIENTATION], _constants.VECTOR_STYLES.ICON_ORIENTATION);
    this._label = this._makeLabelProperty(this._descriptor.properties[_constants.VECTOR_STYLES.LABEL_TEXT]);
    this._labelZoomRange = new _label_zoom_range_property.LabelZoomRangeProperty(this._descriptor.properties[_constants.VECTOR_STYLES.LABEL_ZOOM_RANGE].options, _constants.VECTOR_STYLES.LABEL_ZOOM_RANGE, layer.getMinZoom(), layer.getMaxZoom());
    this._labelSize = this._makeSizeProperty(this._descriptor.properties[_constants.VECTOR_STYLES.LABEL_SIZE], _constants.VECTOR_STYLES.LABEL_SIZE, this._symbolizeAs.isSymbolizedAsIcon());
    this._labelColor = this._makeColorProperty(this._descriptor.properties[_constants.VECTOR_STYLES.LABEL_COLOR], _constants.VECTOR_STYLES.LABEL_COLOR, chartsPaletteServiceGetColor);
    this._labelBorderColor = this._makeColorProperty(this._descriptor.properties[_constants.VECTOR_STYLES.LABEL_BORDER_COLOR], _constants.VECTOR_STYLES.LABEL_BORDER_COLOR, chartsPaletteServiceGetColor);
    this._labelBorderSize = new _label_border_size_property.LabelBorderSizeProperty(this._descriptor.properties[_constants.VECTOR_STYLES.LABEL_BORDER_SIZE].options, _constants.VECTOR_STYLES.LABEL_BORDER_SIZE, this._labelSize);
    this._labelPosition = new _label_position_property.LabelPositionProperty(this._descriptor.properties[_constants.VECTOR_STYLES.LABEL_POSITION].options, _constants.VECTOR_STYLES.LABEL_POSITION, this._icon, this._iconSize, this._labelSize, this._symbolizeAs.isSymbolizedAsIcon());
  }
  async _updateFieldsInDescriptor(nextFields, styleFieldsHelper, previousFields, mapColors) {
    const originalProperties = this.getPropertiesDescriptor();
    const invalidStyleNames = Object.keys(originalProperties).filter(key => {
      const dynamicOptions = getDynamicOptions(originalProperties, key);
      if (!dynamicOptions || !dynamicOptions.field || !dynamicOptions.field.name) {
        return false;
      }
      const hasMatchingField = nextFields.some(field => {
        return dynamicOptions && dynamicOptions.field && dynamicOptions.field.name === field.getName();
      });
      return !hasMatchingField;
    });
    let hasChanges = false;
    const updatedProperties = {
      ...originalProperties
    };
    invalidStyleNames.forEach(invalidStyleName => {
      for (let i = 0; i < previousFields.length; i++) {
        const previousField = previousFields[i];
        const nextField = nextFields[i];
        if (previousField.isEqual(nextField)) {
          continue;
        }
        const isFieldDataTypeCompatible = styleFieldsHelper.hasFieldForStyle(nextField, invalidStyleName);
        if (!isFieldDataTypeCompatible) {
          return;
        }
        hasChanges = true;
        updatedProperties[invalidStyleName] = {
          type: _constants.STYLE_TYPE.DYNAMIC,
          options: {
            ...originalProperties[invalidStyleName].options,
            field: rectifyFieldDescriptor(nextField, {
              origin: previousField.getOrigin(),
              name: previousField.getName()
            })
          }
        };
      }
    });
    return this._deleteFieldsFromDescriptorAndUpdateStyling(updatedProperties, hasChanges, styleFieldsHelper, mapColors);
  }
  async _deleteFieldsFromDescriptorAndUpdateStyling(originalProperties, hasChanges, styleFieldsHelper, mapColors) {
    const updatedProperties = {};
    const dynamicProperties = Object.keys(originalProperties).filter(key => {
      const dynamicOptions = getDynamicOptions(originalProperties, key);
      return dynamicOptions && dynamicOptions.field && dynamicOptions.field.name;
    });
    dynamicProperties.forEach(key => {
      var _field;
      // TODO instead of looking up instance by key, update argument originalProperties to be instances instead of descriptors
      const styleProperty = this.getAllStyleProperties().find(property => {
        return property.getStyleName() === key;
      });
      if (!styleProperty) {
        return;
      }
      const nextStyleFields = styleFieldsHelper.getFieldsForStyle(styleProperty, this._layer.getSource().isMvt()).filter(styleField => {
        return !styleField.isUnsupported;
      });

      // Convert dynamic styling to static stying when there are no style fields
      if (nextStyleFields.length === 0) {
        const staticProperties = (0, _vector_style_defaults.getDefaultStaticProperties)(mapColors);
        updatedProperties[key] = staticProperties[key];
        return;
      }
      const dynamicProperty = originalProperties[key];
      if (!dynamicProperty || !dynamicProperty.options) {
        return;
      }
      const fieldName = (_field = dynamicProperty.options.field) === null || _field === void 0 ? void 0 : _field.name;
      if (!fieldName) {
        return;
      }
      const fieldStillExists = nextStyleFields.some(nextStyleField => {
        return fieldName === nextStyleField.name;
      });
      if (fieldStillExists) {
        return;
      }
      updatedProperties[key] = {
        type: _dynamic_style_property.DynamicStyleProperty.type,
        options: {
          ...originalProperties[key].options
        }
      };
      if ('field' in updatedProperties[key].options) {
        delete updatedProperties[key].options.field;
      }
    });
    if (Object.keys(updatedProperties).length !== 0) {
      return {
        hasChanges: true,
        nextStyleDescriptor: VectorStyle.createDescriptor({
          ...originalProperties,
          ...updatedProperties
        }, this.isTimeAware())
      };
    } else {
      return {
        hasChanges,
        nextStyleDescriptor: VectorStyle.createDescriptor({
          ...originalProperties
        }, this.isTimeAware())
      };
    }
  }
  async getDescriptorWithUpdatedStyleProps(nextFields, mapColors, previousFields) {
    const styleFieldsHelper = await (0, _style_fields_helper.createStyleFieldsHelper)(nextFields);
    return previousFields && previousFields.length === nextFields.length ?
    // Field-config changed
    await this._updateFieldsInDescriptor(nextFields, styleFieldsHelper, previousFields, mapColors) :
    // Deletions or additions
    await this._deleteFieldsFromDescriptorAndUpdateStyling(this.getPropertiesDescriptor(), false, styleFieldsHelper, mapColors);
  }
  getType() {
    return _constants.LAYER_STYLE_TYPE.VECTOR;
  }
  getAllStyleProperties() {
    return [this._symbolizeAs, this._icon, this._lineColor, this._fillColor, this._lineWidth, this._iconSize, this._iconOrientation, this._label, this._labelZoomRange, this._labelSize, this._labelColor, this._labelBorderColor, this._labelBorderSize, this._labelPosition];
  }
  _hasBorder() {
    return this._lineWidth.isDynamic() ? this._lineWidth.isComplete() : this._lineWidth.getOptions().size !== 0;
  }
  renderEditor(onStyleDescriptorChange, onCustomIconsChange) {
    const rawProperties = this.getPropertiesDescriptor();
    const handlePropertyChange = (propertyName, stylePropertyDescriptor) => {
      rawProperties[propertyName] = stylePropertyDescriptor; // override single property, but preserve the rest
      const vectorStyleDescriptor = VectorStyle.createDescriptor(rawProperties, this.isTimeAware());
      onStyleDescriptorChange(vectorStyleDescriptor);
    };
    const onIsTimeAwareChange = isTimeAware => {
      const vectorStyleDescriptor = VectorStyle.createDescriptor(rawProperties, isTimeAware);
      onStyleDescriptorChange(vectorStyleDescriptor);
    };
    const propertiesWithFieldMeta = this.getDynamicPropertiesArray().filter(dynamicStyleProp => {
      return dynamicStyleProp.isFieldMetaEnabled();
    });
    const styleProperties = {};
    this.getAllStyleProperties().forEach(styleProperty => {
      styleProperties[styleProperty.getStyleName()] = styleProperty;
    });
    return /*#__PURE__*/_react.default.createElement(_vector_style_editor.VectorStyleEditor, {
      handlePropertyChange: handlePropertyChange,
      styleProperties: styleProperties,
      layer: this._layer,
      isPointsOnly: this.getIsPointsOnly(),
      isLinesOnly: this._getIsLinesOnly(),
      onIsTimeAwareChange: onIsTimeAwareChange,
      onCustomIconsChange: onCustomIconsChange,
      isTimeAware: this.isTimeAware(),
      showIsTimeAware: propertiesWithFieldMeta.length > 0,
      customIcons: this._customIcons,
      hasBorder: this._hasBorder(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 527,
        columnNumber: 7
      }
    });
  }
  getSourceFieldNames() {
    const fieldNames = [];
    this.getDynamicPropertiesArray().forEach(styleProperty => {
      if (styleProperty.getFieldOrigin() === _constants.FIELD_ORIGIN.SOURCE) {
        fieldNames.push(styleProperty.getFieldName());
      }
    });
    return fieldNames;
  }
  isTimeAware() {
    var _this$_descriptor$isT;
    return (_this$_descriptor$isT = this._descriptor.isTimeAware) !== null && _this$_descriptor$isT !== void 0 ? _this$_descriptor$isT : true;
  }
  getPropertiesDescriptor() {
    return this._descriptor.properties;
  }
  getDynamicPropertiesArray() {
    const styleProperties = this.getAllStyleProperties();
    return styleProperties.filter(styleProperty => styleProperty.isDynamic() && styleProperty.isComplete());
  }
  _getDynamicPropertyByFieldName(fieldName) {
    const dynamicProps = this.getDynamicPropertiesArray();
    return dynamicProps.find(dynamicProp => {
      return fieldName === dynamicProp.getFieldName();
    });
  }
  getStyleMeta() {
    return this._styleMeta;
  }
  getIconSvg(symbolId) {
    const meta = this._getIconMeta(symbolId);
    return meta ? meta.svg : undefined;
  }
  _getSymbolId() {
    return this.arePointsSymbolizedAsCircles() || this._icon.isDynamic() ? undefined : this._icon.getOptions().value;
  }
  _getIconMeta(symbolId) {
    const icon = this._customIcons.find(({
      symbolId: value
    }) => value === symbolId);
    if (icon) {
      return {
        ...icon,
        iconSource: _constants.ICON_SOURCE.CUSTOM
      };
    }
    const symbol = (0, _symbol_utils.getMakiSymbol)(symbolId);
    return symbol ? {
      ...symbol,
      iconSource: _constants.ICON_SOURCE.MAKI
    } : undefined;
  }
  getPrimaryColor() {
    const primaryColorKey = this._getIsLinesOnly() ? _constants.VECTOR_STYLES.LINE_COLOR : _constants.VECTOR_STYLES.FILL_COLOR;
    return (0, _extract_color_from_style_property.extractColorFromStyleProperty)(this._descriptor.properties[primaryColorKey], 'grey');
  }
  getIcon(showIncompleteIndicator) {
    const isLinesOnly = this._getIsLinesOnly();
    const isPointsOnly = this.getIsPointsOnly();
    let strokeColor;
    if (isLinesOnly) {
      strokeColor = (0, _extract_color_from_style_property.extractColorFromStyleProperty)(this._descriptor.properties[_constants.VECTOR_STYLES.LINE_COLOR], 'grey');
    } else if (this._hasBorder()) {
      strokeColor = (0, _extract_color_from_style_property.extractColorFromStyleProperty)(this._descriptor.properties[_constants.VECTOR_STYLES.LINE_COLOR], 'none');
    }
    const fillColor = isLinesOnly ? undefined : (0, _extract_color_from_style_property.extractColorFromStyleProperty)(this._descriptor.properties[_constants.VECTOR_STYLES.FILL_COLOR], 'grey');
    const borderStyle = showIncompleteIndicator ? {
      borderColor: this.getPrimaryColor(),
      borderStyle: 'dashed',
      borderWidth: '1px'
    } : {};
    const symbolId = this._getSymbolId();
    const svg = symbolId ? this.getIconSvg(symbolId) : undefined;
    return /*#__PURE__*/_react.default.createElement(_vector_icon.VectorIcon, {
      borderStyle: borderStyle,
      isPointsOnly: isPointsOnly,
      isLinesOnly: isLinesOnly,
      strokeColor: strokeColor,
      fillColor: fillColor,
      symbolId: symbolId,
      svg: svg,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 687,
        columnNumber: 7
      }
    });
  }
  isUsingCustomIcon(symbolId) {
    if (this._icon.isDynamic()) {
      const {
        customIconStops
      } = this._icon.getOptions();
      return customIconStops ? customIconStops.some(({
        icon
      }) => icon === symbolId) : false;
    }
    const {
      value
    } = this._icon.getOptions();
    return value === symbolId;
  }
  async hasLegendDetails() {
    return this._source.hasLegendDetails && this._source.renderLegendDetails ? await this._source.hasLegendDetails() : this._getLegendDetailStyleProperties().length > 0;
  }
  renderLegendDetails() {
    const symbolId = this._getSymbolId();
    const svg = symbolId ? this.getIconSvg(symbolId) : undefined;
    return this._source.renderLegendDetails ? this._source.renderLegendDetails(this) : /*#__PURE__*/_react.default.createElement(_vector_style_legend.VectorStyleLegend, {
      masks: this._layer.getMasks(),
      styles: this._getLegendDetailStyleProperties(),
      isPointsOnly: this.getIsPointsOnly(),
      isLinesOnly: this._getIsLinesOnly(),
      symbolId: symbolId,
      svg: svg,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 746,
        columnNumber: 7
      }
    });
  }
  clearFeatureState(featureCollection, mbMap, sourceId) {
    const tmpFeatureIdentifier = {
      source: '',
      id: undefined
    };
    for (let i = 0; i < featureCollection.features.length; i++) {
      const feature = featureCollection.features[i];
      tmpFeatureIdentifier.source = sourceId;
      tmpFeatureIdentifier.id = feature.id;
      mbMap.removeFeatureState(tmpFeatureIdentifier);
    }
  }
  setFeatureStateAndStyleProps(featureCollection, mbMap, mbSourceId) {
    if (!featureCollection) {
      return false;
    }
    const dynamicStyleProps = this.getDynamicPropertiesArray();
    if (dynamicStyleProps.length === 0) {
      return false;
    }
    let shouldResetAllData = false;
    for (let j = 0; j < dynamicStyleProps.length; j++) {
      const dynamicStyleProp = dynamicStyleProps[j];
      const usedFeatureState = dynamicStyleProp.enrichGeoJsonAndMbFeatureState(featureCollection, mbMap, mbSourceId);
      if (!usedFeatureState) {
        shouldResetAllData = true;
      }
    }

    // returns boolean indicating if styles do not support feature-state and some values are stored in geojson properties
    // this return-value is used in an optimization for style-updates with mapbox-gl.
    // `true` indicates the entire data needs to reset on the source (otherwise the style-rules will not be reapplied)
    // `false` indicates the data does not need to be reset on the store, because styles are re-evaluated if they use featureState
    return shouldResetAllData;
  }
  arePointsSymbolizedAsCircles() {
    return !this._symbolizeAs.isSymbolizedAsIcon();
  }
  hasLabels() {
    return (0, _style_util.getHasLabel)(this._label);
  }
  setMBPaintProperties({
    alpha,
    mbMap,
    fillLayerId,
    lineLayerId
  }) {
    this._fillColor.syncFillColorWithMb(fillLayerId, mbMap, alpha);
    this._lineColor.syncLineColorWithMb(lineLayerId, mbMap, alpha);
    this._lineWidth.syncLineWidthWithMb(lineLayerId, mbMap);
  }
  setMBPaintPropertiesForPoints({
    alpha,
    mbMap,
    pointLayerId
  }) {
    this._fillColor.syncCircleColorWithMb(pointLayerId, mbMap, alpha);
    this._lineColor.syncCircleStrokeWithMb(pointLayerId, mbMap, alpha);
    const hasNoRadius = !this._iconSize.isDynamic() && this._iconSize.getOptions().size === 0;
    this._lineWidth.syncCircleStrokeWidthWithMb(pointLayerId, mbMap, hasNoRadius);
    this._iconSize.syncCircleRadiusWithMb(pointLayerId, mbMap);
  }
  setMBPropertiesForLabelText({
    alpha,
    mbMap,
    textLayerId
  }) {
    this._label.syncTextFieldWithMb(textLayerId, mbMap);
    this._labelZoomRange.syncLabelZoomRange(textLayerId, mbMap);
    this._labelColor.syncLabelColorWithMb(textLayerId, mbMap, alpha);
    this._labelSize.syncLabelSizeWithMb(textLayerId, mbMap);
    this._labelBorderSize.syncLabelBorderSizeWithMb(textLayerId, mbMap);
    this._labelPosition.syncLabelPositionWithMb(textLayerId, mbMap);
    this._labelBorderColor.syncLabelBorderColorWithMb(textLayerId, mbMap);
  }
  setMBSymbolPropertiesForPoints({
    mbMap,
    symbolLayerId,
    alpha
  }) {
    mbMap.setLayoutProperty(symbolLayerId, 'icon-ignore-placement', true);
    mbMap.setPaintProperty(symbolLayerId, 'icon-opacity', alpha);
    mbMap.setLayoutProperty(symbolLayerId, 'icon-allow-overlap', true);
    this._icon.syncIconWithMb(symbolLayerId, mbMap);
    // icon-color is only supported on SDF icons.
    this._fillColor.syncIconColorWithMb(symbolLayerId, mbMap);
    this._lineColor.syncHaloBorderColorWithMb(symbolLayerId, mbMap);
    this._lineWidth.syncHaloWidthWithMb(symbolLayerId, mbMap);
    this._iconSize.syncIconSizeWithMb(symbolLayerId, mbMap);
    this._iconOrientation.syncIconRotationWithMb(symbolLayerId, mbMap);
  }
  _makeField(fieldDescriptor) {
    if (!fieldDescriptor || !fieldDescriptor.name) {
      return null;
    }

    // fieldDescriptor.label is ignored. This is essentially cruft duplicating label-info from the metric-selection
    // Ignore this custom label
    if (fieldDescriptor.origin === _constants.FIELD_ORIGIN.SOURCE) {
      return this._source.getFieldByName(fieldDescriptor.name);
    } else if (fieldDescriptor.origin === _constants.FIELD_ORIGIN.JOIN) {
      const targetJoin = this._layer.getValidJoins().find(join => {
        return !!join.getRightJoinSource().getFieldByName(fieldDescriptor.name);
      });
      return targetJoin ? targetJoin.getRightJoinSource().getFieldByName(fieldDescriptor.name) : null;
    } else {
      throw new Error(`Unknown origin-type ${fieldDescriptor.origin}`);
    }
  }
  _makeSizeProperty(descriptor, styleName, isSymbolizedAsIcon) {
    if (!descriptor || !descriptor.options) {
      return new _static_size_property.StaticSizeProperty({
        size: 0
      }, styleName);
    } else if (descriptor.type === _static_style_property.StaticStyleProperty.type) {
      return new _static_size_property.StaticSizeProperty(descriptor.options, styleName);
    } else if (descriptor.type === _dynamic_style_property.DynamicStyleProperty.type) {
      const options = descriptor.options;
      const field = this._makeField(options.field);
      return new _dynamic_size_property.DynamicSizeProperty(options, styleName, field, this._layer, this._getFieldFormatter, isSymbolizedAsIcon);
    } else {
      throw new Error(`${descriptor} not implemented`);
    }
  }
  _makeColorProperty(descriptor, styleName, chartsPaletteServiceGetColor) {
    if (!descriptor || !descriptor.options) {
      return new _static_color_property.StaticColorProperty({
        color: ''
      }, styleName);
    } else if (descriptor.type === _static_style_property.StaticStyleProperty.type) {
      return new _static_color_property.StaticColorProperty(descriptor.options, styleName);
    } else if (descriptor.type === _dynamic_style_property.DynamicStyleProperty.type) {
      const options = descriptor.options;
      const field = this._makeField(options.field);
      return new _dynamic_color_property.DynamicColorProperty(options, styleName, field, this._layer, this._getFieldFormatter, chartsPaletteServiceGetColor);
    } else {
      throw new Error(`${descriptor} not implemented`);
    }
  }
  _makeOrientationProperty(descriptor, styleName) {
    if (!descriptor || !descriptor.options) {
      return new _static_orientation_property.StaticOrientationProperty({
        orientation: 0
      }, styleName);
    } else if (descriptor.type === _static_style_property.StaticStyleProperty.type) {
      return new _static_orientation_property.StaticOrientationProperty(descriptor.options, styleName);
    } else if (descriptor.type === _dynamic_style_property.DynamicStyleProperty.type) {
      const options = descriptor.options;
      const field = this._makeField(options.field);
      return new _dynamic_orientation_property.DynamicOrientationProperty(options, styleName, field, this._layer, this._getFieldFormatter);
    } else {
      throw new Error(`${descriptor} not implemented`);
    }
  }
  _makeLabelProperty(descriptor) {
    if (!descriptor || !descriptor.options) {
      return new _static_text_property.StaticTextProperty({
        value: ''
      }, _constants.VECTOR_STYLES.LABEL_TEXT);
    } else if (descriptor.type === _static_style_property.StaticStyleProperty.type) {
      return new _static_text_property.StaticTextProperty(descriptor.options, _constants.VECTOR_STYLES.LABEL_TEXT);
    } else if (descriptor.type === _dynamic_style_property.DynamicStyleProperty.type) {
      const options = descriptor.options;
      const field = this._makeField(options.field);
      return new _dynamic_text_property.DynamicTextProperty(options, _constants.VECTOR_STYLES.LABEL_TEXT, field, this._layer, this._getFieldFormatter);
    } else {
      throw new Error(`${descriptor} not implemented`);
    }
  }
  _makeIconProperty(descriptor) {
    if (!descriptor || !descriptor.options) {
      return new _static_icon_property.StaticIconProperty({
        value: _constants.DEFAULT_ICON
      }, _constants.VECTOR_STYLES.ICON);
    } else if (descriptor.type === _static_style_property.StaticStyleProperty.type) {
      const {
        value
      } = {
        ...descriptor.options
      };
      const meta = this._getIconMeta(value);
      let svg;
      let label;
      let iconSource;
      if (meta) {
        ({
          svg,
          label,
          iconSource
        } = meta);
      }
      return new _static_icon_property.StaticIconProperty({
        value,
        svg,
        label,
        iconSource
      }, _constants.VECTOR_STYLES.ICON);
    } else if (descriptor.type === _dynamic_style_property.DynamicStyleProperty.type) {
      const options = {
        ...descriptor.options
      };
      if (options.customIconStops) {
        options.customIconStops.forEach(iconStop => {
          const meta = this._getIconMeta(iconStop.icon);
          if (meta) {
            iconStop.iconSource = meta.iconSource;
          }
        });
      }
      const field = this._makeField(options.field);
      return new _dynamic_icon_property.DynamicIconProperty(options, _constants.VECTOR_STYLES.ICON, field, this._layer, this._getFieldFormatter);
    } else {
      throw new Error(`${descriptor} not implemented`);
    }
  }
}
exports.VectorStyle = VectorStyle;
function getDynamicOptions(originalProperties, key) {
  if (!originalProperties[key]) {
    return null;
  }
  const propertyDescriptor = originalProperties[key];
  if (!propertyDescriptor || !('type' in propertyDescriptor) || propertyDescriptor.type !== _constants.STYLE_TYPE.DYNAMIC || !propertyDescriptor.options) {
    return null;
  }
  return propertyDescriptor.options;
}
function rectifyFieldDescriptor(currentField, previousFieldDescriptor) {
  return {
    origin: previousFieldDescriptor.origin,
    name: currentField.getName()
  };
}