"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DynamicSizeProperty = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _dynamic_style_property = require("../dynamic_style_property");
var _size = require("../../components/legend/size");
var _style_util = require("../../style_util");
var _constants = require("../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/properties/dynamic_size_property/dynamic_size_property.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class DynamicSizeProperty extends _dynamic_style_property.DynamicStyleProperty {
  constructor(options, styleName, field, vectorLayer, getFieldFormatter, isSymbolizedAsIcon) {
    super(options, styleName, field, vectorLayer, getFieldFormatter);
    (0, _defineProperty2.default)(this, "_isSymbolizedAsIcon", void 0);
    this._isSymbolizedAsIcon = isSymbolizedAsIcon;
  }
  supportsFeatureState() {
    // mb style "icon-size" does not support feature state
    if (this.getStyleName() === _constants.VECTOR_STYLES.ICON_SIZE && this._isSymbolizedAsIcon) {
      return false;
    }

    // mb style "text-size" does not support feature state
    if (this.getStyleName() === _constants.VECTOR_STYLES.LABEL_SIZE) {
      return false;
    }
    return true;
  }
  syncHaloWidthWithMb(mbLayerId, mbMap) {
    mbMap.setPaintProperty(mbLayerId, 'icon-halo-width', this.getMbSizeExpression());
  }
  syncIconSizeWithMb(symbolLayerId, mbMap) {
    mbMap.setLayoutProperty(symbolLayerId, 'icon-size', this.getMbSizeExpression());
  }
  syncCircleStrokeWidthWithMb(mbLayerId, mbMap) {
    mbMap.setPaintProperty(mbLayerId, 'circle-stroke-width', this.getMbSizeExpression());
  }
  syncCircleRadiusWithMb(mbLayerId, mbMap) {
    mbMap.setPaintProperty(mbLayerId, 'circle-radius', this.getMbSizeExpression());
  }
  syncLineWidthWithMb(mbLayerId, mbMap) {
    mbMap.setPaintProperty(mbLayerId, 'line-width', this.getMbSizeExpression());
  }
  syncLabelSizeWithMb(mbLayerId, mbMap) {
    mbMap.setLayoutProperty(mbLayerId, 'text-size', this.getMbSizeExpression());
  }

  /*
   * Returns interpolation expression linearly translating domain values [minValue, maxValue] to display range [minSize, maxSize]
   */
  getMbSizeExpression(options) {
    const rangeFieldMeta = this.getRangeFieldMeta();
    if (!this.isSizeDynamicConfigComplete() || !rangeFieldMeta) {
      // return min of size to avoid flashing
      // returning minimum allows "growing" of the symbols when the meta comes in
      // A grow effect us less visually jarring as shrinking.
      // especially relevant when displaying fine-grained grids using mvt
      return this._options.minSize >= 0 ? this._options.minSize : null;
    }
    const isArea = this.getStyleName() === _constants.VECTOR_STYLES.ICON_SIZE;
    // isArea === true
    // It's a mistake to linearly map a data value to an area dimension (i.e. cirle radius).
    // Area squares area dimension ("pie * r * r" or "x * x"), visually distorting proportions.
    // Since it is the quadratic function that is causing this,
    // we need to counteract its effects by applying its inverse function — the square-root function.
    // https://bl.ocks.org/guilhermesimoes/e6356aa90a16163a6f917f53600a2b4a

    // can not take square root of 0 or negative number
    // shift values to be positive integers >= 1
    const valueShift = rangeFieldMeta.min < 1 ? Math.abs(rangeFieldMeta.min) + 1 : 0;
    const maxStopInput = isArea ? Math.sqrt(rangeFieldMeta.max + valueShift) : rangeFieldMeta.max;
    const minStopInput = isArea ? Math.sqrt(rangeFieldMeta.min + valueShift) : rangeFieldMeta.min;
    const maxStopOutput = options !== null && options !== void 0 && options.maxStopOutput ? options.maxStopOutput : this.getMaxStopOutput();
    const minStopOutput = options !== null && options !== void 0 && options.minStopOutput ? options.minStopOutput : this.getMinStopOutput();
    const invert = this._options.invert === undefined ? false : this._options.invert;
    function getStopsWithoutRange() {
      return invert ? [maxStopInput, minStopOutput] : [maxStopInput, maxStopOutput];
    }
    function getStops() {
      return invert ? [minStopInput, maxStopOutput, maxStopInput, minStopOutput] : [minStopInput, minStopOutput, maxStopInput, maxStopOutput];
    }
    const stops = rangeFieldMeta.min === rangeFieldMeta.max ? getStopsWithoutRange() : getStops();
    const valueExpression = (0, _style_util.makeMbClampedNumberExpression)({
      lookupFunction: options !== null && options !== void 0 && options.forceFeatureProperties ? _constants.MB_LOOKUP_FUNCTION.GET : this.getMbLookupFunction(),
      maxValue: rangeFieldMeta.max,
      minValue: rangeFieldMeta.min,
      fieldName: this.getMbFieldName(),
      fallback: invert ? rangeFieldMeta.max : rangeFieldMeta.min
    });
    const valueShiftExpression = rangeFieldMeta.min < 1 ? ['+', valueExpression, valueShift] : valueExpression;
    const sqrtValueExpression = ['sqrt', valueShiftExpression];
    const inputExpression = isArea ? sqrtValueExpression : valueExpression;
    return ['interpolate', ['linear'], inputExpression, ...stops];
  }
  getMaxStopOutput() {
    return this.getStyleName() === _constants.VECTOR_STYLES.ICON_SIZE && this._isSymbolizedAsIcon ? this._options.maxSize / _constants.HALF_MAKI_ICON_SIZE : this._options.maxSize;
  }
  getMinStopOutput() {
    return this.getStyleName() === _constants.VECTOR_STYLES.ICON_SIZE && this._isSymbolizedAsIcon ? this._options.minSize / _constants.HALF_MAKI_ICON_SIZE : this._options.minSize;
  }
  isSizeDynamicConfigComplete() {
    return this._field && this._field.isValid() && this._options.minSize >= 0 && this._options.maxSize >= 0;
  }
  renderLegendDetailRow() {
    return this.getStyleName() === _constants.VECTOR_STYLES.ICON_SIZE && !this._isSymbolizedAsIcon ? /*#__PURE__*/_react.default.createElement(_size.MarkerSizeLegend, {
      style: this,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_size.OrdinalLegend, {
      style: this,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 7
      }
    });
  }
}
exports.DynamicSizeProperty = DynamicSizeProperty;