"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OtherCategoryColorPicker = OtherCategoryColorPicker;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mb_validated_color_picker = require("./mb_validated_color_picker");
var _style_util = require("../../style_util");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/color/other_category_color_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function OtherCategoryColorPicker(props) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const OTHER_CATEGORY_SWATCHES = [euiTheme.colors.textInverse, euiTheme.colors.textDisabled, euiTheme.colors.textSubdued, euiTheme.colors.textParagraph, euiTheme.colors.textHeading];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.maps.colorStops.otherCategoryColorPickerTooltip', {
      defaultMessage: 'When the selected field has more terms than colors in the palette, the rest of the terms are grouped under "Other" category. Select a palette with more colors to increase the number of terms colored in your map'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_mb_validated_color_picker.MbValidatedColorPicker, {
    swatches: OTHER_CATEGORY_SWATCHES,
    prepend: _style_util.OTHER_CATEGORY_LABEL,
    onChange: props.onChange,
    color: props.color ? props.color : _style_util.OTHER_CATEGORY_DEFAULT_COLOR,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  })));
}