"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMvt = isMvt;
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isMvt(renderAs, resolution) {
  // heatmap uses MVT regardless of resolution because heatmap only supports counting metrics
  if (renderAs === _constants.RENDER_AS.HEATMAP) {
    return true;
  }

  // hex uses MVT regardless of resolution because hex never supported "top terms" metric
  if (renderAs === _constants.RENDER_AS.HEX) {
    return true;
  }

  // point and grid only use mvt at high resolution because lower resolutions may contain mvt unsupported "top terms" metric
  return resolution === _constants.GRID_RESOLUTION.SUPER_FINE;
}