"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIconSize = getIconSize;
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getIconSize(resolution) {
  if (resolution === _constants.GRID_RESOLUTION.COARSE) {
    return {
      minSize: 16,
      maxSize: 48
    };
  }
  if (resolution === _constants.GRID_RESOLUTION.FINE) {
    return {
      minSize: 8,
      maxSize: 24
    };
  }
  if (resolution === _constants.GRID_RESOLUTION.MOST_FINE) {
    return {
      minSize: 4,
      maxSize: 12
    };
  }
  return {
    minSize: 2,
    maxSize: 6
  };
}