"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EMSFileSource = void 0;
exports.getSourceTitle = getSourceTitle;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _vector_source = require("../vector_source");
var _constants = require("../../../../common/constants");
var _util = require("../../../util");
var _i18n_getters = require("../../../../common/i18n_getters");
var _update_source_editor = require("./update_source_editor");
var _ems_file_field = require("../../fields/ems_file_field");
var _kibana_services = require("../../../kibana_services");
var _ems_unavailable_message = require("../../../components/ems_unavailable_message");
var _licensed_features = require("../../../licensed_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/ems_file_source/ems_file_source.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getErrorInfo(fileId) {
  return _i18n.i18n.translate('xpack.maps.source.emsFile.unableToFindFileIdErrorMessage', {
    defaultMessage: `Unable to find EMS vector shapes for id: {id}. {info}`,
    values: {
      id: fileId,
      info: (0, _ems_unavailable_message.getEmsUnavailableMessage)()
    }
  });
}
function getSourceTitle() {
  const emsSettings = (0, _kibana_services.getEMSSettings)();
  if (emsSettings.isEMSUrlSet()) {
    return _i18n.i18n.translate('xpack.maps.source.emsOnPremFileTitle', {
      defaultMessage: 'Elastic Maps Server Boundaries'
    });
  } else {
    return _i18n.i18n.translate('xpack.maps.source.emsFileTitle', {
      defaultMessage: 'EMS Boundaries'
    });
  }
}
class EMSFileSource extends _vector_source.AbstractVectorSource {
  static createDescriptor({
    id,
    tooltipProperties = []
  }) {
    return {
      type: _constants.SOURCE_TYPES.EMS_FILE,
      id: id,
      tooltipProperties
    };
  }
  constructor(descriptor) {
    var _this$_descriptor$too;
    super(EMSFileSource.createDescriptor(descriptor));
    (0, _defineProperty2.default)(this, "_tooltipFields", void 0);
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    (0, _defineProperty2.default)(this, "getValueSuggestions", async (field, query) => {
      const values = await this._getFieldValues(field.getName());
      return query.length ? values.filter(value => value.toLowerCase().includes(query.toLowerCase())) : values;
    });
    this._descriptor = EMSFileSource.createDescriptor(descriptor);
    this._tooltipFields = ((_this$_descriptor$too = this._descriptor.tooltipProperties) !== null && _this$_descriptor$too !== void 0 ? _this$_descriptor$too : []).map(propertyKey => this.getFieldByName(propertyKey));
  }
  renderSourceSettingsEditor({
    onChange
  }) {
    return /*#__PURE__*/_react.default.createElement(_update_source_editor.UpdateSourceEditor, {
      onChange: onChange,
      tooltipFields: this._tooltipFields,
      layerId: this._descriptor.id,
      source: this,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 7
      }
    });
  }
  async getEMSFileLayer() {
    let emsFileLayers;
    try {
      emsFileLayers = await (0, _util.getEmsFileLayers)();
    } catch (e) {
      throw new Error(`${getErrorInfo(this._descriptor.id)} - ${e.message}`);
    }
    const emsFileLayer = emsFileLayers.find(fileLayer => fileLayer.hasId(this._descriptor.id));
    if (emsFileLayer) {
      return emsFileLayer;
    }
    throw new Error(getErrorInfo(this._descriptor.id));
  }

  // Map EMS field name to language specific label
  async getEmsFieldLabel(emsFieldName) {
    const emsFileLayer = await this.getEMSFileLayer();
    const emsFields = emsFileLayer.getFieldsInLanguage();
    const emsField = emsFields.find(field => field.name === emsFieldName);
    return emsField ? emsField.description : emsFieldName;
  }
  async getGeoJsonWithMeta() {
    try {
      const emsFileLayer = await this.getEMSFileLayer();
      const featureCollection = await emsFileLayer.getGeoJson();
      if (!featureCollection) throw new Error('No features found');
      const emsIdField = emsFileLayer.getFields().find(field => {
        return field.type === 'id';
      });
      featureCollection.features.forEach((feature, index) => {
        feature.id = emsIdField ? feature.properties[emsIdField.id] : index;
      });
      return {
        data: featureCollection,
        meta: {}
      };
    } catch (error) {
      throw new Error(getErrorInfo(this._descriptor.id));
    }
  }
  async getImmutableProperties() {
    let emsLink;
    try {
      const emsFileLayer = await this.getEMSFileLayer();
      emsLink = emsFileLayer.getEMSHotLink();
    } catch (error) {
      // ignore error if EMS layer id could not be found
    }
    const props = [{
      label: (0, _i18n_getters.getDataSourceLabel)(),
      value: getSourceTitle()
    }, {
      label: _i18n.i18n.translate('xpack.maps.source.emsFile.layerLabel', {
        defaultMessage: `Layer`
      }),
      value: this._descriptor.id,
      link: emsLink
    }];
    const emsSettings = (0, _kibana_services.getEMSSettings)();
    if (emsSettings.isEMSUrlSet()) {
      props.push({
        label: _i18n.i18n.translate('xpack.maps.source.emsFile.emsOnPremLabel', {
          defaultMessage: `Elastic Maps Server`
        }),
        value: emsSettings.getEMSRoot()
      });
    }
    return props;
  }
  async getDisplayName() {
    try {
      const emsFileLayer = await this.getEMSFileLayer();
      return emsFileLayer.getDisplayName();
    } catch (error) {
      return this._descriptor.id;
    }
  }
  getAttributionProvider() {
    return async () => {
      const emsFileLayer = await this.getEMSFileLayer();
      return emsFileLayer.getAttributions();
    };
  }
  async getFields() {
    const emsFileLayer = await this.getEMSFileLayer();
    const fields = emsFileLayer.getFieldsInLanguage();
    return fields.map(f => this.getFieldByName(f.name));
  }
  getFieldByName(fieldName) {
    return new _ems_file_field.EMSFileField({
      fieldName,
      source: this,
      origin: _constants.FIELD_ORIGIN.SOURCE
    });
  }
  async getLeftJoinFields() {
    return this.getFields();
  }
  hasTooltipProperties() {
    return this._tooltipFields.length > 0;
  }
  async getTooltipProperties(properties) {
    const promises = this._tooltipFields.map(field => {
      // @ts-ignore
      const value = properties[field.getName()];
      return field.createTooltipProperty(value);
    });
    return Promise.all(promises);
  }
  async getSupportedShapeTypes() {
    return [_constants.VECTOR_SHAPE_TYPE.POLYGON];
  }
  async getLicensedFeatures() {
    const emsSettings = (0, _kibana_services.getEMSSettings)();
    return emsSettings.isEMSUrlSet() ? [_licensed_features.LICENSED_FEATURES.ON_PREM_EMS] : [];
  }
  async _getFieldValues(fieldName) {
    try {
      var _targetEmsField$value;
      const emsFileLayer = await this.getEMSFileLayer();
      const targetEmsField = emsFileLayer.getFields().find(({
        id
      }) => id === fieldName);
      if (targetEmsField !== null && targetEmsField !== void 0 && (_targetEmsField$value = targetEmsField.values) !== null && _targetEmsField$value !== void 0 && _targetEmsField$value.length) {
        return targetEmsField.values;
      }

      // Fallback to pulling values from feature properties when values are not available in file definition
      const valuesSet = new Set(); // use set to avoid duplicate values
      const featureCollection = await emsFileLayer.getGeoJson();
      featureCollection === null || featureCollection === void 0 ? void 0 : featureCollection.features.forEach(feature => {
        if (feature.properties && fieldName in feature.properties && feature.properties[fieldName] != null) {
          valuesSet.add(feature.properties[fieldName].toString());
        }
      });
      return Array.from(valuesSet);
    } catch (error) {
      // ignore errors
      return [];
    }
  }
}
exports.EMSFileSource = EMSFileSource;