"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildVectorRequestMeta = buildVectorRequestMeta;
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function buildVectorRequestMeta(source, fieldNames, dataFilters, sourceQuery, isForceRefresh, isFeatureEditorOpenForLayer) {
  return {
    ...dataFilters,
    fieldNames: _lodash.default.uniq(fieldNames).sort(),
    sourceQuery: sourceQuery ? sourceQuery : undefined,
    applyGlobalQuery: source.getApplyGlobalQuery(),
    applyGlobalTime: source.getApplyGlobalTime(),
    sourceMeta: source.getSyncMeta(dataFilters),
    applyForceRefresh: source.getApplyForceRefresh(),
    isForceRefresh,
    isFeatureEditorOpenForLayer
  };
}