"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.callWithoutRepeats = callWithoutRepeats;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function callWithoutRepeats(func, isArgsEqual = _lodash.isEqual) {
  let previousArgs;
  let previousResult;
  return (...args) => {
    if (!isArgsEqual(args, previousArgs)) {
      previousArgs = args;
      previousResult = func(...args);
    }
    return previousResult;
  };
}