"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataSearch = void 0;
var _react = require("react");
var _rxjs = require("rxjs");
var _use_kibana = require("../../hooks/use_kibana");
var _use_observable = require("../use_observable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDataSearch = ({
  getRequest,
  parseResponses
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const requests$ = (0, _use_observable.useObservable)(() => new _rxjs.ReplaySubject(1), []);
  const search = (0, _react.useCallback)((...args) => {
    const requestArgs = getRequest(...args);
    if (requestArgs == null) {
      return;
    }
    const abortController = new AbortController();
    let isAbortable = true;
    const newRequestDescriptor = {
      ...requestArgs,
      abortController,
      response$: services.data.search.search(requestArgs.request, {
        abortSignal: abortController.signal,
        ...requestArgs.options
      }).pipe(
      // avoid aborting failed or completed requests
      (0, _rxjs.tap)({
        error: () => {
          isAbortable = false;
        },
        complete: () => {
          isAbortable = false;
        }
      }), (0, _use_observable.tapUnsubscribe)(() => {
        if (isAbortable) {
          abortController.abort();
        }
      }), parseResponses, (0, _rxjs.share)())
    };
    requests$.next(newRequestDescriptor);
    return newRequestDescriptor;
  }, [getRequest, services.data.search, parseResponses, requests$]);
  return {
    requests$,
    search
  };
};
exports.useDataSearch = useDataSearch;