"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkVersionConflict = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * checks if encoded OCC update _version matches actual version of list/item
 * @param updateVersion - version in payload
 * @param existingVersion - version in exiting list/item
 */
const checkVersionConflict = (updateVersion, existingVersion) => {
  if (updateVersion && existingVersion && updateVersion !== existingVersion) {
    throw _boom.default.conflict(`Conflict: versions mismatch. Provided versions:${JSON.stringify((0, _securitysolutionEsUtils.decodeVersion)(updateVersion))} does not match ${JSON.stringify((0, _securitysolutionEsUtils.decodeVersion)(existingVersion))}`);
  }
};
exports.checkVersionConflict = checkVersionConflict;