"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateExceptionListRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _zodHelpers = require("@kbn/zod-helpers");
var _api = require("@kbn/securitysolution-exceptions-common/api");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateExceptionListRoute = router => {
  router.versioned.put({
    access: 'public',
    path: _securitysolutionListConstants.EXCEPTION_LIST_URL,
    security: {
      authz: {
        requiredPrivileges: ['lists-all']
      }
    }
  }).addVersion({
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_api.UpdateExceptionListRequestBody)
      }
    },
    version: '2023-10-31'
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const {
        _version,
        tags,
        name,
        description,
        id,
        list_id: listId,
        meta,
        namespace_type: namespaceType,
        os_types: osTypes,
        type,
        version
      } = request.body;
      const exceptionLists = await (0, _utils.getExceptionListClient)(context);
      if (id == null && listId == null) {
        return siemResponse.error({
          body: 'either id or list_id need to be defined',
          statusCode: 404
        });
      }
      const list = await exceptionLists.updateExceptionList({
        _version,
        description,
        id,
        listId,
        meta,
        name,
        namespaceType,
        osTypes,
        tags,
        type,
        version
      });
      if (list == null) {
        return siemResponse.error({
          body: (0, _utils.getErrorMessageExceptionList)({
            id,
            listId
          }),
          statusCode: 404
        });
      }
      return response.ok({
        body: _api.UpdateExceptionListResponse.parse(list)
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.updateExceptionListRoute = updateExceptionListRoute;