"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardLinkComponent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _analytics = require("@kbn/analytics");
var _esQuery = require("@kbn/es-query");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/presentation-util-plugin/public");
var _content_management = require("../../../common/content_management");
var _kibana_services = require("../../services/kibana_services");
var _dashboard_link_strings = require("./dashboard_link_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/links/public/components/dashboard_link/dashboard_link_component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DashboardLinkComponent = ({
  link,
  layout,
  parentApi
}) => {
  var _link$options;
  const [parentDashboardId, parentDashboardTitle, parentDashboardDescription, timeRange, filters, query] = (0, _presentationPublishing.useBatchedPublishingSubjects)(parentApi.savedObjectId$, parentApi.title$, parentApi.description$, parentApi.timeRange$, parentApi.filters$, parentApi.query$);

  /**
   * Returns the title and description of the dashboard that the link points to; note that, if the link points to
   * the current dashboard, then we need to get the most up-to-date information via the `parentDashboardInput` - this
   * will respond to changes so that the link label/tooltip remains in sync with the dashboard title/description.
   */
  const [dashboardTitle, dashboardDescription] = (0, _react.useMemo)(() => {
    return link.destination === parentDashboardId ? [parentDashboardTitle, parentDashboardDescription] : [link.title, link.description];
  }, [link, parentDashboardId, parentDashboardTitle, parentDashboardDescription]);

  /**
   * Memoized link information
   */
  const linkLabel = (0, _react.useMemo)(() => {
    return link.label || (dashboardTitle !== null && dashboardTitle !== void 0 ? dashboardTitle : _dashboard_link_strings.DashboardLinkStrings.getDashboardErrorLabel());
  }, [link, dashboardTitle]);
  const {
    tooltipTitle,
    tooltipMessage
  } = (0, _react.useMemo)(() => {
    if (link.error) {
      return {
        tooltipTitle: _dashboard_link_strings.DashboardLinkStrings.getDashboardErrorLabel(),
        tooltipMessage: link.error.message
      };
    }
    return {
      tooltipTitle: Boolean(dashboardDescription) ? linkLabel : undefined,
      tooltipMessage: dashboardDescription || linkLabel
    };
  }, [link, linkLabel, dashboardDescription]);

  /**
   * Dashboard-to-dashboard navigation
   */
  const onClickProps = (0, _react.useMemo)(() => {
    /** If the link points to the current dashboard, then there should be no `onClick` or `href` prop */
    if (!link.destination || link.destination === parentDashboardId) return;
    const linkOptions = {
      ..._public.DEFAULT_DASHBOARD_DRILLDOWN_OPTIONS,
      ...link.options
    };
    const params = {
      dashboardId: link.destination
    };
    if (linkOptions.useCurrentFilters && query) {
      params.query = query;
    }
    if (linkOptions.useCurrentDateRange && timeRange) {
      params.timeRange = timeRange;
    }
    params.filters = linkOptions.useCurrentFilters ? filters : filters === null || filters === void 0 ? void 0 : filters.filter(_esQuery.isFilterPinned);
    const locator = parentApi.locator;
    if (!locator) return;
    const href = locator.getRedirectUrl(params);
    return {
      href,
      onClick: async event => {
        _kibana_services.trackUiMetric === null || _kibana_services.trackUiMetric === void 0 ? void 0 : (0, _kibana_services.trackUiMetric)(_analytics.METRIC_TYPE.CLICK, `${_content_management.DASHBOARD_LINK_TYPE}:click`);

        /**
         * If the link is being opened via a modified click, then we should use the default `href` navigation behaviour
         * by passing all the dashboard state via the URL - this will keep behaviour consistent across all browsers.
         */
        const modifiedClick = event.ctrlKey || event.metaKey || event.shiftKey;
        if (modifiedClick) {
          return;
        }

        /** Otherwise, prevent the default behaviour and handle click depending on `openInNewTab` option */
        event.preventDefault();
        if (linkOptions.openInNewTab) {
          window.open(href, '_blank');
        } else {
          await locator.navigate(params);
        }
      }
    };
  }, [link.destination, link.options, parentDashboardId, filters, parentApi.locator, query, timeRange]);
  const id = `dashboardLink--${link.id}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, (0, _extends2.default)({
    size: "s",
    color: "text"
  }, onClickProps, {
    id: id,
    css: styles,
    showToolTip: true,
    toolTipProps: {
      title: tooltipTitle,
      content: tooltipMessage,
      position: layout === _content_management.LINKS_VERTICAL_LAYOUT ? 'right' : 'bottom',
      repositionOnScroll: true,
      delay: 'long',
      'data-test-subj': `${id}--tooltip`
    },
    iconType: link.error ? 'warning' : undefined,
    iconProps: {
      className: 'dashboardLinkIcon'
    },
    isDisabled: Boolean(link.error),
    className: (0, _classnames.default)('linksPanelLink', {
      linkCurrent: link.destination === parentDashboardId,
      dashboardLinkError: Boolean(link.error),
      'dashboardLinkError--noLabel': !link.label
    }),
    label: linkLabel,
    external: (_link$options = link.options) === null || _link$options === void 0 ? void 0 : _link$options.openInNewTab,
    "data-test-subj": link.error ? `${id}--error` : `${id}`,
    "aria-current": link.destination === parentDashboardId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 5
    }
  }));
};
exports.DashboardLinkComponent = DashboardLinkComponent;
const styles = ({
  euiTheme
}) => (0, _react2.css)({
  // universal current dashboard link styles
  '&.linkCurrent': {
    borderRadius: 0,
    cursor: 'default',
    '& .euiListGroupItem__text': {
      color: euiTheme.colors.textPrimary
    }
  },
  // vertical layout - current dashboard link styles
  '.verticalLayoutWrapper &.linkCurrent::before': {
    // add left border for current dashboard
    content: "''",
    position: 'absolute',
    height: '75%',
    width: `calc(.5 * ${euiTheme.size.xs})`,
    backgroundColor: euiTheme.colors.primary
  },
  // horizontal layout - current dashboard link styles
  '.horizontalLayoutWrapper &.linkCurrent': {
    padding: `0 ${euiTheme.size.s}`,
    '& .euiListGroupItem__text': {
      // add bottom border for current dashboard
      boxShadow: `${euiTheme.colors.textPrimary} 0 calc(-.5 * ${euiTheme.size.xs}) inset`,
      paddingInline: 0
    }
  },
  // dashboard not found error styles
  '&.dashboardLinkError': {
    '&.dashboardLinkError--noLabel .euiListGroupItem__text': {
      fontStyle: 'italic'
    },
    '.dashboardLinkIcon': {
      marginRight: euiTheme.size.s
    }
  }
});