"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uploadNeedsAcknowledgement = exports.uploadMessages = exports.startTrialError = exports.startBasicLicenseNeedsAcknowledgement = exports.shouldShowStartTrial = exports.shouldShowRevertToBasicLicense = exports.shouldShowRequestTrialExtension = exports.licenseManagement = exports.isPermissionsLoading = exports.isInvalid = exports.isImminentExpiration = exports.isExpired = exports.isApplying = exports.getUploadErrorMessage = exports.getStartBasicMessages = exports.getPermissionsError = exports.getPermission = exports.getLicenseType = exports.getLicenseState = exports.getLicense = exports.getExpirationMillis = exports.getExpirationDateFormatted = exports.getExpirationDate = exports.WARNING_THRESHOLD_IN_DAYS = void 0;
var _redux = require("redux");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _reselect = require("reselect");
var _license = require("./license");
var _upload_status = require("./upload_status");
var _start_basic_license_status = require("./start_basic_license_status");
var _upload_error_message = require("./upload_error_message");
var _trial_status = require("./trial_status");
var _permissions = require("./permissions");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WARNING_THRESHOLD_IN_DAYS = exports.WARNING_THRESHOLD_IN_DAYS = 25;
const licenseManagement = exports.licenseManagement = (0, _redux.combineReducers)({
  license: _license.license,
  uploadStatus: _upload_status.uploadStatus,
  uploadErrorMessage: _upload_error_message.uploadErrorMessage,
  trialStatus: _trial_status.trialStatus,
  startBasicStatus: _start_basic_license_status.startBasicStatus,
  permissions: _permissions.permissions
});
const getPermission = state => {
  return state.permissions.hasPermission;
};
exports.getPermission = getPermission;
const isPermissionsLoading = state => {
  return state.permissions.loading;
};
exports.isPermissionsLoading = isPermissionsLoading;
const getPermissionsError = state => {
  return state.permissions.error;
};
exports.getPermissionsError = getPermissionsError;
const getLicense = state => {
  return state.license;
};
exports.getLicense = getLicense;
const getLicenseType = state => {
  return getLicense(state).type;
};
exports.getLicenseType = getLicenseType;
const getExpirationMillis = state => {
  return getLicense(state).expiryDateInMillis;
};
exports.getExpirationMillis = getExpirationMillis;
const getExpirationDate = state => {
  //basic licenses do not expire
  if (getLicenseType(state) === 'basic') {
    return null;
  }
  const expirationMillis = getExpirationMillis(state);
  if (expirationMillis) {
    return _momentTimezone.default.tz(getExpirationMillis(state), _momentTimezone.default.tz.guess());
  } else {
    return null;
  }
};
exports.getExpirationDate = getExpirationDate;
const getExpirationDateFormatted = state => {
  const expirationDate = getExpirationDate(state);
  return expirationDate ? expirationDate.format('LLL z') : null;
};
exports.getExpirationDateFormatted = getExpirationDateFormatted;
const isExpired = state => {
  return new Date().getTime() > getExpirationMillis(state);
};
exports.isExpired = isExpired;
const isImminentExpiration = state => {
  const now = new Date();
  const expirationDate = getExpirationDate(state);
  return expirationDate && expirationDate.isAfter(now) && expirationDate.diff(now, 'days') <= WARNING_THRESHOLD_IN_DAYS;
};
exports.isImminentExpiration = isImminentExpiration;
const shouldShowRevertToBasicLicense = state => {
  const {
    type
  } = getLicense(state);
  return type === 'trial' || isImminentExpiration(state) || isExpired(state);
};
exports.shouldShowRevertToBasicLicense = shouldShowRevertToBasicLicense;
const uploadNeedsAcknowledgement = state => {
  return !!state.uploadStatus.acknowledge;
};
exports.uploadNeedsAcknowledgement = uploadNeedsAcknowledgement;
const isApplying = state => {
  return !!state.uploadStatus.applying;
};
exports.isApplying = isApplying;
const uploadMessages = state => {
  return state.uploadStatus.messages;
};
exports.uploadMessages = uploadMessages;
const isInvalid = state => {
  return !!state.uploadStatus.invalid;
};
exports.isInvalid = isInvalid;
const getUploadErrorMessage = state => {
  return state.uploadErrorMessage;
};
exports.getUploadErrorMessage = getUploadErrorMessage;
const shouldShowStartTrial = state => {
  const licenseType = getLicenseType(state);
  return state.trialStatus.canStartTrial && licenseType !== 'trial' && (
  //don't show for platinum & enterprise unless it is expired
  licenseType !== 'platinum' && licenseType !== 'enterprise' || isExpired(state));
};
exports.shouldShowStartTrial = shouldShowStartTrial;
const shouldShowRequestTrialExtension = state => {
  if (state.trialStatus.canStartTrial) {
    return false;
  }
  const {
    type
  } = getLicense(state);
  return type !== 'platinum' && type !== 'enterprise' || isExpired(state);
};
exports.shouldShowRequestTrialExtension = shouldShowRequestTrialExtension;
const startTrialError = state => {
  return state.trialStatus.startTrialError;
};
exports.startTrialError = startTrialError;
const startBasicLicenseNeedsAcknowledgement = state => {
  return !!state.startBasicStatus.acknowledge;
};
exports.startBasicLicenseNeedsAcknowledgement = startBasicLicenseNeedsAcknowledgement;
const getStartBasicMessages = state => {
  return state.startBasicStatus.messages;
};
exports.getStartBasicMessages = getStartBasicMessages;
const getLicenseState = exports.getLicenseState = (0, _reselect.createSelector)(getLicense, getExpirationDateFormatted, isExpired, (license, expirationDate, isExpired) => {
  const {
    isActive,
    type
  } = license;
  return {
    type: (0, _lodash.capitalize)(type),
    isExpired,
    expirationDate,
    status: isActive ? _i18n.i18n.translate('xpack.licenseMgmt.licenseDashboard.licenseStatus.activeLicenseStatusText', {
      defaultMessage: 'active'
    }) : _i18n.i18n.translate('xpack.licenseMgmt.licenseDashboard.licenseStatus.inactiveLicenseStatusText', {
      defaultMessage: 'inactive'
    })
  };
});