"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.trialStatusLoaded = exports.startLicenseTrial = exports.loadTrialStatus = void 0;
var _reduxActions = require("redux-actions");
var _es = require("../../lib/es");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const trialStatusLoaded = exports.trialStatusLoaded = (0, _reduxActions.createAction)('LICENSE_MANAGEMENT_TRIAL_STATUS_LOADED');
const loadTrialStatus = () => async (dispatch, getState, {
  http
}) => {
  const trialOK = await (0, _es.canStartTrial)(http);
  dispatch(trialStatusLoaded(trialOK));
};
exports.loadTrialStatus = loadTrialStatus;
const startLicenseTrial = () => async (dispatch, getState, {
  licensing,
  toasts,
  http
}) => {
  /*eslint camelcase: 0*/
  const {
    trial_was_started,
    error_message
  } = await (0, _es.startTrial)(http);
  if (trial_was_started) {
    await licensing.refresh();
    // reload necessary to get left nav to refresh with proper links
    window.location.reload();
  } else {
    return toasts.addDanger(error_message);
  }
};
exports.startLicenseTrial = startLicenseTrial;