"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLensResponseItem = getLensResponseItem;
var _transforms = require("../../../common/transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Converts Lens Saved Object to Lens Response Item
 */
function getLensResponseItem({
  // Data params
  id,
  references,
  attributes,
  // Meta params
  type,
  createdAt,
  updatedAt,
  createdBy,
  updatedBy,
  managed,
  originId
}) {
  return {
    data: _transforms.ConfigBuilderStub.out({
      ...attributes,
      id,
      references
    }),
    meta: {
      type,
      createdAt,
      updatedAt,
      createdBy,
      updatedBy,
      managed,
      originId
    }
  };
}