"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.endValueDefinitions = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const endValueDefinitions = exports.endValueDefinitions = [{
  id: 'None',
  title: _i18n.i18n.translate('xpack.lens.endValue.none', {
    defaultMessage: 'Hide'
  }),
  description: _i18n.i18n.translate('xpack.lens.endValueDescription.none', {
    defaultMessage: 'Do not extend series to the edge of the chart'
  })
}, {
  id: 'Zero',
  title: _i18n.i18n.translate('xpack.lens.endValue.zero', {
    defaultMessage: 'Zero'
  }),
  description: _i18n.i18n.translate('xpack.lens.endValueDescription.zero', {
    defaultMessage: 'Extend series as zero to the edge of the chart'
  })
}, {
  id: 'Nearest',
  title: _i18n.i18n.translate('xpack.lens.endValue.nearest', {
    defaultMessage: 'Nearest'
  }),
  description: _i18n.i18n.translate('xpack.lens.endValueDescription.nearest', {
    defaultMessage: 'Extend series with the first/last value to the edge of the chart'
  })
}];