"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAnnotationActions = void 0;
var _constants = require("@kbn/visualizations-plugin/common/constants");
var _common = require("@kbn/event-annotation-plugin/common");
var _unlink_action = require("./unlink_action");
var _save_action = require("./save_action");
var _visualization_helpers = require("../../visualization_helpers");
var _revert_changes_action = require("./revert_changes_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createAnnotationActions = ({
  state,
  layer,
  setState,
  registerLibraryAnnotationGroup,
  core,
  isSaveable,
  eventAnnotationService,
  savedObjectsTagging,
  dataViews,
  startServices
}) => {
  const actions = [];
  const savingToLibraryPermitted = Boolean(core.application.capabilities.visualize_v2.save && isSaveable);
  if (savingToLibraryPermitted) {
    actions.push((0, _save_action.getSaveLayerAction)({
      state,
      layer,
      setState,
      registerLibraryAnnotationGroup,
      eventAnnotationService,
      toasts: core.notifications.toasts,
      savedObjectsTagging,
      dataViews,
      goToAnnotationLibrary: () => core.application.navigateToApp(_constants.VISUALIZE_APP_NAME, {
        path: `#/${_common.ANNOTATIONS_LISTING_VIEW_ID}`
      }),
      startServices
    }));
  }
  if ((0, _visualization_helpers.isByReferenceAnnotationsLayer)(layer)) {
    actions.push((0, _unlink_action.getUnlinkLayerAction)({
      state,
      layer,
      setState,
      toasts: core.notifications.toasts
    }));
    actions.push((0, _revert_changes_action.getRevertChangesAction)({
      state,
      layer,
      setState,
      core
    }));
  }
  return actions;
};
exports.createAnnotationActions = createAnnotationActions;