"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuggestions = getSuggestions;
var _lodash = require("lodash");
var _chartIcons = require("@kbn/chart-icons");
var _constants = require("./constants");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSuggestions({
  table,
  state,
  keptLayerIds,
  mainPalette,
  subVisualizationId
}) {
  const isUnchanged = state && table.changeType === 'unchanged';
  if (isUnchanged || keptLayerIds.length > 1 || keptLayerIds.length && table.layerId !== keptLayerIds[0]) {
    return [];
  }
  const [buckets, metrics] = (0, _lodash.partition)(table.columns, col => col.operation.isBucketed);
  if (buckets.length !== 1 || metrics.length !== 1) {
    return [];
  }
  return buckets.filter(bucket => {
    return bucket.operation.dataType !== 'date';
  }).map(bucket => {
    return {
      previewIcon: _chartIcons.IconChartTagcloud,
      title: _constants.TAGCLOUD_LABEL,
      score: bucket.operation.dataType === 'string' ? 0.4 : 0.2,
      state: {
        layerId: table.layerId,
        tagAccessor: bucket.columnId,
        valueAccessor: metrics[0].columnId,
        ..._constants.DEFAULT_STATE,
        colorMapping: !mainPalette ? (0, _utils.getColorMappingDefaults)() : (mainPalette === null || mainPalette === void 0 ? void 0 : mainPalette.type) === 'colorMapping' ? mainPalette.value : undefined
      }
    };
  });
}