"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricStateDefaults = exports.legacyMetricStateDefaults = exports.SECONDARY_DEFAULT_STATIC_COLOR = exports.METRIC_LAYOUT_BY_POSITION = exports.LENS_METRIC_ID = exports.GROUP_ID = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LENS_METRIC_ID = exports.LENS_METRIC_ID = 'lnsMetric';
const GROUP_ID = exports.GROUP_ID = {
  METRIC: 'metric',
  SECONDARY_METRIC: 'secondaryMetric',
  MAX: 'max',
  BREAKDOWN_BY: 'breakdownBy',
  TREND_METRIC: 'trendMetric',
  TREND_SECONDARY_METRIC: 'trendSecondaryMetric',
  TREND_TIME: 'trendTime',
  TREND_BREAKDOWN_BY: 'trendBreakdownBy'
};
const legacyMetricStateDefaults = exports.legacyMetricStateDefaults = {
  iconAlign: 'left'
};

/** Defaults for select optional Metric vis state options */
const metricStateDefaults = exports.metricStateDefaults = {
  titlesTextAlign: 'left',
  primaryAlign: 'right',
  secondaryAlign: 'right',
  iconAlign: 'right',
  valueFontMode: 'default',
  primaryPosition: 'bottom',
  titleWeight: 'bold',
  secondaryLabelPosition: 'before',
  applyColorTo: 'background'
};
const METRIC_LAYOUT_BY_POSITION = exports.METRIC_LAYOUT_BY_POSITION = {
  bottom: {
    titlesTextAlign: 'left',
    titleWeight: 'bold',
    primaryAlign: 'right',
    iconAlign: 'right',
    secondaryAlign: 'right'
  },
  top: {
    titlesTextAlign: 'left',
    titleWeight: 'normal',
    primaryAlign: 'left',
    iconAlign: 'right',
    secondaryAlign: 'left'
  }
};
const SECONDARY_DEFAULT_STATIC_COLOR = exports.SECONDARY_DEFAULT_STATIC_COLOR = '#E4E8F1';