"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.legacyMetricSupportedTypes = exports.getLegacyMetricVisualization = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _coloring = require("@kbn/coloring");
var _common = require("@kbn/charts-plugin/common");
var _public = require("@kbn/visualizations-plugin/public");
var _chartIcons = require("@kbn/chart-icons");
var _public2 = require("@kbn/expression-xy-plugin/public");
var _common2 = require("@kbn/expressions-plugin/common");
var _metric_suggestions = require("./metric_suggestions");
var _dimension_editor = require("./dimension_editor");
var _metric_config_panel = require("./metric_config_panel");
var _title_position_option = require("./metric_config_panel/title_position_option");
var _size_options = require("./metric_config_panel/size_options");
var _align_options = require("./metric_config_panel/align_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/legacy_metric/visualization.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const legacyMetricSupportedTypes = exports.legacyMetricSupportedTypes = new Set(['string', 'boolean', 'number', 'ip', 'date']);
const getFontSizeAndUnit = fontSize => {
  const [size, sizeUnit] = fontSize.split(/(\d+)/).filter(Boolean);
  return {
    size: Number(size),
    sizeUnit
  };
};
const toExpression = (paletteService, state, datasourceLayers, attributes, datasourceExpressionsByLayers = {}) => {
  var _getOverridePaletteSt, _state$palette, _state$palette$params, _state$palette2, _state$palette3, _state$palette3$param, _state$palette4, _state$palette4$param, _datasourceExpression;
  if (!state.accessor) {
    return null;
  }
  const [datasource] = Object.values(datasourceLayers);
  const datasourceExpression = datasourceExpressionsByLayers[state.layerId];
  const operation = datasource && datasource.getOperationForColumnId(state.accessor);
  const stops = (_getOverridePaletteSt = (0, _coloring.getOverridePaletteStops)(paletteService, state.palette)) !== null && _getOverridePaletteSt !== void 0 ? _getOverridePaletteSt : [];
  const isCustomPalette = ((_state$palette = state.palette) === null || _state$palette === void 0 ? void 0 : (_state$palette$params = _state$palette.params) === null || _state$palette$params === void 0 ? void 0 : _state$palette$params.name) === _coloring.CUSTOM_PALETTE;
  const canColor = (operation === null || operation === void 0 ? void 0 : operation.dataType) === 'number';
  const paletteParams = {
    ...((_state$palette2 = state.palette) === null || _state$palette2 === void 0 ? void 0 : _state$palette2.params),
    colors: stops.map(({
      color
    }) => color),
    stops: isCustomPalette || ((_state$palette3 = state.palette) === null || _state$palette3 === void 0 ? void 0 : (_state$palette3$param = _state$palette3.params) === null || _state$palette3$param === void 0 ? void 0 : _state$palette3$param.rangeMax) == null ? stops.map(({
      stop
    }) => stop) : (0, _coloring.shiftPalette)(stops, Math.max((_state$palette4 = state.palette) === null || _state$palette4 === void 0 ? void 0 : (_state$palette4$param = _state$palette4.params) === null || _state$palette4$param === void 0 ? void 0 : _state$palette4$param.rangeMax, ...stops.map(({
      stop
    }) => stop))).map(({
      stop
    }) => stop),
    reverse: false
  };
  const fontSizes = {
    xs: getFontSizeAndUnit(_uiTheme.euiThemeVars.euiFontSizeXS),
    s: getFontSizeAndUnit(_uiTheme.euiThemeVars.euiFontSizeS),
    m: getFontSizeAndUnit(_uiTheme.euiThemeVars.euiFontSizeM),
    l: getFontSizeAndUnit(_uiTheme.euiThemeVars.euiFontSizeL),
    xl: getFontSizeAndUnit(_uiTheme.euiThemeVars.euiFontSizeXL),
    xxl: getFontSizeAndUnit(_uiTheme.euiThemeVars.euiFontSizeXXL)
  };
  const labelFont = fontSizes[(state === null || state === void 0 ? void 0 : state.size) || _size_options.DEFAULT_TITLE_SIZE];
  const labelToMetricFontSizeMap = {
    xs: fontSizes.xs.size * 2,
    s: fontSizes.m.size * 2.5,
    m: fontSizes.l.size * 2.5,
    l: fontSizes.xl.size * 2.5,
    xl: fontSizes.xxl.size * 2.5,
    xxl: fontSizes.xxl.size * 3
  };
  const metricFontSize = labelToMetricFontSizeMap[(state === null || state === void 0 ? void 0 : state.size) || _size_options.DEFAULT_TITLE_SIZE];
  const fontFn = (0, _common2.buildExpressionFunction)('font', {
    align: (state === null || state === void 0 ? void 0 : state.textAlign) || _align_options.DEFAULT_TEXT_ALIGNMENT,
    size: metricFontSize,
    weight: '600',
    lHeight: metricFontSize * 1.5,
    sizeUnit: labelFont.sizeUnit
  });
  const labelFontFn = (0, _common2.buildExpressionFunction)('font', {
    align: (state === null || state === void 0 ? void 0 : state.textAlign) || _align_options.DEFAULT_TEXT_ALIGNMENT,
    size: labelFont.size,
    lHeight: labelFont.size * 1.5,
    sizeUnit: labelFont.sizeUnit
  });
  const visdimensionFn = (0, _common2.buildExpressionFunction)('visdimension', {
    accessor: state.accessor
  });
  const legacyMetricVisFn = (0, _common2.buildExpressionFunction)('legacyMetricVis', {
    autoScaleMetricAlignment: state === null || state === void 0 ? void 0 : state.autoScaleMetricAlignment,
    labelPosition: (state === null || state === void 0 ? void 0 : state.titlePosition) || _title_position_option.DEFAULT_TITLE_POSITION,
    font: (0, _common2.buildExpression)([fontFn]),
    labelFont: (0, _common2.buildExpression)([labelFontFn]),
    metric: (0, _common2.buildExpression)([visdimensionFn]),
    showLabels: !(attributes !== null && attributes !== void 0 && attributes.mode) || (attributes === null || attributes === void 0 ? void 0 : attributes.mode) === 'full',
    colorMode: !canColor ? _common.ColorMode.None : (state === null || state === void 0 ? void 0 : state.colorMode) || _common.ColorMode.None,
    autoScale: true,
    colorFullBackground: true,
    palette: state !== null && state !== void 0 && state.colorMode && (state === null || state === void 0 ? void 0 : state.colorMode) !== _common.ColorMode.None ? paletteService.get(_coloring.CUSTOM_PALETTE).toExpression(paletteParams) : undefined,
    percentageMode: false
  });
  return {
    type: 'expression',
    chain: [...((_datasourceExpression = datasourceExpression === null || datasourceExpression === void 0 ? void 0 : datasourceExpression.chain) !== null && _datasourceExpression !== void 0 ? _datasourceExpression : []), legacyMetricVisFn.toAst()]
  };
};
const getLegacyMetricVisualization = ({
  paletteService
}) => ({
  id: 'lnsLegacyMetric',
  getVisualizationTypeId() {
    return this.id;
  },
  visualizationTypes: [{
    id: 'lnsLegacyMetric',
    icon: _chartIcons.IconChartMetric,
    label: _i18n.i18n.translate('xpack.lens.legacyMetric.label', {
      defaultMessage: 'Legacy Metric'
    }),
    isDeprecated: true,
    sortPriority: 100,
    description: _i18n.i18n.translate('xpack.lens.legacyMetric.visualizationDescription', {
      defaultMessage: 'Present individual key metrics or KPIs.'
    })
  }],
  hideFromChartSwitch(frame) {
    return Object.values(frame.datasourceLayers).some(datasource => datasource && datasource.datasourceId === 'textBased');
  },
  clearLayer(state) {
    return {
      ...state,
      accessor: undefined
    };
  },
  getLayerIds(state) {
    return [state.layerId];
  },
  getDescription() {
    return {
      icon: _chartIcons.IconChartMetric,
      label: _i18n.i18n.translate('xpack.lens.legacyMetric.label', {
        defaultMessage: 'Legacy Metric'
      })
    };
  },
  getSuggestions: _metric_suggestions.getSuggestions,
  initialize(addNewLayer, state) {
    return state || {
      layerId: addNewLayer(),
      accessor: undefined,
      layerType: _public2.LayerTypes.DATA
    };
  },
  triggers: [_public.VIS_EVENT_TO_TRIGGER.filter],
  getConfiguration(props) {
    const hasColoring = props.state.palette != null;
    const stops = (0, _coloring.getOverridePaletteStops)(paletteService, props.state.palette);
    return {
      groups: [{
        groupId: 'metric',
        dataTestSubj: 'lnsLegacyMetric_metricDimensionPanel',
        paramEditorCustomProps: {
          headingLabel: _i18n.i18n.translate('xpack.lens.metric.headingLabel', {
            defaultMessage: 'Value'
          })
        },
        isMetricDimension: true,
        groupLabel: _i18n.i18n.translate('xpack.lens.metric.label', {
          defaultMessage: 'Metric'
        }),
        layerId: props.state.layerId,
        accessors: props.state.accessor ? [{
          columnId: props.state.accessor,
          triggerIconType: hasColoring ? 'colorBy' : undefined,
          palette: hasColoring ? stops === null || stops === void 0 ? void 0 : stops.map(({
            color
          }) => color) : undefined
        }] : [],
        supportsMoreColumns: !props.state.accessor,
        filterOperations: op => !op.isBucketed && legacyMetricSupportedTypes.has(op.dataType),
        enableDimensionEditor: true,
        requiredMinDimensionCount: 1
      }]
    };
  },
  getSupportedLayers() {
    return [{
      type: _public2.LayerTypes.DATA,
      label: _i18n.i18n.translate('xpack.lens.legacyMetric.addLayer', {
        defaultMessage: 'Visualization'
      })
    }];
  },
  getLayerType(layerId, state) {
    if ((state === null || state === void 0 ? void 0 : state.layerId) === layerId) {
      return state.layerType;
    }
  },
  toExpression: (state, datasourceLayers, attributes, datasourceExpressionsByLayers) => toExpression(paletteService, state, datasourceLayers, {
    ...attributes
  }, datasourceExpressionsByLayers),
  toPreviewExpression: (state, datasourceLayers, datasourceExpressionsByLayers) => toExpression(paletteService, state, datasourceLayers, {
    mode: 'reduced'
  }, datasourceExpressionsByLayers),
  setDimension({
    prevState,
    columnId
  }) {
    return {
      ...prevState,
      accessor: columnId
    };
  },
  removeDimension({
    prevState
  }) {
    return {
      ...prevState,
      accessor: undefined,
      colorMode: _common.ColorMode.None,
      palette: undefined
    };
  },
  ToolbarComponent(props) {
    return /*#__PURE__*/_react.default.createElement(_metric_config_panel.MetricToolbar, {
      state: props.state,
      setState: props.setState,
      frame: props.frame,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 301,
        columnNumber: 12
      }
    });
  },
  DimensionEditorComponent(props) {
    return /*#__PURE__*/_react.default.createElement(_dimension_editor.MetricDimensionEditor, (0, _extends2.default)({}, props, {
      paletteService: paletteService,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 305,
        columnNumber: 12
      }
    }));
  },
  getVisualizationInfo(state) {
    const dimensions = [];
    if (state.accessor) {
      dimensions.push({
        id: state.accessor,
        name: _i18n.i18n.translate('xpack.lens.metric.label', {
          defaultMessage: 'Metric'
        }),
        dimensionType: 'metric'
      });
    }
    const hasColoring = state.palette != null;
    const stops = (0, _coloring.getOverridePaletteStops)(paletteService, state.palette);
    return {
      layers: [{
        layerId: state.layerId,
        layerType: state.layerType,
        chartType: 'metric',
        ...this.getDescription(state),
        dimensions,
        palette: hasColoring ? stops === null || stops === void 0 ? void 0 : stops.map(({
          color
        }) => color) : undefined
      }]
    };
  }
});
exports.getLegacyMetricVisualization = getLegacyMetricVisualization;