"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDatasourceLayers = void 0;
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDatasourceLayers = exports.getDatasourceLayers = (0, _memoizeOne.default)(function getDatasourceLayers(datasourceStates, datasourceMap, indexPatterns) {
  const datasourceLayers = {};
  Object.keys(datasourceMap).filter(id => datasourceStates[id] && !datasourceStates[id].isLoading).forEach(id => {
    const datasourceState = datasourceStates[id].state;
    const datasource = datasourceMap[id];
    const layers = datasource.getLayers(datasourceState);
    layers.forEach(layer => {
      datasourceLayers[layer] = datasourceMap[id].getPublicAPI({
        state: datasourceState,
        layerId: layer,
        indexPatterns
      });
    });
  });
  return datasourceLayers;
});