"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.contextMiddleware = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _ = require("..");
var _utils = require("../../utils");
var _subscribe_to_external_context = require("./subscribe_to_external_context");
var _lens_slice = require("../lens_slice");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isTimeBased(state, datasourceMap) {
  var _datasourceMap$active, _datasourceMap$active2;
  const {
    activeDatasourceId,
    datasourceStates,
    dataViews
  } = state.lens;
  return Boolean(activeDatasourceId && datasourceStates[activeDatasourceId] && ((_datasourceMap$active = (_datasourceMap$active2 = datasourceMap[activeDatasourceId]).isTimeBased) === null || _datasourceMap$active === void 0 ? void 0 : _datasourceMap$active.call(_datasourceMap$active2, datasourceStates[activeDatasourceId].state, dataViews.indexPatterns)));
}
const contextMiddleware = storeDeps => store => {
  let unsubscribeFromExternalContext;
  return next => action => {
    var _action$payload;
    if (!((_action$payload = action.payload) !== null && _action$payload !== void 0 && _action$payload.searchSessionId) && !_lens_slice.onActiveDataChange.match(action) && ((0, _.selectAutoApplyEnabled)(store.getState()) || _.applyChanges.match(action)) && isTimeBased(store.getState(), storeDeps.datasourceMap)) {
      updateTimeRange(storeDeps.lensServices.data, store.dispatch);
    }
    if (_.navigateAway.match(action) && unsubscribeFromExternalContext) {
      return unsubscribeFromExternalContext();
    }
    next(action);
    // store stopped loading and external context is not subscribed to yet - do it now
    if (!store.getState().lens.isLoading && !unsubscribeFromExternalContext) {
      unsubscribeFromExternalContext = (0, _subscribe_to_external_context.subscribeToExternalContext)(storeDeps.lensServices.data, store.getState, store.dispatch);
    }
  };
};
exports.contextMiddleware = contextMiddleware;
const TIME_LAG_PERCENTAGE_LIMIT = 0.02;
const TIME_LAG_MIN_LIMIT = 10000; // for a small timerange to avoid infinite data refresh timelag minimum is TIME_LAG_ABSOLUTE ms

/**
 * checks if TIME_LAG_PERCENTAGE_LIMIT passed to renew searchSessionId
 * and request new data.
 */
function updateTimeRange(data, dispatch) {
  const timefilter = data.query.timefilter.timefilter;
  const unresolvedTimeRange = timefilter.getTime();
  if (!(0, _utils.containsDynamicMath)(unresolvedTimeRange.from) && !(0, _utils.containsDynamicMath)(unresolvedTimeRange.to)) {
    return;
  }
  const {
    min,
    max
  } = timefilter.getBounds();
  if (!min || !max) {
    // bounds not fully specified, bailing out
    return;
  }

  // calculate length of currently configured range in ms
  const timeRangeLength = _moment.default.duration(max.diff(min)).asMilliseconds();

  // calculate lag of managed "now" for date math
  const nowDiff = Date.now() - data.nowProvider.get().valueOf();

  // if the lag is significant, start a new session to clear the cache
  if (nowDiff > Math.max(timeRangeLength * TIME_LAG_PERCENTAGE_LIMIT, TIME_LAG_MIN_LIMIT)) {
    dispatch((0, _.setExecutionContext)({
      searchSessionId: data.search.session.start(),
      resolvedDateRange: (0, _utils.getResolvedDateRange)(timefilter)
    }));
  }
}