"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountInlinePanel = exports.lensFlyoutProps = void 0;
var _reactDom = _interopRequireDefault(require("react-dom"));
var _presentationUtil = require("@kbn/presentation-util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Shared logic to mount the inline config panel
 * @param ConfigPanel
 * @param coreStart
 * @param overlayTracker
 * @param uuid
 * @param container
 */

const mountInlinePanel = async ({
  core,
  api,
  loadContent,
  options: {
    dataTestSubj,
    uuid,
    container
  } = {}
}) => {
  if (container) {
    const component = await loadContent();
    if (!component) {
      throw new Error('Inline panel content is not available');
    }
    return _reactDom.default.render(component, container);
  }
  (0, _presentationUtil.openLazyFlyout)({
    core,
    parentApi: api,
    loadContent,
    flyoutProps: {
      ...lensFlyoutProps,
      'data-test-subj': dataTestSubj !== null && dataTestSubj !== void 0 ? dataTestSubj : 'customizeLens',
      focusedPanelId: uuid
    }
  });
};

// styles needed to display extra drop targets that are outside of the config panel main area while also allowing to scroll vertically
exports.mountInlinePanel = mountInlinePanel;
const inlineFlyoutStyles = ({
  euiTheme
}) => `
  clip-path: none;
  max-inline-size: 640px;
  min-inline-size: 256px;
  background:${euiTheme.colors.backgroundBaseSubdued};

  .kbnOverlayMountWrapper {
    padding-left: 400px;
    margin-left: -400px;
    pointer-events: none;
    .euiFlyoutFooter {
      pointer-events: auto;
    }
  }
`;
const lensFlyoutProps = exports.lensFlyoutProps = {
  css: inlineFlyoutStyles,
  'data-test-subj': 'customizeLens',
  hideCloseButton: true,
  isResizable: true,
  outsideClickCloses: true
};