"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeStateManagement = initializeStateManagement;
var _lodash = require("lodash");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Due to inline editing we need something advanced to handle the state
 * management at the embeddable level, so here's the initializers for it
 */
function initializeStateManagement(initialState, internalApi) {
  const savedObjectId$ = new _rxjs.BehaviorSubject(initialState.savedObjectId);
  return {
    api: {
      updateAttributes: internalApi.updateAttributes,
      updateSavedObjectId: newSavedObjectId => savedObjectId$.next(newSavedObjectId),
      savedObjectId$,
      dataViews$: internalApi.dataViews$,
      dataLoading$: internalApi.dataLoading$,
      blockingError$: internalApi.blockingError$,
      rendered$: internalApi.hasRenderCompleted$
    },
    anyStateChange$: (0, _rxjs.merge)(internalApi.attributes$).pipe((0, _rxjs.map)(() => undefined)),
    getComparators: () => {
      return {
        attributes: initialState.savedObjectId === undefined ? 'deepEquality' : 'skip',
        savedObjectId: 'skip'
      };
    },
    getLatestState: () => {
      return {
        attributes: internalApi.attributes$.getValue(),
        savedObjectId: savedObjectId$.getValue()
      };
    },
    reinitializeRuntimeState: lastSavedRuntimeState => {
      internalApi.updateAttributes(lastSavedRuntimeState.attributes);
    },
    cleanup: _lodash.noop
  };
}