"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLensBasicClient = getLensBasicClient;
var _lens_client = require("./lens_client");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This is a wrapper client used only to update basic attributes from the vis plugin
 */
function getLensBasicClient(cm, http) {
  const lensClient = new _lens_client.LensClient(http);
  return {
    get: async id => {
      const result = await lensClient.get(id);
      const lensSavedObject = (0, _utils.getLensSOFromResponse)(result);
      return {
        item: {
          ...lensSavedObject,
          // TODO: Fix this attributes type when config builder changes are applied
          attributes: lensSavedObject.attributes
        },
        meta: {
          outcome: result.meta.outcome
        }
      };
    },
    update: async ({
      id,
      options = {},
      data = {}
    }) => {
      var _options$references;
      const result = await lensClient.update(id, data, (_options$references = options.references) !== null && _options$references !== void 0 ? _options$references : []);
      const lensSavedObject = (0, _utils.getLensSOFromResponse)(result);
      return {
        item: {
          ...lensSavedObject,
          // TODO fix this attributes type when config builder changes are applied
          attributes: lensSavedObject.attributes
        }
      };
    },
    delete: async id => {
      return lensClient.delete(id);
    }
  };
}