"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOriginalRequestErrorMessages = getOriginalRequestErrorMessages;
var _searchErrors = require("@kbn/search-errors");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getOriginalRequestErrorMessages(error) {
  const errorMessages = [];
  if (error && 'original' in error && error.original) {
    const searchErrorDisplay = (0, _searchErrors.renderSearchError)(error.original);
    if (searchErrorDisplay) {
      errorMessages.push({
        short: error.original.message,
        long: searchErrorDisplay.actions ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, searchErrorDisplay.body, searchErrorDisplay.actions) : searchErrorDisplay.body
      });
    } else {
      errorMessages.push(error.original.message);
    }
  } else if (error !== null && error !== void 0 && error.message) {
    errorMessages.push(error.message);
  }
  return errorMessages.map(message => ({
    uniqueId: typeof message === 'string' ? message : message.short,
    severity: 'error',
    displayLocations: [{
      id: 'visualizationOnEmbeddable'
    }],
    longMessage: typeof message === 'string' ? '' : message.long,
    shortMessage: typeof message === 'string' ? message : message.short,
    fixableInEditor: false
  }));
}

// NOTE - if you are adding a new error message, add it as a UserMessage in get_application_error_messages
// or the getUserMessages method of a particular datasource or visualization class! Alternatively, use the
// addUserMessage function passed down by the application component.