"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useApplicationUserMessages = exports.handleMessageOverwriteFromConsumer = exports.getApplicationUserMessages = exports.filterAndSortUserMessages = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _state_management = require("../state_management");
var _state_helpers = require("../editor_frame_service/editor_frame/state_helpers");
var _user_messages_ids = require("../user_messages_ids");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/app_plugin/get_application_user_messages.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Provides a place to register general user messages that don't belong in the datasource or visualization objects
 */
const getApplicationUserMessages = ({
  visualizationType,
  visualization,
  visualizationState,
  activeDatasource,
  activeDatasourceState,
  dataViews,
  core
}) => {
  const messages = [];
  if (!visualizationType) {
    messages.push(getMissingVisTypeError());
  }
  if (visualizationState !== null && visualizationState !== void 0 && visualizationState.activeId && !visualization) {
    messages.push(getUnknownVisualizationTypeError(visualizationState.activeId));
  }
  if (!activeDatasource) {
    messages.push(getUnknownDatasourceTypeError());
  }
  const missingIndexPatterns = (0, _state_helpers.getMissingIndexPattern)(activeDatasource, activeDatasourceState, dataViews.indexPatterns);
  if (missingIndexPatterns.length) {
    messages.push(...getMissingIndexPatternsErrors(core, missingIndexPatterns));
  }
  return messages;
};
exports.getApplicationUserMessages = getApplicationUserMessages;
function getMissingVisTypeError() {
  return {
    uniqueId: _user_messages_ids.EDITOR_MISSING_VIS_TYPE,
    severity: 'error',
    displayLocations: [{
      id: 'visualizationOnEmbeddable'
    }],
    fixableInEditor: true,
    shortMessage: '',
    longMessage: _i18n.i18n.translate('xpack.lens.editorFrame.expressionMissingVisualizationType', {
      defaultMessage: 'Visualization type not found.'
    })
  };
}
function getUnknownVisualizationTypeError(visType) {
  return {
    uniqueId: _user_messages_ids.EDITOR_UNKNOWN_VIS_TYPE,
    severity: 'error',
    fixableInEditor: false,
    displayLocations: [{
      id: 'visualization'
    }],
    shortMessage: _i18n.i18n.translate('xpack.lens.unknownVisType.shortMessage', {
      defaultMessage: `Unknown visualization type`
    }),
    longMessage: _i18n.i18n.translate('xpack.lens.unknownVisType.longMessage', {
      defaultMessage: `The visualization type {visType} could not be resolved.`,
      values: {
        visType
      }
    })
  };
}
function getUnknownDatasourceTypeError() {
  return {
    uniqueId: _user_messages_ids.EDITOR_UNKNOWN_DATASOURCE_TYPE,
    severity: 'error',
    fixableInEditor: false,
    displayLocations: [{
      id: 'visualization'
    }],
    shortMessage: _i18n.i18n.translate('xpack.lens.unknownDatasourceType.shortMessage', {
      defaultMessage: `Unknown datasource type`
    }),
    longMessage: _i18n.i18n.translate('xpack.lens.editorFrame.expressionMissingDatasource', {
      defaultMessage: 'Could not find datasource for the visualization'
    })
  };
}
function getMissingIndexPatternsErrors(core, missingIndexPatterns) {
  var _core$application$cap, _core$application$cap2;
  // Check for access to both Management app && specific indexPattern section
  const {
    management: isManagementEnabled
  } = core.application.capabilities.navLinks;
  const isIndexPatternManagementEnabled = (_core$application$cap = core.application.capabilities.management) === null || _core$application$cap === void 0 ? void 0 : (_core$application$cap2 = _core$application$cap.kibana) === null || _core$application$cap2 === void 0 ? void 0 : _core$application$cap2.indexPatterns;
  const canFix = isManagementEnabled && isIndexPatternManagementEnabled;
  return [{
    uniqueId: _user_messages_ids.EDITOR_MISSING_DATAVIEW,
    severity: 'error',
    fixableInEditor: canFix,
    displayLocations: [{
      id: 'visualizationInEditor'
    }],
    shortMessage: '',
    longMessage: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      className: "eui-textBreakWord",
      "data-test-subj": "missing-refs-failure",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.editorFrame.dataViewNotFound",
      defaultMessage: "Data view not found",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement("p", {
      className: "eui-textBreakWord",
      style: {
        userSelect: 'text'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.indexPattern.missingDataView",
      defaultMessage: "The {count, plural, one {data view} other {data views}} ({count, plural, one {id} other {ids}}: {indexpatterns}) cannot be found.",
      values: {
        count: missingIndexPatterns.length,
        indexpatterns: missingIndexPatterns.join(', ')
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 13
      }
    }), canFix && /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
      coreStart: core,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("a", {
      href: core.application.getUrlForApp('management', {
        path: '/kibana/indexPatterns/create'
      }),
      style: {
        width: '100%',
        textAlign: 'center'
      },
      "data-test-subj": "configuration-failure-reconfigure-indexpatterns",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.lens.editorFrame.dataViewReconfigure', {
      defaultMessage: `Recreate it in the data view management page.`
    })))))
  }, {
    uniqueId: _user_messages_ids.EDITOR_MISSING_EXPRESSION_DATAVIEW,
    severity: 'error',
    fixableInEditor: canFix,
    displayLocations: [{
      id: 'visualizationOnEmbeddable'
    }],
    shortMessage: '',
    longMessage: _i18n.i18n.translate('xpack.lens.editorFrame.expressionMissingDataView', {
      defaultMessage: 'Could not find the {count, plural, one {data view} other {data views}}: {ids}',
      values: {
        count: missingIndexPatterns.length,
        ids: missingIndexPatterns.join(', ')
      }
    })
  }];
}
const handleMessageOverwriteFromConsumer = (messages, onBeforeBadgesRender) => {
  if (onBeforeBadgesRender) {
    // we need something else to better identify those errors
    const [messagesToHandle, originalMessages] = (0, _lodash.partition)(messages, message => message.displayLocations.some(location => location.id === 'embeddableBadge'));
    if (messagesToHandle.length > 0) {
      const customBadgeMessages = onBeforeBadgesRender(messagesToHandle);
      return originalMessages.concat(customBadgeMessages);
    }
  }
  return messages;
};
exports.handleMessageOverwriteFromConsumer = handleMessageOverwriteFromConsumer;
const filterAndSortUserMessages = (userMessages, locationId, {
  dimensionId,
  severity
} = {}) => {
  const locationIds = new Set((Array.isArray(locationId) ? locationId : [locationId]).filter(_utils.nonNullable));
  const filteredMessages = userMessages.filter(message => {
    if (locationIds.size) {
      const hasMatch = message.displayLocations.some(location => {
        if (!locationIds.has(location.id)) {
          return false;
        }
        return !(location.id === 'dimensionButton' && location.dimensionId !== dimensionId);
      });
      if (!hasMatch) {
        return false;
      }
    }
    return !severity || message.severity === severity;
  });
  return filteredMessages.sort(bySeverity);
};
exports.filterAndSortUserMessages = filterAndSortUserMessages;
function bySeverity(a, b) {
  if (a.severity === b.severity) {
    return 0;
  }
  if (a.severity === 'error') {
    return -1;
  }
  if (b.severity === 'error') {
    return 1;
  }
  if (a.severity === 'warning') {
    return -1;
  }
  return 1;
}
const useApplicationUserMessages = ({
  coreStart,
  dispatch,
  activeDatasourceId,
  datasource,
  datasourceState,
  framePublicAPI,
  visualizationType,
  visualization,
  visualizationState
}) => {
  const userMessages = (0, _react.useMemo)(() => {
    var _visualization$getUse, _visualization$getUse2;
    return [...(datasourceState && datasourceState.state && datasource && activeDatasourceId ? datasource.getUserMessages(datasourceState.state, {
      frame: framePublicAPI,
      setState: newStateOrUpdater => {
        dispatch((0, _state_management.updateDatasourceState)({
          newDatasourceState: typeof newStateOrUpdater === 'function' ? newStateOrUpdater(datasourceState.state) : newStateOrUpdater,
          datasourceId: activeDatasourceId
        }));
      }
    }) : []), ...(visualizationState !== null && visualizationState !== void 0 && visualizationState.activeId && visualizationState.state ? (_visualization$getUse = visualization === null || visualization === void 0 ? void 0 : (_visualization$getUse2 = visualization.getUserMessages) === null || _visualization$getUse2 === void 0 ? void 0 : _visualization$getUse2.call(visualization, visualizationState.state, {
      frame: framePublicAPI
    })) !== null && _visualization$getUse !== void 0 ? _visualization$getUse : [] : []), ...getApplicationUserMessages({
      visualizationType,
      visualization,
      visualizationState,
      activeDatasource: datasource,
      activeDatasourceState: datasourceState,
      core: coreStart,
      dataViews: framePublicAPI.dataViews
    })];
  }, [activeDatasourceId, datasource, datasourceState, dispatch, framePublicAPI, visualization, visualizationState, visualizationType, coreStart]);
  // these are messages managed from other parts of Lens
  const [additionalUserMessages, setAdditionalUserMessages] = (0, _react.useState)({});
  const getUserMessages = (0, _react.useCallback)((locationId, filterArgs) => filterAndSortUserMessages(userMessages.concat(Object.values(additionalUserMessages)), locationId, filterArgs !== null && filterArgs !== void 0 ? filterArgs : {}), [additionalUserMessages, userMessages]);
  const addUserMessages = (0, _react.useCallback)(messages => {
    const newMessageMap = {
      ...additionalUserMessages
    };
    const addedMessageIds = [];
    messages.forEach(message => {
      if (!newMessageMap[message.uniqueId]) {
        addedMessageIds.push(message.uniqueId);
        newMessageMap[message.uniqueId] = message;
      }
    });
    if (addedMessageIds.length) {
      setAdditionalUserMessages(newMessageMap);
    }
    return () => {
      const withMessagesRemoved = {
        ...additionalUserMessages
      };
      addedMessageIds.forEach(id => delete withMessagesRemoved[id]);
      setAdditionalUserMessages(withMessagesRemoved);
    };
  }, [additionalUserMessages]);
  return {
    getUserMessages,
    addUserMessages
  };
};
exports.useApplicationUserMessages = useApplicationUserMessages;