"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformToV1LensItemAttributes = transformToV1LensItemAttributes;
exports.transformToV1LensSavedObject = transformToV1LensSavedObject;
var _raw_color_mappings = require("./raw_color_mappings");
var _legend_stats = require("./legend_stats");
var _attributes = require("./attributes");
var _metric = require("./metric");
var _add_version = require("./add_version");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Transforms existing unversioned Lens SO attributes to v1 Lens Item attributes
 *
 * Includes:
 * - Legend value → Legend stats
 * - Stringified color mapping values → Raw color mappings values
 * - Fix color mapping loop mode
 * - Cleanup Lens SO attributes
 * - Cleanup metric properties
 * - Add version property
 */
function transformToV1LensItemAttributes(attributes) {
  return [_legend_stats.convertToLegendStats, _raw_color_mappings.convertToRawColorMappingsFn, _attributes.attributesCleanup, _metric.metricMigrations, _add_version.addVersion].reduce((newState, fn) => fn(newState), attributes);
}

/**
 * Transforms existing unversioned Lens SO to v1 Lens SO
 *
 * Includes:
 * - Legend value → Legend stats
 * - Stringified color mapping values → Raw color mappings values
 * - Add version property
 */
function transformToV1LensSavedObject(so) {
  return {
    ...so,
    attributes: transformToV1LensItemAttributes(so.attributes)
  };
}