"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createHistoryObservable = createHistoryObservable;
exports.createQueryParamObservable = createQueryParamObservable;
exports.createQueryParamsObservable = createQueryParamsObservable;
var _rxjs = require("rxjs");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _get_query_params = require("./get_query_params");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Convert history.listen into an observable
 * @param history - {@link History} instance
 */
function createHistoryObservable(history) {
  return new _rxjs.Observable(observer => {
    const unlisten = history.listen((location, action) => observer.next({
      location,
      action
    }));
    return () => {
      unlisten();
    };
  });
}

/**
 * Create an observable that emits every time any of query params change.
 * Uses deepEqual check.
 * @param history - {@link History} instance
 */
function createQueryParamsObservable(history) {
  return createHistoryObservable(history).pipe((0, _rxjs.map)(({
    location
  }) => ({
    ...(0, _get_query_params.getQueryParams)(location)
  })), (0, _common.distinctUntilChangedWithInitialValue)({
    ...(0, _get_query_params.getQueryParams)(history.location)
  }, _fastDeepEqual.default));
}

/**
 * Create an observable that emits every time _paramKey_ changes
 * @param history - {@link History} instance
 * @param paramKey - query param key to observe
 */
function createQueryParamObservable(history, paramKey) {
  var _getQueryParams$param;
  return createQueryParamsObservable(history).pipe((0, _rxjs.map)(params => {
    var _params$paramKey;
    return (_params$paramKey = params[paramKey]) !== null && _params$paramKey !== void 0 ? _params$paramKey : null;
  }), (0, _common.distinctUntilChangedWithInitialValue)((_getQueryParams$param = (0, _get_query_params.getQueryParams)(history.location)[paramKey]) !== null && _getQueryParams$param !== void 0 ? _getQueryParams$param : null, _fastDeepEqual.default));
}