"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withKibana = exports.useKibana = exports.createKibanaReactContext = exports.context = exports.KibanaContextProvider = void 0;
var _react = _interopRequireDefault(require("react"));
var _overlays = require("../overlays");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const {
  useMemo,
  useContext,
  createElement,
  createContext
} = _react.default;
const defaultContextValue = {
  services: {},
  overlays: (0, _overlays.createReactOverlays)({})
};
const context = exports.context = createContext(defaultContextValue);
const useKibana = () => useContext(context);
exports.useKibana = useKibana;
const withKibana = type => {
  const EnhancedType = props => {
    const kibana = useKibana();
    return /*#__PURE__*/_react.default.createElement(type, {
      ...props,
      kibana
    });
  };
  return EnhancedType;
};
exports.withKibana = withKibana;
const createKibanaReactContext = services => {
  const value = {
    services,
    overlays: (0, _overlays.createReactOverlays)(services)
  };
  const Provider = ({
    services: newServices = {},
    children
  }) => {
    const oldValue = useKibana();
    const {
      value: newValue
    } = useMemo(() => createKibanaReactContext({
      ...services,
      ...oldValue.services,
      ...newServices
    }), [services, oldValue, newServices]);
    const newProvider = createElement(context.Provider, {
      value: newValue,
      children
    });
    return newProvider;
  };
  return {
    value,
    Provider,
    Consumer: context.Consumer
  };
};
exports.createKibanaReactContext = createKibanaReactContext;
const {
  Provider: KibanaContextProvider
} = createKibanaReactContext({});
exports.KibanaContextProvider = KibanaContextProvider;