"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InterceptPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _prompter = require("./prompter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InterceptPublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "prompter", void 0);
    (0, _defineProperty2.default)(this, "interceptsTargetDomElement", void 0);
    const {
      enabled
    } = initializerContext.config.get();
    if (enabled) {
      this.prompter = new _prompter.InterceptPrompter();
    }
  }
  setup(core) {
    var _this$prompter;
    (_this$prompter = this.prompter) === null || _this$prompter === void 0 ? void 0 : _this$prompter.setup({
      analytics: core.analytics,
      notifications: core.notifications
    });
    return {};
  }
  start(core) {
    var _this$prompter2;
    this.interceptsTargetDomElement = document.createElement('div');
    const prompterStart = (_this$prompter2 = this.prompter) === null || _this$prompter2 === void 0 ? void 0 : _this$prompter2.start({
      http: core.http,
      analytics: core.analytics,
      rendering: core.rendering,
      targetDomElement: this.interceptsTargetDomElement
    });
    return {
      registerIntercept: prompterStart === null || prompterStart === void 0 ? void 0 : prompterStart.registerIntercept.bind(prompterStart)
    };
  }
  stop() {
    var _this$interceptsTarge;
    (_this$interceptsTarge = this.interceptsTargetDomElement) === null || _this$interceptsTarge === void 0 ? void 0 : _this$interceptsTarge.remove();
  }
}
exports.InterceptPublicPlugin = InterceptPublicPlugin;