"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerInspectComponentRoutes = void 0;
var _get_component_data = require("./component_data/get_component_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Options for {@link registerInspectComponentRoutes}.
 */

/**
 * Register routes for the Inspect Component plugin.
 * @param {InspectComponentRoutesOptions} options
 * @param {http} options.httpService {@link HttpServiceSetup}
 * @param {Logger} options.logger {@link Logger}
 */
const registerInspectComponentRoutes = ({
  httpService,
  logger
}) => {
  const router = httpService.createRouter();

  /**
   * @internal
   * Route for getting data about a React component at a given path.
   * @returns {Object} Result object.
   * @returns {string[]} result.codeowners - List of codeowners for the file.
   * @returns {string} result.relativePath - Path relative to the repo root.
   * @returns {string} result.baseFileName - Base file name.
   */
  router.post({
    path: '/internal/inspect_component/inspect',
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization'
      }
    },
    options: {
      access: 'internal'
    },
    validate: {
      body: _get_component_data.getComponentDataBodySchema
    }
  }, async (_ctx, req, res) => (0, _get_component_data.getComponentData)({
    req,
    res,
    logger
  }));
};
exports.registerInspectComponentRoutes = registerInspectComponentRoutes;