"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findFirstFiberWithDebugSource = void 0;
var _get_fiber_from_html_element = require("./get_fiber_from_html_element");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const hasDebugSource = fiber => {
  return fiber._debugSource !== undefined && fiber._debugSource !== null;
};

/**
 * Finds the first {@link ReactFiberNode React Fiber node} associated with the given HTML element (or its ancestors)
 * that has a {@link DebugSource _debugSource} attached to it.
 * @param {HTMLElement} element The HTML element to start the search from.
 * @return {ReactFiberNode | null} {@link ReactFiberNode React Fiber node}, or null if none found.
 */
const findFirstFiberWithDebugSource = element => {
  let current = element;
  while (current) {
    const fiber = (0, _get_fiber_from_html_element.getFiberFromHtmlElement)(current);
    if (fiber) {
      let fiberCursor = fiber;
      while (fiberCursor) {
        if (hasDebugSource(fiberCursor)) {
          return {
            ...fiberCursor,
            element: current
          };
        }
        fiberCursor = fiberCursor._debugOwner;
      }
    }
    current = current.parentElement;
  }
  return null;
};
exports.findFirstFiberWithDebugSource = findFirstFiberWithDebugSource;