"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInputControlVisController = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _reactDom = require("react-dom");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public = require("@kbn/visualizations-plugin/public");
var _input_control_vis = require("./components/vis/input_control_vis");
var _control_factory = require("./control/control_factory");
var _lineage = require("./lineage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/input_control_vis/public/vis_controller.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const createInputControlVisController = (coreStart, deps, handlers, el) => {
  let isLoaded = false;
  return new class InputControlVisController {
    constructor() {
      (0, _defineProperty2.default)(this, "controls", void 0);
      (0, _defineProperty2.default)(this, "queryBarUpdateHandler", void 0);
      (0, _defineProperty2.default)(this, "filterManager", void 0);
      (0, _defineProperty2.default)(this, "updateSubsciption", void 0);
      (0, _defineProperty2.default)(this, "timeFilterSubscription", void 0);
      (0, _defineProperty2.default)(this, "visParams", void 0);
      (0, _defineProperty2.default)(this, "isDarkMode", void 0);
      (0, _defineProperty2.default)(this, "drawVis", () => {
        var _this$visParams;
        (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, coreStart, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 88,
            columnNumber: 9
          }
        }), /*#__PURE__*/_react.default.createElement(_public.VisualizationContainer, {
          handlers: handlers,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 89,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_input_control_vis.InputControlVis, {
          updateFiltersOnChange: (_this$visParams = this.visParams) === null || _this$visParams === void 0 ? void 0 : _this$visParams.updateFiltersOnChange,
          controls: this.controls,
          stageFilter: this.stageFilter,
          submitFilters: this.submitFilters,
          resetControls: this.updateControlsFromKbn,
          clearControls: this.clearControls,
          hasChanges: this.hasChanges,
          hasValues: this.hasValues,
          refreshControl: this.refreshControl,
          isDarkMode: this.isDarkMode,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 90,
            columnNumber: 13
          }
        }))), el);
      });
      (0, _defineProperty2.default)(this, "stageFilter", async (controlIndex, newValue) => {
        var _this$visParams2;
        this.controls[controlIndex].set(newValue);
        if ((_this$visParams2 = this.visParams) !== null && _this$visParams2 !== void 0 && _this$visParams2.updateFiltersOnChange) {
          // submit filters on each control change
          this.submitFilters();
        } else {
          // Do not submit filters, just update vis so controls are updated with latest value
          await this.updateNestedControls();
          this.drawVis();
        }
      });
      (0, _defineProperty2.default)(this, "submitFilters", () => {
        var _this$visParams3;
        const stagedControls = this.controls.filter(control => {
          return control.hasChanged();
        });
        const newFilters = stagedControls.map(control => control.getKbnFilter()).filter(filter => {
          return filter !== null;
        });
        stagedControls.forEach(control => {
          // to avoid duplicate filters, remove any old filters for control
          control.filterManager.findFilters().forEach(existingFilter => {
            this.filterManager.removeFilter(existingFilter);
          });
        });

        // Clean up filter pills for nested controls that are now disabled because ancestors are not set.
        // This has to be done after looking up the staged controls because otherwise removing a filter
        // will re-sync the controls of all other filters.
        this.controls.map(control => {
          if (control.hasAncestors() && control.hasUnsetAncestor()) {
            control.filterManager.findFilters().forEach(existingFilter => {
              this.filterManager.removeFilter(existingFilter);
            });
          }
        });
        this.filterManager.addFilters(newFilters, (_this$visParams3 = this.visParams) === null || _this$visParams3 === void 0 ? void 0 : _this$visParams3.pinFilters);
      });
      (0, _defineProperty2.default)(this, "clearControls", async () => {
        this.controls.forEach(control => {
          control.clear();
        });
        await this.updateNestedControls();
        this.drawVis();
      });
      (0, _defineProperty2.default)(this, "updateControlsFromKbn", async () => {
        this.controls.forEach(control => {
          control.reset();
        });
        await this.updateNestedControls();
        this.drawVis();
      });
      (0, _defineProperty2.default)(this, "hasChanges", () => {
        return this.controls.map(control => control.hasChanged()).some(control => control);
      });
      (0, _defineProperty2.default)(this, "hasValues", () => {
        return this.controls.map(control => {
          return control.hasValue();
        }).reduce((a, b) => {
          return a || b;
        });
      });
      (0, _defineProperty2.default)(this, "refreshControl", async (controlIndex, query) => {
        await this.controls[controlIndex].fetch(query);
        this.drawVis();
      });
      this.controls = [];
      this.queryBarUpdateHandler = this.updateControlsFromKbn.bind(this);
      this.filterManager = deps.data.query.filterManager;
      this.updateSubsciption = this.filterManager.getUpdates$().subscribe(this.queryBarUpdateHandler);
      this.timeFilterSubscription = deps.data.query.timefilter.timefilter.getTimeUpdate$().subscribe(() => {
        var _this$visParams4;
        if ((_this$visParams4 = this.visParams) !== null && _this$visParams4 !== void 0 && _this$visParams4.useTimeFilter) {
          isLoaded = false;
        }
      });
      this.isDarkMode = deps.core.theme.getTheme().darkMode;
    }
    async render(visParams) {
      if (!isLoaded || !(0, _lodash.isEqual)(visParams, this.visParams)) {
        this.visParams = visParams;
        this.controls = [];
        this.controls = await this.initControls(visParams);
        isLoaded = true;
      }
      this.drawVis();
    }
    destroy() {
      this.updateSubsciption.unsubscribe();
      this.timeFilterSubscription.unsubscribe();
      (0, _reactDom.unmountComponentAtNode)(el);
      this.controls.forEach(control => control.destroy());
    }
    async initControls(visParams) {
      const controlParamsList = visParams.controls.filter(controlParams => {
        // ignore controls that do not have indexPattern or field
        return controlParams.indexPattern && controlParams.fieldName;
      });
      const controlFactoryPromises = controlParamsList.map(controlParams => {
        const factory = (0, _control_factory.getControlFactory)(controlParams);
        return factory(controlParams, visParams.useTimeFilter, deps);
      });
      const controls = await Promise.all(controlFactoryPromises);
      const getControl = controlId => {
        return controls.find(({
          id
        }) => id === controlId);
      };
      const controlInitPromises = [];
      (0, _lineage.getLineageMap)(controlParamsList).forEach((lineage, controlId) => {
        // first lineage item is the control. remove it
        lineage.shift();
        const ancestors = [];
        lineage.forEach(ancestorId => {
          const control = getControl(ancestorId);
          if (control) {
            ancestors.push(control);
          }
        });
        const control = getControl(controlId);
        if (control) {
          control.setAncestors(ancestors);
          controlInitPromises.push(control.fetch());
        }
      });
      await Promise.all(controlInitPromises);
      return controls;
    }
    async updateNestedControls() {
      const fetchPromises = this.controls.map(async control => {
        if (control.hasAncestors()) {
          await control.fetch();
        }
      });
      return await Promise.all(fetchPromises);
    }
  }();
};
exports.createInputControlVisController = createInputControlVisController;